/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.OracleConnection;

final class T4Caqe
extends T4CTTIfun {
    static final int KPD_AQ_BUFMSG = 2;
    static final int KPD_AQ_EITHER = 16;
    static final int OCI_COMMIT_ON_SUCCESS = 32;
    static final int ATTR_TRANSFORMATION = 196;
    T4CTTIaqm aqm;
    T4Ctoh toh;
    private byte[] queueNameBytes = null;
    private AQEnqueueOptions enqueueOptions = null;
    private AQMessagePropertiesI messageProperties = null;
    private byte[] messageData = null;
    private byte[] messageOid = null;
    private boolean isRawQueue = false;
    private int nbExtensions = 0;
    private byte[][] extensionTextValues = null;
    private byte[][] extensionBinaryValues = null;
    private int[] extensionKeywords = null;
    private AQAgentI[] attrRecipientList = null;
    private byte[][] recipientTextValues = null;
    private byte[][] recipientBinaryValues = null;
    private int[] recipientKeywords = null;
    private byte[] aqmcorBytes;
    private byte[] aqmeqnBytes;
    private boolean retrieveMessageId = false;
    private byte[] outMsgid = null;
    private byte[] senderAgentName = null;
    private byte[] senderAgentAddress = null;
    private byte senderAgentProtocol = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Aug_26_08:19:15_PDT_2011";
    public static final boolean TRACE = false;

    T4Caqe(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)121);
        this.toh = new T4Ctoh();
        this.aqm = new T4CTTIaqm(this.connection, this.toh);
    }

    void doOAQEQ(String string, AQEnqueueOptions aQEnqueueOptions, AQMessagePropertiesI aQMessagePropertiesI, byte[] byArray, byte[] byArray2, boolean bl) throws SQLException, IOException {
        String string2;
        this.enqueueOptions = aQEnqueueOptions;
        this.messageProperties = aQMessagePropertiesI;
        String string3 = this.messageProperties.getCorrelation();
        this.aqmcorBytes = (byte[])(string3 != null && string3.length() != 0 ? this.meg.conv.StringToCharBytes(string3) : null);
        String string4 = this.messageProperties.getExceptionQueue();
        this.aqmeqnBytes = (byte[])(string4 != null && string4.length() != 0 ? this.meg.conv.StringToCharBytes(string4) : null);
        AQAgentI aQAgentI = (AQAgentI)this.messageProperties.getSender();
        if (aQAgentI != null) {
            this.senderAgentName = (byte[])(aQAgentI.getName() != null ? this.meg.conv.StringToCharBytes(aQAgentI.getName()) : null);
            this.senderAgentAddress = (byte[])(aQAgentI.getAddress() != null ? this.meg.conv.StringToCharBytes(aQAgentI.getAddress()) : null);
            this.senderAgentProtocol = (byte)aQAgentI.getProtocol();
        } else {
            this.senderAgentName = null;
            this.senderAgentAddress = null;
            this.senderAgentProtocol = 0;
        }
        this.messageData = byArray;
        this.messageOid = byArray2;
        this.isRawQueue = bl;
        this.queueNameBytes = (byte[])(string != null && string.length() != 0 ? this.meg.conv.StringToCharBytes(string) : null);
        this.attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList();
        if (this.attrRecipientList != null && this.attrRecipientList.length > 0) {
            this.recipientTextValues = new byte[this.attrRecipientList.length * 3][];
            this.recipientBinaryValues = new byte[this.attrRecipientList.length * 3][];
            this.recipientKeywords = new int[this.attrRecipientList.length * 3];
            for (int i2 = 0; i2 < this.attrRecipientList.length; ++i2) {
                if (this.attrRecipientList[i2].getName() != null) {
                    this.recipientTextValues[3 * i2] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i2].getName());
                }
                if (this.attrRecipientList[i2].getAddress() != null) {
                    this.recipientTextValues[3 * i2 + 1] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i2].getAddress());
                }
                this.recipientBinaryValues[3 * i2 + 2] = new byte[1];
                this.recipientBinaryValues[3 * i2 + 2][0] = (byte)this.attrRecipientList[i2].getProtocol();
                this.recipientKeywords[3 * i2] = 3 * i2;
                this.recipientKeywords[3 * i2 + 1] = 3 * i2 + 1;
                this.recipientKeywords[3 * i2 + 2] = 3 * i2 + 2;
            }
        }
        if ((string2 = this.enqueueOptions.getTransformation()) != null && string2.length() > 0) {
            this.nbExtensions = 1;
            this.extensionTextValues = new byte[this.nbExtensions][];
            this.extensionBinaryValues = new byte[this.nbExtensions][];
            this.extensionKeywords = new int[this.nbExtensions];
            this.extensionTextValues[0] = this.meg.conv.StringToCharBytes(string2);
            this.extensionBinaryValues[0] = null;
            this.extensionKeywords[0] = 196;
        } else {
            this.nbExtensions = 0;
        }
        this.outMsgid = null;
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.queueNameBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.aqm.initToDefaultValues();
        this.aqm.aqmpri = this.messageProperties.getPriority();
        this.aqm.aqmdel = this.messageProperties.getDelay();
        this.aqm.aqmexp = this.messageProperties.getExpiration();
        this.aqm.aqmcorBytes = this.aqmcorBytes;
        this.aqm.aqmeqnBytes = this.aqmeqnBytes;
        this.aqm.senderAgentName = this.senderAgentName;
        this.aqm.senderAgentAddress = this.senderAgentAddress;
        this.aqm.senderAgentProtocol = this.senderAgentProtocol;
        this.aqm.originalMsgId = this.messageProperties.getPreviousQueueMessageId();
        this.aqm.marshal();
        AQAgentI[] aQAgentIArray = (AQAgentI[])this.messageProperties.getRecipientList();
        if (aQAgentIArray != null && aQAgentIArray.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(aQAgentIArray.length * 3);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalSB4(this.enqueueOptions.getVisibility().getCode());
        boolean bl = false;
        if (this.enqueueOptions.getRelativeMessageId() != null && this.enqueueOptions.getRelativeMessageId().length > 0) {
            bl = true;
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.enqueueOptions.getRelativeMessageId().length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalSWORD(this.enqueueOptions.getSequenceDeviation().getCode());
        this.meg.marshalPTR();
        this.meg.marshalSWORD(16);
        this.meg.marshalUB2(1);
        if (!this.isRawQueue) {
            this.meg.marshalPTR();
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.messageData.length);
        }
        if (this.enqueueOptions.getRetrieveMessageId()) {
            this.retrieveMessageId = true;
            this.meg.marshalPTR();
            this.meg.marshalSWORD(16);
        } else {
            this.retrieveMessageId = false;
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        int n2 = 0;
        if (this.connection.autocommit) {
            n2 = 32;
        }
        if (this.enqueueOptions.getDeliveryMode() == AQEnqueueOptions.DeliveryMode.BUFFERED) {
            n2 |= 2;
        }
        this.meg.marshalUB4(n2);
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        if (this.nbExtensions > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.nbExtensions);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalNULLPTR();
        this.meg.marshalSWORD(0);
        this.meg.marshalNULLPTR();
        this.meg.marshalSWORD(0);
        this.meg.marshalNULLPTR();
        if (this.connection.getTTCVersion() >= 4) {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
            this.meg.marshalNULLPTR();
            this.meg.marshalNULLPTR();
        }
        if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
            this.meg.marshalCHR(this.queueNameBytes);
        }
        if (aQAgentIArray != null && aQAgentIArray.length > 0) {
            this.meg.marshalKPDKV(this.recipientTextValues, this.recipientBinaryValues, this.recipientKeywords);
        }
        if (bl) {
            this.meg.marshalB1Array(this.enqueueOptions.getRelativeMessageId());
        }
        this.meg.marshalB1Array(this.messageOid);
        if (!this.isRawQueue) {
            this.toh.init(this.messageOid, this.messageData.length);
            this.toh.marshal(this.meg);
            this.meg.marshalCLR(this.messageData, 0, this.messageData.length);
        } else {
            this.meg.marshalB1Array(this.messageData);
        }
        if (this.nbExtensions > 0) {
            this.meg.marshalKPDKV(this.extensionTextValues, this.extensionBinaryValues, this.extensionKeywords);
        }
    }

    byte[] getMessageId() {
        return this.outMsgid;
    }

    @Override
    void readRPA() throws SQLException, IOException {
        if (this.retrieveMessageId) {
            this.outMsgid = new byte[16];
            this.meg.unmarshalBuffer(this.outMsgid, 0, 16);
        }
        int n2 = this.meg.unmarshalUB2();
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

