/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.proxy.MethodSignature;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.GetProxy;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;

class AnnotationsRegistry {
    private Map<Class, Value> ifacesToAnnotatedSuperclasses = new HashMap<Class, Value>();

    AnnotationsRegistry() {
    }

    void register(Class ... classArray) {
        for (Class clazz : classArray) {
            if (clazz.isInterface()) {
                throw SyntaxError.mustBeClass(clazz);
            }
            Value value = new Value(clazz);
            for (Class clazz2 : value.getIfacesToProxy()) {
                this.ifacesToAnnotatedSuperclasses.put(clazz2, value);
            }
        }
    }

    Value get(Class clazz) {
        if (null == clazz) {
            return null;
        }
        return this.ifacesToAnnotatedSuperclasses.get(clazz);
    }

    Set<Class> keySet() {
        return this.ifacesToAnnotatedSuperclasses.keySet();
    }

    Collection<Value> values() {
        return this.ifacesToAnnotatedSuperclasses.values();
    }

    boolean containsKey(Object object) {
        return this.ifacesToAnnotatedSuperclasses.containsKey(object);
    }

    static class Value {
        private final Class superclass;
        private final List<Class> ifacesToProxy = new ArrayList<Class>();
        private final MethodSpecific.Pres pres = new MethodSpecific.Pres();
        private final MethodSpecific.VoidPosts voidPosts = new MethodSpecific.VoidPosts();
        private final MethodSpecific.ReturningPosts returningPosts = new MethodSpecific.ReturningPosts();
        private final MethodSpecific.VoidOnErrors voidOnErrors = new MethodSpecific.VoidOnErrors();
        private final MethodSpecific.ReturningOnErrors returningOnErrors = new MethodSpecific.ReturningOnErrors();
        private final Rest rest;
        private Method methodGetCreator = null;
        private Method methodGetDelegate = null;
        private Method methodGetProxy = null;
        private Method methodSetDelegate = null;
        private boolean isProxyLocale = false;
        private ProxyResultPolicy proxyResultPolicy = ProxyResultPolicy.CACHE;
        private Class proxyAccessIface = null;
        private Method proxyAccessGetter = null;
        private Method proxyAccessSetter = null;
        private Method pre = null;
        private Method voidPost = null;
        private Method returningPost = null;
        private Map<Class, Method> voidOnErrorsMap = new HashMap<Class, Method>();
        private Map<Class, Method> returningOnErrorsMap = new HashMap<Class, Method>();
        private static final Class[] listOfMethodOperators = new Class[]{Pre.class, Post.class, OnError.class, GetCreator.class, GetDelegate.class, GetProxy.class, SetDelegate.class};

        Value(Class clazz) {
            this.superclass = clazz;
            this.rest = this.parseAnnotations();
        }

        private void parseAnnotationTypeProxyResult() {
            if (this.superclass.isAnnotationPresent(ProxyResult.class)) {
                ProxyResult proxyResult = this.superclass.getAnnotation(ProxyResult.class);
                this.proxyResultPolicy = proxyResult.value();
            }
        }

        private void parseAnnotationProxyLocale() {
            if (this.superclass.isAnnotationPresent(ProxyLocale.class)) {
                this.isProxyLocale = true;
            }
        }

        private void parseAnnotationProxyFor() {
            if (this.superclass.isAnnotationPresent(ProxyFor.class)) {
                ProxyFor proxyFor = this.superclass.getAnnotation(ProxyFor.class);
                for (Class clazz : proxyFor.value()) {
                    if (!clazz.isInterface()) {
                        throw SyntaxError.mustBeIface(clazz);
                    }
                    this.ifacesToProxy.add(clazz);
                }
            } else {
                throw SyntaxError.noProxyForClass(this.superclass);
            }
        }

        private boolean isProxyAccessGetter(Method method) {
            if (!Object.class.equals(method.getReturnType())) {
                return false;
            }
            if (!Arrays.deepEquals(new Class[0], method.getParameterTypes())) {
                return false;
            }
            return Arrays.deepEquals(new Class[0], method.getExceptionTypes());
        }

        private boolean isProxyAccessSetter(Method method) {
            if (!Void.TYPE.equals(method.getReturnType())) {
                return false;
            }
            if (!Arrays.deepEquals(new Class[]{Object.class}, method.getParameterTypes())) {
                return false;
            }
            return Arrays.deepEquals(new Class[0], method.getExceptionTypes());
        }

        private void parseAnnotationProxyAccess() {
            if (this.superclass.isAnnotationPresent(ProxyAccess.class)) {
                this.proxyAccessIface = this.superclass.getAnnotation(ProxyAccess.class).value();
                if (!this.proxyAccessIface.isInterface()) {
                    throw SyntaxError.mustBeIface(this.proxyAccessIface);
                }
                if (0 != this.proxyAccessIface.getInterfaces().length) {
                    throw SyntaxError.mustNotImplementIfaces(this.proxyAccessIface);
                }
                Method[] methodArray = this.proxyAccessIface.getMethods();
                if (2 != methodArray.length) {
                    throw SyntaxError.wrongProxyAccessIface(this.proxyAccessIface);
                }
                if (this.isProxyAccessGetter(methodArray[0]) && this.isProxyAccessSetter(methodArray[1])) {
                    this.proxyAccessGetter = methodArray[0];
                    this.proxyAccessSetter = methodArray[1];
                } else if (this.isProxyAccessGetter(methodArray[1]) && this.isProxyAccessSetter(methodArray[0])) {
                    this.proxyAccessGetter = methodArray[1];
                    this.proxyAccessSetter = methodArray[0];
                } else {
                    throw SyntaxError.wrongProxyAccessIface(this.proxyAccessIface);
                }
            }
        }

        private void checkIsSingle(Method method, Class clazz) {
            for (Class clazz2 : listOfMethodOperators) {
                if (clazz2.equals(clazz) || !method.isAnnotationPresent(clazz2)) continue;
                throw SyntaxError.onlyOneAllowed;
            }
        }

        private void parseAnnotationPre(Method method) {
            if (method.isAnnotationPresent(Pre.class)) {
                this.checkIsSingle(method, Pre.class);
                if (!Arrays.deepEquals(new Class[0], method.getExceptionTypes())) {
                    throw SyntaxError.wrongPre;
                }
                if (!Arrays.deepEquals(new Class[]{Method.class, Object.class, Object[].class}, method.getParameterTypes())) {
                    throw SyntaxError.wrongPre;
                }
                if (!Void.TYPE.equals(method.getReturnType())) {
                    throw SyntaxError.wrongPre;
                }
                if (method.isAnnotationPresent(Methods.class)) {
                    for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                        this.pres.put(new MethodSignature(signature.name(), signature.args(), null), method);
                    }
                } else {
                    if (null != this.pre) {
                        throw SyntaxError.onlyOneMethodslessAllowed;
                    }
                    this.pre = method;
                }
            }
        }

        private Class doAutoBoxing(Class clazz) {
            if (Boolean.TYPE.equals(clazz)) {
                return Boolean.class;
            }
            if (Character.TYPE.equals(clazz)) {
                return Character.class;
            }
            if (Byte.TYPE.equals(clazz)) {
                return Byte.class;
            }
            if (Short.TYPE.equals(clazz)) {
                return Short.class;
            }
            if (Integer.TYPE.equals(clazz)) {
                return Integer.class;
            }
            if (Long.TYPE.equals(clazz)) {
                return Long.class;
            }
            if (Float.TYPE.equals(clazz)) {
                return Float.class;
            }
            if (Double.TYPE.equals(clazz)) {
                return Double.class;
            }
            return clazz;
        }

        private void checkReturnTypesMismatch(MethodSignature methodSignature, Method method) {
            Method method2 = null;
            Class clazz = this.doAutoBoxing(method.getReturnType());
            for (Class clazz2 : this.getIfacesToProxy()) {
                try {
                    method2 = clazz2.getDeclaredMethod(methodSignature.getName(), methodSignature.getParameterTypes());
                    Class clazz3 = this.doAutoBoxing(method2.getReturnType());
                    if (Void.TYPE.equals(clazz3)) continue;
                    clazz.asSubclass(clazz3);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (ClassCastException classCastException) {
                    throw SyntaxError.returnTypeMismatch(method, method2);
                }
            }
        }

        private void checkReturnTypesMismatch(Method method) {
            Class clazz = this.doAutoBoxing(method.getReturnType());
            for (Class clazz2 : this.getIfacesToProxy()) {
                for (Method method2 : clazz2.getDeclaredMethods()) {
                    Class clazz3 = this.doAutoBoxing(method2.getReturnType());
                    if (Void.TYPE.equals(clazz3)) continue;
                    try {
                        clazz3.asSubclass(clazz);
                    }
                    catch (ClassCastException classCastException) {
                        throw SyntaxError.returnTypeMismatch(method, method2);
                    }
                }
            }
        }

        private void parseAnnotationPost(Method method) {
            if (method.isAnnotationPresent(Post.class)) {
                this.checkIsSingle(method, Post.class);
                Class<?> clazz = method.getReturnType();
                Object[] objectArray = method.getParameterTypes();
                Object[] objectArray2 = method.getExceptionTypes();
                if (!Arrays.deepEquals(new Class[0], objectArray2)) {
                    throw SyntaxError.wrongPost;
                }
                if (Void.TYPE.equals(clazz) && Arrays.deepEquals(new Class[]{Method.class}, objectArray)) {
                    if (method.isAnnotationPresent(Methods.class)) {
                        for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                            this.voidPosts.put(new MethodSignature(signature.name(), signature.args(), null), method);
                        }
                    } else {
                        if (null != this.voidPost) {
                            throw SyntaxError.onlyOneMethodslessAllowed;
                        }
                        this.voidPost = method;
                    }
                } else if (!Void.TYPE.equals(clazz) && Arrays.deepEquals(new Class[]{Method.class, clazz}, objectArray)) {
                    if (method.isAnnotationPresent(Methods.class)) {
                        for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                            MethodSignature methodSignature = new MethodSignature(signature.name(), signature.args(), null);
                            this.checkReturnTypesMismatch(methodSignature, method);
                            this.returningPosts.put(methodSignature, method);
                        }
                    } else {
                        this.checkReturnTypesMismatch(method);
                        if (null != this.returningPost) {
                            throw SyntaxError.onlyOneMethodslessAllowed;
                        }
                        this.returningPost = method;
                    }
                } else {
                    throw SyntaxError.wrongPost;
                }
            }
        }

        private void parseAnnotationOnError(Method method) {
            if (method.isAnnotationPresent(OnError.class)) {
                this.checkIsSingle(method, OnError.class);
                Class<?> clazz = method.getReturnType();
                Object[] objectArray = method.getParameterTypes();
                Object[] objectArray2 = method.getExceptionTypes();
                OnError onError = method.getAnnotation(OnError.class);
                Class clazz2 = onError.value();
                if (Arrays.deepEquals(new Class[]{Method.class, clazz2}, objectArray) && Arrays.deepEquals(new Class[]{clazz2}, objectArray2) && Void.TYPE.equals(clazz)) {
                    if (method.isAnnotationPresent(Methods.class)) {
                        for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                            MethodSignature methodSignature = new MethodSignature(signature.name(), signature.args(), null);
                            HashMap<Class, Method> hashMap = (HashMap<Class, Method>)this.voidOnErrors.get(methodSignature);
                            if (null == hashMap) {
                                hashMap = new HashMap<Class, Method>();
                                this.voidOnErrors.put(methodSignature, hashMap);
                            }
                            if (null == hashMap.put(clazz2, method)) continue;
                            throw SyntaxError.onlyOneOnErrorExceptionTypeAllowed;
                        }
                    } else if (null != this.voidOnErrorsMap.put(clazz2, method)) {
                        throw SyntaxError.onlyOneMethodslessAllowed;
                    }
                } else if (Arrays.deepEquals(new Class[]{Method.class, clazz2}, objectArray) && Arrays.deepEquals(new Class[]{clazz2}, objectArray2) && !Void.TYPE.equals(clazz)) {
                    if (method.isAnnotationPresent(Methods.class)) {
                        for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                            MethodSignature methodSignature = new MethodSignature(signature.name(), signature.args(), null);
                            this.checkReturnTypesMismatch(methodSignature, method);
                            HashMap<Class, Method> hashMap = (HashMap<Class, Method>)this.returningOnErrors.get(methodSignature);
                            if (null == hashMap) {
                                hashMap = new HashMap<Class, Method>();
                                this.returningOnErrors.put(methodSignature, hashMap);
                            }
                            if (null == hashMap.put(clazz2, method)) continue;
                            throw SyntaxError.onlyOneOnErrorExceptionTypeAllowed;
                        }
                    } else {
                        this.checkReturnTypesMismatch(method);
                        if (null != this.returningOnErrorsMap.put(clazz2, method)) {
                            throw SyntaxError.onlyOneMethodslessAllowed;
                        }
                    }
                } else {
                    throw SyntaxError.wrongOnError;
                }
            }
        }

        private void parseAnnotationGetCreator(Method method) {
            if (method.isAnnotationPresent(GetCreator.class)) {
                this.checkIsSingle(method, GetCreator.class);
                if (method.isAnnotationPresent(Methods.class)) {
                    throw SyntaxError.wrongMethodsContext;
                }
                int n2 = method.getModifiers();
                if (!Modifier.isProtected(n2)) {
                    throw SyntaxError.wrongGetCreatorMustBeProtected;
                }
                if (!Modifier.isAbstract(n2)) {
                    throw SyntaxError.wrongGetCreatorMustBeAbstract;
                }
                if (!Arrays.deepEquals(new Class[0], method.getParameterTypes())) {
                    throw SyntaxError.wrongGetCreator;
                }
                if (!Object.class.equals(method.getReturnType())) {
                    throw SyntaxError.wrongGetCreator;
                }
                this.methodGetCreator = method;
            }
        }

        private void parseAnnotationGetProxy(Method method) {
            if (method.isAnnotationPresent(GetProxy.class)) {
                this.checkIsSingle(method, GetProxy.class);
                if (method.isAnnotationPresent(Methods.class)) {
                    throw SyntaxError.wrongMethodsContext;
                }
                int n2 = method.getModifiers();
                if (!Modifier.isProtected(n2)) {
                    throw SyntaxError.wrongGetProxyMustBeProtected;
                }
                if (!Modifier.isAbstract(n2)) {
                    throw SyntaxError.wrongGetProxyMustBeAbstract;
                }
                if (!Arrays.deepEquals(new Class[]{Object.class, Object.class}, method.getParameterTypes())) {
                    throw SyntaxError.wrongGetProxy;
                }
                if (!Object.class.equals(method.getReturnType())) {
                    throw SyntaxError.wrongGetProxy;
                }
                this.methodGetProxy = method;
            }
        }

        private void parseAnnotationGetDelegate(Method method) {
            if (method.isAnnotationPresent(GetDelegate.class)) {
                this.checkIsSingle(method, GetDelegate.class);
                if (method.isAnnotationPresent(Methods.class)) {
                    throw SyntaxError.wrongMethodsContext;
                }
                int n2 = method.getModifiers();
                if (!Modifier.isProtected(n2)) {
                    throw SyntaxError.wrongGetDelegateMustBeProtected;
                }
                if (!Modifier.isAbstract(n2)) {
                    throw SyntaxError.wrongGetDelegateMustBeAbstract;
                }
                if (!Arrays.deepEquals(new Class[0], method.getParameterTypes())) {
                    throw SyntaxError.wrongGetDelegate;
                }
                if (Void.TYPE.equals(method.getReturnType())) {
                    throw SyntaxError.wrongGetDelegate;
                }
                this.methodGetDelegate = method;
            }
        }

        private void parseAnnotationSetDelegate(Method method) {
            if (method.isAnnotationPresent(SetDelegate.class)) {
                this.checkIsSingle(method, SetDelegate.class);
                if (method.isAnnotationPresent(Methods.class)) {
                    throw SyntaxError.wrongMethodsContext;
                }
                int n2 = method.getModifiers();
                if (!Modifier.isProtected(n2)) {
                    throw SyntaxError.wrongSetDelegateMustBeProtected;
                }
                if (!Modifier.isAbstract(n2)) {
                    throw SyntaxError.wrongSetDelegateMustBeAbstract;
                }
                if (1 != method.getParameterTypes().length) {
                    throw SyntaxError.wrongSetDelegate;
                }
                if (!Void.TYPE.equals(method.getReturnType())) {
                    throw SyntaxError.wrongSetDelegate;
                }
                this.methodSetDelegate = method;
            }
        }

        private Rest parseAnnotations() {
            this.parseAnnotationProxyFor();
            this.parseAnnotationProxyAccess();
            this.parseAnnotationProxyLocale();
            this.parseAnnotationTypeProxyResult();
            for (Method method : this.superclass.getDeclaredMethods()) {
                this.parseAnnotationPre(method);
                this.parseAnnotationPost(method);
                this.parseAnnotationOnError(method);
                this.parseAnnotationGetCreator(method);
                this.parseAnnotationGetProxy(method);
                this.parseAnnotationGetDelegate(method);
                this.parseAnnotationSetDelegate(method);
            }
            if (null != this.proxyAccessIface) {
                for (Class clazz : this.ifacesToProxy) {
                    try {
                        clazz.asSubclass(this.proxyAccessIface);
                    }
                    catch (ClassCastException classCastException) {
                        throw SyntaxError.mustExtendProxyAccessIface(clazz, this.proxyAccessIface);
                    }
                }
            }
            return new Rest(this.pre, this.voidPost, this.returningPost, this.voidOnErrorsMap, this.returningOnErrorsMap);
        }

        boolean belongsToIfaceToProxy(Class clazz, MethodSignature methodSignature) {
            for (Class clazz2 : this.ifacesToProxy) {
                try {
                    clazz.asSubclass(clazz2);
                    if (!this.isMethodDeclared(clazz2, methodSignature)) continue;
                    return true;
                }
                catch (ClassCastException classCastException) {
                }
            }
            return false;
        }

        private boolean isMethodDeclared(Class clazz, MethodSignature methodSignature) {
            try {
                if (null != clazz.getDeclaredMethod(methodSignature.getName(), methodSignature.getParameterTypes())) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!this.isMethodDeclared(clazz2, methodSignature)) continue;
                return true;
            }
            return false;
        }

        Method getMethodPre(Class clazz, MethodSignature methodSignature) {
            Method method = (Method)this.pres.get(methodSignature);
            if (null != method) {
                return method;
            }
            return this.belongsToIfaceToProxy(clazz, methodSignature) ? this.rest.getPre() : null;
        }

        Method getMethodVoidPost(Class clazz, MethodSignature methodSignature) {
            Method method = (Method)this.voidPosts.get(methodSignature);
            if (null != method) {
                return method;
            }
            return this.belongsToIfaceToProxy(clazz, methodSignature) ? this.rest.getVoidPost() : null;
        }

        Method getMethodReturningPost(Class clazz, MethodSignature methodSignature) {
            Method method = (Method)this.returningPosts.get(methodSignature);
            if (null != method) {
                return method;
            }
            return this.belongsToIfaceToProxy(clazz, methodSignature) ? this.rest.getReturningPost() : null;
        }

        Map<Class, Method> getMapVoidOnError(Class clazz, MethodSignature methodSignature) {
            Map map = (Map)this.voidOnErrors.get(methodSignature);
            if (null != map) {
                return map;
            }
            return this.belongsToIfaceToProxy(clazz, methodSignature) ? this.rest.getVoidOnError() : null;
        }

        Map<Class, Method> getMapReturningOnError(Class clazz, MethodSignature methodSignature) {
            Map map = (Map)this.returningOnErrors.get(methodSignature);
            if (null != map) {
                return map;
            }
            return this.belongsToIfaceToProxy(clazz, methodSignature) ? this.rest.getReturningOnError() : null;
        }

        Method getMethodGetCreator() {
            return this.methodGetCreator;
        }

        Method getMethodGetDelegate() {
            return this.methodGetDelegate;
        }

        Method getMethodGetProxy() {
            return this.methodGetProxy;
        }

        Method getMethodSetDelegate() {
            return this.methodSetDelegate;
        }

        List<Class> getIfacesToProxy() {
            return this.ifacesToProxy;
        }

        Class getSuperclass() {
            return this.superclass;
        }

        boolean isProxyLocale() {
            return this.isProxyLocale;
        }

        ProxyResultPolicy getProxyResultPolicy() {
            return this.proxyResultPolicy;
        }

        ProxyResultPolicy getProxyResultPolicy(Method method) {
            Method method2;
            try {
                method2 = this.superclass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return this.proxyResultPolicy;
            }
            if (method2.isAnnotationPresent(ProxyResult.class)) {
                ProxyResult proxyResult = method2.getAnnotation(ProxyResult.class);
                return proxyResult.value();
            }
            return this.proxyResultPolicy;
        }

        Class getProxyAccessIface() {
            return this.proxyAccessIface;
        }

        Method getProxyAccessGetter() {
            return this.proxyAccessGetter;
        }

        Method getProxyAccessSetter() {
            return this.proxyAccessSetter;
        }

        private static class Rest {
            private final Method pre;
            private final Method voidPost;
            private final Method returningPost;
            private final Map<Class, Method> voidOnErrorsMap;
            private final Map<Class, Method> returningOnErrorsMap;

            Rest(Method method, Method method2, Method method3, Map<Class, Method> map, Map<Class, Method> map2) {
                this.pre = method;
                this.voidPost = method2;
                this.returningPost = method3;
                this.voidOnErrorsMap = map;
                this.returningOnErrorsMap = map2;
            }

            Method getPre() {
                return this.pre;
            }

            Map<Class, Method> getReturningOnError() {
                return this.returningOnErrorsMap;
            }

            Method getReturningPost() {
                return this.returningPost;
            }

            Map<Class, Method> getVoidOnError() {
                return this.voidOnErrorsMap;
            }

            Method getVoidPost() {
                return this.voidPost;
            }
        }

        private static class MethodSpecific<T> {
            private final Map<MethodSignature, T> ref = new HashMap<MethodSignature, T>();
            private final String annotationType;

            private MethodSpecific(String string) {
                this.annotationType = string;
            }

            void put(MethodSignature methodSignature, T t2) {
                if (null != this.ref.put(methodSignature, t2)) {
                    throw SyntaxError.annotationDefinedMoreThanOnce(this.annotationType);
                }
            }

            T get(MethodSignature methodSignature) {
                return this.ref.get(methodSignature);
            }

            static final class ReturningOnErrors
            extends MethodSpecific<Map<Class, Method>> {
                ReturningOnErrors() {
                    super("Returning @OnError");
                }
            }

            static final class VoidOnErrors
            extends MethodSpecific<Map<Class, Method>> {
                VoidOnErrors() {
                    super("Void @OnError");
                }
            }

            static final class ReturningPosts
            extends MethodSpecific<Method> {
                ReturningPosts() {
                    super("Returning @Post");
                }
            }

            static final class VoidPosts
            extends MethodSpecific<Method> {
                VoidPosts() {
                    super("Void @Post");
                }
            }

            static final class Pres
            extends MethodSpecific<Method> {
                Pres() {
                    super("@Pre");
                }
            }
        }
    }

    private static class SyntaxError
    extends RuntimeException {
        private static final SyntaxError onlyOneAllowed = new SyntaxError("only one @Pre/@Post/@OnError/@GetDelegate/@SetDelegate/@GetCreator/@GetProxy allowed");
        private static final SyntaxError onlyOneMethodslessAllowed = new SyntaxError("only one @Methods-less @Pre/@Post/@OnError allowed");
        private static final SyntaxError wrongMethodsContext = new SyntaxError("wrong context for @Methods");
        private static final SyntaxError wrongPre = new SyntaxError("wrong @Pre");
        private static final SyntaxError wrongPost = new SyntaxError("wrong @Post");
        private static final SyntaxError wrongOnError = new SyntaxError("wrong @OnError");
        private static final SyntaxError onlyOneOnErrorExceptionTypeAllowed = new SyntaxError("only one @OnError Exception type allowed for a given method");
        private static final SyntaxError wrongGetCreator = new SyntaxError("wrong @GetCreator");
        private static final SyntaxError wrongGetCreatorMustBeProtected = new SyntaxError("wrong @GetCreator: must be protected");
        private static final SyntaxError wrongGetCreatorMustBeAbstract = new SyntaxError("wrong @GetCreator: must be abstract");
        private static final SyntaxError wrongGetDelegate = new SyntaxError("wrong @GetDelegate");
        private static final SyntaxError wrongGetDelegateMustBeProtected = new SyntaxError("wrong @GetDelegate: must be protected");
        private static final SyntaxError wrongGetDelegateMustBeAbstract = new SyntaxError("wrong @GetDelegate: must be abstract");
        private static final SyntaxError wrongGetProxy = new SyntaxError("wrong @GetProxy");
        private static final SyntaxError wrongGetProxyMustBeProtected = new SyntaxError("wrong @GetProxy: must be protected");
        private static final SyntaxError wrongGetProxyMustBeAbstract = new SyntaxError("wrong @GetProxy: must be abstract");
        private static final SyntaxError wrongSetDelegate = new SyntaxError("wrong @SetDelegate");
        private static final SyntaxError wrongSetDelegateMustBeProtected = new SyntaxError("wrong @SetDelegate: must be protected");
        private static final SyntaxError wrongSetDelegateMustBeAbstract = new SyntaxError("wrong @SetDelegate: must be abstract");

        SyntaxError(String string) {
            super(string);
        }

        private static SyntaxError mustBeClass(Class clazz) {
            return new SyntaxError(clazz.getName() + " must be an abstract or concrete class");
        }

        private static SyntaxError mustBeIface(Class clazz) {
            return new SyntaxError(clazz.getName() + " must be an interface");
        }

        private static SyntaxError mustNotImplementIfaces(Class clazz) {
            return new SyntaxError(clazz.getName() + " must not implement interfaces");
        }

        private static SyntaxError wrongProxyAccessIface(Class clazz) {
            return new SyntaxError(clazz.getName() + " wrong @ProxyAccess argument.  " + "Must contain an interface with a simple getter and a simple setter and nothing else, like:\n" + "public interface Proxyable<T> {\n" + "  void setProxy(T proxy);\n" + "  T getProxy();\n" + "}");
        }

        private static SyntaxError annotationDefinedMoreThanOnce(String string) {
            return new SyntaxError(string + " is defined more than once for the same method");
        }

        private static SyntaxError mustExtendProxyAccessIface(Class clazz, Class clazz2) {
            return new SyntaxError(clazz.getName() + " must extends @ProxyAccess interface " + clazz2.getName());
        }

        private static SyntaxError noProxyForClass(Class clazz) {
            return new SyntaxError("no @ProxyFor for class " + clazz.getName());
        }

        private static SyntaxError returnTypeMismatch(Method method, Method method2) {
            return new SyntaxError("interceptor " + method.getName() + " and interceptee " + method2.getName() + ": have different return types (" + method.getReturnType().getName() + " and " + method2.getReturnType().getName() + ")");
        }
    }
}

