/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import java.io.File;
import picard.PicardException;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Illumina;

@CommandLineProgramProperties(usage="Program to collect Coverage Summary Metrics of SAM files for data sequenced by Illumina products. It uses our best approximation of the filters that Illumina uses which means:\n\n1. Examine PF reads only2. Examine reads that are not marked as duplicate only3. Examine mapped reads only (it is unclear if Illumina does this or not, but without this we cannot do the next point)4. Only count bases that are present in two of mated reads, once. (For this we need TLEN from the sam record, which required that reads are mapped)\nProgram assumes that all reads in the SAM file are of equal length, and that if a read is marked as \"mated\", its mate will really exist.\n", usageShort="Collects summary metrics according to Illumina specifications.", programGroup=Illumina.class)
public class CollectIlluminaSummaryMetrics
extends SinglePassSamProgram {
    @Option(doc="IntervalList describing the target interval of the sequencing experiment (for calculating average coverage). Use null to use reference from BAM as interval (whole genome)", optional=true)
    public File TARGET_REGION = null;
    private final IlluminaSummaryMetrics metrics = new IlluminaSummaryMetrics();
    private static final Log log = Log.getInstance(CollectIlluminaSummaryMetrics.class);
    private Integer readLength = 0;

    public static void main(String[] argv) {
        new CollectIlluminaSummaryMetrics().instanceMainWithExit(argv);
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        if (this.TARGET_REGION == null) {
            this.metrics.TARGET_TERRITORY = header.getSequenceDictionary().getReferenceLength();
        } else {
            IOUtil.assertFileIsReadable((File)this.TARGET_REGION);
            IOUtil.assertFileIsWritable((File)this.OUTPUT);
            IntervalList targetInterval = IntervalList.fromFile((File)this.TARGET_REGION);
            this.metrics.TARGET_TERRITORY = targetInterval.getUniqueBaseCount();
        }
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        boolean isPfRead;
        if (this.readLength == 0) {
            this.readLength = rec.getReadLength();
        } else if (rec.getReadLength() != this.readLength.intValue()) {
            String message = String.format("This program only works with uniform read lengths. First record had length %d. Current record %s, has length %d", this.readLength, rec.getReadName(), rec.getReadLength());
            log.error(new Object[]{message});
            throw new PicardException(message);
        }
        if (rec.getReadUnmappedFlag() || rec.isSecondaryOrSupplementary()) {
            return;
        }
        ++this.metrics.TOTAL_READS;
        int length = rec.getReadLength();
        this.metrics.TOTAL_BASES += (long)length;
        boolean bl = isPfRead = !rec.getReadFailsVendorQualityCheckFlag();
        if (isPfRead) {
            ++this.metrics.PF_READS;
            this.metrics.PF_BASES += (long)length;
        } else {
            return;
        }
        if (rec.getDuplicateReadFlag()) {
            ++this.metrics.DUPLICATE_READS;
            return;
        }
        int tLen = Math.abs(rec.getInferredInsertSize());
        if (rec.getReadPairedFlag() && !rec.getMateUnmappedFlag() && !rec.getReadUnmappedFlag() && tLen != 0) {
            if (rec.getFirstOfPairFlag()) {
                this.metrics.TOTAL_ILLUMINA_BASES = rec.getReadNegativeStrandFlag() ^ rec.getMateNegativeStrandFlag() ? (this.metrics.TOTAL_ILLUMINA_BASES += (long)Math.min(2 * length, tLen)) : (this.metrics.TOTAL_ILLUMINA_BASES += (long)(length + Math.min(length, tLen)));
            }
        } else {
            this.metrics.TOTAL_ILLUMINA_BASES += (long)rec.getReadLength();
        }
    }

    @Override
    protected boolean usesNoRefReads() {
        return false;
    }

    @Override
    protected void finish() {
        this.metrics.READ_LENGTH = this.readLength.intValue();
        this.metrics.AVERAGE_ILMN_DEPTH = (double)this.metrics.TOTAL_ILLUMINA_BASES / (double)this.metrics.TARGET_TERRITORY;
        MetricsFile metricsFile = this.getMetricsFile();
        metricsFile.addMetric((MetricBase)this.metrics);
        metricsFile.write(this.OUTPUT);
    }

    public static class IlluminaSummaryMetrics
    extends MetricBase {
        public int TOTAL_READS = 0;
        public int PF_READS = 0;
        public int DUPLICATE_READS = 0;
        public long TOTAL_BASES;
        public long PF_BASES = 0L;
        public long TOTAL_ILLUMINA_BASES = 0L;
        public double AVERAGE_ILMN_DEPTH = 0.0;
        public long READ_LENGTH = 0L;
        public long TARGET_TERRITORY = 0L;

        public IlluminaSummaryMetrics() {
        }

        public IlluminaSummaryMetrics(int TOTAL_READS, int PF_READS, int DUPLICATE_READS, long TOTAL_BASES, long PF_BASES, long TOTAL_ILLUMINA_BASES, double AVERAGE_ILMN_DEPTH, long READ_LENGTH, long TARGET_TERRITORY) {
            this.TOTAL_READS = TOTAL_READS;
            this.PF_READS = PF_READS;
            this.DUPLICATE_READS = DUPLICATE_READS;
            this.TOTAL_BASES = TOTAL_BASES;
            this.PF_BASES = PF_BASES;
            this.TOTAL_ILLUMINA_BASES = TOTAL_ILLUMINA_BASES;
            this.AVERAGE_ILMN_DEPTH = AVERAGE_ILMN_DEPTH;
            this.READ_LENGTH = READ_LENGTH;
            this.TARGET_TERRITORY = TARGET_TERRITORY;
        }
    }
}

