/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.counts;

import edu.cornell.med.icb.goby.counts.CountsArchiveReader;
import edu.cornell.med.icb.goby.counts.CountsReader;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.bdval.io.compound.CompoundDataInput;

public class CachingCountsArchiveReader
extends CountsArchiveReader {
    private byte[] bytes;
    private String previousId;
    private byte[] indexBytes;
    private boolean hasIndex;
    int previousIndex = -1;

    public CachingCountsArchiveReader(String basename) throws IOException {
        super(basename);
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    @Override
    public CountsReader getCountReader(String identifier) throws IOException {
        if (identifier == null || this.previousId == null || !identifier.equals(this.previousId)) {
            String name = this.makeFileIdentifier(identifier);
            CompoundDataInput input = this.compoundReader.readFile(name);
            this.bytes = new byte[(int)input.length()];
            input.readFully(this.bytes);
            String indexName = "#index:" + name;
            if (this.compoundReader.containsFile(indexName)) {
                CompoundDataInput indexInput = this.compoundReader.readFile(indexName);
                this.indexBytes = new byte[(int)indexInput.length()];
                indexInput.readFully(this.indexBytes);
                this.hasIndex = true;
            }
            this.previousId = identifier;
        }
        FastByteArrayInputStream stream = new FastByteArrayInputStream(this.bytes);
        if (this.hasIndex) {
            DataInputStream indexDataInput = new DataInputStream(new FastByteArrayInputStream(this.indexBytes));
            return new CountsReader(stream, indexDataInput);
        }
        return new CountsReader(stream);
    }
}

