/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.algorithmic.compression;

import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;

public final class FastArithmeticCoder {
    public static final int BITS = 63;
    private static final long HALF = 0x4000000000000000L;
    private static final long QUARTER = 0x2000000000000000L;
    private int[] cumCount;
    private int total;
    private int n;
    private long low = 0L;
    private long range = 0x4000000000000000L;
    private long outstandingBits = 0L;
    private boolean firstBit = true;

    public void reset() {
        this.range = 0x4000000000000000L;
        this.outstandingBits = 0L;
        this.low = 0L;
        this.firstBit = true;
    }

    public FastArithmeticCoder(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("You cannot use " + n + " symbols.");
        }
        this.n = n;
        this.cumCount = new int[n + 1];
        for (int i = 0; i < n; ++i) {
            this.incrementCount(i);
        }
        this.total = n;
    }

    private void incrementCount(int x) {
        ++x;
        while (x <= this.n) {
            int n = x;
            this.cumCount[n] = this.cumCount[n] + 1;
            x += x & -x;
        }
    }

    private int getCount(int x) {
        int c = 0;
        while (x != 0) {
            c += this.cumCount[x];
            x &= x - 1;
        }
        return c;
    }

    private int emit(int bit, OutputBitStream obs) throws IOException {
        if (this.firstBit) {
            this.firstBit = false;
            return 0;
        }
        int l = obs.writeBit(bit);
        while (this.outstandingBits-- != 0L) {
            l += obs.writeBit(1 - bit);
        }
        this.outstandingBits = 0L;
        return l;
    }

    public int encode(int x, OutputBitStream obs) throws IOException {
        if (x < 0) {
            throw new IllegalArgumentException("You cannot encode a negative symbol.");
        }
        if (x >= this.n) {
            throw new IllegalArgumentException("You cannot encode " + x + ": you have only " + this.n + " symbols.");
        }
        long r = this.range / (long)this.total;
        int lowCount = this.getCount(x);
        int highCount = this.getCount(x + 1);
        this.low += r * (long)lowCount;
        this.range = x != this.n - 1 ? r * (long)(highCount - lowCount) : (this.range -= r * (long)lowCount);
        this.incrementCount(x);
        ++this.total;
        int l = 0;
        while (this.range <= 0x2000000000000000L) {
            if (this.low >= 0x4000000000000000L) {
                l += this.emit(1, obs);
                this.low -= 0x4000000000000000L;
            } else if (this.range + this.low <= 0x4000000000000000L) {
                l += this.emit(0, obs);
            } else {
                this.low -= 0x2000000000000000L;
                ++this.outstandingBits;
            }
            this.range <<= 1;
            this.low <<= 1;
        }
        return l;
    }

    public int flush(OutputBitStream obs) throws IOException {
        long roundup;
        long value;
        int nbits;
        int l = 0;
        long bits = 0L;
        for (nbits = 1; nbits <= 63 && (this.low > (value = (bits = this.low + (roundup = (1L << 63 - nbits) - 1L) >>> 63 - nbits) << 63 - nbits) || value + roundup > this.low + (this.range - 1L) && (value + roundup < 0L || this.low + (this.range - 1L) >= 0L)); ++nbits) {
        }
        for (int i = 1; i <= nbits; ++i) {
            l += this.emit((int)(bits >>> nbits - i & 1L), obs);
        }
        return l;
    }
}

