/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import java.util.Arrays;
import org.broadinstitute.sting.utils.recalibration.EventType;

public class ReadCovariates {
    private final int[][][] keys;
    private int currentCovariateIndex = 0;

    public ReadCovariates(int readLength, int numberOfCovariates) {
        this.keys = new int[EventType.values().length][readLength][numberOfCovariates];
    }

    public void setCovariateIndex(int index) {
        this.currentCovariateIndex = index;
    }

    public ReadCovariates clear() {
        for (int i = 0; i < this.keys.length; ++i) {
            for (int j = 0; j < this.keys[i].length; ++j) {
                Arrays.fill(this.keys[i][j], 0);
            }
        }
        return this;
    }

    public void addCovariate(int mismatch, int insertion, int deletion, int readOffset) {
        this.keys[EventType.BASE_SUBSTITUTION.index][readOffset][this.currentCovariateIndex] = mismatch;
        this.keys[EventType.BASE_INSERTION.index][readOffset][this.currentCovariateIndex] = insertion;
        this.keys[EventType.BASE_DELETION.index][readOffset][this.currentCovariateIndex] = deletion;
    }

    public int[] getKeySet(int readPosition, EventType errorModel) {
        return this.keys[errorModel.index][readPosition];
    }

    public int[][] getKeySet(EventType errorModel) {
        return this.keys[errorModel.index];
    }

    public int[] getMismatchesKeySet(int readPosition) {
        return this.keys[EventType.BASE_SUBSTITUTION.index][readPosition];
    }

    public int[] getInsertionsKeySet(int readPosition) {
        return this.keys[EventType.BASE_INSERTION.index][readPosition];
    }

    public int[] getDeletionsKeySet(int readPosition) {
        return this.keys[EventType.BASE_DELETION.index][readPosition];
    }

    protected int[][] getMismatchesKeySet() {
        return this.keys[EventType.BASE_SUBSTITUTION.index];
    }

    protected int[][] getInsertionsKeySet() {
        return this.keys[EventType.BASE_INSERTION.index];
    }

    protected int[][] getDeletionsKeySet() {
        return this.keys[EventType.BASE_DELETION.index];
    }
}

