/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.PrivateIpAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateNetworkInterfaceRequest
extends AmazonWebServiceRequest {
    private Boolean dryRun;
    private String subnetId;
    private String description;
    private String privateIpAddress;
    private List<String> groups;
    private List<PrivateIpAddress> privateIpAddresses;
    private Integer secondaryPrivateIpAddressCount;

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public CreateNetworkInterfaceRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public CreateNetworkInterfaceRequest withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateNetworkInterfaceRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public CreateNetworkInterfaceRequest withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public List<String> getGroups() {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        ArrayList<String> groupsCopy = new ArrayList<String>(groups.size());
        groupsCopy.addAll(groups);
        this.groups = groupsCopy;
    }

    public CreateNetworkInterfaceRequest withGroups(String ... groups) {
        if (this.getGroups() == null) {
            this.setGroups(new ArrayList<String>(groups.length));
        }
        for (String value : groups) {
            this.getGroups().add(value);
        }
        return this;
    }

    public CreateNetworkInterfaceRequest withGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
        } else {
            ArrayList<String> groupsCopy = new ArrayList<String>(groups.size());
            groupsCopy.addAll(groups);
            this.groups = groupsCopy;
        }
        return this;
    }

    public List<PrivateIpAddress> getPrivateIpAddresses() {
        if (this.privateIpAddresses == null) {
            this.privateIpAddresses = new ArrayList<PrivateIpAddress>();
        }
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(Collection<PrivateIpAddress> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
            return;
        }
        ArrayList<PrivateIpAddress> privateIpAddressesCopy = new ArrayList<PrivateIpAddress>(privateIpAddresses.size());
        privateIpAddressesCopy.addAll(privateIpAddresses);
        this.privateIpAddresses = privateIpAddressesCopy;
    }

    public CreateNetworkInterfaceRequest withPrivateIpAddresses(PrivateIpAddress ... privateIpAddresses) {
        if (this.getPrivateIpAddresses() == null) {
            this.setPrivateIpAddresses(new ArrayList<PrivateIpAddress>(privateIpAddresses.length));
        }
        for (PrivateIpAddress value : privateIpAddresses) {
            this.getPrivateIpAddresses().add(value);
        }
        return this;
    }

    public CreateNetworkInterfaceRequest withPrivateIpAddresses(Collection<PrivateIpAddress> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
        } else {
            ArrayList<PrivateIpAddress> privateIpAddressesCopy = new ArrayList<PrivateIpAddress>(privateIpAddresses.size());
            privateIpAddressesCopy.addAll(privateIpAddresses);
            this.privateIpAddresses = privateIpAddressesCopy;
        }
        return this;
    }

    public Integer getSecondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
    }

    public CreateNetworkInterfaceRequest withSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dryRun != null) {
            sb.append("DryRun: " + this.dryRun + ", ");
        }
        if (this.subnetId != null) {
            sb.append("SubnetId: " + this.subnetId + ", ");
        }
        if (this.description != null) {
            sb.append("Description: " + this.description + ", ");
        }
        if (this.privateIpAddress != null) {
            sb.append("PrivateIpAddress: " + this.privateIpAddress + ", ");
        }
        if (this.groups != null) {
            sb.append("Groups: " + this.groups + ", ");
        }
        if (this.privateIpAddresses != null) {
            sb.append("PrivateIpAddresses: " + this.privateIpAddresses + ", ");
        }
        if (this.secondaryPrivateIpAddressCount != null) {
            sb.append("SecondaryPrivateIpAddressCount: " + this.secondaryPrivateIpAddressCount + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddresses() == null ? 0 : this.getPrivateIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryPrivateIpAddressCount() == null ? 0 : this.getSecondaryPrivateIpAddressCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInterfaceRequest)) {
            return false;
        }
        CreateNetworkInterfaceRequest other = (CreateNetworkInterfaceRequest)((Object)obj);
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getPrivateIpAddresses() == null ^ this.getPrivateIpAddresses() == null) {
            return false;
        }
        if (other.getPrivateIpAddresses() != null && !other.getPrivateIpAddresses().equals(this.getPrivateIpAddresses())) {
            return false;
        }
        if (other.getSecondaryPrivateIpAddressCount() == null ^ this.getSecondaryPrivateIpAddressCount() == null) {
            return false;
        }
        return other.getSecondaryPrivateIpAddressCount() == null || other.getSecondaryPrivateIpAddressCount().equals(this.getSecondaryPrivateIpAddressCount());
    }
}

