/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig.keyinfo;

import java.math.BigInteger;
import java.security.KeyException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class KeyInfoFactoryTest
extends TestCase {
    KeyInfoFactory factory;

    public KeyInfoFactoryTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.factory = KeyInfoFactory.getInstance("DOM", new XMLDSigRI());
    }

    public void tearDown() {
    }

    public void testgetInstance() {
        try {
            KeyInfoFactory.getInstance("non-existent");
            KeyInfoFactoryTest.fail((String)"Should throw NoSuchMechanismException if no impl found");
        }
        catch (NoSuchMechanismException noSuchMechanismException) {
            // empty catch block
        }
        try {
            KeyInfoFactory.getInstance(null);
            KeyInfoFactoryTest.fail((String)"Should raise a NPE for null xmltype");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testgetMechanismType() {
        KeyInfoFactoryTest.assertNotNull((Object)this.factory);
        KeyInfoFactoryTest.assertEquals((String)"DOM", (String)this.factory.getMechanismType());
    }

    public void testisFeatureSupported() {
        try {
            this.factory.isFeatureSupported(null);
            KeyInfoFactoryTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        KeyInfoFactoryTest.assertTrue((!this.factory.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }

    public void testnewKeyInfo() {
        String string = "keyId";
        KeyInfo keyInfo = this.factory.newKeyInfo(Collections.singletonList(this.factory.newKeyName("foo")), string);
        KeyInfoFactoryTest.assertEquals((String)string, (String)keyInfo.getId());
        try {
            keyInfo = this.factory.newKeyInfo(null, string);
            KeyInfoFactoryTest.fail((String)"Should raise a NPE for null key info types");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testnewKeyName() {
        KeyName keyName = this.factory.newKeyName("keyName");
        KeyInfoFactoryTest.assertEquals((String)"keyName", (String)keyName.getName());
        try {
            keyName = this.factory.newKeyName(null);
            KeyInfoFactoryTest.fail((String)"Should raise a NPE for null key name");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testnewKeyValue() {
        PublicKey publicKey = new PublicKey(){

            public byte[] getEncoded() {
                return new byte[20];
            }

            public String getFormat() {
                return "none";
            }

            public String getAlgorithm() {
                return "test";
            }
        };
        try {
            KeyValue keyValue = this.factory.newKeyValue(publicKey);
            KeyInfoFactoryTest.assertEquals((Object)publicKey, (Object)keyValue.getPublicKey());
            KeyInfoFactoryTest.fail((String)"Should throw a KeyException");
        }
        catch (KeyException keyException) {
            // empty catch block
        }
        try {
            this.factory.newKeyValue(null);
            KeyInfoFactoryTest.fail((String)"Should raise a NPE for null key");
        }
        catch (KeyException keyException) {
            KeyInfoFactoryTest.fail((String)"Should raise a NPE for null key");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testnewPGPKeyId() {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] byArray3 = new byte[]{-58, 1, 0};
        byte[] byArray4 = new byte[]{-56, 1, 0};
        PGPData pGPData = this.factory.newPGPData(byArray);
        KeyInfoFactoryTest.assertTrue((boolean)Arrays.equals(byArray, pGPData.getKeyId()));
        try {
            pGPData = this.factory.newPGPData(byArray2);
            KeyInfoFactoryTest.fail((String)"Should throw IAE for invalid key id values");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        pGPData = this.factory.newPGPData(byArray, byArray3, null);
        KeyInfoFactoryTest.assertTrue((boolean)Arrays.equals(byArray, pGPData.getKeyId()));
        KeyInfoFactoryTest.assertTrue((boolean)Arrays.equals(byArray3, pGPData.getKeyPacket()));
        try {
            pGPData = this.factory.newPGPData(byArray2, byArray3, null);
            KeyInfoFactoryTest.fail((String)"Should throw IAE for invalid key id values");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            pGPData = this.factory.newPGPData(byArray, byArray4, null);
            KeyInfoFactoryTest.fail((String)"Should throw IAE for invalid key packet values");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            pGPData = this.factory.newPGPData(byArray2, byArray4, null);
            KeyInfoFactoryTest.fail((String)"Should throw IAE for invalid key id and packet values");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        pGPData = this.factory.newPGPData(byArray3, null);
        KeyInfoFactoryTest.assertTrue((boolean)Arrays.equals(byArray3, pGPData.getKeyPacket()));
        try {
            pGPData = this.factory.newPGPData(byArray4, null);
            KeyInfoFactoryTest.fail((String)"Should throw IAE for invalid key packet values");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testnewRetrievalMethod() throws Exception {
        RetrievalMethod retrievalMethod = this.factory.newRetrievalMethod("#X509CertChain");
        KeyInfoFactoryTest.assertEquals((String)"#X509CertChain", (String)retrievalMethod.getURI());
        try {
            retrievalMethod = this.factory.newRetrievalMethod(null);
            KeyInfoFactoryTest.fail((String)"Should raise a NPE for null URI");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            retrievalMethod = this.factory.newRetrievalMethod(null, null, null);
            KeyInfoFactoryTest.fail((String)"Should raise a NPE for null URI");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String string = "http://www.w3.org/2000/09/xmldsig#X509Data";
        try {
            retrievalMethod = this.factory.newRetrievalMethod(null, string, null);
            KeyInfoFactoryTest.fail((String)"Should raise a NPE for null URI");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        retrievalMethod = this.factory.newRetrievalMethod("#X509CertChain", string, null);
        KeyInfoFactoryTest.assertEquals((String)"#X509CertChain", (String)retrievalMethod.getURI());
        KeyInfoFactoryTest.assertEquals((String)string, (String)retrievalMethod.getType());
    }

    public void testnewX509Data() {
        X509Data x509Data = this.factory.newX509Data(Collections.singletonList("cn=foo"));
        KeyInfoFactoryTest.assertNotNull((Object)x509Data);
    }

    public void testnewX509IssuerSerial() {
        String string = "CN=valeriep";
        X509IssuerSerial x509IssuerSerial = this.factory.newX509IssuerSerial(string, BigInteger.ONE);
        KeyInfoFactoryTest.assertEquals((String)string, (String)x509IssuerSerial.getIssuerName());
        KeyInfoFactoryTest.assertEquals((Object)BigInteger.ONE, (Object)x509IssuerSerial.getSerialNumber());
        try {
            x509IssuerSerial = this.factory.newX509IssuerSerial(null, BigInteger.ZERO);
            KeyInfoFactoryTest.fail((String)"Should raise an NPE for null issuer names");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            KeyInfoFactoryTest.fail((String)"Should throw NPE instead of IAE for null issuer names");
        }
        try {
            x509IssuerSerial = this.factory.newX509IssuerSerial(string, null);
            KeyInfoFactoryTest.fail((String)"Should raise an NPE for null serial numbers");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            KeyInfoFactoryTest.fail((String)"Should throw NPE instead of IAE for null serial numbers");
        }
        try {
            x509IssuerSerial = this.factory.newX509IssuerSerial(null, null);
            KeyInfoFactoryTest.fail((String)"Should raise an NPE for null issuer names/serial numbers");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            KeyInfoFactoryTest.fail((String)"Should throw NPE instead of IAE for null issuer names/serial numbers");
        }
        try {
            x509IssuerSerial = this.factory.newX509IssuerSerial("valeriep", BigInteger.ZERO);
            KeyInfoFactoryTest.fail((String)"Should throw IAE for invalid issuer names");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) throws Exception {
        KeyInfoFactoryTest keyInfoFactoryTest = new KeyInfoFactoryTest("KeyInfoFactoryTest");
        keyInfoFactoryTest.setUp();
    }
}

