/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.dynamic;

import java.util.LinkedList;
import org.mvel2.optimizers.dynamic.DynamicAccessor;
import org.mvel2.util.MVELClassLoader;

public class DynamicClassLoader
extends ClassLoader
implements MVELClassLoader {
    private int totalClasses;
    private int tenureLimit;
    private final LinkedList<DynamicAccessor> allAccessors = new LinkedList();

    public DynamicClassLoader(ClassLoader classLoader, int tenureLimit) {
        super(classLoader);
        this.tenureLimit = tenureLimit;
    }

    public Class defineClassX(String className, byte[] b, int start, int end) {
        ++this.totalClasses;
        return super.defineClass(className, b, start, end);
    }

    public int getTotalClasses() {
        return this.totalClasses;
    }

    public DynamicAccessor registerDynamicAccessor(DynamicAccessor accessor) {
        this.allAccessors.add(accessor);
        assert (accessor != null);
        return accessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deoptimizeAll() {
        LinkedList<DynamicAccessor> linkedList = this.allAccessors;
        synchronized (linkedList) {
            for (DynamicAccessor a : this.allAccessors) {
                if (a == null) continue;
                a.deoptimize();
            }
            this.allAccessors.clear();
        }
    }

    public boolean isOverloaded() {
        return this.tenureLimit < this.totalClasses;
    }
}

