// This file is auto-generated by the build script
// Please, do not modify it manually

use super::test_markdown_html;

#[test]
fn regression_test_1() {
    let original = r##"<details><summary>Testing 1..2..3..</summary>

This is a test of the details element.

</details>
"##;
    let expected = r##"<details><summary>Testing 1..2..3..</summary>
<p>This is a test of the details element.</p>
</details>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_2() {
    let original = r##"see the [many] [articles] [on] [QuickCheck].

[many]: https://medium.com/@jlouis666/quickcheck-advice-c357efb4e7e6
[articles]: http://www.quviq.com/products/erlang-quickcheck/
[on]: https://wiki.haskell.org/Introduction_to_QuickCheck1
[QuickCheck]: https://hackage.haskell.org/package/QuickCheck
"##;
    let expected = r##"<p>see the 
  <a href="https://medium.com/@jlouis666/quickcheck-advice-c357efb4e7e6">many</a> 
  <a href="http://www.quviq.com/products/erlang-quickcheck/">articles</a> 
  <a href="https://wiki.haskell.org/Introduction_to_QuickCheck1">on</a> 
  <a href="https://hackage.haskell.org/package/QuickCheck">QuickCheck</a>.
</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_3() {
    let original = r##"[![debug-stub-derive on crates.io][cratesio-image]][cratesio]
[![debug-stub-derive on docs.rs][docsrs-image]][docsrs]

[cratesio-image]: https://img.shields.io/crates/v/debug_stub_derive.svg
[cratesio]: https://crates.io/crates/debug_stub_derive
[docsrs-image]: https://docs.rs/debug_stub_derive/badge.svg?version=0.3.0
[docsrs]: https://docs.rs/debug_stub_derive/0.3.0/
"##;
    let expected = r##"<p><a href="https://crates.io/crates/debug_stub_derive"><img src="https://img.shields.io/crates/v/debug_stub_derive.svg" alt="debug-stub-derive on crates.io" /></a>
<a href="https://docs.rs/debug_stub_derive/0.3.0/"><img src="https://docs.rs/debug_stub_derive/badge.svg?version=0.3.0" alt="debug-stub-derive on docs.rs" /></a></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_4() {
    let original = r##"|  Title A  |  Title B  |
| --------- | --------- |
| Content   | Content   |

|  Title A  |  Title B  |  Title C  |  Title D  |
| --------- | --------- | --------- | ---------:|
| Content   | Content   | Conent    | Content   |
"##;
    let expected = r##"<table><thead><tr><th>Title A  </th><th>Title B  </th></tr></thead><tbody>
<tr><td>Content   </td><td>Content   </td></tr>
</tbody></table>
<table><thead><tr><th>Title A  </th><th>Title B  </th><th>Title C  </th><th align="right">Title D  </th></tr></thead><tbody>
<tr><td>Content   </td><td>Content   </td><td>Conent    </td><td align="right">Content   </td></tr>
</tbody></table>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_5() {
    let original = r##"foo§__(bar)__
"##;
    let expected = r##"<p>foo§<strong>(bar)</strong></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_6() {
    let original = r##"<https://example.com> hello
"##;
    let expected = r##"<p><a href="https://example.com">https://example.com</a> hello</p>

"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_7() {
    let original = r##"[foo][bar]

<!-- foo -->
[bar]: a
"##;
    let expected = r##"<p><a href="a">foo</a></p>
<!-- foo -->
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_8() {
    let original = r##"<!-- <dl> -->
- **foo** (u8, u8)

  make something

- **bar** (u16, u16)

  make something
"##;
    let expected = r##"<!-- <dl> -->
<ul>
<li>
<p><strong>foo</strong> (u8, u8)</p>
<p>make something</p>
</li>
<li>
<p><strong>bar</strong> (u16, u16)</p>
<p>make something</p>
</li>
</ul>

"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_9() {
    let original = r##"[`
i8
`](
../../../std/primitive.i8.html
)
"##;
    let expected = r##"<p><a href="../../../std/primitive.i8.html"><code>i8</code></a></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_10() {
    let original = r##"[a]

[a]: /url (title\\*)
"##;
    let expected = r##"<p><a href="/url" title="title\*">a</a></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_11() {
    let original = r##"[a]

[a]: /url (title\))
"##;
    let expected = r##"<p><a href="/url" title="title)">a</a></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_12() {
    let original = r##"[a]

[a]: /url (title))
"##;
    let expected = r##"<p>[a]</p>
<p>[a]: /url (title))</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_13() {
    let original = r##"a <?php this is not a valid processing tag
---
b <?php but this is ?>
"##;
    let expected = r##"<h2>a &lt;?php this is not a valid processing tag</h2>
<p>b <?php but this is ?></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_14() {
    let original = r##"[a]: u\
foo
"##;
    let expected = r##"<p>foo</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_15() {
    let original = r##"\`foo`
"##;
    let expected = r##"<p>`foo`</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_16() {
    let original = r##"foo\\
bar
"##;
    let expected = r##"<p>foo\
bar</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_17() {
    let original = r##"1\. foo

1\) bar
"##;
    let expected = r##"<p>1. foo</p>
<p>1) bar</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_18() {
    let original = r##"1...

1.2.3.

1 2 3 .

1.|2.-3.

1)2)3)
"##;
    let expected = r##"<p>1...</p>
<p>1.2.3.</p>
<p>1 2 3 .</p>
<p>1.|2.-3.</p>
<p>1)2)3)</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_19() {
    let original = r##"[](<<>)
"##;
    let expected = r##"<p>[](&lt;&lt;&gt;)</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_20() {
    let original = r##"\``foo``bar`
"##;
    let expected = r##"<p>`<code>foo``bar</code></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_21() {
    let original = r##"\\`foo`
"##;
    let expected = r##"<p>\<code>foo</code></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_22() {
    let original = r##"[\\]: x

YOLO
"##;
    let expected = r##"<p>YOLO</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_23() {
    let original = r##"lorem ipsum
A | B
---|---
foo | bar
"##;
    let expected = r##"<p>lorem ipsum
A | B
---|---
foo | bar</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_24() {
    let original = r##"foo|bar  
---|---
foo|bar
"##;
    let expected = r##"<table><thead><tr><th>foo</th><th>bar</th></tr></thead>
<tbody><tr><td>foo</td><td>bar</td></tr></tbody>
</table>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_25() {
    let original = r##"foo|bar\\
---|---
foo|bar
"##;
    let expected = r##"<table><thead><tr><th>foo</th><th>bar\</th></tr></thead>
<tbody><tr><td>foo</td><td>bar</td></tr></tbody>
</table>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_26() {
    let original = r##"[<foo>](url)
"##;
    let expected = r##"<p><a href="url"><foo></a></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_27() {
    let original = r##"[<foo>bar</foo>](url)
"##;
    let expected = r##"<p><a href="url"><foo>bar</foo></a></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_28() {
    let original = r##"![<http://example.com>](http://example.com/logo.png)
"##;
    let expected = r##"<p><img alt="http://example.com" src="http://example.com/logo.png"></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_29() {
    let original = r##"[<http://one> <http://two>](url)
"##;
    let expected = r##"<p><a href="url"></a><a href="http://one">http://one</a> <a href="http://two">http://two</a></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_30() {
    let original = r##"Markdown | Less | Pretty
--- | --- | ---
 
some text
"##;
    let expected = r##"<table><thead><tr><th>Markdown </th><th> Less </th><th> Pretty</th></tr></thead><tbody>
</tbody></table>
<p>some text</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_31() {
    let original = r##"1. > foo
2. >
"##;
    let expected = r##"<ol>
<li>
<blockquote>
<p>foo</p>
</blockquote>
</li>
<li>
<blockquote>
</blockquote>
</li>
</ol>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_32() {
    let original = r##"[
x

]: f
"##;
    let expected = r##"<p>[
x</p>
<p>]: f</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_33() {
    let original = r##"[foo]:
"##;
    let expected = r##"<p>[foo]:</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_34() {
    let original = r##"> foo | bar
> --- | ---
yolo | swag
"##;
    let expected = r##"<blockquote>
<table><thead><tr><th>foo</th><th>bar</th></tr></thead></table>
</blockquote>
<p>yolo | swag</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_35() {
    let original = r##"<foo bar>
"##;
    let expected = r##"<foo bar>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_36() {
    let original = r##"<foo bar =
 "hi"> 
"##;
    let expected = r##"<p><foo bar =
 "hi"> </p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_37() {
    let original = r##"~~*_**__

__a__
"##;
    let expected = r##"<p>~~*_**__</p>
<p><strong>a</strong></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_38() {
    let original = r##"> `
> `
"##;
    let expected = r##"<blockquote>
<p><code></code></p>
</blockquote>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_39() {
    let original = r##"`\|`
"##;
    let expected = r##"<p><code>\|</code></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_40() {
    let original = r##"Paragraph 1
    
Paragraph 2
"##;
    let expected = r##"<p>Paragraph 1</p>
<p>Paragraph 2</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_41() {
    let original = r##"\[[link text](https://www.google.com/)\]
"##;
    let expected = r##"<p>[<a href="https://www.google.com/">link text</a>]</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_42() {
    let original = r##"foo | bar
--- | ---
[a](< | url>)
"##;
    let expected = r##"<table><thead><tr><th>foo</th><th>bar</th></tr></thead><tbody><tr><td>[a](&lt;</td><td>url&gt;)</td></tr></tbody></table>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_43() {
    let original = r##"[a](url "
- - -
")
"##;
    let expected = r##"<p>[a](url "</p>
<hr>
<p>")</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_44() {
    let original = r##"[a](url

)
"##;
    let expected = r##"<p>[a](url</p>
<p>)</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_45() {
    let original = r##"[a](b "

")
"##;
    let expected = r##"<p>[a](b &quot;</p>
<p>&quot;)</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_46() {
    let original = r##"<http:// >
"##;
    let expected = r##"<p>&lt;http:// &gt;</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_47() {
    let original = r##"<http://>
"##;
    let expected = r##"<p>&lt;http://&gt;</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_48() {
    let original = r##"foo | bar
--- | ---
<http://| baz
"##;
    let expected = r##"<table>
<thead>
<tr><th>foo</th><th>bar</th></tr>
</thead>
<tbody>
<tr><td>&lt;http://</td><td>baz</td></tr>
</tbody>
</table>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_49() {
    let original = r##"foo | bar
--- | ---
<http://|>
"##;
    let expected = r##"<table>
<thead>
<tr><th>foo</th><th>bar</th></tr>
</thead>
<tbody>
<tr><td>&lt;http://</td><td>&gt;</td></tr>
</tbody>
</table>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_50() {
    let original = r##"<sup>\*hi</sup>\_
"##;
    let expected = r##"<p><sup>*hi</sup>_</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_51() {
    let original = r##"email: <john@example.com>\_
"##;
    let expected = r##"<p>email: <a href="mailto:john@example.com">john@example.com</a>_</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_52() {
    let original = r##"> [link](/url 'foo
> bar')
"##;
    let expected = r##"<blockquote>
<p><a href="/url" title="foo
bar">link</a></p>
</blockquote>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_53() {
    let original = r##"> [foo
> bar]: /url
>
> [foo bar]
"##;
    let expected = r##"<blockquote>
<p><a href="/url">foo bar</a></p>
</blockquote>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_54() {
    let original = r##"> [foo   bar]: /url
>
> [foo
> bar]
"##;
    let expected = r##"<blockquote>
<p><a href="/url">foo
bar</a></p>
</blockquote>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_55() {
    let original = r##"> - [a
> b c]: /foo

[a b c]
"##;
    let expected = r##"<blockquote>
<ul>
<li></li>
</ul>
</blockquote>
<p><a href="/foo">a b c</a></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_56() {
    let original = r##"[a
> b]: /foo

[a b] [a > b]
"##;
    let expected = r##"<p>[a</p>
<blockquote>
<p>b]: /foo</p>
</blockquote>
<p>[a b] [a > b]</p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_57() {
    let original = r##"[`cargo
package`]

[`cargo package`]: https://example.com
"##;
    let expected = r##"<p><a href="https://example.com"><code>cargo package</code></a></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_58() {
    let original = r##"> [`cargo
> package`]

[`cargo package`]: https://example.com
"##;
    let expected = r##"<blockquote>
<p><a href="https://example.com"><code>cargo package</code></a></p>
</blockquote>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_59() {
    let original = r##"> `cargo
> package`
"##;
    let expected = r##"<blockquote>
<p><code>cargo package</code></p>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_60() {
    let original = r##"Lorem ipsum.[^a]

An unordered list before the footnotes:
* Ipsum
* Lorem

[^a]: Cool.
"##;
    let expected = r##"<p>Lorem ipsum.<sup class="footnote-reference"><a href="#a">1</a></sup></p>
<p>An unordered list before the footnotes:</p>
<ul>
    <li>Ipsum</li>
    <li>Lorem</li>
</ul>
<div class="footnote-definition" id="a"><sup class="footnote-definition-label">1</sup>
    <p>Cool.</p>
</div>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_61() {
    let original = r##"[][a]

[a]: b

# assimp-rs [![][crates-badge]][crates]

[crates]: https://crates.io/crates/assimp
[crates-badge]: http://meritbadge.herokuapp.com/assimp
"##;
    let expected = r##"<p><a href="b"></a></p>

<h1>assimp-rs <a href="https://crates.io/crates/assimp"><img alt="" src="http://meritbadge.herokuapp.com/assimp"></a></h1>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_62() {
    let original = r##"* A list.

   * A sublist.

   * Another sublist.


* A list.
 
   * A sublist.
 
   * Another sublist.
 
"##;
    let expected = r##"<ul>
<li>
<p>A list.</p>
<ul>
<li>
<p>A sublist.</p>
</li>
<li>
<p>Another sublist.</p>
</li>
</ul>
</li>
<li>
<p>A list.</p>
<ul>
<li>
<p>A sublist.</p>
</li>
<li>
<p>Another sublist.</p>
</li>
</ul>
</li>
</ul>
"##;

    test_markdown_html(original, expected);
}

#[test]
fn regression_test_63() {
    let original = r##"<foo
"##;
    let expected = r##"<p>&lt;foo</p>
"##;

    test_markdown_html(original, expected);
}
