#ifndef INCLUDE_MODULE_IMAC_H
#define INCLUDE_MODULE_IMAC_H
/**
 * @brief Hardware abstraction layer for Intel based MacBooks
 *
 * This file contains the definitions and prototypes for the
 * MacBook hardware abstraction layer.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation
 * (http://www.gnu.org/licenses/gpl.html)
 *
 * @file    src/module_imac.h
 * @author  Stefan Bruda <bruda@cs.ubishops.ca> 
 * @author  Matthias Grimm <matthias.grimm@users.sourceforge.net>
 */

#include <glib.h>
#include <pbbtaglist.h>

#define SYSFS_AMBIENT	"/sys/devices/platform/applesmc/light"
#define SYSFS_KEYBLIGHT	"/sys/class/leds/smc:kbd_backlight/brightness"
#define KEYBLIGHTMAX	255
#define AMBIENTLIGHTMAX	255

#define CMTYPE(type,ver,rev)	(type << 8 | ver << 4 | rev)
#define MTYPE(mid)				(mid >> 8 & 0xff) 
#define MVERSION(mid)			(mid >> 4 & 0x0f)
#define MREVISION(mid)			(mid & 0xf)

enum machine_type { TYPE_UNKNOWN, TYPE_MACBOOK, TYPE_MACBOOKPRO };
typedef unsigned short machine_t;

#define SMC_LIGHT_SENSOR_LEFT_KEY  "ALV0" //0x414c5630, r-o length 6
#define SMC_LIGHT_SENSOR_RIGHT_KEY "ALV1" //0x414c5631, r-o length 6
#define SMC_BACKLIGHT_KEY          "LKSB" //0x4c4b5342, w-o
#define SMC_CLAMSHELL_KEY          "MSLD" //0x4d534c44, r-o length 1 (unused)
#define SMC_MOTION_SENSOR_X_KEY    "MO_X" //0x4d4f5f58, r-o length 2
#define SMC_MOTION_SENSOR_Y_KEY    "MO_Y" //0x4d4f5f58, r-o length 2
#define SMC_MOTION_SENSOR_Z_KEY    "MO_Z" //0x4d4f5f58, r-o length 2
#define SMC_MOTION_SENSOR_KEY      "MOCN" //0x4d4f434e, r/w length 2


/* public prototypes */
int imac_init ();
void imac_exit ();

/* private prototypes */
void imac_query (struct tagitem *taglist);
void imac_configure (struct tagitem *taglist);
void imac_handle_tags (int cfgure, struct tagitem *taglist);

/* functions for ambient light sensor and keyboard illumination */
gboolean haveKBDIllumination();
gboolean haveAmbient();
int getRawAmbient ();
void setKBDIllumination (unsigned short level);

machine_t getMachineType ();
const char *getMachineName(machine_t mid);

/* Apple SMC interface */

unsigned char get_status();
int waitfree(char num);
int writeSMCKey(char* key, char len, unsigned char* buffer);
int readSMCKey(char* key, char len, unsigned char* buffer);

#endif    /* INCLUDE_MODULE_IMAC_H */
