/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/simd/simd_f64x2_arith.wast

// ./test/core/simd/simd_f64x2_arith.wast:4
let $0 = instantiate(`(module
  (func (export "f64x2.add") (param v128 v128) (result v128) (f64x2.add (local.get 0) (local.get 1)))
  (func (export "f64x2.sub") (param v128 v128) (result v128) (f64x2.sub (local.get 0) (local.get 1)))
  (func (export "f64x2.mul") (param v128 v128) (result v128) (f64x2.mul (local.get 0) (local.get 1)))
  (func (export "f64x2.div") (param v128 v128) (result v128) (f64x2.div (local.get 0) (local.get 1)))
  (func (export "f64x2.neg") (param v128) (result v128) (f64x2.neg (local.get 0)))
  (func (export "f64x2.sqrt") (param v128) (result v128) (f64x2.sqrt (local.get 0)))
)`);

// ./test/core/simd/simd_f64x2_arith.wast:13
assert_return(() => invoke($0, `f64x2.add`, [f64x2([0, 0]), f64x2([0, 0])]), [
  new F64x2Pattern(value("f64", 0), value("f64", 0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:16
assert_return(() => invoke($0, `f64x2.add`, [f64x2([0, 0]), f64x2([-0, -0])]), [
  new F64x2Pattern(value("f64", 0), value("f64", 0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:19
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:22
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0, 0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:25
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([0, 0]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:28
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([0, 0]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:31
assert_return(() => invoke($0, `f64x2.add`, [f64x2([0, 0]), f64x2([1, 1])]), [
  new F64x2Pattern(value("f64", 1), value("f64", 1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:34
assert_return(() => invoke($0, `f64x2.add`, [f64x2([0, 0]), f64x2([-1, -1])]), [
  new F64x2Pattern(value("f64", -1), value("f64", -1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:37
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0, 0]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:40
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0, 0]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:43
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0, 0]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:46
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0, 0]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:49
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:52
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:55
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([0, 0]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:58
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([0, 0]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:61
assert_return(() => invoke($0, `f64x2.add`, [f64x2([-0, -0]), f64x2([0, 0])]), [
  new F64x2Pattern(value("f64", 0), value("f64", 0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:64
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-0, -0]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:67
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:70
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0, -0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:73
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-0, -0]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:76
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-0, -0]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:79
assert_return(() => invoke($0, `f64x2.add`, [f64x2([-0, -0]), f64x2([1, 1])]), [
  new F64x2Pattern(value("f64", 1), value("f64", 1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:82
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-0, -0]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:85
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0, -0]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:88
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0, -0]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:91
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0, -0]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:94
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0, -0]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:97
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:100
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:103
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-0, -0]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:106
assert_return(
  () =>
    invoke($0, `f64x2.add`, [f64x2([-0, -0]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:109
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:112
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:115
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004450147717014403,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004450147717014403,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:118
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:121
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:124
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:127
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:130
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:133
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:136
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:139
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:142
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:145
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:148
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:151
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:154
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:157
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:160
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:163
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:166
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004450147717014403,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004450147717014403,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:169
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:172
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:175
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:178
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:181
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:184
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:187
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:190
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:193
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:196
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:199
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:202
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:205
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([0.5, 0.5]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:208
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([0.5, 0.5]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:211
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:214
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:217
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([0.5, 0.5]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:220
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([0.5, 0.5]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:223
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([0.5, 0.5]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", 1.5), value("f64", 1.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:226
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([0.5, 0.5]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:229
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.5, 0.5]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.783185307179586),
      value("f64", 6.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:232
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.5, 0.5]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -5.783185307179586),
      value("f64", -5.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:235
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.5, 0.5]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:238
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:241
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:244
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:247
assert_return(
  () =>
    invoke($0, `f64x2.add`, [f64x2([0.5, 0.5]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:250
assert_return(
  () =>
    invoke($0, `f64x2.add`, [f64x2([0.5, 0.5]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:253
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-0.5, -0.5]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:256
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-0.5, -0.5]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:259
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:262
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:265
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-0.5, -0.5]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:268
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-0.5, -0.5]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:271
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-0.5, -0.5]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:274
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-0.5, -0.5]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -1.5), value("f64", -1.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:277
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0.5, -0.5]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 5.783185307179586),
      value("f64", 5.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:280
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0.5, -0.5]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.783185307179586),
      value("f64", -6.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:283
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:286
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:289
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:292
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:295
assert_return(
  () =>
    invoke($0, `f64x2.add`, [f64x2([-0.5, -0.5]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:298
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0.5, -0.5]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:301
assert_return(() => invoke($0, `f64x2.add`, [f64x2([1, 1]), f64x2([0, 0])]), [
  new F64x2Pattern(value("f64", 1), value("f64", 1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:304
assert_return(() => invoke($0, `f64x2.add`, [f64x2([1, 1]), f64x2([-0, -0])]), [
  new F64x2Pattern(value("f64", 1), value("f64", 1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:307
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:310
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1, 1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:313
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([1, 1]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 1.5), value("f64", 1.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:316
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([1, 1]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:319
assert_return(() => invoke($0, `f64x2.add`, [f64x2([1, 1]), f64x2([1, 1])]), [
  new F64x2Pattern(value("f64", 2), value("f64", 2)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:322
assert_return(() => invoke($0, `f64x2.add`, [f64x2([1, 1]), f64x2([-1, -1])]), [
  new F64x2Pattern(value("f64", 0), value("f64", 0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:325
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1, 1]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 7.283185307179586),
      value("f64", 7.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:328
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1, 1]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -5.283185307179586),
      value("f64", -5.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:331
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1, 1]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:334
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1, 1]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:337
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:340
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:343
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([1, 1]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:346
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([1, 1]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:349
assert_return(() => invoke($0, `f64x2.add`, [f64x2([-1, -1]), f64x2([0, 0])]), [
  new F64x2Pattern(value("f64", -1), value("f64", -1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:352
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-1, -1]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:355
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:358
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-1, -1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:361
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-1, -1]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:364
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-1, -1]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -1.5), value("f64", -1.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:367
assert_return(() => invoke($0, `f64x2.add`, [f64x2([-1, -1]), f64x2([1, 1])]), [
  new F64x2Pattern(value("f64", 0), value("f64", 0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:370
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-1, -1]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -2), value("f64", -2))],
);

// ./test/core/simd/simd_f64x2_arith.wast:373
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-1, -1]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 5.283185307179586),
      value("f64", 5.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:376
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-1, -1]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -7.283185307179586),
      value("f64", -7.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:379
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-1, -1]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:382
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-1, -1]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:385
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:388
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:391
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-1, -1]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:394
assert_return(
  () =>
    invoke($0, `f64x2.add`, [f64x2([-1, -1]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:397
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:400
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:403
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:406
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:409
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.783185307179586),
      value("f64", 6.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:412
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 5.783185307179586),
      value("f64", 5.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:415
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 7.283185307179586),
      value("f64", 7.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:418
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 5.283185307179586),
      value("f64", 5.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:421
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 12.566370614359172),
      value("f64", 12.566370614359172),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:424
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:427
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:430
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:433
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:436
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:439
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:442
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:445
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:448
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:451
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:454
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:457
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -5.783185307179586),
      value("f64", -5.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:460
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.783185307179586),
      value("f64", -6.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:463
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -5.283185307179586),
      value("f64", -5.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:466
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -7.283185307179586),
      value("f64", -7.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:469
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:472
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -12.566370614359172),
      value("f64", -12.566370614359172),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:475
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:478
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:481
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:484
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:487
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:490
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:493
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:496
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:499
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:502
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:505
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:508
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:511
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:514
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:517
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:520
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:523
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:526
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:529
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:532
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:535
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:538
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:541
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:544
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:547
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:550
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:553
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:556
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:559
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:562
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:565
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:568
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:571
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:574
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:577
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:580
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:583
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:586
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:589
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:592
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:595
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:598
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:601
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:604
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:607
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:610
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:613
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:616
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:619
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:622
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:625
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:628
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:631
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:634
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:637
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:640
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:643
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:646
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:649
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:652
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:655
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:658
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:661
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:664
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:667
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:670
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:673
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:676
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:679
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:682
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:685
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([Infinity, Infinity]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:688
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([Infinity, Infinity]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:691
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:694
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:697
assert_return(
  () =>
    invoke($0, `f64x2.add`, [f64x2([Infinity, Infinity]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:700
assert_return(
  () =>
    invoke($0, `f64x2.add`, [f64x2([Infinity, Infinity]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:703
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([Infinity, Infinity]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:706
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([Infinity, Infinity]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:709
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:712
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:715
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:718
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:721
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:724
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:727
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:730
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:733
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-Infinity, -Infinity]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:736
assert_return(
  () =>
    invoke($0, `f64x2.add`, [f64x2([-Infinity, -Infinity]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:739
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:742
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:745
assert_return(
  () =>
    invoke($0, `f64x2.add`, [f64x2([-Infinity, -Infinity]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:748
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:751
assert_return(
  () => invoke($0, `f64x2.add`, [f64x2([-Infinity, -Infinity]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:754
assert_return(
  () =>
    invoke($0, `f64x2.add`, [f64x2([-Infinity, -Infinity]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:757
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:760
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:763
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:766
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:769
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:772
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:775
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:778
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:781
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:784
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:787
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:790
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:793
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:796
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:799
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:802
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:805
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:808
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:811
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:814
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:817
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:820
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:823
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:826
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:829
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:832
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:835
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:838
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:841
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:844
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:847
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:850
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:853
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:856
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:859
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:862
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:865
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:868
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:871
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:874
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:877
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:880
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:883
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:886
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:889
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:892
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:895
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:898
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:901
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:904
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:907
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:910
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:913
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:916
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:919
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:922
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:925
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:928
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:931
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:934
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:937
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:940
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:943
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:946
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:949
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:952
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:955
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:958
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:961
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:964
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:967
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:970
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:973
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:976
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:979
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:982
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:985
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:988
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:991
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:994
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:997
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1000
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1003
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1006
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1009
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1012
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1015
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1018
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1021
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1024
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1027
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1030
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1033
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1036
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1039
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1042
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1045
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1048
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1051
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1054
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1057
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1060
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1063
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1066
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1069
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1072
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1075
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1078
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1081
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1084
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1087
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1090
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1093
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1096
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1099
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1102
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1105
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1108
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1111
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1114
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1117
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1120
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1123
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1126
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1129
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1132
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1135
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1138
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1141
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1144
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1147
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1150
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1153
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1156
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1159
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1162
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1165
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1168
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1171
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1174
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1177
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1180
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1183
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1186
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1189
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1192
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1195
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1198
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1201
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1204
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1207
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1210
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:1213
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([123456789, 123456789]),
      f64x2([123456789, 123456789]),
    ]),
  [new F64x2Pattern(value("f64", 246913578), value("f64", 246913578))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1216
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 2469135780000000000000000000),
      value("f64", 2469135780000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1219
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 2469135780000000000000000000),
      value("f64", 2469135780000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1222
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.0000000000123456789, 0.0000000000123456789]),
      f64x2([0.0000000000123456789, 0.0000000000123456789]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000246913578),
      value("f64", 0.0000000000246913578),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1225
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([123456789, 123456789]),
      f64x2([123456789, 123456789]),
    ]),
  [new F64x2Pattern(value("f64", 246913578), value("f64", 246913578))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1228
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 2469135780000000000000000000),
      value("f64", 2469135780000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1231
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 2469135780000000000000000000),
      value("f64", 2469135780000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1234
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.0000000000123456789, 0.0000000000123456789]),
      f64x2([0.0000000000123456789, 0.0000000000123456789]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000246913578),
      value("f64", 0.0000000000246913578),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1237
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([123456789.01234567, 123456789.01234567]),
      f64x2([123456789.01234567, 123456789.01234567]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 246913578.02469134),
      value("f64", 246913578.02469134),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1240
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
      f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 2469135780246913700000000000),
      value("f64", 2469135780246913700000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1243
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
      f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 2469135780246913700000000000),
      value("f64", 2469135780246913700000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1246
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
      f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000024691357802469137),
      value("f64", 0.000000000024691357802469137),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1249
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1375488932539311400000000, 1375488932539311400000000]),
      f64x2([1375488932539311400000000, 1375488932539311400000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 2750977865078623000000000),
      value("f64", 2750977865078623000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1252
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 1442304682926341000000000000000),
      value("f64", 1442304682926341000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1255
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 1442304682926341000000000000000),
      value("f64", 1442304682926341000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1258
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([2623536934927580700, 2623536934927580700]),
      f64x2([2623536934927580700, 2623536934927580700]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 5247073869855161000),
      value("f64", 5247073869855161000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1261
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1375488932539311400000000, 1375488932539311400000000]),
      f64x2([1375488932539311400000000, 1375488932539311400000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 2750977865078623000000000),
      value("f64", 2750977865078623000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1264
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 1442304682926341000000000000000),
      value("f64", 1442304682926341000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1267
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 1442304682926341000000000000000),
      value("f64", 1442304682926341000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1270
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([2623536934927580700, 2623536934927580700]),
      f64x2([2623536934927580700, 2623536934927580700]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 5247073869855161000),
      value("f64", 5247073869855161000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1273
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([1375488932539311400000000, 1375488932539311400000000]),
      f64x2([1375488932539311400000000, 1375488932539311400000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 2750977865078623000000000),
      value("f64", 2750977865078623000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1276
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 1442304682926341000000000000000),
      value("f64", 1442304682926341000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1279
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 1442304682926341000000000000000),
      value("f64", 1442304682926341000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1282
assert_return(
  () =>
    invoke($0, `f64x2.add`, [
      f64x2([2623536934927580700, 2623536934927580700]),
      f64x2([2623536934927580700, 2623536934927580700]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 5247073869855161000),
      value("f64", 5247073869855161000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1285
assert_return(() => invoke($0, `f64x2.sub`, [f64x2([0, 0]), f64x2([0, 0])]), [
  new F64x2Pattern(value("f64", 0), value("f64", 0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:1288
assert_return(() => invoke($0, `f64x2.sub`, [f64x2([0, 0]), f64x2([-0, -0])]), [
  new F64x2Pattern(value("f64", 0), value("f64", 0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:1291
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1294
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0, 0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1297
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([0, 0]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1300
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([0, 0]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1303
assert_return(() => invoke($0, `f64x2.sub`, [f64x2([0, 0]), f64x2([1, 1])]), [
  new F64x2Pattern(value("f64", -1), value("f64", -1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:1306
assert_return(() => invoke($0, `f64x2.sub`, [f64x2([0, 0]), f64x2([-1, -1])]), [
  new F64x2Pattern(value("f64", 1), value("f64", 1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:1309
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0, 0]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1312
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0, 0]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1315
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0, 0]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1318
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0, 0]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1321
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1324
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1327
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([0, 0]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1330
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([0, 0]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1333
assert_return(() => invoke($0, `f64x2.sub`, [f64x2([-0, -0]), f64x2([0, 0])]), [
  new F64x2Pattern(value("f64", -0), value("f64", -0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:1336
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-0, -0]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1339
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1342
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0, -0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1345
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-0, -0]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1348
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-0, -0]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1351
assert_return(() => invoke($0, `f64x2.sub`, [f64x2([-0, -0]), f64x2([1, 1])]), [
  new F64x2Pattern(value("f64", -1), value("f64", -1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:1354
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-0, -0]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1357
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0, -0]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1360
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0, -0]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1363
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0, -0]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1366
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0, -0]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1369
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1372
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1375
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-0, -0]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1378
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [f64x2([-0, -0]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1381
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1384
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1387
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1390
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004450147717014403,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004450147717014403,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1393
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1396
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1399
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1402
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1405
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1408
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1411
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1414
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1417
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1420
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1423
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1426
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1429
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1432
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1435
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004450147717014403,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004450147717014403,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1438
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1441
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1444
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1447
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1450
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1453
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1456
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1459
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1462
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1465
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1468
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1471
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1474
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1477
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([0.5, 0.5]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1480
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([0.5, 0.5]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1483
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1486
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1489
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([0.5, 0.5]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1492
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([0.5, 0.5]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1495
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([0.5, 0.5]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1498
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([0.5, 0.5]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", 1.5), value("f64", 1.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1501
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.5, 0.5]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -5.783185307179586),
      value("f64", -5.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1504
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.5, 0.5]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.783185307179586),
      value("f64", 6.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1507
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.5, 0.5]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1510
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1513
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1516
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1519
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [f64x2([0.5, 0.5]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1522
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [f64x2([0.5, 0.5]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1525
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-0.5, -0.5]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1528
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-0.5, -0.5]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1531
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1534
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1537
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-0.5, -0.5]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1540
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-0.5, -0.5]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1543
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-0.5, -0.5]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", -1.5), value("f64", -1.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1546
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-0.5, -0.5]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1549
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0.5, -0.5]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.783185307179586),
      value("f64", -6.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1552
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0.5, -0.5]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 5.783185307179586),
      value("f64", 5.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1555
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1558
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1561
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1564
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1567
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [f64x2([-0.5, -0.5]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1570
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0.5, -0.5]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1573
assert_return(() => invoke($0, `f64x2.sub`, [f64x2([1, 1]), f64x2([0, 0])]), [
  new F64x2Pattern(value("f64", 1), value("f64", 1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:1576
assert_return(() => invoke($0, `f64x2.sub`, [f64x2([1, 1]), f64x2([-0, -0])]), [
  new F64x2Pattern(value("f64", 1), value("f64", 1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:1579
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1582
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1, 1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1585
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([1, 1]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1588
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([1, 1]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", 1.5), value("f64", 1.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1591
assert_return(() => invoke($0, `f64x2.sub`, [f64x2([1, 1]), f64x2([1, 1])]), [
  new F64x2Pattern(value("f64", 0), value("f64", 0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:1594
assert_return(() => invoke($0, `f64x2.sub`, [f64x2([1, 1]), f64x2([-1, -1])]), [
  new F64x2Pattern(value("f64", 2), value("f64", 2)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:1597
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1, 1]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -5.283185307179586),
      value("f64", -5.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1600
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1, 1]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 7.283185307179586),
      value("f64", 7.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1603
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1, 1]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1606
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1, 1]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1609
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1612
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1615
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([1, 1]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1618
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([1, 1]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1621
assert_return(() => invoke($0, `f64x2.sub`, [f64x2([-1, -1]), f64x2([0, 0])]), [
  new F64x2Pattern(value("f64", -1), value("f64", -1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:1624
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-1, -1]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1627
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1630
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-1, -1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1633
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-1, -1]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -1.5), value("f64", -1.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1636
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-1, -1]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1639
assert_return(() => invoke($0, `f64x2.sub`, [f64x2([-1, -1]), f64x2([1, 1])]), [
  new F64x2Pattern(value("f64", -2), value("f64", -2)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:1642
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-1, -1]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1645
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-1, -1]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -7.283185307179586),
      value("f64", -7.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1648
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-1, -1]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 5.283185307179586),
      value("f64", 5.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1651
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-1, -1]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1654
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-1, -1]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1657
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1660
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1663
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-1, -1]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1666
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [f64x2([-1, -1]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1669
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1672
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1675
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1678
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1681
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 5.783185307179586),
      value("f64", 5.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1684
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.783185307179586),
      value("f64", 6.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1687
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 5.283185307179586),
      value("f64", 5.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1690
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 7.283185307179586),
      value("f64", 7.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1693
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1696
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 12.566370614359172),
      value("f64", 12.566370614359172),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1699
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1702
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1705
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1708
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1711
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1714
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1717
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1720
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1723
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1726
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1729
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.783185307179586),
      value("f64", -6.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1732
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -5.783185307179586),
      value("f64", -5.783185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1735
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -7.283185307179586),
      value("f64", -7.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1738
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -5.283185307179586),
      value("f64", -5.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1741
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -12.566370614359172),
      value("f64", -12.566370614359172),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1744
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1747
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1750
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1753
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1756
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1759
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1762
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1765
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1768
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1771
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1774
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1777
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1780
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1783
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1786
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1789
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1792
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1795
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1798
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1801
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1804
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1807
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1810
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1813
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1816
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1819
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1822
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1825
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1828
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1831
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1834
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1837
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1840
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1843
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1846
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1849
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1852
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1855
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1858
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1861
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1864
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1867
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1870
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1873
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1876
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1879
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1882
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1885
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1888
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1891
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1894
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1897
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1900
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1903
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1906
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1909
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1912
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1915
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507201,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1918
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002225073858507202,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1921
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1924
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1927
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1930
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1933
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1936
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1939
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1942
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:1945
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1948
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1951
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1954
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1957
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([Infinity, Infinity]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1960
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([Infinity, Infinity]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1963
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1966
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1969
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [f64x2([Infinity, Infinity]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1972
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [f64x2([Infinity, Infinity]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1975
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([Infinity, Infinity]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1978
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([Infinity, Infinity]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1981
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1984
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1987
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1990
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1993
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1996
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:1999
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2002
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2005
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-Infinity, -Infinity]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2008
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [f64x2([-Infinity, -Infinity]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2011
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2014
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2017
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [f64x2([-Infinity, -Infinity]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2020
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2023
assert_return(
  () => invoke($0, `f64x2.sub`, [f64x2([-Infinity, -Infinity]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2026
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [f64x2([-Infinity, -Infinity]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2029
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2032
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2035
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2038
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2041
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2044
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2047
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2050
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2053
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2056
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2059
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2062
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2065
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2068
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2071
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2074
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2077
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2080
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2083
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2086
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2089
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2092
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2095
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2098
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2101
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2104
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2107
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2110
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2113
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2116
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2119
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2122
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2125
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2128
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2131
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2134
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2137
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2140
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2143
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2146
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2149
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2152
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2155
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2158
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2161
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2164
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2167
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2170
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2173
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2176
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2179
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2182
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2185
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2188
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2191
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2194
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2197
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2200
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2203
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2206
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2209
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2212
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2215
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2218
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2221
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2224
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2227
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2230
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2233
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2236
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2239
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2242
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2245
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2248
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2251
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2254
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2257
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2260
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2263
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2266
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2269
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2272
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2275
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2278
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2281
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2284
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2287
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2290
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2293
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2296
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2299
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2302
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2305
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2308
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2311
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2314
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2317
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2320
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2323
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2326
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2329
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2332
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2335
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2338
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2341
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2344
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2347
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2350
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2353
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2356
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2359
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2362
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2365
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2368
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2371
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2374
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2377
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2380
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2383
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2386
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2389
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2392
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2395
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2398
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2401
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2404
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2407
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2410
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2413
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2416
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2419
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2422
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2425
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2428
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2431
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2434
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2437
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2440
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2443
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2446
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2449
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2452
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2455
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2458
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2461
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2464
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2467
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2470
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2473
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2476
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2479
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2482
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2485
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([123456789, 123456789]),
      f64x2([123456789, 123456789]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2488
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2491
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2494
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.0000000000123456789, 0.0000000000123456789]),
      f64x2([0.0000000000123456789, 0.0000000000123456789]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2497
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([123456789, 123456789]),
      f64x2([123456789, 123456789]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2500
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2503
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
      f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2506
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.0000000000123456789, 0.0000000000123456789]),
      f64x2([0.0000000000123456789, 0.0000000000123456789]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2509
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([123456789.01234567, 123456789.01234567]),
      f64x2([123456789.01234567, 123456789.01234567]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2512
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
      f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2515
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
      f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2518
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
      f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2521
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1375488932539311400000000, 1375488932539311400000000]),
      f64x2([1375488932539311400000000, 1375488932539311400000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2524
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2527
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2530
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([2623536934927580700, 2623536934927580700]),
      f64x2([2623536934927580700, 2623536934927580700]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2533
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1375488932539311400000000, 1375488932539311400000000]),
      f64x2([1375488932539311400000000, 1375488932539311400000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2536
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2539
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2542
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([2623536934927580700, 2623536934927580700]),
      f64x2([2623536934927580700, 2623536934927580700]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2545
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([1375488932539311400000000, 1375488932539311400000000]),
      f64x2([1375488932539311400000000, 1375488932539311400000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2548
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2551
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
      f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2554
assert_return(
  () =>
    invoke($0, `f64x2.sub`, [
      f64x2([2623536934927580700, 2623536934927580700]),
      f64x2([2623536934927580700, 2623536934927580700]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2557
assert_return(() => invoke($0, `f64x2.mul`, [f64x2([0, 0]), f64x2([0, 0])]), [
  new F64x2Pattern(value("f64", 0), value("f64", 0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:2560
assert_return(() => invoke($0, `f64x2.mul`, [f64x2([0, 0]), f64x2([-0, -0])]), [
  new F64x2Pattern(value("f64", -0), value("f64", -0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:2563
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2566
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0, 0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2569
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([0, 0]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2572
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([0, 0]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2575
assert_return(() => invoke($0, `f64x2.mul`, [f64x2([0, 0]), f64x2([1, 1])]), [
  new F64x2Pattern(value("f64", 0), value("f64", 0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:2578
assert_return(() => invoke($0, `f64x2.mul`, [f64x2([0, 0]), f64x2([-1, -1])]), [
  new F64x2Pattern(value("f64", -0), value("f64", -0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:2581
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0, 0]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2584
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0, 0]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2587
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0, 0]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2590
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0, 0]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2593
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2596
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0, 0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2599
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([0, 0]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2602
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([0, 0]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2605
assert_return(() => invoke($0, `f64x2.mul`, [f64x2([-0, -0]), f64x2([0, 0])]), [
  new F64x2Pattern(value("f64", -0), value("f64", -0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:2608
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-0, -0]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2611
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2614
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0, -0]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2617
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-0, -0]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2620
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-0, -0]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2623
assert_return(() => invoke($0, `f64x2.mul`, [f64x2([-0, -0]), f64x2([1, 1])]), [
  new F64x2Pattern(value("f64", -0), value("f64", -0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:2626
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-0, -0]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2629
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0, -0]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2632
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0, -0]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2635
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0, -0]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2638
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0, -0]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2641
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2644
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0, -0]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2647
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-0, -0]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2650
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [f64x2([-0, -0]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:2653
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2656
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2659
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2662
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2665
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2668
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2671
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2674
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2677
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2680
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2683
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 3.9999999999999996),
      value("f64", 3.9999999999999996),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2686
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -3.9999999999999996),
      value("f64", -3.9999999999999996),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2689
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2692
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2695
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2698
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2701
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2704
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2707
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2710
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2713
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2716
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2719
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2722
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2725
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2728
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2731
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -3.9999999999999996),
      value("f64", -3.9999999999999996),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2734
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 3.9999999999999996),
      value("f64", 3.9999999999999996),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2737
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2740
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2743
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2746
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2749
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([0.5, 0.5]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2752
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([0.5, 0.5]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2755
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2758
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2761
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([0.5, 0.5]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0.25), value("f64", 0.25))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2764
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([0.5, 0.5]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0.25), value("f64", -0.25))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2767
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([0.5, 0.5]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2770
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([0.5, 0.5]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2773
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0.5, 0.5]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 3.141592653589793),
      value("f64", 3.141592653589793),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2776
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0.5, 0.5]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -3.141592653589793),
      value("f64", -3.141592653589793),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2779
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0.5, 0.5]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2782
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0.5, 0.5]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2785
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2788
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0.5, 0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2791
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [f64x2([0.5, 0.5]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2794
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [f64x2([0.5, 0.5]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2797
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-0.5, -0.5]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2800
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-0.5, -0.5]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2803
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2806
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011125369292536007,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2809
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-0.5, -0.5]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -0.25), value("f64", -0.25))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2812
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-0.5, -0.5]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", 0.25), value("f64", 0.25))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2815
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-0.5, -0.5]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2818
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-0.5, -0.5]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2821
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0.5, -0.5]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -3.141592653589793),
      value("f64", -3.141592653589793),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2824
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0.5, -0.5]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 3.141592653589793),
      value("f64", 3.141592653589793),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2827
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2830
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2833
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2836
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0.5, -0.5]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2839
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [f64x2([-0.5, -0.5]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2842
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0.5, -0.5]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2845
assert_return(() => invoke($0, `f64x2.mul`, [f64x2([1, 1]), f64x2([0, 0])]), [
  new F64x2Pattern(value("f64", 0), value("f64", 0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:2848
assert_return(() => invoke($0, `f64x2.mul`, [f64x2([1, 1]), f64x2([-0, -0])]), [
  new F64x2Pattern(value("f64", -0), value("f64", -0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:2851
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2854
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([1, 1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2857
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([1, 1]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2860
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([1, 1]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2863
assert_return(() => invoke($0, `f64x2.mul`, [f64x2([1, 1]), f64x2([1, 1])]), [
  new F64x2Pattern(value("f64", 1), value("f64", 1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:2866
assert_return(() => invoke($0, `f64x2.mul`, [f64x2([1, 1]), f64x2([-1, -1])]), [
  new F64x2Pattern(value("f64", -1), value("f64", -1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:2869
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([1, 1]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2872
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([1, 1]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2875
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([1, 1]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2878
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([1, 1]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2881
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2884
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([1, 1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2887
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([1, 1]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2890
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([1, 1]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2893
assert_return(() => invoke($0, `f64x2.mul`, [f64x2([-1, -1]), f64x2([0, 0])]), [
  new F64x2Pattern(value("f64", -0), value("f64", -0)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:2896
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-1, -1]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2899
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2902
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-1, -1]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2905
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-1, -1]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2908
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-1, -1]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2911
assert_return(() => invoke($0, `f64x2.mul`, [f64x2([-1, -1]), f64x2([1, 1])]), [
  new F64x2Pattern(value("f64", -1), value("f64", -1)),
]);

// ./test/core/simd/simd_f64x2_arith.wast:2914
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-1, -1]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2917
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-1, -1]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2920
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-1, -1]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2923
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-1, -1]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2926
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-1, -1]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2929
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2932
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-1, -1]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2935
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-1, -1]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2938
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [f64x2([-1, -1]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2941
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2944
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2947
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2950
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2953
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 3.141592653589793),
      value("f64", 3.141592653589793),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2956
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -3.141592653589793),
      value("f64", -3.141592653589793),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2959
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2962
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2965
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 39.47841760435743),
      value("f64", 39.47841760435743),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2968
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -39.47841760435743),
      value("f64", -39.47841760435743),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2971
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2974
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2977
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2980
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2983
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2986
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2989
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2992
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:2995
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:2998
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013980551375161837,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3001
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -3.141592653589793),
      value("f64", -3.141592653589793),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3004
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 3.141592653589793),
      value("f64", 3.141592653589793),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3007
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3010
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3013
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -39.47841760435743),
      value("f64", -39.47841760435743),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3016
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 39.47841760435743),
      value("f64", 39.47841760435743),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3019
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3022
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3025
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3028
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3031
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3034
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3037
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3040
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3043
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 3.9999999999999996),
      value("f64", 3.9999999999999996),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3046
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -3.9999999999999996),
      value("f64", -3.9999999999999996),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3049
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3052
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3055
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3058
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3061
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3064
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3067
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3070
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3073
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000000008881784197001251),
      value("f64", 0.0000000000000008881784197001251),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3076
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000000008881784197001251),
      value("f64", 0.0000000000000008881784197001251),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3079
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3082
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3085
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3088
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3091
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -3.9999999999999996),
      value("f64", -3.9999999999999996),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3094
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 3.9999999999999996),
      value("f64", 3.9999999999999996),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3097
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3100
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        89884656743115790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3103
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3106
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
      value(
        "f64",
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3109
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3112
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3115
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3118
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3121
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -0.0000000000000008881784197001251),
      value("f64", -0.0000000000000008881784197001251),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3124
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -0.0000000000000008881784197001251),
      value("f64", -0.0000000000000008881784197001251),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3127
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3130
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3133
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3136
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3139
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3142
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3145
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3148
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3151
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3154
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3157
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3160
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3163
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000000008881784197001251),
      value("f64", 0.0000000000000008881784197001251),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3166
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -0.0000000000000008881784197001251),
      value("f64", -0.0000000000000008881784197001251),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3169
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3172
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3175
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3178
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3181
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3184
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3187
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3190
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3193
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3196
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3199
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([1, 1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3202
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-1, -1]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
      value(
        "f64",
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3205
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
      value(
        "f64",
        0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3208
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [
    new F64x2Pattern(
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
      value(
        "f64",
        -0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003,
      ),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3211
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000000008881784197001251),
      value("f64", 0.0000000000000008881784197001251),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3214
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [
    new F64x2Pattern(
      value("f64", -0.0000000000000008881784197001251),
      value("f64", -0.0000000000000008881784197001251),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_arith.wast:3217
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3220
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3223
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3226
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3229
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([Infinity, Infinity]), f64x2([0, 0])]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3232
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([Infinity, Infinity]), f64x2([-0, -0])]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3235
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3238
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3241
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [f64x2([Infinity, Infinity]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3244
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [f64x2([Infinity, Infinity]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3247
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([Infinity, Infinity]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3250
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([Infinity, Infinity]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3253
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([Infinity, Infinity]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3256
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([Infinity, Infinity]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3259
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3262
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3265
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3268
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([Infinity, Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3271
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([Infinity, Infinity]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3274
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([Infinity, Infinity]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3277
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-Infinity, -Infinity]), f64x2([0, 0])]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3280
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [f64x2([-Infinity, -Infinity]), f64x2([-0, -0])]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3283
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3286
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3289
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [f64x2([-Infinity, -Infinity]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3292
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3295
assert_return(
  () => invoke($0, `f64x2.mul`, [f64x2([-Infinity, -Infinity]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3298
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [f64x2([-Infinity, -Infinity]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3301
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3304
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3307
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3310
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3313
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3316
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3319
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3322
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_arith.wast:3325
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3328
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3331
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3334
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3337
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3340
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3343
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3346
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3349
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3352
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3355
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3358
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3361
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3364
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3367
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3370
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3373
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3376
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3379
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3382
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3385
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3388
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3391
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3394
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3397
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3400
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3403
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3406
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3409
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3412
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3415
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3418
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3421
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3424
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3427
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3430
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3433
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3436
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3439
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3442
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3445
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3448
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3451
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3454
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3457
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3460
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3463
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3466
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3469
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3472
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3475
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3478
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3481
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3484
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3487
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3490
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3493
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3496
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3499
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3502
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3505
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3508
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3511
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3514
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3517
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3520
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3523
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3526
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3529
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3532
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`canonical_nan`, `canonical_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3535
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3538
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3541
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3544
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3547
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3550
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3553
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3556
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3559
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3562
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
        -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3565
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([0.5, 0.5]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3568
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3571
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-0.5, -0.5]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3574
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3577
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([1, 1]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3580
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3583
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-1, -1]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3586
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3589
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([6.283185307179586, 6.283185307179586]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3592
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([6.283185307179586, 6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3595
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-6.283185307179586, -6.283185307179586]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3598
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-6.283185307179586, -6.283185307179586]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3601
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3604
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3607
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3610
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
        -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3613
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3616
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3619
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3622
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
        0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3625
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([Infinity, Infinity]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3628
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3631
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      f64x2([-Infinity, -Infinity]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3634
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3637
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3640
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf8,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3643
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3646
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3649
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([0, 0]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3652
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3655
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
      f64x2([-0, -0]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3658
assert_return(
  () =>
    invoke($0, `f64x2.mul`, [
      f64x2([-0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0xf4,
        0xff,
      ]),
    ]),
  [new F64x2Pattern(`arithmetic_nan`, `arithmetic_nan`)],
);

// ./test/core/simd/simd_f64x2_arith.wast:3661
assert_retur