/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import java.util.Iterator;
import org.jhotdraw.contrib.html.DisposableResourceHolder;
import org.jhotdraw.contrib.html.DisposableResourceManager;
import org.jhotdraw.contrib.html.DisposalThread;
import org.jhotdraw.contrib.html.ResourceDisposabilityStrategy;
import org.jhotdraw.contrib.html.ResourceManagerNotSetException;

public class ETSLADisposalStrategy
implements ResourceDisposabilityStrategy {
    private DisposableResourceManager manager;
    private long gcPeriodicity = 60000L;
    private DisposalThread disposalThread = null;
    private boolean disposingActive = false;

    public ETSLADisposalStrategy() {
    }

    public ETSLADisposalStrategy(long l) {
        this(null, l);
    }

    public ETSLADisposalStrategy(DisposableResourceManager disposableResourceManager, long l) {
        this.setManager(disposableResourceManager);
        this.setPeriodicity(l);
        this.initDisposalThread();
    }

    public synchronized void setManager(DisposableResourceManager disposableResourceManager) {
        if (this.getManager() == null) {
            this.stopDisposing(Long.MAX_VALUE);
        }
        this.manager = disposableResourceManager;
    }

    public DisposableResourceManager getManager() {
        return this.manager;
    }

    public void startDisposing() throws ResourceManagerNotSetException {
        if (this.getManager() == null) {
            throw new ResourceManagerNotSetException();
        }
        if (this.disposingActive) {
            return;
        }
        this.disposingActive = true;
        this.disposalThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDisposing(long l) {
        if (!this.disposingActive) {
            return;
        }
        try {
            this.disposalThread.interruptDisposalPending = true;
            this.disposalThread.join(l);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.disposingActive = false;
        }
    }

    protected void initDisposalThread() {
        if (this.disposalThread != null) {
            return;
        }
        this.disposalThread = new DisposalThread(this, this.getPeriodicity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void dispose() {
        DisposableResourceManager disposableResourceManager = this.getManager();
        synchronized (disposableResourceManager) {
            long l = System.currentTimeMillis();
            Iterator iterator = this.getManager().getResources();
            while (iterator.hasNext()) {
                DisposableResourceHolder disposableResourceHolder;
                DisposableResourceHolder disposableResourceHolder2 = disposableResourceHolder = (DisposableResourceHolder)iterator.next();
                synchronized (disposableResourceHolder2) {
                    if (!disposableResourceHolder.isLocked() && disposableResourceHolder.getLastTimeAccessed() + disposableResourceHolder.getDisposableDelay() < l) {
                        disposableResourceHolder.dispose();
                    }
                }
            }
        }
    }

    public long getPeriodicity() {
        return this.gcPeriodicity;
    }

    public void setPeriodicity(long l) {
        this.gcPeriodicity = l;
        if (this.disposalThread != null) {
            this.disposalThread.setPeriodicity(l);
        }
    }
}

