/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Rectangle;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.LocatorHandle;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

class ResizeHandle
extends LocatorHandle {
    ResizeHandle(Figure figure, Locator locator) {
        super(figure, locator);
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.setUndoActivity(this.createUndoActivity(drawingView));
        this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.owner()));
        ((UndoActivity)this.getUndoActivity()).setOldDisplayBox(this.owner().displayBox());
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        Rectangle rectangle = ((UndoActivity)this.getUndoActivity()).getOldDisplayBox();
        if (this.owner().displayBox().equals(rectangle)) {
            this.setUndoActivity(null);
        }
    }

    protected Undoable createUndoActivity(DrawingView drawingView) {
        return new UndoActivity(drawingView);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Rectangle myOldDisplayBox;

        public UndoActivity(DrawingView drawingView) {
            super(drawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            return this.resetDisplayBox();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            return this.resetDisplayBox();
        }

        private boolean resetDisplayBox() {
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            if (!figureEnumeration.hasNextFigure()) {
                return false;
            }
            Figure figure = figureEnumeration.nextFigure();
            Rectangle rectangle = figure.displayBox();
            figure.displayBox(this.getOldDisplayBox());
            this.setOldDisplayBox(rectangle);
            return true;
        }

        protected void setOldDisplayBox(Rectangle rectangle) {
            this.myOldDisplayBox = rectangle;
        }

        public Rectangle getOldDisplayBox() {
            return this.myOldDisplayBox;
        }
    }
}

