.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtApp-Add-Signal wid-get
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.ny0
.TH XtAppAddSignal __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtAppAddSignal, XtRemoveSignal, XtNoticeSignal \- register and remove a signal source
.SH SYNTAX
.HP
XtSignalId XtAppAddSignal(XtAppContext \fIapp_context\fP, XtSignalCallbackProc
\fIproc\fP, XtPointer \fIclient_data\fP);
.HP
void XtRemoveSignal(XtSignalId \fIid\fP);
.HP
void XtNoticeSignal(XtSignalId \fIid\fP);
.SH ARGUMENTS
.IP \fIapp_context\fP 1i
Specifies the application context.
.IP \fIclient_data\fP 1i
Specifies the argument that is to be passed to the specified procedure
when a signal has been raised.
.IP \fIid\fP 1i
Specifies the ID returned from the corresponding
.ZN XtAppAddSignal
call.
.IP \fIproc\fP 1i
Specifies the procedure that is to be called when the signal has been
raised.
.SH DESCRIPTION
The
.ZN XtAppAddSignal
function initiates a mechanism for handling signals within the context
of the Intrinsics. Prior to establishing an operating system dependent
signal handler the application may call
.ZN XtAppAddSignal
and store the returned \fIid\fP in a place accessible to the signal
handler.
.LP
Upon receipt of a signal from the operating system, the application may
call
.ZN XtNoticeSignal
passing the \fIid\fP returned by the call to
.ZN XtAppAddSignal .
.LP
.ZN XtNoticeSignal
is the only Intrinsics function that can safely be called from a signal
handler. If
.ZN XtNoticeSignal
is called multiple times before the Intrinsics are able to invoke the
registered callback, the callback is only called once. Logically the
Intrinsics maintain ``pending'' for each registered callback. This
flag is initially
.ZN False
and is set to
.ZN True
by
.ZN XtNoticeSignal ;
the Intrinsics invoke the callback whenever the flag is
.ZN True ,
and the flag is set to
.ZN False
just before the callback is invoked.
.LP
The
.ZN XtRemoveSignal
function is called to remove the specified Intrinsics signal handler. The
client should disable the source of the signal before calling
.ZN XtRemoveSignal .
.SH "SEE ALSO"
XtAppAddTimeOut(__libmansuffix__),XtAppAddInput(__libmansuffix__),XtAppAddWorkProc(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
