/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-application-manifest.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_APPLICATION_MANIFEST_H
#define __UNITY_WEBAPPS_APPLICATION_MANIFEST_H


#define UNITY_WEBAPPS_TYPE_APPLICATION_MANIFEST              (unity_webapps_application_manifest_get_type())
#define UNITY_WEBAPPS_APPLICATION_MANIFEST(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_APPLICATION_MANIFEST, UnityWebappsApplicationManifest))
#define UNITY_WEBAPPS_APPLICATION_MANIFEST_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_APPLICATION_MANIFEST, UnityWebappsApplicationManifestClass))
#define UNITY_WEBAPPS_IS_APPLICATION_MANIFEST(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_APPLICATION_MANIFEST))
#define UNITY_WEBAPPS_IS_APPLICATION_MANIFEST_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_APPLICATION_MANIFEST))
#define UNITY_WEBAPPS_APPLICATION_MANIFEST_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_APPLICATION_MANIFEST, UnityWebappsApplicationManifestClass))

#include <glib.h>

typedef struct _UnityWebappsApplicationManifestPrivate UnityWebappsApplicationManifestPrivate;

typedef struct _UnityWebappsApplicationManifest UnityWebappsApplicationManifest;

struct _UnityWebappsApplicationManifest {
	GObject object;

	UnityWebappsApplicationManifestPrivate *priv;
};

typedef struct _UnityWebappsApplicationManifestClass UnityWebappsApplicationManifestClass;

struct _UnityWebappsApplicationManifestClass
{
	GObjectClass parent_class;
};

GType unity_webapps_application_manifest_get_type (void) G_GNUC_CONST;

UnityWebappsApplicationManifest *unity_webapps_application_manifest_new ();
UnityWebappsApplicationManifest *unity_webapps_application_manifest_new_from_file (const gchar *filename);

const gchar *unity_webapps_application_manifest_get_name (UnityWebappsApplicationManifest *manifest);
const gchar *unity_webapps_application_manifest_get_package_name (UnityWebappsApplicationManifest *manifest);
const gchar *unity_webapps_application_manifest_get_domain (UnityWebappsApplicationManifest *manifest);

gboolean
unity_webapps_application_manifest_load_from_file (UnityWebappsApplicationManifest *manifest, const gchar *filename);

const gchar **unity_webapps_application_manifest_get_scripts (UnityWebappsApplicationManifest *manifest);
const gchar **unity_webapps_application_manifest_get_requires (UnityWebappsApplicationManifest *manifest);
const gchar **unity_webapps_application_manifest_get_includes (UnityWebappsApplicationManifest *manifest);

const gchar *
unity_webapps_application_manifest_get_base_path (UnityWebappsApplicationManifest *manifest);



#endif
