// Copyright 2016 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#ifndef XFA_FXFA_PARSER_CXFA_FONT_H_
#define XFA_FXFA_PARSER_CXFA_FONT_H_

#include "core/fxge/fx_dib.h"
#include "xfa/fxfa/parser/cxfa_data.h"

class CXFA_Node;

class CXFA_Font : public CXFA_Data {
 public:
  explicit CXFA_Font(CXFA_Node* pNode);

  float GetBaselineShift();
  float GetHorizontalScale();
  float GetVerticalScale();
  float GetLetterSpacing();
  int32_t GetLineThrough();
  int32_t GetUnderline();
  int32_t GetUnderlinePeriod();
  float GetFontSize();
  void GetTypeface(WideStringView& wsTypeFace);

  bool IsBold();
  bool IsItalic();

  FX_ARGB GetColor();
  void SetColor(FX_ARGB color);
};

#endif  // XFA_FXFA_PARSER_CXFA_FONT_H_
