/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef IMPTEXT_H_INCLUDED
#define IMPTEXT_H_INCLUDED

#include <string>

class WPXInputStream;

namespace libebook
{

class IMPCollector;

class IMPText
{
  // -Weffc++
  IMPText(const IMPText &);
  IMPText &operator=(const IMPText &);

public:
  IMPText(WPXInputStream *input, IMPCollector *collector);

  bool parse();

private:
  void flushText();

private:
  WPXInputStream *const m_input;
  IMPCollector *const m_collector;

  std::string m_text;
  bool m_openHeader;
  bool m_openFooter;
};

}

#endif // IMPTEXT_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
