/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.HasValueRestriction;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.impl.RestrictionImpl;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;

public class HasValueRestrictionImpl
extends RestrictionImpl
implements HasValueRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new HasValueRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to HasValueRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, HasValueRestriction.class);
        }
    };

    public HasValueRestrictionImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public void setHasValue(RDFNode value) {
        this.setPropertyValue(this.getProfile().HAS_VALUE(), "HAS_VALUE", value);
    }

    @Override
    public RDFNode getHasValue() {
        this.checkProfile(this.getProfile().HAS_VALUE(), "HAS_VALUE");
        RDFNode n = this.getPropertyValue(this.getProfile().HAS_VALUE());
        if (!(n instanceof Literal) && n.canAs(Individual.class)) {
            n = n.as(Individual.class);
        }
        return n;
    }

    @Override
    public boolean hasValue(RDFNode value) {
        return this.hasPropertyValue(this.getProfile().HAS_VALUE(), "HAS_VALUE", value);
    }

    @Override
    public void removeHasValue(RDFNode value) {
        this.removePropertyValue(this.getProfile().HAS_VALUE(), "HAS_VALUE", value);
    }
}

