/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef TDPARSER_H_INCLUDED
#define TDPARSER_H_INCLUDED

#include <vector>

#include "PDXParser.h"

class WPXDocumentInterface;
class WPXInputStream;

namespace libebook
{

class EBOOKCharsetConverter;

class TDTextParser;

class TDParser : public PDXParser
{
  // disable copying
  TDParser(const TDParser &);
  TDParser &operator=(const TDParser &);

public:
  explicit TDParser(WPXInputStream *input, WPXDocumentInterface *document = 0);
  virtual ~TDParser();

private:
  virtual bool isFormatSupported(unsigned type, unsigned creator);

  virtual void readAppInfoRecord(WPXInputStream *record);
  virtual void readSortInfoRecord(WPXInputStream *record);
  virtual void readIndexRecord(WPXInputStream *record);
  virtual void readDataRecord(WPXInputStream *record, bool last);

  void createConverter(const std::vector<char> &text);

  void openDocument();
  void closeDocument();

private:
  bool m_compressed;
  unsigned m_textLength;
  unsigned m_recordCount;
  unsigned m_recordSize;
  unsigned m_read;

  bool m_openedDocument;

  EBOOKCharsetConverter *m_converter;
  TDTextParser *m_textParser;
};

}

#endif // TDPARSER_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
