/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef FB2TOKEN_H_INCLUDED
#define FB2TOKEN_H_INCLUDED

#include "EBOOKToken.h"

namespace libebook
{

#define FB2_NO_NAMESPACE(ns) (0 == ns)

namespace FB2Token
{

enum
{
  INVALID_TOKEN = 0,

  // namespaces
  NS_FICTIONBOOK,
  NS_XLINK,
  NS_XML,
  NS_XMLNS,

  // elements
  a,
  annotation,
  author,
  binary,
  body,
  book_name,
  book_title,
  cite,
  city,
  code,
  coverpage,
  custom_info,
  date,
  description,
  document_info,
  email,
  emphasis,
  empty_line,
  epigraph,
  FictionBook,
  first_name,
  genre,
  history,
  home_page,
  id,
  image,
  isbn,
  keywords,
  lang,
  last_name,
  middle_name,
  nickname,
  output,
  output_document,
  p,
  part,
  poem,
  program_used,
  publisher,
  publish_info,
  section,
  sequence,
  src_lang,
  src_ocr,
  src_title_info,
  src_url,
  stanza,
  strikethrough,
  strong,
  style,
  stylesheet,
  sub,
  subtitle,
  sup,
  table,
  td,
  text_author,
  th,
  title,
  title_info,
  tr,
  translator,
  v,
  version,
  year,

  // attributes
  align,
  alt,
  colspan,
  content_type,
  create,
  currency,
  href,
  include,
  include_all,
  info_type,
  match,
  mode,
  name,
  number,
  price,
  rowspan,
  type,
  value,

  // attribute values
  note,
  simple,

  LAST_TOKEN
};

}

const EBOOKToken *getFB2Token(const char *str, const unsigned length);
const EBOOKToken *getFB2Token(const char *str);
const EBOOKToken *getFB2Token(const unsigned char *str);

int getFB2TokenID(const EBOOKToken &token);
int getFB2TokenID(const EBOOKToken *token);
int getFB2TokenID(const char *str, const unsigned length);
int getFB2TokenID(const char *str);
int getFB2TokenID(const unsigned char *str);

const char *getFB2TokenName(const EBOOKToken &token);
const char *getFB2TokenName(const EBOOKToken *token);
const char *getFB2TokenName(const char *str, const unsigned length);
const char *getFB2TokenName(const char *str);
const char *getFB2TokenName(const unsigned char *str);

}

#endif // FB2TOKEN_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
