/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; version 3.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "bamf-control.h"
#include "bamf-control-proxy.h"

BamfControl::BamfControl() :
    m_proxy(NULL)
{
    m_proxy = new OrgAyatanaBamfControlInterface("org.ayatana.bamf",
                                                 "/org/ayatana/bamf/control",
                                                 QDBusConnection::sessionBus(),
                                                 static_cast<QObject*>(this));
}

BamfControl::~BamfControl()
{
    delete m_proxy;
}

void
BamfControl::insert_desktop_file(const QString& desktop_file) const
{
    QDBusPendingReply<> reply = m_proxy->OmNomNomDesktopFile(desktop_file);
    reply.waitForFinished();
    if (reply.isError()) {
        qWarning() << reply.error();
    }
}

void
BamfControl::register_application_for_pid(const QString &application, int pid) const
{
    QDBusPendingReply<> reply = m_proxy->RegisterApplicationForPid(application, pid);
    reply.waitForFinished();
    if (reply.isError()) {
        qWarning() << reply.error();
    }
}

