/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import com.google.inject.internal.Lists;
import java.util.List;
import org.testng.collections.CollectionUtils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlDefine;
import org.testng.xml.XmlDependencies;
import org.testng.xml.XmlRun;
import org.testng.xml.dom.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlGroups {
    private List<XmlDefine> m_defines = Lists.newArrayList();
    private XmlRun m_run;
    private List<XmlDependencies> m_dependencies = Lists.newArrayList();

    public List<XmlDefine> getDefines() {
        return this.m_defines;
    }

    @Tag(name="define")
    public void addDefine(XmlDefine define) {
        this.getDefines().add(define);
    }

    public void setDefines(List<XmlDefine> defines) {
        this.m_defines = defines;
    }

    public XmlRun getRun() {
        return this.m_run;
    }

    public void setRun(XmlRun run) {
        this.m_run = run;
    }

    public List<XmlDependencies> getDependencies() {
        return this.m_dependencies;
    }

    @Tag(name="dependencies")
    public void setXmlDependencies(XmlDependencies dependencies) {
        this.m_dependencies.add(dependencies);
    }

    public String toXml(String indent) {
        boolean hasGroups;
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        String indent2 = indent + "  ";
        boolean bl = hasGroups = CollectionUtils.hasElements(this.m_defines) || this.m_run != null || CollectionUtils.hasElements(this.m_dependencies);
        if (hasGroups) {
            xsb.push("groups");
        }
        for (XmlDefine xmlDefine : this.m_defines) {
            xsb.getStringBuffer().append(xmlDefine.toXml(indent2));
        }
        xsb.getStringBuffer().append(this.m_run.toXml(indent2));
        for (XmlDependencies xmlDependencies : this.m_dependencies) {
            xsb.getStringBuffer().append(xmlDependencies.toXml(indent2));
        }
        if (hasGroups) {
            xsb.pop("groups");
        }
        return xsb.toXML();
    }
}

