#
# Copyright 2010 Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of either or both of the following licenses:
#
# 1) the GNU Lesser General Public License version 3, as published by the
# Free Software Foundation; and/or
# 2) the GNU Lesser General Public License version 2.1, as published by
# the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
# PURPOSE.  See the applicable version of the GNU Lesser General Public
# License for more details.
#
# You should have received a copy of both the GNU Lesser General Public
# License version 3 and version 2.1 along with this program.  If not, see
# <http://www.gnu.org/licenses/>
#
# Authors:
#    Cody Russell <crussell@canonical.com>
#

from ..overrides import override
from ..importer import modules

Grip = modules['Grip']._introspection_module

__all__ = []

class GestureEvent(Grip.GestureEvent):
    _UNION_MEMBERS = {
        Grip.GestureType.DRAG: 'drag',
        Grip.GestureType.PINCH: 'pinch',
        Grip.GestureType.ROTATE: 'rotate',
        Grip.GestureType.TAP: 'tap'
    }

    def __new__(cls, *args, **kwargs):
        return Grip.GestureEvent.__new__(cls)

    def __getattr__(self, name):
        real_event = getattr(self, '_UNION_MEMBERS').get(self.type)
        if real_event:
            return getattr(getattr(self, real_event), name)
        else:
            return getattr(self, name)

GestureEvent = override(GestureEvent)
__all__.append('GestureEvent')
