/*
 * Copyright (C) 2012 Canonical Ltd
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.    See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken.vandine@canonical.com>
 */


class UtilsSuite : Object
{
    private Friends.Utils utils;
    public UtilsSuite ()
    {
        utils = new Friends.Utils ();
        GLib.Test.add_data_func ("/Unit/Friends/Utils/time_string_seconds",
                                 test_time_string_seconds);
        GLib.Test.add_data_func ("/Unit/Friends/Utils/time_string_minute",
                                 test_time_string_minute);
        GLib.Test.add_data_func ("/Unit/Friends/Utils/time_string_minutes",
                                 test_time_string_minutes);
        GLib.Test.add_data_func ("/Unit/Friends/Utils/time_string_hour",
                                 test_time_string_hour);
    }

    internal void test_time_string_seconds ()
    {
        TimeVal time = TimeVal ();
        time.get_current_time ();
        time.tv_sec -= 59;
        string timestring = time.to_iso8601 ();
        string ts = utils.create_time_string (timestring);
        assert (ts == "a few seconds ago");
    }

    internal void test_time_string_minute ()
    {
        TimeVal time = TimeVal ();
        time.get_current_time ();
        time.tv_sec -= 60;
        string timestring = time.to_iso8601 ();
        string ts = utils.create_time_string (timestring);
        assert (ts == "1 minute ago");
    }

    internal void test_time_string_minutes ()
    {
        TimeVal time = TimeVal ();
        time.get_current_time ();
        time.tv_sec -= 3559;
        string timestring = time.to_iso8601 ();
        string ts = utils.create_time_string (timestring);
        assert (ts.contains ("minutes ago"));
    }

    internal void test_time_string_hour ()
    {
        TimeVal time = TimeVal ();
        time.get_current_time ();
        time.tv_sec -= 3601;
        string timestring = time.to_iso8601 ();
        string ts = utils.create_time_string (timestring);
        assert (ts == "1 hour ago");
    }
}

