/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2022 MediaTek Inc.
 * Copyright (c) 2022 BayLibre, SAS
 */

#ifndef _MTK_HDMI_PHY_8195_H
#define _MTK_HDMI_PHY_8195_H

#include <linux/clk.h>
#include <linux/clk-provider.h>
#include <linux/types.h>

#define PCW_DECIMAL_WIDTH 24
#define PLL_PREDIV 1
#define PLL_FBKDIV_HS3 1

#define HDMI20_CLK_CFG 0x70
#define REG_TXC_DIV GENMASK(31, 30)

#define HDMI_1_CFG_0 0x00
#define RG_HDMITX21_DRV_IBIAS_CLK GENMASK(10, 5)
#define RG_HDMITX21_DRV_IMP_EN GENMASK(23, 20)
#define RG_HDMITX21_DRV_EN GENMASK(27, 24)
#define RG_HDMITX21_SER_EN GENMASK(31, 28)

#define HDMI_1_CFG_1 0x04
#define RG_HDMITX21_DRV_IBIAS_D0 GENMASK(19, 14)
#define RG_HDMITX21_DRV_IBIAS_D1 GENMASK(25, 20)
#define RG_HDMITX21_DRV_IBIAS_D2 GENMASK(31, 26)

#define HDMI_1_CFG_10 0x40
#define RG_HDMITXPLL_REF_CK_SEL GENMASK(2, 1)
#define RG_HDMITX21_VREF_SEL BIT(4)
#define RG_HDMITX21_BIAS_PE_VREF_SELB BIT(10)
#define RG_HDMITX21_BIAS_PE_BG_VREF_SEL GENMASK(16, 15)
#define RG_HDMITX21_BG_PWD BIT(20)

#define HDMI_1_CFG_2 0x08
#define RG_HDMITX21_DRV_IMP_D0_EN1 GENMASK(13, 8)
#define RG_HDMITX21_DRV_IMP_D1_EN1 GENMASK(19, 14)
#define RG_HDMITX21_DRV_IMP_D2_EN1 GENMASK(25, 20)
#define RG_HDMITX21_DRV_IMP_CLK_EN1 GENMASK(31, 26)

#define HDMI_1_CFG_3 0x0c
#define RG_HDMITX21_CKLDO_EN BIT(3)
#define RG_HDMITX21_SLDOLPF_EN BIT(7)
#define RG_HDMITX21_SLDO_EN GENMASK(11, 8)

#define HDMI_1_CFG_6 0x18
#define RG_HDMITX21_D2_DRV_OP_EN BIT(8)
#define RG_HDMITX21_D1_DRV_OP_EN BIT(9)
#define RG_HDMITX21_D0_DRV_OP_EN BIT(10)
#define RG_HDMITX21_CK_DRV_OP_EN BIT(11)
#define RG_HDMITX21_FRL_EN BIT(12)
#define RG_HDMITX21_FRL_CK_EN BIT(13)
#define RG_HDMITX21_FRL_D0_EN BIT(14)
#define RG_HDMITX21_FRL_D1_EN BIT(15)
#define RG_HDMITX21_FRL_D2_EN BIT(16)
#define RG_HDMITX21_INTR_CAL GENMASK(22, 18)
#define RG_HDMITX21_TX_POSDIV GENMASK(27, 26)
#define RG_HDMITX21_TX_POSDIV_EN BIT(28)
#define RG_HDMITX21_BIAS_EN BIT(29)

#define HDMI_1_CFG_9 0x24
#define RG_HDMITX21_SLDO_VREF_SEL GENMASK(5, 4)

#define HDMI_1_PLL_CFG_0 0x44
#define RG_HDMITXPLL_HREN GENMASK(13, 12)
#define RG_HDMITXPLL_IBAND_FIX_EN BIT(24)
#define RG_HDMITXPLL_LVR_SEL GENMASK(27, 26)
#define RG_HDMITXPLL_BP2 BIT(30)
#define RG_HDMITXPLL_TCL_EN BIT(31)

#define HDMI_1_PLL_CFG_1 0x48
#define RG_HDMITXPLL_RESERVE_BIT1_0 GENMASK(1, 0)
#define RG_HDMITXPLL_RESERVE_BIT3_2 GENMASK(3, 2)
#define RG_HDMITXPLL_RESERVE_BIT12_11 GENMASK(12, 11)
#define RG_HDMITXPLL_RESERVE_BIT13 BIT(13)
#define RG_HDMITXPLL_RESERVE_BIT14 BIT(14)

#define HDMI_1_PLL_CFG_2 0x4c
#define RG_HDMITXPLL_BC GENMASK(28, 27)
#define RG_HDMITXPLL_IC GENMASK(26, 22)
#define RG_HDMITXPLL_BR GENMASK(21, 19)
#define RG_HDMITXPLL_IR GENMASK(18, 14)
#define RG_HDMITXPLL_BP GENMASK(13, 10)
#define RG_HDMITXPLL_HIKVCO BIT(29)
#define RG_HDMITXPLL_PWD BIT(31)

#define HDMI_1_PLL_CFG_3 0x50
#define RG_HDMITXPLL_FBKDIV_LOW GENMASK(31, 0)

#define HDMI_1_PLL_CFG_4 0x54
#define DA_HDMITXPLL_ISO_EN BIT(1)
#define DA_HDMITXPLL_PWR_ON BIT(2)
#define RG_HDMITXPLL_POSDIV_DIV3_CTRL BIT(21)
#define RG_HDMITXPLL_POSDIV GENMASK(23, 22)
#define RG_HDMITXPLL_DIV_CTRL GENMASK(25, 24)
#define RG_HDMITXPLL_PREDIV GENMASK(29, 28)
#define RG_HDMITXPLL_FBKDIV_HIGH BIT(31)

#define HDMI_ANA_CTL 0x7c
#define REG_ANA_HDMI20_FIFO_EN BIT(16)

#define HDMI_CTL_3 0xcc
#define REG_HDMITXPLL_DIV GENMASK(4, 0)
#define REG_HDMITX_REF_XTAL_SEL BIT(7)
#define REG_HDMITX_REF_RESPLL_SEL BIT(9)
#define REG_PIXEL_CLOCK_SEL BIT(10)
#define REG_HDMITX_PIXEL_CLOCK BIT(23)

#endif /* MTK_HDMI_PHY_8195_H */
