/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2023 Intel Corporation
 */

#ifndef _ABI_GSC_COMMAND_HEADER_ABI_H
#define _ABI_GSC_COMMAND_HEADER_ABI_H

#include <linux/types.h>

struct intel_gsc_mtl_header {
	u32 validity_marker;
#define GSC_HECI_VALIDITY_MARKER 0xA578875A

	u8 heci_client_id;

	u8 reserved1;

	u16 header_version;
#define MTL_GSC_HEADER_VERSION 1

	/* FW allows host to decide host_session handle as it sees fit. */
	u64 host_session_handle;

	/* handle generated by FW for messages that need to be re-submitted */
	u64 gsc_message_handle;

	u32 message_size; /* lower 20 bits only, upper 12 are reserved */

	/*
	 * Flags mask:
	 * Bit 0: Pending
	 * Bit 1: Session Cleanup;
	 * Bits 2-15: Flags
	 * Bits 16-31: Extension Size
	 * According to internal spec flags are either input or output
	 * we distinguish the flags using OUTFLAG or INFLAG
	 */
	u32 flags;
#define GSC_OUTFLAG_MSG_PENDING	BIT(0)
#define GSC_INFLAG_MSG_CLEANUP	BIT(1)

	u32 status;
} __packed;

#endif
