package dns

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// HTTPStatusCode enumerates the values for http status code.
type HTTPStatusCode string

const (
	// Accepted specifies the accepted state for http status code.
	Accepted HTTPStatusCode = "Accepted"
	// Ambiguous specifies the ambiguous state for http status code.
	Ambiguous HTTPStatusCode = "Ambiguous"
	// BadGateway specifies the bad gateway state for http status code.
	BadGateway HTTPStatusCode = "BadGateway"
	// BadRequest specifies the bad request state for http status code.
	BadRequest HTTPStatusCode = "BadRequest"
	// Conflict specifies the conflict state for http status code.
	Conflict HTTPStatusCode = "Conflict"
	// Continue specifies the continue state for http status code.
	Continue HTTPStatusCode = "Continue"
	// Created specifies the created state for http status code.
	Created HTTPStatusCode = "Created"
	// ExpectationFailed specifies the expectation failed state for http status
	// code.
	ExpectationFailed HTTPStatusCode = "ExpectationFailed"
	// Forbidden specifies the forbidden state for http status code.
	Forbidden HTTPStatusCode = "Forbidden"
	// Found specifies the found state for http status code.
	Found HTTPStatusCode = "Found"
	// GatewayTimeout specifies the gateway timeout state for http status code.
	GatewayTimeout HTTPStatusCode = "GatewayTimeout"
	// Gone specifies the gone state for http status code.
	Gone HTTPStatusCode = "Gone"
	// HTTPVersionNotSupported specifies the http version not supported state
	// for http status code.
	HTTPVersionNotSupported HTTPStatusCode = "HttpVersionNotSupported"
	// InternalServerError specifies the internal server error state for http
	// status code.
	InternalServerError HTTPStatusCode = "InternalServerError"
	// LengthRequired specifies the length required state for http status code.
	LengthRequired HTTPStatusCode = "LengthRequired"
	// MethodNotAllowed specifies the method not allowed state for http status
	// code.
	MethodNotAllowed HTTPStatusCode = "MethodNotAllowed"
	// Moved specifies the moved state for http status code.
	Moved HTTPStatusCode = "Moved"
	// MovedPermanently specifies the moved permanently state for http status
	// code.
	MovedPermanently HTTPStatusCode = "MovedPermanently"
	// MultipleChoices specifies the multiple choices state for http status
	// code.
	MultipleChoices HTTPStatusCode = "MultipleChoices"
	// NoContent specifies the no content state for http status code.
	NoContent HTTPStatusCode = "NoContent"
	// NonAuthoritativeInformation specifies the non authoritative information
	// state for http status code.
	NonAuthoritativeInformation HTTPStatusCode = "NonAuthoritativeInformation"
	// NotAcceptable specifies the not acceptable state for http status code.
	NotAcceptable HTTPStatusCode = "NotAcceptable"
	// NotFound specifies the not found state for http status code.
	NotFound HTTPStatusCode = "NotFound"
	// NotImplemented specifies the not implemented state for http status code.
	NotImplemented HTTPStatusCode = "NotImplemented"
	// NotModified specifies the not modified state for http status code.
	NotModified HTTPStatusCode = "NotModified"
	// OK specifies the ok state for http status code.
	OK HTTPStatusCode = "OK"
	// PartialContent specifies the partial content state for http status code.
	PartialContent HTTPStatusCode = "PartialContent"
	// PaymentRequired specifies the payment required state for http status
	// code.
	PaymentRequired HTTPStatusCode = "PaymentRequired"
	// PreconditionFailed specifies the precondition failed state for http
	// status code.
	PreconditionFailed HTTPStatusCode = "PreconditionFailed"
	// ProxyAuthenticationRequired specifies the proxy authentication required
	// state for http status code.
	ProxyAuthenticationRequired HTTPStatusCode = "ProxyAuthenticationRequired"
	// Redirect specifies the redirect state for http status code.
	Redirect HTTPStatusCode = "Redirect"
	// RedirectKeepVerb specifies the redirect keep verb state for http status
	// code.
	RedirectKeepVerb HTTPStatusCode = "RedirectKeepVerb"
	// RedirectMethod specifies the redirect method state for http status code.
	RedirectMethod HTTPStatusCode = "RedirectMethod"
	// RequestedRangeNotSatisfiable specifies the requested range not
	// satisfiable state for http status code.
	RequestedRangeNotSatisfiable HTTPStatusCode = "RequestedRangeNotSatisfiable"
	// RequestEntityTooLarge specifies the request entity too large state for
	// http status code.
	RequestEntityTooLarge HTTPStatusCode = "RequestEntityTooLarge"
	// RequestTimeout specifies the request timeout state for http status code.
	RequestTimeout HTTPStatusCode = "RequestTimeout"
	// RequestURITooLong specifies the request uri too long state for http
	// status code.
	RequestURITooLong HTTPStatusCode = "RequestUriTooLong"
	// ResetContent specifies the reset content state for http status code.
	ResetContent HTTPStatusCode = "ResetContent"
	// SeeOther specifies the see other state for http status code.
	SeeOther HTTPStatusCode = "SeeOther"
	// ServiceUnavailable specifies the service unavailable state for http
	// status code.
	ServiceUnavailable HTTPStatusCode = "ServiceUnavailable"
	// SwitchingProtocols specifies the switching protocols state for http
	// status code.
	SwitchingProtocols HTTPStatusCode = "SwitchingProtocols"
	// TemporaryRedirect specifies the temporary redirect state for http status
	// code.
	TemporaryRedirect HTTPStatusCode = "TemporaryRedirect"
	// Unauthorized specifies the unauthorized state for http status code.
	Unauthorized HTTPStatusCode = "Unauthorized"
	// UnsupportedMediaType specifies the unsupported media type state for http
	// status code.
	UnsupportedMediaType HTTPStatusCode = "UnsupportedMediaType"
	// Unused specifies the unused state for http status code.
	Unused HTTPStatusCode = "Unused"
	// UpgradeRequired specifies the upgrade required state for http status
	// code.
	UpgradeRequired HTTPStatusCode = "UpgradeRequired"
	// UseProxy specifies the use proxy state for http status code.
	UseProxy HTTPStatusCode = "UseProxy"
)

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// Failed specifies the failed state for operation status.
	Failed OperationStatus = "Failed"
	// InProgress specifies the in progress state for operation status.
	InProgress OperationStatus = "InProgress"
	// Succeeded specifies the succeeded state for operation status.
	Succeeded OperationStatus = "Succeeded"
)

// RecordType enumerates the values for record type.
type RecordType string

const (
	// A specifies the a state for record type.
	A RecordType = "A"
	// AAAA specifies the aaaa state for record type.
	AAAA RecordType = "AAAA"
	// CNAME specifies the cname state for record type.
	CNAME RecordType = "CNAME"
	// MX specifies the mx state for record type.
	MX RecordType = "MX"
	// NS specifies the ns state for record type.
	NS RecordType = "NS"
	// PTR specifies the ptr state for record type.
	PTR RecordType = "PTR"
	// SOA specifies the soa state for record type.
	SOA RecordType = "SOA"
	// SRV specifies the srv state for record type.
	SRV RecordType = "SRV"
	// TXT specifies the txt state for record type.
	TXT RecordType = "TXT"
)

// AaaaRecord is an AAAA record.
type AaaaRecord struct {
	Ipv6Address *string `json:"ipv6Address,omitempty"`
}

// ARecord is an A record.
type ARecord struct {
	Ipv4Address *string `json:"ipv4Address,omitempty"`
}

// CloudError is
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody is
type CloudErrorBody struct {
	Code    *string           `json:"code,omitempty"`
	Message *string           `json:"message,omitempty"`
	Target  *string           `json:"target,omitempty"`
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// CnameRecord is a CNAME record.
type CnameRecord struct {
	Cname *string `json:"cname,omitempty"`
}

// MxRecord is an MX record.
type MxRecord struct {
	Preference *int32  `json:"preference,omitempty"`
	Exchange   *string `json:"exchange,omitempty"`
}

// NsRecord is an NS record.
type NsRecord struct {
	Nsdname *string `json:"nsdname,omitempty"`
}

// PtrRecord is a PTR record.
type PtrRecord struct {
	Ptrdname *string `json:"ptrdname,omitempty"`
}

// RecordSet is describes a DNS record set (a collection of DNS records with
// the same name and type).
type RecordSet struct {
	autorest.Response    `json:"-"`
	ID                   *string `json:"id,omitempty"`
	Name                 *string `json:"name,omitempty"`
	Type                 *string `json:"type,omitempty"`
	Etag                 *string `json:"etag,omitempty"`
	*RecordSetProperties `json:"properties,omitempty"`
}

// RecordSetListResult is the response to a record set List operation.
type RecordSetListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RecordSet `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// RecordSetListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RecordSetListResult) RecordSetListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RecordSetProperties is represents the properties of the records in the
// record set.
type RecordSetProperties struct {
	Metadata    *map[string]*string `json:"metadata,omitempty"`
	TTL         *int64              `json:"TTL,omitempty"`
	ARecords    *[]ARecord          `json:"ARecords,omitempty"`
	AaaaRecords *[]AaaaRecord       `json:"AAAARecords,omitempty"`
	MxRecords   *[]MxRecord         `json:"MXRecords,omitempty"`
	NsRecords   *[]NsRecord         `json:"NSRecords,omitempty"`
	PtrRecords  *[]PtrRecord        `json:"PTRRecords,omitempty"`
	SrvRecords  *[]SrvRecord        `json:"SRVRecords,omitempty"`
	TxtRecords  *[]TxtRecord        `json:"TXTRecords,omitempty"`
	CnameRecord *CnameRecord        `json:"CNAMERecord,omitempty"`
	SoaRecord   *SoaRecord          `json:"SOARecord,omitempty"`
}

// RecordSetUpdateParameters is parameters supplied to update a record set.
type RecordSetUpdateParameters struct {
	RecordSet *RecordSet `json:"RecordSet,omitempty"`
}

// Resource is
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// SoaRecord is an SOA record.
type SoaRecord struct {
	Host         *string `json:"host,omitempty"`
	Email        *string `json:"email,omitempty"`
	SerialNumber *int64  `json:"serialNumber,omitempty"`
	RefreshTime  *int64  `json:"refreshTime,omitempty"`
	RetryTime    *int64  `json:"retryTime,omitempty"`
	ExpireTime   *int64  `json:"expireTime,omitempty"`
	MinimumTTL   *int64  `json:"minimumTTL,omitempty"`
}

// SrvRecord is an SRV record.
type SrvRecord struct {
	Priority *int32  `json:"priority,omitempty"`
	Weight   *int32  `json:"weight,omitempty"`
	Port     *int32  `json:"port,omitempty"`
	Target   *string `json:"target,omitempty"`
}

// SubResource is
type SubResource struct {
	ID *string `json:"id,omitempty"`
}

// TxtRecord is a TXT record.
type TxtRecord struct {
	Value *[]string `json:"value,omitempty"`
}

// Zone is describes a DNS zone.
type Zone struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Etag              *string             `json:"etag,omitempty"`
	*ZoneProperties   `json:"properties,omitempty"`
}

// ZoneDeleteResult is the response to a Zone Delete operation.
type ZoneDeleteResult struct {
	autorest.Response   `json:"-"`
	AzureAsyncOperation *string         `json:"azureAsyncOperation,omitempty"`
	Status              OperationStatus `json:"status,omitempty"`
	StatusCode          HTTPStatusCode  `json:"statusCode,omitempty"`
	RequestID           *string         `json:"requestId,omitempty"`
}

// ZoneListResult is the response to a Zone List or ListAll operation.
type ZoneListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Zone `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// ZoneListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ZoneListResult) ZoneListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ZoneProperties is represents the properties of the zone.
type ZoneProperties struct {
	MaxNumberOfRecordSets *int64    `json:"maxNumberOfRecordSets,omitempty"`
	NumberOfRecordSets    *int64    `json:"numberOfRecordSets,omitempty"`
	NameServers           *[]string `json:"nameServers,omitempty"`
}
