static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_object(buffer, _(\"Input buffer\"), GEGL_TYPE_BUFFER)                \n"
"	  description (_(\"The GeglBuffer to load into the pipeline\"))              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE buffer-source.c                                      \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gulong buffer_changed_handler;                                              \n"
"} Priv;                                                                       \n"
"                                                                              \n"
"static Priv *                                                                 \n"
"get_priv (GeglProperties *o)                                                  \n"
"{                                                                             \n"
"  Priv *priv = (Priv*)o->user_data;                                           \n"
"  if (priv == NULL) {                                                         \n"
"    priv = g_new0 (Priv, 1);                                                  \n"
"    o->user_data = (void*) priv;                                              \n"
"                                                                              \n"
"    priv->buffer_changed_handler = 0;                                         \n"
"  }                                                                           \n"
"  return priv;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void buffer_changed (GeglBuffer          *buffer,                      \n"
"                            const GeglRectangle *rect,                        \n"
"                            gpointer             userdata)                    \n"
"{                                                                             \n"
"  gegl_operation_invalidate (GEGL_OPERATION (userdata), rect, FALSE);         \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_buffer_source_prepare (GeglOperation *operation)                         \n"
"{                                                                             \n"
"  const Babl *format = NULL;                                                  \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (o->buffer)                                                              \n"
"    format = gegl_buffer_get_format (GEGL_BUFFER (o->buffer));                \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle result = {0,0,0,0};                                           \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"                                                                              \n"
"  if (!o->buffer)                                                             \n"
"    {                                                                         \n"
"      return result;                                                          \n"
"    }                                                                         \n"
"  result = *gegl_buffer_get_extent (GEGL_BUFFER (o->buffer));                 \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"my_set_property (GObject  *gobject,                                           \n"
"                          guint         property_id,                          \n"
"                          const GValue *value,                                \n"
"                          GParamSpec   *pspec)                                \n"
"{                                                                             \n"
"  GeglOperation *operation = GEGL_OPERATION (gobject);                        \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv *p = get_priv(o);                                                      \n"
"  GObject *buffer = NULL;                                                     \n"
"                                                                              \n"
"  switch (property_id)                                                        \n"
"  {                                                                           \n"
"    case PROP_buffer:                                                         \n"
"      if (o->buffer) {                                                        \n"
"        // Invariant: valid buffer should always have valid signal handler    \n"
"        g_assert(p->buffer_changed_handler > 0);                              \n"
"        g_signal_handler_disconnect (o->buffer, p->buffer_changed_handler);   \n"
"        /* XXX: should decrement signal connected count */                    \n"
"      }                                                                       \n"
"      buffer = G_OBJECT (g_value_get_object (value));                         \n"
"      if (buffer) {                                                           \n"
"        p->buffer_changed_handler = gegl_buffer_signal_connect (GEGL_BUFFER(buffer), \"changed\", G_CALLBACK(buffer_changed), operation);\n"
"      }                                                                       \n"
"      break;                                                                  \n"
"    default:                                                                  \n"
"      break;                                                                  \n"
"  }                                                                           \n"
"                                                                              \n"
"  /* The set_property provided by the chant system does the                   \n"
"   * storing and reffing/unreffing of the input properties */                 \n"
"  set_property(gobject, property_id, value, pspec);                           \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation        *operation,                                     \n"
"         GeglOperationContext *context,                                       \n"
"         const gchar          *output_pad,                                    \n"
"         const GeglRectangle  *result,                                        \n"
"         gint                  level)                                         \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (o->buffer)                                                              \n"
"    {                                                                         \n"
"      g_object_ref (o->buffer); /* Add an extra reference, since              \n"
"				     * gegl_operation_set_data is                                         \n"
"				     * stealing one.                                                      \n"
"				     */                                                                   \n"
"                                                                              \n"
"      /* override core behaviour, by resetting the buffer in the operation_context */\n"
"      gegl_operation_context_take_object (context, \"output\",                \n"
"                                          G_OBJECT (o->buffer));              \n"
"      /* mark that this buffer should not be used for in-place                \n"
"       * processing.                                                          \n"
"       */                                                                     \n"
"      gegl_object_set_has_forked (G_OBJECT (o->buffer));                      \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"dispose (GObject *object)                                                     \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"  Priv *p = get_priv(o);                                                      \n"
"                                                                              \n"
"  if (o->buffer)                                                              \n"
"    {                                                                         \n"
"      // Invariant: valid buffer should always have valid signal handler      \n"
"      g_assert(p->buffer_changed_handler > 0);                                \n"
"      g_signal_handler_disconnect (o->buffer, p->buffer_changed_handler);     \n"
"        /* XXX: should decrement signal connected count */                    \n"
"      g_object_unref (o->buffer);                                             \n"
"      o->buffer = NULL;                                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (p) {                                                                    \n"
"    g_free(p);                                                                \n"
"    o->user_data = NULL;                                                      \n"
"  }                                                                           \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->dispose (object);                    \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  operation_class->prepare = gegl_buffer_source_prepare;                      \n"
"  operation_class->process = process;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->set_property = my_set_property;                     \n"
"  G_OBJECT_CLASS (klass)->dispose = dispose;                                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"      \"name\",       \"gegl:buffer-source\",                                 \n"
"      \"title\",      _(\"Buffer Source\"),                                   \n"
"      \"categories\", \"programming:input\",                                  \n"
"      \"description\", _(\"Use an existing in-memory GeglBuffer as image source.\"),\n"
"      NULL);                                                                  \n"
"                                                                              \n"
"  operation_class->no_cache = TRUE;                                           \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
