//Written in the D programming language
/**
 * License: $(HTTP boost.org/LICENSE_1_0.txt, Boost License 1.0).
 *
 * Authors: Dmitry Olshansky
 *
 */
// !!! DO NOT EDIT !!!
// !!! Did you even read the comment? !!!
// This module is automatically generated from Unicode Character Database files
// https://github.com/dlang/phobos/blob/master/tools/unicode_table_generator.d
//dfmt off
module std.internal.unicode_norm;
import std.internal.unicode_tables;

package(std):


static if (size_t.sizeof == 4)
{
//1728 bytes
enum nfcQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(cast(immutable size_t[]) x"
0000000000000040000000C0",
cast(immutable size_t[]) x"
000001000000010000001E00",
cast(immutable size_t[]) x"
020201000302020202020204020502020202020206020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010000000000000000000200030000000500040007000600080000
000A000900000000000000000000000000000000000B000000000000000C0000000E000D000F00000000000000000000
000000000000001000000000000000000000001100000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000012000000140013000000000000000000000000000000000000000000000000
0000000000000000000000000000000000160015001700000019001800000000001A0000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000001B0000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000001200120000001C000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000081A9FDF010361F80000003F40100000
000000800000000000000000000000000000000000000000003800000000000000000000000000000000000000000000
0000000010000000FF000000000000000000000040000000B08000000000000000000000004800004E00000000000000
00000000000000000000000000000000000000004000000030C000000000000000000000400000000080000000000000
000000000000000000400000000000000000000000000000006000040000000000000000400000000080000000000000
000000000000000080008400000000000000000000000000108420080168020020080002020010840000000000000000
0000000000004000000000000000000000000000000000000000000000000000000000000000000000000000003FFFFE
00000000FFFFFF0000000007000000000000000000200000000000000000000000000000000000000000000000000000
0000000000000000000000002AAA0000000000004800000008080A002A00C80800000003000000000000000000000000
000000000000000000000000000000000000000000000C40000000000000000000000000000000000000000000000000
000000000000060000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000010000000000000000000000000000000000000000000000006000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FE53FFFFFFFFC65FFFFFFFFFFFF3FFF
FFFFFFFFFFFFFFFF03FFFFFF00000000A00000005F7FFC0000007FDB0000000000000000000000000000000000000000
000000000000000000000000000000000000000004000000000000000000000000000000000000800000000000000000
000000000000000000000000000000000000000040000000008000000000000000000000000000000000000000000000
000000000000000000000000000000000000000024010000000000000000000000000000000000000000000000000000
000000000000800000000000000000000000000000010000000000000000000000000000000000000000000000000000
0000000000000000C00000000000001F00000000F800000000000001000000003FFFFFFF000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
);
//2048 bytes
enum nfdQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(cast(immutable size_t[]) x"
0000000000000040000000E0",
cast(immutable size_t[]) x"
000001000000014000002400",
cast(immutable size_t[]) x"
020201000504030202020206020702020202020208020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000100000003000200050004000500060007000500090008000B000A000C0005
0005000D00050005000500050005000500050005000E0005000500050010000F00120011001400130005000500050005
000500050005001500050005000500050005001600050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050017001700170017
001700170017001700170017001700170017001700170017001700170017001700170017001700170017001700170017
001700170017001700170017001700170017001700170017001700170018001700050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
00170005001A001900050005000500050005000500050005000500050005000500050005000500050005000500050005
001C001B001D0005001F001E000500050020000500050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050021000500050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
001700170005002200050005000500050005000500050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500000000000000000000000000000000
00000000000000003E7EFFBFBE7EFFBFFFFCFFFF7EF1FF3FFFF3F1F87FFFFF3F0000000000018003DFFFE000FF31FFCF
CFFFFFFF000FFFC000000000000000000000000000000000000000000000000000000000000000000000001B40100000
0001D7E00001FC0000187C00000000000200708B02000000708B000000C000000000000000000000FCCF0006033FFCFC
0000000000000000000000000000000000000000000000000000000000000000000000000000007C0000000000000000
000000000000000000080005000000000000000000120200FF000000000000000000000000000000B000180000000000
00000000004800004E000000000000000000000000000000000000000000000000000000000000003000190000000000
001000000000000000001C000000000000000000000000000000010000000000000000000000000000000D8100000000
000000000000000000001C00000000000000000000000000740000000000000000000000000000001084200801680200
200800020200108400000000000000000000000000000040000000000000000000000000000000000000000000000000
00045540280000000000000B0000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0BFFFFFFFFFFFFFFFFFFFFFF03FFFFFF3F3FFFFFFFFFFFFFAAFF3F3F3FFFFFFFFFFFFFFF5FDFFFFFEFCFFFDE3FDCFFFF
00000003000000000000000000000000000000000000000000000000000000000000000000000C400000000000000000
0C000000000040000000E000000000000000121000000050000002920333E005000003330000F0000000000000003C0F
000000000000060000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000100000000000000000000000000000005555500036DB02A5401000005555500036DB02A547900000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000F00000000000000007FE53FFFFFFFFC65FFFFFFFFFFFF3FFFFFFFFFFFFFFFFFFF03FFFFFF00000000
A00000005F7FFC0000007FDB000000000000000000000000000000000000000000000000000000000000000000000000
14000000000008000000000000000000000000000000C000000000000000000000000000000000000000000000000000
000000000000000000001800000000000000000000000000000000000000000000000000000000000000000000000000
0000000058000000000000000000000000000000000000000000000000000000000000000C0000000000000000000000
00000000010000000000000000000000000000000000000000000000000000000000000000000000C00000000000001F
00000000F800000000000001000000003FFFFFFF00000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000",
);
//2848 bytes
enum nfkcQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(cast(immutable size_t[]) x"
0000000000000040000000E0",
cast(immutable size_t[]) x"
000001000000014000003D00",
cast(immutable size_t[]) x"
020201000402030202020205070602020202020208020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000100000003000200050004000400060007000400090008000B000A000D000C
000F000E0004000400040004000400040004000400100004001100040013001200150014001700160004001800040004
0004000400040019001B001A001D001C001F001E00210020000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040023002200040004002400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400210004002600250027002100290028
000400040004000400040004002A000400040004000400040004000400040004002C002B002D0004002F002E00040004
003000040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
003100040004000400330032003500340004000400040004000400040004000400040036000400040004000400040004
000400040004000400040004000400370038000400040039000400040004000400040004003A00040004000400040004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
002100210004003B00040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400000000000000000000000000000000
00000000773C8501000000000000000000000000800C00000000020180000000000000000000000000001FF0000E0000
000000000000000000000000000000000000000001FF00003F0000000000001F081A9FDF010361F80000003F44100000
000000B000000000007F0000023700000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000008000000000000000000000000000000000000000000038000001E00000
000000000000000000000000000000000000000010000000FF000000000000000000000040000000B080000000000000
00000000004800004E0000000000000000000000000000000000000000000000000000004000000030C0000000000000
000000004000000000800000000000000000000000000000004000000000000000000000000000000060000400000000
000000004000000000800000000000000000000000000000800084000000000000000000000800000000000000000000
0000000000080000300000000000000000001000000000001084200803E8020020080002020010840000000000000000
0000000000004000000000000000000000000000000000000000000010000000000000000000000000000000003FFFFE
00000000FFFFFF0000000007000000000000000000200000000000000000000000000000000000000000000000000000
00000000F7FF7000FFFFBFFF010007FFF8000000FFFFFFFF000000000000000000000000000000000000000000000000
0C0000000000000000000000000000000000000000000000000000002AAA000000000000E8000000E808EA036A00E808
008207FF50D8807080800380FFF300001FFF7FFF0000010000000000000000003E6FFEEFFBFBBD57FFFF03E1FFFFFFFF
00000200000000000000000000000000000000000001B000000000000000000000000000000000000000000000000000
0000000000000600000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF000007FF0000100000000000000000000070000000000000000000001000000000000000
000000000000000000000000300000000000000000000000000000000000000000000000000000000000000000008000
000000000000000000000000000000000000000000000000000000000000000080000000000000000000000000080000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF003FFFFF0000000000000001074000000000000000000000
9E00000000000000000000008000000000000000FFFE0000FFFFFFFFFFFFFFFFFFFC7FFF000000000000000000000000
7FFFFFFFFFFFFFFFFFFF00FF7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000030000000000000000000000000000000
00000000000000000000000000010000000000000000000000000000031C00000000000000000000F000000000000200
000000000000000000000000000000007FE53FFFFFFFFC65FFFFFFFFFFFF3FFFFFFFFFFFFFFFFFFF03FFFFFF00000000
A0F8007F5F7FFFFFFFFFFFDBFFFFFFFFFFFFFFFF0003FFFFFFF80000FFFFFFFFFFFFFFFF3FFFFFFFFFFF0000FFFFFFFF
FFFCFFFFFFFFFFFF000000FF1FFF000003FF0000FFFF0000FFF7FF9FFFD70F7FFFFFFFFFFFFFFFFFFFFFFFFF1FFFFFFF
FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFF1CFCFCFC00007F7F00000000000000000000000000000000
FFFFFFBE07FDFFFF00000000000000000000000000000000000000000000000000000000040000000000000000000000
000000000000008000000000000000000000000000000000000000000000000000000000400000000080000000000000
000000000000000000000000000000000000000000000000000000000000000000000000240100000000000000000000
000000000000000000000000000000000000000000008000000000000000000000000000000100000000000000000000
000000000000000000000000000000000000000000000000C00000000000001F00000000F80000000000000100000000
FFFFFFFFFFFFFFFFFFDFFFFFFFFFFFFFDFFFFFFFEBFFDE64FFFFFFEFFFFFFFFFDFDFE7BF7BFFFFFFFFFDFC5FFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3FFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCFFFFFFFFFFF00000000FFFF0000FFFFFFFF00003FFF
00000000000000000000000000000000FFFFFFEF0AF7FE96AA96EA845EF7F7960FFFFBFF0FFFFBEE0000000000000000
FFFF07FFFFFF7FFF0000FFFF00001C0000010000000000000000000000000000FFFF00070FFFFFFF000301FF00000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003FF0000
3FFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);
//2944 bytes
enum nfkdQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(cast(immutable size_t[]) x"
0000000000000040000000F0",
cast(immutable size_t[]) x"
000001000000016000003E00",
cast(immutable size_t[]) x"
020201000504030202020206080702020202020209020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001000000030002000500040007000600080007000A0009000C000B000E000D
0007000F0007000700070007000700070007000700100007001100070013001200150014001700160007001800070007
0007000700070019001B001A001D001C001F001E00210020000700070007000700070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070023002200070007002400070021002100210021
002100210021002100210021002100210021002100210021002100210021002100210021002100210021002100210021
002100210021002100210021002100210021002100210021002100210025002100070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007
002100070027002600280021002A0029000700070007000700070007002B000700070007000700070007000700070007
002D002C002E00070030002F000700070031000700070007000700070007000700070007000700070007000700070007
000700070007000700070007000700070032000700070007003400330036003500070007000700070007000700070007
0007003700070007000700070007000700070007000700070007000700070038003900070007003A0007000700070007
00070007003B000700070007000700070007000700070007000700070007000700070007000700070007000700070007
00070007000700070007000700070007002100210007003C000700070007000700070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007
0000000000000000000000000000000000000000773C85013E7EFFBFBE7EFFBFFFFCFFFFFEFDFF3FFFF3F3F9FFFFFF3F
0000000000018003DFFFFFF0FF3FFFCFCFFFFFFF000FFFC000000000000000000000000001FF00003F0000000000001F
00000000000000000000001B441000000001D7F00001FC00007F7C00023700000200708B02000000708B000000C00000
0000000000000000FCCF0006033FFCFC0000000000000000000000000000000000000080000000000000000000000000
000000000000007C0000000001E000000000000000000000000800050000000000000000000000000000000000000000
000000000000000000000000000000000000000000120200FF000000000000000000000000000000B000180000000000
00000000004800004E000000000000000000000000000000000000000000000000000000000000003000190000000000
001000000000000000001C000000000000000000000000000000010000000000000000000000000000000D8100000000
000000000000000000001C00000000000000000000000000740000000000000000000000000800000000000000000000
0000000000080000300000000000000000001000000000001084200803E8020020080002020010840000000000000000
000000000000004000000000000000000000000000000000000000001000000000045540280000000000000B00000000
0000000000000000000000000000000000000000F7FF7000FFFFBFFF010007FFF8000000FFFFFFFF0000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0FFFFFFFFFFFFFFFFFFFFFFF03FFFFFF3F3FFFFFFFFFFFFFAAFF3F3F3FFFFFFF
FFFFFFFFFFDFFFFFEFCFFFDF7FDCFFFF008207FF50D8807080800380FFF300001FFF7FFF000001000000000000000000
3E6FFEEFFBFBBD57FFFF03E1FFFFFFFF0C000200000040000000E00000000000000012100001B050000002920333E005
000003330000F0000000000000003C0F0000000000000600000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000007FF00001000000000000000000000700000
000000000000000010000000000000000000000000000000000000003000000000000000000000000000000000000000
000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000000
80000000000000000000000000080000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF003FFFFF00000000
00000001074000005555500036DB02A5D81000005555500036DB02A5C790000000000000FFFE0000FFFFFFFFFFFFFFFF
FFFC7FFF0000000000000000000000007FFFFFFFFFFFFFFFFFFF00FF7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000
3000000000000000000000000000000000000000000000000000000000010000000000000000000000000000031C0000
0000000000000000F00000000000020000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000F00000000000000007FE53FFFFFFFFC65FFFFFFFFFFFF3FFFFFFFFFFFFFFFFFFF03FFFFFF00000000
A0F8007F5F7FFFFFFFFFFFDBFFFFFFFFFFFFFFFF0003FFFFFFF80000FFFFFFFFFFFFFFFF3FFFFFFFFFFF0000FFFFFFFF
FFFCFFFFFFFFFFFF000000FF1FFF000003FF0000FFFF0000FFF7FF9FFFD70F7FFFFFFFFFFFFFFFFFFFFFFFFF1FFFFFFF
FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFF1CFCFCFC00007F7F00000000000000000000000000000000
FFFFFFBE07FDFFFF00000000000000000000000000000000000000000000000014000000000008000000000000000000
000000000000C00000000000000000000000000000000000000000000000000000000000000000000000180000000000
000000000000000000000000000000000000000000000000000000000000000000000000580000000000000000000000
00000000000000000000000000000000000000000C000000000000000000000000000000010000000000000000000000
000000000000000000000000000000000000000000000000C00000000000001F00000000F80000000000000100000000
FFFFFFFFFFFFFFFFFFDFFFFFFFFFFFFFDFFFFFFFEBFFDE64FFFFFFEFFFFFFFFFDFDFE7BF7BFFFFFFFFFDFC5FFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3FFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCFFFFFFFFFFF00000000FFFF0000FFFFFFFF00003FFF
00000000000000000000000000000000FFFFFFEF0AF7FE96AA96EA845EF7F7960FFFFBFF0FFFFBEE0000000000000000
FFFF07FFFFFF7FFF0000FFFF00001C0000010000000000000000000000000000FFFF00070FFFFFFF000301FF00000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003FF0000
3FFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);

}


static if (size_t.sizeof == 8)
{
//1728 bytes
enum nfcQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(cast(immutable size_t[]) x"
000000000000000000000000000000200000000000000060",
cast(immutable size_t[]) x"
000000000000010000000000000001000000000000001E00",
cast(immutable size_t[]) x"
030202020202010002050202020202040602020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001000000000000000000020000000000050004000300000008000000070006
00000000000A00090000000000000000000B000000000000000C000000000000000F0000000E000D0000000000000000
000000100000000000000000000000000000000000000011000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000014001300120000000000000000000000000000000000000000000000000000
000000000000000000000000000000000017000000160015000000000019001800000000001A00000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000001B00000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000001C00120012000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000010361F8081A9FDF401000000000003F
000000000000008000000000000000000000000000000000000000000038000000000000000000000000000000000000
100000000000000000000000FF000000400000000000000000000000B08000000048000000000000000000004E000000
0000000000000000000000000000000040000000000000000000000030C0000040000000000000000000000000800000
000000000000000000000000004000000000000000000000000000000060000440000000000000000000000000800000
000000000000000000000000800084000000000000000000016802001084200802001084200800020000000000000000
00004000000000000000000000000000000000000000000000000000000000000000000000000000003FFFFE00000000
FFFFFF000000000000000000000000070020000000000000000000000000000000000000000000000000000000000000
00000000000000002AAA00000000000048000000000000002A00C80808080A0000000000000000030000000000000000
0000000000000000000000000000000000000C4000000000000000000000000000000000000000000000000000000000
000006000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000100000000000000000000000000000000000000000000000060000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC657FE53FFFFFFF3FFFFFFFFFFF
FFFFFFFFFFFFFFFF0000000003FFFFFF5F7FFC00A00000000000000000007FDB00000000000000000000000000000000
000000000000000000000000000000000400000000000000000000000000000000000080000000000000000000000000
000000000000000000000000000000004000000000000000000000000080000000000000000000000000000000000000
000000000000000000000000000000002401000000000000000000000000000000000000000000000000000000000000
000080000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000
00000000000000000000001FC0000000F8000000000000000000000000000001000000003FFFFFFF0000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
);
//2048 bytes
enum nfdQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(cast(immutable size_t[]) x"
000000000000000000000000000000200000000000000070",
cast(immutable size_t[]) x"
000000000000010000000000000001400000000000002400",
cast(immutable size_t[]) x"
050403020202010002070202020202060802020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000300020001000000050006000500040009000800070005000C0005000B000A
000500050005000D0005000500050005000E0005000500050010000F0005000500140013001200110005000500050005
000500150005000500050005000500050005000500050016000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050017001700170017
001700170017001700170017001700170017001700170017001700170017001700170017001700170017001700170017
001700170017001700170017001700170017001700170017001800170017001700050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
001A00190017000500050005000500050005000500050005000500050005000500050005000500050005000500050005
001D0005001C001B00050005001F001E0005000500200005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500210005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
000500220017001700050005000500050005000500050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500000000000000000000000000000000
0000000000000000BE7EFFBF3E7EFFBF7EF1FF3FFFFCFFFF7FFFFF3FFFF3F1F80001800300000000FF31FFCFDFFFE000
000FFFC0CFFFFFFF0000000000000000000000000000000000000000000000000000000000000000401000000000001B
0001FC000001D7E00000000000187C00020000000200708B00C00000708B00000000000000000000033FFCFCFCCF0006
00000000000000000000000000000000000000000000000000000000000000000000007C000000000000000000000000
00000000000000000000000000080005001202000000000000000000FF000000000000000000000000000000B0001800
0048000000000000000000004E0000000000000000000000000000000000000000000000000000000000000030001900
00000000001000000000000000001C000000000000000000000000000000010000000000000000000000000000000D81
00000000000000000000000000001C000000000000000000000000007400000000000000000000000168020010842008
020010842008000200000000000000000000004000000000000000000000000000000000000000000000000000000000
2800000000045540000000000000000B00000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0BFFFFFF03FFFFFFFFFFFFFFFFFFFFFF3F3FFFFF3FFFFFFFAAFF3F3F5FDFFFFFFFFFFFFF3FDCFFFFEFCFFFDE
000000000000000300000000000000000000000000000000000000000000000000000C40000000000000000000000000
000040000C000000000000000000E00000000050000012100333E005000002920000F0000000033300003C0F00000000
000006000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000010000000000000000000000036DB02A55555500055555000401000004790000036DB02A5
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000000FFFFFFFFF0000000000000000FFFFFC657FE53FFFFFFF3FFFFFFFFFFFFFFFFFFFFFFFFFFF0000000003FFFFFF
5F7FFC00A00000000000000000007FDB0000000000000000000000000000000000000000000000000000000000000000
000008001400000000000000000000000000C00000000000000000000000000000000000000000000000000000000000
000000000000000000000000000018000000000000000000000000000000000000000000000000000000000000000000
58000000000000000000000000000000000000000000000000000000000000000C000000000000000000000000000000
010000000000000000000000000000000000000000000000000000000000000000000000000000000000001FC0000000
F8000000000000000000000000000001000000003FFFFFFF000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000",
);
//2848 bytes
enum nfkcQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(cast(immutable size_t[]) x"
000000000000000000000000000000200000000000000070",
cast(immutable size_t[]) x"
000000000000010000000000000001400000000000003D00",
cast(immutable size_t[]) x"
040203020202010007060202020202050802020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000300020001000000040006000500040009000800070004000D000C000B000A
00040004000F000E00040004000400040010000400040004001300120011000400170016001500140004000400040018
0004001900040004001D001C001B001A00210020001F001E000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004002300220004000400240004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400260025002100040029002800270021
0004000400040004002A00040004000400040004000400040004000400040004002D0004002C002B00040004002F002E
000400040030000400040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040031000400350034003300320004000400040004000400040004000400040004000400360004000400040004
0004000400040004000400370004000400040039003800040004000400040004003A0004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
0004003B0021002100040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400000000000000000000000000000000
773C8501000000000000000000000000800C00000000000080000000000002010000000000000000000E000000001FF0
0000000000000000000000000000000001FF0000000000000000001F3F000000010361F8081A9FDF441000000000003F
00000000000000B002370000007F00000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000800000000000000000000000000000000001E0000000380000
00000000000000000000000000000000100000000000000000000000FF000000400000000000000000000000B0800000
0048000000000000000000004E0000000000000000000000000000000000000040000000000000000000000030C00000
400000000000000000000000008000000000000000000000000000000040000000000000000000000000000000600004
400000000000000000000000008000000000000000000000000000008000840000080000000000000000000000000000
00080000000000000000000030000000000000000000100003E802001084200802001084200800020000000000000000
00004000000000000000000000000000000000000000000010000000000000000000000000000000003FFFFE00000000
FFFFFF000000000000000000000000070020000000000000000000000000000000000000000000000000000000000000
F7FF700000000000010007FFFFFFBFFFFFFFFFFFF8000000000000000000000000000000000000000000000000000000
000000000C000000000000000000000000000000000000002AAA000000000000E8000000000000006A00E808E808EA03
50D88070008207FFFFF3000080800380000001001FFF7FFF0000000000000000FBFBBD573E6FFEEFFFFFFFFFFFFF03E1
000000000000020000000000000000000001B00000000000000000000000000000000000000000000000000000000000
00000600000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFF00000000
FFFFFFFFFFFFFFFF000007FFFFFFFFFF0000000000001000007000000000000000000000000000000000000010000000
000000000000000030000000000000000000000000000000000000000000000000000000000000000000800000000000
000000000000000000000000000000000000000000000000000000000000000000000000800000000008000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000003FFFFF07400000000000010000000000000000
000000009E0000008000000000000000FFFE000000000000FFFFFFFFFFFFFFFF00000000FFFC7FFF0000000000000000
FFFFFFFF7FFFFFFF7FFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000300000000000000000000000
000000000000000000010000000000000000000000000000031C000000000000000000000000000000000200F0000000
00000000000000000000000000000000FFFFFC657FE53FFFFFFF3FFFFFFFFFFFFFFFFFFFFFFFFFFF0000000003FFFFFF
5F7FFFFFA0F8007FFFFFFFFFFFFFFFDB0003FFFFFFFFFFFFFFFFFFFFFFF800003FFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFCFFFF1FFF0000000000FFFFFF000003FF0000FFD70F7FFFF7FF9FFFFFFFFFFFFFFFFF1FFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF7FFFFFFFFFFFFFFF00007F7F1CFCFCFC00000000000000000000000000000000
07FDFFFFFFFFFFBE00000000000000000000000000000000000000000000000004000000000000000000000000000000
000000800000000000000000000000000000000000000000000000000000000040000000000000000000000000800000
000000000000000000000000000000000000000000000000000000000000000024010000000000000000000000000000
000000000000000000000000000000000000800000000000000000000000000000010000000000000000000000000000
0000000000000000000000000000000000000000000000000000001FC0000000F8000000000000000000000000000001
FFFFFFFFFFFFFFFFFFFFFFFFFFDFFFFFEBFFDE64DFFFFFFFFFFFFFFFFFFFFFEF7BFFFFFFDFDFE7BFFFFFFFFFFFFDFC5F
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3FFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCFFFFFFF00000000000000003FFFFFFFFFFF
000000000000000000000000000000000AF7FE96FFFFFFEF5EF7F796AA96EA840FFFFBEE0FFFFBFF0000000000000000
FFFF7FFFFFFF07FF00001C000000FFFF000000000001000000000000000000000FFFFFFFFFFF000700000000000301FF
0000000000000000000000000000000000000000000000000000000000000000000000000000000003FF000000000000
000000003FFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);
//2944 bytes
enum nfkdQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(cast(immutable size_t[]) x"
000000000000000000000000000000200000000000000078",
cast(immutable size_t[]) x"
000000000000010000000000000001600000000000003E00",
cast(immutable size_t[]) x"
050403020202010008070202020202060902020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000030002000100000007000600050004000A000900080007000E000D000C000B
000700070007000F00070007000700070010000700070007001300120011000700170016001500140007000700070018
0007001900070007001D001C001B001A00210020001F001E000700070007000700070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007
000700070007000700070007000700070007000700070007002300220007000700240007000700070021002100210021
002100210021002100210021002100210021002100210021002100210021002100210021002100210021002100210021
002100210021002100210021002100210021002100210021002500210021002100070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007
0027002600210007002A0029002800210007000700070007002B00070007000700070007000700070007000700070007
002E0007002D002C000700070030002F0007000700310007000700070007000700070007000700070007000700070007
000700070007000700070007000700070007000700320007003600350034003300070007000700070007000700070007
00070007000700370007000700070007000700070007000700070038000700070007003A003900070007000700070007
003B00070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007
000700070007000700070007000700070007003C00210021000700070007000700070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007
00000000000000000000000000000000773C850100000000BE7EFFBF3E7EFFBFFEFDFF3FFFFCFFFFFFFFFF3FFFF3F3F9
0001800300000000FF3FFFCFDFFFFFF0000FFFC0CFFFFFFF000000000000000001FF0000000000000000001F3F000000
0000000000000000441000000000001B0001FC000001D7F002370000007F7C00020000000200708B00C00000708B0000
0000000000000000033FFCFCFCCF00060000000000000000000000000000000000000000000000800000000000000000
0000007C0000000001E00000000000000000000000000000000000000008000500000000000000000000000000000000
00000000000000000000000000000000001202000000000000000000FF000000000000000000000000000000B0001800
0048000000000000000000004E0000000000000000000000000000000000000000000000000000000000000030001900
00000000001000000000000000001C000000000000000000000000000000010000000000000000000000000000000D81
00000000000000000000000000001C000000000000000000000000007400000000080000000000000000000000000000
00080000000000000000000030000000000000000000100003E802001084200802001084200800020000000000000000
00000040000000000000000000000000000000000000000010000000000000002800000000045540000000000000000B
00000000000000000000000000000000F7FF700000000000010007FFFFFFBFFFFFFFFFFFF80000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0FFFFFFF03FFFFFFFFFFFFFFFFFFFFFF3F3FFFFF3FFFFFFFAAFF3F3F
FFDFFFFFFFFFFFFF7FDCFFFFEFCFFFDF50D88070008207FFFFF3000080800380000001001FFF7FFF0000000000000000
FBFBBD573E6FFEEFFFFFFFFFFFFF03E1000040000C000200000000000000E0000001B050000012100333E00500000292
0000F0000000033300003C0F000000000000060000000000000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFF00000000FFFFFFFFFFFFFFFF000007FFFFFFFFFF00000000000010000070000000000000
000000000000000000000000100000000000000000000000300000000000000000000000000000000000000000000000
000000000000000000008000000000000000000000000000000000000000000000000000000000000000000000000000
00000000800000000008000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000003FFFFF
074000000000000136DB02A55555500055555000D8100000C790000036DB02A5FFFE000000000000FFFFFFFFFFFFFFFF
00000000FFFC7FFF0000000000000000FFFFFFFF7FFFFFFF7FFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000
00000000300000000000000000000000000000000000000000010000000000000000000000000000031C000000000000
000000000000000000000200F000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000000FFFFFFFFF0000000000000000FFFFFC657FE53FFFFFFF3FFFFFFFFFFFFFFFFFFFFFFFFFFF0000000003FFFFFF
5F7FFFFFA0F8007FFFFFFFFFFFFFFFDB0003FFFFFFFFFFFFFFFFFFFFFFF800003FFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFCFFFF1FFF0000000000FFFFFF000003FF0000FFD70F7FFFF7FF9FFFFFFFFFFFFFFFFF1FFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF7FFFFFFFFFFFFFFF00007F7F1CFCFCFC00000000000000000000000000000000
07FDFFFFFFFFFFBE00000000000000000000000000000000000000000000000000000800140000000000000000000000
0000C0000000000000000000000000000000000000000000000000000000000000000000000000000000000000001800
000000000000000000000000000000000000000000000000000000000000000058000000000000000000000000000000
000000000000000000000000000000000C00000000000000000000000000000001000000000000000000000000000000
0000000000000000000000000000000000000000000000000000001FC0000000F8000000000000000000000000000001
FFFFFFFFFFFFFFFFFFFFFFFFFFDFFFFFEBFFDE64DFFFFFFFFFFFFFFFFFFFFFEF7BFFFFFFDFDFE7BFFFFFFFFFFFFDFC5F
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3FFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCFFFFFFF00000000000000003FFFFFFFFFFF
000000000000000000000000000000000AF7FE96FFFFFFEF5EF7F796AA96EA840FFFFBEE0FFFFBFF0000000000000000
FFFF7FFFFFFF07FF00001C000000FFFF000000000001000000000000000000000FFFFFFFFFFF000700000000000301FF
0000000000000000000000000000000000000000000000000000000000000000000000000000000003FF000000000000
000000003FFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);

}

