// { dg-do run { target c++11 } }
// { dg-options "-D__STDCPP_WANT_MATH_SPEC_FUNCS__" }
//
// Copyright (C) 2016-2021 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  ellint_3
//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/
#include <limits>
#include <cmath>
#if defined(__TEST_DEBUG)
#  include <iostream>
#  define VERIFY(A) \
  if (!(A)) \
    { \
      std::cout << "line " << __LINE__ \
	<< "  max_abs_frac = " << max_abs_frac \
	<< std::endl; \
    }
#else
#  include <testsuite_hooks.h>
#endif
#include <specfun_testcase.h>

// Test data for k=-0.90000000000000002, nu=0.0000000000000000.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 5.7842011620951154e-16
// mean(f - f_Boost): 5.8286708792820721e-17
// variance(f - f_Boost): 4.1942474344433133e-34
// stddev(f - f_Boost): 2.0479861900030756e-17
const testcase_ellint_3<double>
data001[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17525427376115027, -0.90000000000000002, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35492464591297446, -0.90000000000000002, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.54388221416157123, -0.90000000000000002, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.74797400423532512, -0.90000000000000002, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.97463898451966446, -0.90000000000000002, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.2334463254523438, -0.90000000000000002, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.5355247765594913, -0.90000000000000002, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.8882928567775126, -0.90000000000000002, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.2805491384227703, -0.90000000000000002, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler001 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.10000000000000001.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 4.1500594295134815e-16
// mean(f - f_Boost): 1.0269562977782698e-16
// variance(f - f_Boost): 1.4388836606733082e-32
// stddev(f - f_Boost): 1.1995347684303728e-16
const testcase_ellint_3<double>
data002[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17543204932716244, -0.90000000000000002, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35636022898551184, -0.90000000000000002, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.54880278898382584, -0.90000000000000002, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.75988834774529268, -0.90000000000000002, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.99853303003568117, -0.90000000000000002, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.2759958823999022, -0.90000000000000002, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.6051187364639401, -0.90000000000000002, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.9941406879519472, -0.90000000000000002, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 2.4295011187834881, -0.90000000000000002, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler002 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.20000000000000001.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 5.2711357908578066e-16
// mean(f - f_Boost): 8.0491169285323847e-17
// variance(f - f_Boost): 7.9985534974304465e-34
// stddev(f - f_Boost): 2.8281714052423424e-17
const testcase_ellint_3<double>
data003[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17561047321968409, -0.90000000000000002, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35781659944356109, -0.90000000000000002, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.55388150905215283, -0.90000000000000002, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.77246874123251441, -0.90000000000000002, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 1.0244466254771925, -0.90000000000000002, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.3234824077640801, -0.90000000000000002, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.6849848968804237, -0.90000000000000002, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 2.1185749045502273, -0.90000000000000002, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 2.6076835743348412, -0.90000000000000002, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler003 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.30000000000000004.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 4.9955372494296814e-16
// mean(f - f_Boost): 5.8286708792820721e-17
// variance(f - f_Boost): 4.1942474344433133e-34
// stddev(f - f_Boost): 2.0479861900030756e-17
const testcase_ellint_3<double>
data004[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17578954966746221, -0.90000000000000002, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35929429810867447, -0.90000000000000002, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.55912757154240811, -0.90000000000000002, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.78578314722025389, -0.90000000000000002, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.0526941001131365, -0.90000000000000002, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.3769682234538601, -0.90000000000000002, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.7779437432911238, -0.90000000000000002, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.2676509341813631, -0.90000000000000002, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 2.8256506968858512, -0.90000000000000002, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler004 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.40000000000000002.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 4.7042235432234642e-16
// mean(f - f_Boost): 2.0261570199409106e-16
// variance(f - f_Boost): 5.8024227149195491e-32
// stddev(f - f_Boost): 2.4088218520512364e-16
const testcase_ellint_3<double>
data005[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17596928293938452, -0.90000000000000002, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36079388642472821, -0.90000000000000002, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.56455096667115612, -0.90000000000000002, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.79990996997869435, -0.90000000000000002, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.0836647913872215, -0.90000000000000002, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.4378726836091849, -0.90000000000000002, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.8880446720682853, -0.90000000000000002, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 2.4505848932025227, -0.90000000000000002, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 3.1000689868578615, -0.90000000000000002, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler005 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.50000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 6
// max(|f - f_Boost| / |f_Boost|): 3.8944086593755267e-16
// mean(f - f_Boost): 6.9388939039072284e-17
// variance(f - f_Boost): 1.7333369499485123e-32
// stddev(f - f_Boost): 1.3165625507162629e-16
const testcase_ellint_3<double>
data006[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17614967734498183, -0.90000000000000002, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.36231594750319435, -0.90000000000000002, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.57016256984349567, -0.90000000000000002, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.81494025918293422, -0.90000000000000002, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.1178482279283477, -0.90000000000000002, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.5081455873012106, -0.90000000000000002, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 2.0213599730863998, -0.90000000000000002, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 2.6822467012926827, -0.90000000000000002, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 3.4591069002104677, -0.90000000000000002, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler006 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.60000000000000009.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 4.0602096790645418e-16
// mean(f - f_Boost): 1.0269562977782698e-16
// variance(f - f_Boost): 1.4388836606733082e-32
// stddev(f - f_Boost): 1.1995347684303728e-16
const testcase_ellint_3<double>
data007[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17633073723493825, -0.90000000000000002, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.36386108723492810, -0.90000000000000002, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.57597424744716241, -0.90000000000000002, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.83098051948501150, -0.90000000000000002, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.1558706545698916, -0.90000000000000002, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.5905576379415669, -0.90000000000000002, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 2.1875186010215080, -0.90000000000000002, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.9885767771316849, -0.90000000000000002, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 3.9549939883570224, -0.90000000000000002, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler007 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.70000000000000007.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 5.1938610791060186e-16
// mean(f - f_Boost): 3.0253577421035517e-16
// variance(f - f_Boost): 4.2342877557562532e-32
// stddev(f - f_Boost): 2.0577385051935665e-16
const testcase_ellint_3<double>
data008[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17651246700160939, -0.90000000000000002, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.36542993547358982, -0.90000000000000002, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.58199897877674867, -0.90000000000000002, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.84815633587352857, -0.90000000000000002, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.1985495623872375, -0.90000000000000002, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.6892158134027688, -0.90000000000000002, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 2.4029722191094236, -0.90000000000000002, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 3.4201084941340052, -0.90000000000000002, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 4.6985482312992435, -0.90000000000000002, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler008 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.80000000000000004.
// max(|f - f_Boost|): 2.6645352591003757e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 6.5091520146032660e-16
// mean(f - f_Boost): 2.8310687127941490e-16
// variance(f - f_Boost): 9.8950000698295322e-33
// stddev(f - f_Boost): 9.9473614943006532e-17
const testcase_ellint_3<double>
data009[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17669487107954862, -0.90000000000000002, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36702314729628421, -0.90000000000000002, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.58825099711365492, -0.90000000000000002, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.86661711422209031, -0.90000000000000002, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.2469779109884802, -0.90000000000000002, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.8105469760531578, -0.90000000000000002, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.6989505165893752, -0.90000000000000002, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 4.0935213267757424, -0.90000000000000002, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 5.9820740813645710, -0.90000000000000002, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler009 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.90000000000000002.
// max(|f - f_Boost|): 4.4408920985006262e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 8.2628580104449673e-16
// mean(f - f_Boost): 8.5764728652293339e-16
// variance(f - f_Boost): 8.9671393318321280e-31
// stddev(f - f_Boost): 9.4694980499666013e-16
const testcase_ellint_3<double>
data010[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17687795394604169, -0.90000000000000002, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36864140434751286, -0.90000000000000002, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.59474595366817051, -0.90000000000000002, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.88654237226056665, -0.90000000000000002, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.3026595810616726, -0.90000000000000002, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.9653635459278078, -0.90000000000000002, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 3.1451407527189463, -0.90000000000000002, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 5.3745230680316114, -0.90000000000000002, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 8.9942562031858682, -0.90000000000000002, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler010 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.0000000000000000.
// max(|f - f_Boost|): 1.5543122344752192e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 7.7898565163847540e-16
// mean(f - f_Boost): 2.3869795029440865e-16
// variance(f - f_Boost): 2.1368406725192426e-31
// stddev(f - f_Boost): 4.6225974002926564e-16
const testcase_ellint_3<double>
data011[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17510154241338899, -0.80000000000000004, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35365068839779396, -0.80000000000000004, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.53926804409084550, -0.80000000000000004, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.73587926028070372, -0.80000000000000004, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.94770942970071170, -0.80000000000000004, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.1789022995388236, -0.80000000000000004, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.4323027881876012, -0.80000000000000004, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.7069629739121677, -0.80000000000000004, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.9953027776647294, -0.80000000000000004, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler011 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.10000000000000001.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 8.3898786942190374e-16
// mean(f - f_Boost): 2.3869795029440865e-16
// variance(f - f_Boost): 2.9190059990693968e-31
// stddev(f - f_Boost): 5.4027826155319237e-16
const testcase_ellint_3<double>
data012[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17527903952342144, -0.80000000000000004, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35507705313548549, -0.80000000000000004, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.54411455987643553, -0.80000000000000004, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.74745625666804383, -0.80000000000000004, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.97046953684238557, -0.80000000000000004, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.2183080025184605, -0.80000000000000004, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.4943711151994405, -0.80000000000000004, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.7972401309544201, -0.80000000000000004, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 2.1172616484005085, -0.80000000000000004, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler012 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.20000000000000001.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 7.8513740186068518e-16
// mean(f - f_Boost): 2.8310687127941490e-16
// variance(f - f_Boost): 2.7528339102381189e-31
// stddev(f - f_Boost): 5.2467455724840699e-16
const testcase_ellint_3<double>
data013[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17545718375086419, -0.80000000000000004, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35652404627248163, -0.80000000000000004, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.54911638512920913, -0.80000000000000004, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.75967684282131176, -0.80000000000000004, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.99513526893543769, -0.80000000000000004, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.2622192109995993, -0.80000000000000004, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.5654106676347741, -0.80000000000000004, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.9029531718534984, -0.80000000000000004, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 2.2624789434186798, -0.80000000000000004, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler013 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.30000000000000004.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 7.2825261583337354e-16
// mean(f - f_Boost): 2.6367796834847468e-16
// variance(f - f_Boost): 2.8249350208968825e-31
// stddev(f - f_Boost): 5.3150117788175054e-16
const testcase_ellint_3<double>
data014[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17563597931587369, -0.80000000000000004, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35799220412005128, -0.80000000000000004, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.55428253691111318, -0.80000000000000004, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.77260647376977365, -0.80000000000000004, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.0220015271210958, -0.80000000000000004, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.3115965312302671, -0.80000000000000004, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.6478518468813512, -0.80000000000000004, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.0290458414203481, -0.80000000000000004, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 2.4392042002725693, -0.80000000000000004, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler014 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.40000000000000002.
// max(|f - f_Boost|): 2.2204460492503131e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 8.3462748389836647e-16
// mean(f - f_Boost): 3.3861802251067273e-16
// variance(f - f_Boost): 4.3719465706454422e-31
// stddev(f - f_Boost): 6.6120696991527871e-16
const testcase_ellint_3<double>
data015[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17581543047866136, -0.80000000000000004, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35948208343061633, -0.80000000000000004, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.55962280893702021, -0.80000000000000004, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.78632063889234116, -0.80000000000000004, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.0514333069550323, -0.80000000000000004, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.3677213138838757, -0.80000000000000004, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.7451736773665165, -0.80000000000000004, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 2.1830100424586831, -0.80000000000000004, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.6604037035529724, -0.80000000000000004, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler015 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.50000000000000000.
// max(|f - f_Boost|): 2.6645352591003757e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 9.0388243828581744e-16
// mean(f - f_Boost): 3.8580250105724191e-16
// variance(f - f_Boost): 6.4106456575047741e-31
// stddev(f - f_Boost): 8.0066507713929764e-16
const testcase_ellint_3<double>
data016[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17599554153999472, -0.80000000000000004, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.36099426243351540, -0.80000000000000004, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.56514786174780673, -0.80000000000000004, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.80090697622371010, -0.80000000000000004, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.0838891627679339, -0.80000000000000004, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.4323506654466280, -0.80000000000000004, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.8625761085390575, -0.80000000000000004, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 2.3768757305654766, -0.80000000000000004, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.9478781158239746, -0.80000000000000004, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler016 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.60000000000000009.
// max(|f - f_Boost|): 3.5527136788005009e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 1.0631099169042069e-15
// mean(f - f_Boost): 4.8294701571194306e-16
// variance(f - f_Boost): 1.1633910328160319e-30
// stddev(f - f_Boost): 1.0786060600682865e-15
const testcase_ellint_3<double>
data017[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17617631684170665, -0.80000000000000004, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.36252934193666231, -0.80000000000000004, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.57086932622945163, -0.80000000000000004, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.81646796740150973, -0.80000000000000004, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.1199552158519064, -0.80000000000000004, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.5079766673336394, -0.80000000000000004, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 2.0082747447038165, -0.80000000000000004, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.6315146066775523, -0.80000000000000004, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 3.3418121892288051, -0.80000000000000004, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler017 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.70000000000000007.
// max(|f - f_Boost|): 2.2204460492503131e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 5.6544679145741375e-16
// mean(f - f_Boost): 3.2751579226442120e-16
// variance(f - f_Boost): 4.4236851331020672e-31
// stddev(f - f_Boost): 6.6510789599147505e-16
const testcase_ellint_3<double>
data018[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17635776076721221, -0.80000000000000004, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.36408794649916976, -0.80000000000000004, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.57679992290624138, -0.80000000000000004, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.83312441418142813, -0.80000000000000004, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.1603958891464856, -0.80000000000000004, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.5982855143796213, -0.80000000000000004, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 2.1962484408371821, -0.80000000000000004, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.9873281786111869, -0.80000000000000004, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 3.9268876980046397, -0.80000000000000004, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler018 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.80000000000000004.
// max(|f - f_Boost|): 4.4408920985006262e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 9.0176949165011079e-16
// mean(f - f_Boost): 7.0499162063697436e-16
// variance(f - f_Boost): 1.7230805408026989e-30
// stddev(f - f_Boost): 1.3126616246400665e-15
const testcase_ellint_3<double>
data019[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17653987774203392, -0.80000000000000004, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36567072568046877, -0.80000000000000004, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.58295359996558616, -0.80000000000000004, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.85101998309176108, -0.80000000000000004, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.2062322059736537, -0.80000000000000004, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.7090321420917429, -0.80000000000000004, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.4529058049405066, -0.80000000000000004, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 3.5368893360106948, -0.80000000000000004, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 4.9246422058196062, -0.80000000000000004, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler019 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.90000000000000002.
// max(|f - f_Boost|): 4.4408920985006262e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 7.7782721357365268e-16
// mean(f - f_Boost): 8.9928064994637676e-16
// variance(f - f_Boost): 1.5485199571025344e-30
// stddev(f - f_Boost): 1.2443954183066307e-15
const testcase_ellint_3<double>
data020[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17672267223433513, -0.80000000000000004, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36727835537196063, -0.80000000000000004, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.58934569363716649, -0.80000000000000004, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.87032723471138851, -0.80000000000000004, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.2588676111323349, -0.80000000000000004, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.8498731900660019, -0.80000000000000004, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.8368381299300420, -0.80000000000000004, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 4.5674844191654058, -0.80000000000000004, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 7.2263259298637115, -0.80000000000000004, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler020 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.0000000000000000.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 5.5425633303580569e-16
// mean(f - f_Boost): 7.7715611723760953e-17
// variance(f - f_Boost): 7.4564398834547797e-34
// stddev(f - f_Boost): 2.7306482533374340e-17
const testcase_ellint_3<double>
data021[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17496737466916723, -0.69999999999999996, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35254687535677931, -0.69999999999999996, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.53536740275997130, -0.69999999999999996, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.72603797651684454, -0.69999999999999996, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.92698296348313447, -0.69999999999999996, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.1400447527693316, -0.69999999999999996, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.3657668117194071, -0.69999999999999996, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.6024686895959162, -0.69999999999999996, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.8456939983747234, -0.69999999999999996, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler021 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.10000000000000001.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 5.2736371663370261e-16
// mean(f - f_Boost): 8.8817841970012528e-17
// variance(f - f_Boost): 9.7390235212470591e-34
// stddev(f - f_Boost): 3.1207408609570677e-17
const testcase_ellint_3<double>
data022[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17514462737300920, -0.69999999999999996, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35396527997470451, -0.69999999999999996, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.54015179589433981, -0.69999999999999996, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.73734430854477728, -0.69999999999999996, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.94888950796697047, -0.69999999999999996, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1772807959736322, -0.69999999999999996, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.4231796401075831, -0.69999999999999996, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.6841856799887469, -0.69999999999999996, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.9541347343119562, -0.69999999999999996, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler022 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.20000000000000001.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 4.9907249355047774e-16
// mean(f - f_Boost): 3.3306690738754695e-17
// variance(f - f_Boost): 1.3695501826753678e-34
// stddev(f - f_Boost): 1.1702778228589003e-17
const testcase_ellint_3<double>
data023[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17532252613350796, -0.69999999999999996, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35540417596807522, -0.69999999999999996, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.54508913033361928, -0.69999999999999996, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.74927635777718415, -0.69999999999999996, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.97261706337936338, -0.69999999999999996, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.2187303976209327, -0.69999999999999996, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.4887796709222487, -0.69999999999999996, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.7796581281839212, -0.69999999999999996, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 2.0829290325820202, -0.69999999999999996, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler023 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.30000000000000004.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 4.6912897610535316e-16
// mean(f - f_Boost): 1.6653345369377347e-17
// variance(f - f_Boost): 2.6207864467918357e-32
// stddev(f - f_Boost): 1.6188843216214787e-16
const testcase_ellint_3<double>
data024[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17550107516328570, -0.69999999999999996, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35686409576571959, -0.69999999999999996, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.55018827316513352, -0.69999999999999996, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.76189759494390275, -0.69999999999999996, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.99844623430885615, -0.69999999999999996, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.2652862989039833, -0.69999999999999996, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.5647666808691361, -0.69999999999999996, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.8932499694938163, -0.69999999999999996, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 2.2392290510988535, -0.69999999999999996, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler024 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.40000000000000002.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 6.5578567644745380e-16
// mean(f - f_Boost): 1.4710455076283324e-16
// variance(f - f_Boost): 2.6715739327327140e-33
// stddev(f - f_Boost): 5.1687270509601433e-17
const testcase_ellint_3<double>
data025[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17568027871494424, -0.69999999999999996, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35834559208180261, -0.69999999999999996, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.55545885451190613, -0.69999999999999996, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.77528120402568101, -0.69999999999999996, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.0267241287600319, -0.69999999999999996, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.3181380338980246, -0.69999999999999996, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.6542840785132085, -0.69999999999999996, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 2.0315595131131818, -0.69999999999999996, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.4342502915307875, -0.69999999999999996, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler025 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.50000000000000000.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 6.0416041815443256e-16
// mean(f - f_Boost): 1.9151347174783951e-16
// variance(f - f_Boost): 7.8758646268991113e-33
// stddev(f - f_Boost): 8.8746068233466605e-17
const testcase_ellint_3<double>
data026[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17586014108156545, -0.69999999999999996, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35984923894341653, -0.69999999999999996, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.56091135606739995, -0.69999999999999996, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.78951212635197054, -0.69999999999999996, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.0578865732938729, -0.69999999999999996, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.3789149005151722, -0.69999999999999996, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.7620212286086225, -0.69999999999999996, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 2.2051554347435585, -0.69999999999999996, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.6868019968236991, -0.69999999999999996, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler026 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.60000000000000009.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 3.6515644573247170e-16
// mean(f - f_Boost): 9.9920072216264091e-17
// variance(f - f_Boost): 1.2325951644078310e-33
// stddev(f - f_Boost): 3.5108334685767011e-17
const testcase_ellint_3<double>
data027[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17604066659721918, -0.69999999999999996, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.36137563278353424, -0.69999999999999996, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.56655721272747606, -0.69999999999999996, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.80468966552978305, -0.69999999999999996, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0924902943683852, -0.69999999999999996, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.4499247992499797, -0.69999999999999996, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.8953714382113815, -0.69999999999999996, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.4323229949248670, -0.69999999999999996, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 3.0314573496746742, -0.69999999999999996, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler027 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.70000000000000007.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 4.8475278552871384e-16
// mean(f - f_Boost): 9.9920072216264091e-17
// variance(f - f_Boost): 1.2325951644078310e-33
// stddev(f - f_Boost): 3.5108334685767011e-17
const testcase_ellint_3<double>
data028[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17622185963747933, -0.69999999999999996, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.36292539360435261, -0.69999999999999996, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.57240892970150015, -0.69999999999999996, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.82093084713182629, -0.69999999999999996, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.1312609022179871, -0.69999999999999996, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.5345768067715795, -0.69999999999999996, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 2.0668847445934420, -0.69999999999999996, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.7483444537551240, -0.69999999999999996, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 3.5408408771788560, -0.69999999999999996, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler028 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.80000000000000004.
// max(|f - f_Boost|): 2.2204460492503131e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 6.8664526853112274e-16
// mean(f - f_Boost): 1.6930901125533636e-16
// variance(f - f_Boost): 3.5389557150937801e-33
// stddev(f - f_Boost): 5.9489122661994095e-17
const testcase_ellint_3<double>
data029[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17640372461994805, -0.69999999999999996, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36449916621651091, -0.69999999999999996, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.57848021800372573, -0.69999999999999996, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.83837480968392586, -0.69999999999999996, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.1751669030061143, -0.69999999999999996, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.6381851899173601, -0.69999999999999996, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.3002065924302197, -0.69999999999999996, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 3.2337600665337862, -0.69999999999999996, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 4.4042405729076961, -0.69999999999999996, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler029 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.90000000000000002.
// max(|f - f_Boost|): 3.5527136788005009e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 8.5869439826269878e-16
// mean(f - f_Boost): 6.7723604502134545e-16
// variance(f - f_Boost): 4.8757508225668289e-31
// stddev(f - f_Boost): 6.9826576763914390e-16
const testcase_ellint_3<double>
data030[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17658626600478800, -0.69999999999999996, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36609762156017206, -0.69999999999999996, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.58478615187842409, -0.69999999999999996, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.85718862878291846, -0.69999999999999996, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.2255385617397643, -0.69999999999999996, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.7696521899992939, -0.69999999999999996, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.6476314987883502, -0.69999999999999996, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 4.1373434902898083, -0.69999999999999996, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 6.3796094177887746, -0.69999999999999996, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler030 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.0000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.3664899092028927e-16
// mean(f - f_Boost): 5.2735593669694933e-17
// variance(f - f_Boost): 3.4333862218458872e-34
// stddev(f - f_Boost): 1.8529398861932589e-17
const testcase_ellint_3<double>
data031[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17485154362988359, -0.59999999999999998, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35160509865544320, -0.59999999999999998, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.53210652578446138, -0.59999999999999998, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.71805304664485659, -0.59999999999999998, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.91082759030195981, -0.59999999999999998, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.1112333229323361, -0.59999999999999998, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.3191461190365270, -0.59999999999999998, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.5332022105084779, -0.59999999999999998, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.7507538029157523, -0.59999999999999998, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler031 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.10000000000000001.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.2335247010355137e-16
// mean(f - f_Boost): 8.6042284408449634e-17
// variance(f - f_Boost): 2.2835347143080263e-33
// stddev(f - f_Boost): 4.7786344433405099e-17
const testcase_ellint_3<double>
data032[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17502858548476194, -0.59999999999999998, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35301673150537388, -0.59999999999999998, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53683932476326812, -0.59999999999999998, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.72914228589586771, -0.59999999999999998, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.93208036718354692, -0.59999999999999998, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1468984688863377, -0.59999999999999998, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3733904977062528, -0.59999999999999998, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.6094225663372157, -0.59999999999999998, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.8508766487100685, -0.59999999999999998, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler032 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.20000000000000001.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.0940560416437693e-16
// mean(f - f_Boost): 4.1633363423443370e-17
// variance(f - f_Boost): 8.5834655546147173e-33
// stddev(f - f_Boost): 9.2646994309662939e-17
const testcase_ellint_3<double>
data033[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17520627248155893, -0.59999999999999998, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35444873935437748, -0.59999999999999998, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.54172310557682524, -0.59999999999999998, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.74084300280734672, -0.59999999999999998, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.95509001527006121, -0.59999999999999998, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1865688084431796, -0.59999999999999998, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.4352978868932598, -0.59999999999999998, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.6983400371331816, -0.59999999999999998, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.9695980282802215, -0.59999999999999998, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler033 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.30000000000000004.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.9470074709717020e-16
// mean(f - f_Boost): 7.4940054162198071e-17
// variance(f - f_Boost): 1.6823592487044846e-32
// stddev(f - f_Boost): 1.2970579203352812e-16
const testcase_ellint_3<double>
data034[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17538460882640122, -0.59999999999999998, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35590165133735557, -0.59999999999999998, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.54676661152254535, -0.59999999999999998, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.75321709418305305, -0.59999999999999998, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.98012637808992920, -0.59999999999999998, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.2310891277158875, -0.59999999999999998, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.5069157924585623, -0.59999999999999998, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.8039583598337940, -0.59999999999999998, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 2.1134154405060599, -0.59999999999999998, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler034 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.40000000000000002.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.7909659715991921e-16
// mean(f - f_Boost): -2.7755575615628915e-18
// variance(f - f_Boost): 2.4044165394594425e-32
// stddev(f - f_Boost): 1.5506181152880429e-16
const testcase_ellint_3<double>
data035[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17556359876533037, -0.59999999999999998, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35737601674244679, -0.59999999999999998, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.55197933771320218, -0.59999999999999998, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.76633591620002894, -0.59999999999999998, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.0075231136019616, -0.59999999999999998, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.2815842073813450, -0.59999999999999998, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.5911666941449827, -0.59999999999999998, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 1.9323227566025762, -0.59999999999999998, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.2925036420985130, -0.59999999999999998, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler035 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.50000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.6240126899196213e-16
// mean(f - f_Boost): 9.1593399531575410e-17
// variance(f - f_Boost): 1.0357223256482469e-33
// stddev(f - f_Boost): 3.2182640128619758e-17
const testcase_ellint_3<double>
data036[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17574324658480217, -0.59999999999999998, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35887240603169313, -0.59999999999999998, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.55737161826345261, -0.59999999999999998, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.78028227313077458, -0.59999999999999998, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.0376989776486290, -0.59999999999999998, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.3395933991042925, -0.59999999999999998, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.6924049626591782, -0.59999999999999998, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 2.0931011856518920, -0.59999999999999998, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.5239007084492706, -0.59999999999999998, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler036 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.60000000000000009.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.6651378277398083e-16
// mean(f - f_Boost): 1.1934897514720432e-16
// variance(f - f_Boost): 1.7585404776158019e-33
// stddev(f - f_Boost): 4.1934955319110598e-17
const testcase_ellint_3<double>
data037[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17592355661219386, -0.59999999999999998, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.36039141192661606, -0.59999999999999998, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.56295472636903854, -0.59999999999999998, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.79515295130165986, -0.59999999999999998, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0711886441942242, -0.59999999999999998, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.4072952835139891, -0.59999999999999998, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.8174863977376825, -0.59999999999999998, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.3029921578542232, -0.59999999999999998, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 2.8388723099514972, -0.59999999999999998, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler037 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.70000000000000007.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.2451074234797436e-16
// mean(f - f_Boost): 5.2735593669694933e-17
// variance(f - f_Boost): 3.4333862218458872e-34
// stddev(f - f_Boost): 1.8529398861932589e-17
const testcase_ellint_3<double>
data038[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17610453321631936, -0.59999999999999998, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.36193365056369764, -0.59999999999999998, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.56874098962268527, -0.59999999999999998, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.81106198671477181, -0.59999999999999998, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.1086886419010082, -0.59999999999999998, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.4879048567239257, -0.59999999999999998, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 1.9780310073615923, -0.59999999999999998, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.5941545586772712, -0.59999999999999998, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 3.3029735898397155, -0.59999999999999998, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler038 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.80000000000000004.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 4.3826960061025914e-16
// mean(f - f_Boost): 2.7478019859472625e-16
// variance(f - f_Boost): 4.6451528105588637e-32
// stddev(f - f_Boost): 2.1552616570984749e-16
const testcase_ellint_3<double>
data039[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17628618080795252, -0.59999999999999998, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36349976272521012, -0.59999999999999998, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.57474392342151914, -0.59999999999999998, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.82814493499158159, -0.59999999999999998, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.1511281795998280, -0.59999999999999998, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.5864286332503075, -0.59999999999999998, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.1958944866494527, -0.59999999999999998, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 3.0398358172574604, -0.59999999999999998, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 4.0867036409261832, -0.59999999999999998, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler039 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.90000000000000002.
// max(|f - f_Boost|): 2.2204460492503131e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 5.7440178400898422e-16
// mean(f - f_Boost): 5.0792703376600914e-16
// variance(f - f_Boost): 1.9863137923719990e-31
// stddev(f - f_Boost): 4.4568080420543122e-16
const testcase_ellint_3<double>
data040[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17646850384035848, -0.59999999999999998, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36509041515134105, -0.59999999999999998, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.58097838596260631, -0.59999999999999998, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.84656453396163722, -0.59999999999999998, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.1997828426963724, -0.59999999999999998, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.7112436789225605, -0.59999999999999998, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.5193168553672312, -0.59999999999999998, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 3.8656670488606686, -0.59999999999999998, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 5.8709993116265595, -0.59999999999999998, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler040 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.0000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.4551389361831220e-16
// mean(f - f_Boost): -1.3877787807814457e-17
// variance(f - f_Boost): 2.5893058141206173e-32
// stddev(f - f_Boost): 1.6091320064309879e-16
const testcase_ellint_3<double>
data041[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17475385514035785, -0.50000000000000000, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35081868470101579, -0.50000000000000000, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.52942862705190574, -0.50000000000000000, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.71164727562630326, -0.50000000000000000, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.89824523594227768, -0.50000000000000000, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.0895506700518853, -0.50000000000000000, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.2853005857432933, -0.50000000000000000, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.4845545520549488, -0.50000000000000000, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.6857503548125961, -0.50000000000000000, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler041 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.10000000000000001.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.7416868347177582e-16
// mean(f - f_Boost): 2.7755575615628915e-18
// variance(f - f_Boost): 5.4326441655972001e-32
// stddev(f - f_Boost): 2.3308033305273100e-16
const testcase_ellint_3<double>
data042[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17493071928248824, -0.50000000000000000, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35222467688034798, -0.50000000000000000, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53411928652008112, -0.50000000000000000, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.72256398117177589, -0.50000000000000000, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.91899583232771009, -0.50000000000000000, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1240549163055360, -0.50000000000000000, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3372938086286021, -0.50000000000000000, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.5570024469132429, -0.50000000000000000, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.7803034946545480, -0.50000000000000000, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler042 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.20000000000000001.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.1198767993730867e-16
// mean(f - f_Boost): 2.7755575615628914e-17
// variance(f - f_Boost): 5.0311947683004831e-32
// stddev(f - f_Boost): 2.2430324938128922e-16
const testcase_ellint_3<double>
data043[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17510822779582402, -0.50000000000000000, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35365094725531487, -0.50000000000000000, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53895933237328697, -0.50000000000000000, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.73408090840070794, -0.50000000000000000, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.94145442818535396, -0.50000000000000000, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1624120186296487, -0.50000000000000000, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3965823372867114, -0.50000000000000000, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.6414308440430099, -0.50000000000000000, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.8922947612264018, -0.50000000000000000, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler043 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.30000000000000004.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.3800262770228813e-16
// mean(f - f_Boost): 5.8286708792820721e-17
// variance(f - f_Boost): 8.5027191584278157e-32
// stddev(f - f_Boost): 2.9159422419567599e-16
const testcase_ellint_3<double>
data044[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17528638488102041, -0.50000000000000000, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35509802222332720, -0.50000000000000000, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.54395740731866193, -0.50000000000000000, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.74625871438752667, -0.50000000000000000, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.96588271186092023, -0.50000000000000000, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.2054319584357329, -0.50000000000000000, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.4651077994832871, -0.50000000000000000, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.7416018368052644, -0.50000000000000000, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 2.0277924458111314, -0.50000000000000000, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler044 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.40000000000000002.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.0439932918341581e-16
// mean(f - f_Boost): 3.0531133177191807e-17
// variance(f - f_Boost): 9.0809736800018602e-32
// stddev(f - f_Boost): 3.0134653938616686e-16
const testcase_ellint_3<double>
data045[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17546519477859268, -0.50000000000000000, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35656644822531680, -0.50000000000000000, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.54912289677411319, -0.50000000000000000, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.75916731611690047, -0.50000000000000000, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 0.99260415631328214, -0.50000000000000000, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.2541925856918670, -0.50000000000000000, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.5456393705347609, -0.50000000000000000, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 1.8631904972952076, -0.50000000000000000, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.1962905366178065, -0.50000000000000000, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler045 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.50000000000000000.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.6797816859260978e-16
// mean(f - f_Boost): 9.4368957093138303e-17
// variance(f - f_Boost): 7.7794254682023874e-32
// stddev(f - f_Boost): 2.7891621444803792e-16
const testcase_ellint_3<double>
data046[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17564466176941509, -0.50000000000000000, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35805679276065394, -0.50000000000000000, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.55446601496200032, -0.50000000000000000, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.77288783578259013, -0.50000000000000000, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.0220246013918972, -0.50000000000000000, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.3101681612463965, -0.50000000000000000, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.6422994881851025, -0.50000000000000000, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 2.0152636030998816, -0.50000000000000000, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.4136715042011945, -0.50000000000000000, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler046 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.60000000000000009.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.9178421578645735e-16
// mean(f - f_Boost): 1.3322676295501878e-16
// variance(f - f_Boost): 1.7749370367472766e-31
// stddev(f - f_Boost): 4.2130001622920411e-16
const testcase_ellint_3<double>
data047[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17582479017522740, -0.50000000000000000, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.35956964546660036, -0.50000000000000000, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.55999790372984193, -0.50000000000000000, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.78751507911209895, -0.50000000000000000, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0546620505035220, -0.50000000000000000, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.3754438357425935, -0.50000000000000000, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.7615727400820127, -0.50000000000000000, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.2134638067565242, -0.50000000000000000, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 2.7090491861753558, -0.50000000000000000, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler047 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.70000000000000007.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.0745105182189226e-16
// mean(f - f_Boost): 4.1633363423443370e-17
// variance(f - f_Boost): 1.9996383743576116e-32
// stddev(f - f_Boost): 1.4140857026211713e-16
const testcase_ellint_3<double>
data048[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17600558435914915, -0.50000000000000000, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.36110561926726259, -0.50000000000000000, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.56573074641137111, -0.50000000000000000, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.80316073084237205, -0.50000000000000000, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.0911910688131461, -0.50000000000000000, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.4530946406380640, -0.50000000000000000, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 1.9144386536785372, -0.50000000000000000, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.4878788958234970, -0.50000000000000000, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 3.1433945297859225, -0.50000000000000000, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler048 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.80000000000000004.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.4380477375534667e-16
// mean(f - f_Boost): 2.3037127760972000e-16
// variance(f - f_Boost): 1.4989821857033475e-31
// stddev(f - f_Boost): 3.8716691306248618e-16
const testcase_ellint_3<double>
data049[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17618704872620228, -0.50000000000000000, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36266535159745827, -0.50000000000000000, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.57167789954529158, -0.50000000000000000, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.81995752984315018, -0.50000000000000000, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.1325112162158122, -0.50000000000000000, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.5479055930718042, -0.50000000000000000, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.1215243941010486, -0.50000000000000000, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.9069405767650132, -0.50000000000000000, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 3.8750701888108066, -0.50000000000000000, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler049 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.90000000000000002.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.6192315188521289e-16
// mean(f - f_Boost): 3.5249581031848718e-16
// variance(f - f_Boost): 2.5029385557256515e-31
// stddev(f - f_Boost): 5.0029376927217987e-16
const testcase_ellint_3<double>
data050[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17636918772384180, -0.50000000000000000, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36424950570740700, -0.50000000000000000, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.57785404590231426, -0.50000000000000000, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.83806480521716531, -0.50000000000000000, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.1798568683069752, -0.50000000000000000, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.6678766243739607, -0.50000000000000000, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.4282976450693483, -0.50000000000000000, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 3.6810787666126656, -0.50000000000000000, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 5.5355132096026454, -0.50000000000000000, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler050 = 2.5000000000000020e-13;

// Test data for k=-0.39999999999999991, nu=0.0000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.1423314994346225e-16
// mean(f - f_Boost): 1.9428902930940238e-17
// variance(f - f_Boost): 2.2263750157116445e-32
// stddev(f - f_Boost): 1.4921042241450980e-16
const testcase_ellint_3<double>
data051[10] =
{
  { 0.0000000000000000, -0.39999999999999991, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17467414669441528, -0.39999999999999991, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35018222772483443, -0.39999999999999991, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.52729015917508748, -0.39999999999999991, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.70662374407341244, -0.39999999999999991, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.88859210497602159, -0.39999999999999991, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.0733136290471381, -0.39999999999999991, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.2605612170157066, -0.39999999999999991, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.4497513956433439, -0.39999999999999991, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.6399998658645112, -0.39999999999999991, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler051 = 2.5000000000000020e-13;

// Test data for k=-0.39999999999999991, nu=0.10000000000000001.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.8489340395463703e-16
// mean(f - f_Boost): 6.3837823915946496e-17
// variance(f - f_Boost): 4.4785242050000272e-32
// stddev(f - f_Boost): 2.1162523963365114e-16
const testcase_ellint_3<double>
data052[10] =
{
  { 0.0000000000000000, -0.39999999999999991, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17485086590796767, -0.39999999999999991, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35158366412506992, -0.39999999999999991, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53194731675711726, -0.39999999999999991, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.71740615528010931, -0.39999999999999991, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.90896157773487030, -0.39999999999999991, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1069605483834348, -0.39999999999999991, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3109353428823001, -0.39999999999999991, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.5195460789903448, -0.39999999999999991, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.7306968836847187, -0.39999999999999991, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler052 = 2.5000000000000020e-13;

// Test data for k=-0.39999999999999991, nu=0.20000000000000001.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.0467985583872730e-16
// mean(f - f_Boost): 8.6042284408449634e-17
// variance(f - f_Boost): 1.5826864298542218e-32
// stddev(f - f_Boost): 1.2580486595733180e-16
const testcase_ellint_3<double>
data053[10] =
{
  { 0.0000000000000000, -0.39999999999999991, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17502822886437389, -0.39999999999999991, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35300530062530805, -0.39999999999999991, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53675259548210896, -0.39999999999999991, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.72878006428676934, -0.39999999999999991, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.93100219010583563, -0.39999999999999991, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1443487271187609, -0.39999999999999991, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3683427764108813, -0.39999999999999991, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.6008221459300933, -0.39999999999999991, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.8380358826317627, -0.39999999999999991, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler053 = 2.5000000000000020e-13;

// Test data for k=-0.39999999999999991, nu=0.30000000000000004.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 2.9973414591826100e-16
// mean(f - f_Boost): 8.6042284408449634e-17
// variance(f - f_Boost): 1.5826864298542218e-32
// stddev(f - f_Boost): 1.2580486595733180e-16
const testcase_ellint_3<double>
data054[10] =
{
  { 0.0000000000000000, -0.39999999999999991, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17520623975982899, -0.39999999999999991, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35444766141612105, -0.39999999999999991, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.54171455841536009, -0.39999999999999991, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.74080517001084012, -0.39999999999999991, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.95496950509296563, -0.39999999999999991, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.1862627879844718, -0.39999999999999991, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.4346501803799458, -0.39999999999999991, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.6971744798077697, -0.39999999999999991, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 1.9677924132520139, -0.39999999999999991, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler054 = 2.5000000000000020e-13;

// Test data for k=-0.39999999999999991, nu=0.40000000000000002.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 6.2577246923979600e-16
// mean(f - f_Boost): 1.8596235662471373e-16
// variance(f - f_Boost): 1.6222417021441306e-31
// stddev(f - f_Boost): 4.0277061736727151e-16
const testcase_ellint_3<double>
data055[10] =
{
  { 0.0000000000000000, -0.39999999999999991, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17538490283034375, -0.39999999999999991, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35591129064319948, -0.39999999999999991, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.54684250413264535, -0.39999999999999991, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.75355027742668290, -0.39999999999999991, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 0.98117935026780634, -0.39999999999999991, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.2337464222030734, -0.39999999999999991, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.5125183419289221, -0.39999999999999991, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 1.8140224451130311, -0.39999999999999991, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.1289968719280026, -0.39999999999999991, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler055 = 2.5000000000000020e-13;

// Test data for k=-0.39999999999999991, nu=0.50000000000000000.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.8009196014748294e-16
// mean(f - f_Boost): 1.6375789613221060e-16
// variance(f - f_Boost): 6.4788283329186610e-32
// stddev(f - f_Boost): 2.5453542647181080e-16
const testcase_ellint_3<double>
data056[10] =
{
  { 0.0000000000000000, -0.39999999999999991, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17556422235224273, -0.39999999999999991, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35739675341763921, -0.39999999999999991, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.55214655195037188, -0.39999999999999991, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.76709520942047438, -0.39999999999999991, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.0100278761577499, -0.39999999999999991, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.2882265661384342, -0.39999999999999991, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.6059059780051874, -0.39999999999999991, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.9600182740224081, -0.39999999999999991, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.3367461373176508, -0.39999999999999991, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler056 = 2.5000000000000020e-13;

// Test data for k=-0.39999999999999991, nu=0.60000000000000009.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 2.8411408870840790e-16
// mean(f - f_Boost): 9.7144514654701197e-17
// variance(f - f_Boost): 1.4860570558543486e-32
// stddev(f - f_Boost): 1.2190393988113545e-16
const testcase_ellint_3<double>
data057[10] =
{
  { 0.0000000000000000, -0.39999999999999991, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17574420264267029, -0.39999999999999991, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.35890463689046265, -0.39999999999999991, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.55763773975194486, -0.39999999999999991, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.78153324227761267, -0.39999999999999991, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0420205885765887, -0.39999999999999991, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.3517205230381770, -0.39999999999999991, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.7210360970313896, -0.39999999999999991, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.1500780510169242, -0.39999999999999991, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 2.6186940209850191, -0.39999999999999991, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler057 = 2.5000000000000020e-13;

// Test data for k=-0.39999999999999991, nu=0.70000000000000007.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.1553900340611668e-16
// mean(f - f_Boost): 1.1657341758564144e-16
// variance(f - f_Boost): 1.3242789405258207e-32
// stddev(f - f_Boost): 1.1507731924779187e-16
const testcase_ellint_3<double>
data058[10] =
{
  { 0.0000000000000000, -0.39999999999999991, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17592484806010436, -0.39999999999999991, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.36043555139631439, -0.39999999999999991, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.56332813669944881, -0.39999999999999991, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.79697424562157548, -0.39999999999999991, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.0778155987523672, -0.39999999999999991, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.4272018169896268, -0.39999999999999991, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 1.8684377907453380, -0.39999999999999991, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.4128677409207469, -0.39999999999999991, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 3.0327078743873241, -0.39999999999999991, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler058 = 2.5000000000000020e-13;

// Test data for k=-0.39999999999999991, nu=0.80000000000000004.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.5727642219519274e-16
// mean(f - f_Boost): 2.1926904736346843e-16
// variance(f - f_Boost): 1.5293405480859847e-31
// stddev(f - f_Boost): 3.9106783913868252e-16
const testcase_ellint_3<double>
data059[10] =
{
  { 0.0000000000000000, -0.39999999999999991, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17610616300487833, -0.39999999999999991, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36199013167171978, -0.39999999999999991, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.56923097361842423, -0.39999999999999991, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.81354878456624347, -0.39999999999999991, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.1182902719261825, -0.39999999999999991, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.5192950589409022, -0.39999999999999991, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.0678761710223981, -0.39999999999999991, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.8135222249879783, -0.39999999999999991, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 3.7289548002199902, -0.39999999999999991, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler059 = 2.5000000000000020e-13;

// Test data for k=-0.39999999999999991, nu=0.90000000000000002.
// max(|f - f_Boost|): 2.6645352591003757e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 5.0221626338023938e-16
// mean(f - f_Boost): 4.1910919179599658e-16
// variance(f - f_Boost): 6.2246150910247033e-31
// stddev(f - f_Boost): 7.8896229891070860e-16
const testcase_ellint_3<double>
data060[10] =
{
  { 0.0000000000000000, -0.39999999999999991, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17628815191971123, -0.39999999999999991, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36356903815378772, -0.39999999999999991, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.57536079447000310, -0.39999999999999991, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.83141355850172571, -0.39999999999999991, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.1646481598721361, -0.39999999999999991, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.6357275034001995, -0.39999999999999991, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.3628787566572398, -0.39999999999999991, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 3.5521010369134958, -0.39999999999999991, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 5.3055535102872513, -0.39999999999999991, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler060 = 2.5000000000000020e-13;

// Test data for k=-0.29999999999999993, nu=0.0000000000000000.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.2241249691539529e-16
// mean(f - f_Boost): 4.9960036108132046e-17
// variance(f - f_Boost): 4.6872855002064458e-32
// stddev(f - f_Boost): 2.1650139722889657e-16
const testcase_ellint_3<double>
data061[10] =
{
  { 0.0000000000000000, -0.29999999999999993, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17461228653000099, -0.29999999999999993, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.34969146102798421, -0.29999999999999993, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.52565822873726309, -0.29999999999999993, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.70284226512408543, -0.29999999999999993, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.88144139195111171, -0.29999999999999993, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.0614897067260520, -0.29999999999999993, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.2428416824174220, -0.29999999999999993, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.4251795877015929, -0.29999999999999993, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.6080486199305126, -0.29999999999999993, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler061 = 2.5000000000000020e-13;

// Test data for k=-0.29999999999999993, nu=0.10000000000000001.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.1872304407982844e-16
// mean(f - f_Boost): 9.4368957093138303e-17
// variance(f - f_Boost): 4.0359883022230488e-32
// stddev(f - f_Boost): 2.0089769292411121e-16
const testcase_ellint_3<double>
data062[10] =
{
  { 0.0000000000000000, -0.29999999999999993, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17478889331392972, -0.29999999999999993, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35108939018329183, -0.29999999999999993, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53028990896115835, -0.29999999999999993, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.71352417052371409, -0.29999999999999993, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.90153086032405894, -0.29999999999999993, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.0945187977283313, -0.29999999999999993, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.2920699268385680, -0.29999999999999993, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.4931243665896394, -0.29999999999999993, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.6960848815118226, -0.29999999999999993, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler062 = 2.5000000000000020e-13;

// Test data for k=-0.29999999999999993, nu=0.20000000000000001.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 6.2247497610332889e-16
// mean(f - f_Boost): 1.1102230246251565e-16
// variance(f - f_Boost): 3.8043060629871325e-32
// stddev(f - f_Boost): 1.9504630380981672e-16
const testcase_ellint_3<double>
data063[10] =
{
  { 0.0000000000000000, -0.29999999999999993, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17496614335337535, -0.29999999999999993, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35250745937139372, -0.29999999999999993, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53506875002836884, -0.29999999999999993, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.72479106622248191, -0.29999999999999993, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.92326451535891607, -0.29999999999999993, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1312092060698349, -0.29999999999999993, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3481473154592321, -0.29999999999999993, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.5722049569662748, -0.29999999999999993, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.8002173372290498, -0.29999999999999993, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler063 = 2.5000000000000020e-13;

// Test data for k=-0.29999999999999993, nu=0.30000000000000004.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 6.1678685180047551e-16
// mean(f - f_Boost): 1.0547118733938987e-16
// variance(f - f_Boost): 7.5633408838247182e-32
// stddev(f - f_Boost): 2.7501528837184157e-16
const testcase_ellint_3<double>
data064[10] =
{
  { 0.0000000000000000, -0.29999999999999993, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17514404084107435, -0.29999999999999993, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35394619108645647, -0.29999999999999993, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.54000325463372689, -0.29999999999999993, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.73670193794067651, -0.29999999999999993, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.94689345491722177, -0.29999999999999993, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.1723274608389140, -0.29999999999999993, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.4128880552936287, -0.29999999999999993, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.6659010047449661, -0.29999999999999993, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 1.9260216862473254, -0.29999999999999993, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler064 = 2.5000000000000020e-13;

// Test data for k=-0.29999999999999993, nu=0.40000000000000002.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 6.3983279132797385e-16
// mean(f - f_Boost): 1.1657341758564144e-16
// variance(f - f_Boost): 1.8245832308692586e-31
// stddev(f - f_Boost): 4.2715140534349863e-16
const testcase_ellint_3<double>
data065[10] =
{
  { 0.0000000000000000, -0.29999999999999993, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17532259000954434, -0.29999999999999993, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35540612770983693, -0.29999999999999993, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.54510265552938919, -0.29999999999999993, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.74932476310965057, -0.29999999999999993, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 0.97272793583093109, -0.29999999999999993, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.2188928987074241, -0.29999999999999993, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.4888771674085941, -0.29999999999999993, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 1.7794558498219191, -0.29999999999999993, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.0822121773175528, -0.29999999999999993, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler065 = 2.5000000000000020e-13;

// Test data for k=-0.29999999999999993, nu=0.50000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 6.0516138451673425e-16
// mean(f - f_Boost): 4.7184478546569152e-17
// variance(f - f_Boost): 1.9448563670505968e-32
// stddev(f - f_Boost): 1.3945810722401896e-16
const testcase_ellint_3<double>
data066[10] =
{
  { 0.0000000000000000, -0.29999999999999993, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17550179513158179, -0.29999999999999993, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35688783251681200, -0.29999999999999993, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.55037700010142798, -0.29999999999999993, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.76273839789895992, -0.29999999999999993, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.0011570518830419, -0.29999999999999993, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.2722987414055109, -0.29999999999999993, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.5799590511080066, -0.29999999999999993, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.9212367220124293, -0.29999999999999993, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.2833505881933971, -0.29999999999999993, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler066 = 2.5000000000000020e-13;

// Test data for k=-0.29999999999999993, nu=0.60000000000000009.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 5.2121157428443725e-16
// mean(f - f_Boost): 1.9428902930940239e-16
// variance(f - f_Boost): 1.5987596229703424e-31
// stddev(f - f_Boost): 3.9984492281012430e-16
const testcase_ellint_3<double>
data067[10] =
{
  { 0.0000000000000000, -0.29999999999999993, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17568166052076745, -0.29999999999999993, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.35839189074731181, -0.29999999999999993, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.55583724744367558, -0.29999999999999993, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.77703498090888223, -0.29999999999999993, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0326772113675962, -0.29999999999999993, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.3345139983717369, -0.29999999999999993, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.6921742922838403, -0.29999999999999993, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.1056608968472186, -0.29999999999999993, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 2.5560975528589061, -0.29999999999999993, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler067 = 2.5000000000000020e-13;

// Test data for k=-0.29999999999999993, nu=0.70000000000000007.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 6.0088945789059381e-16
// mean(f - f_Boost): 1.6653345369377348e-16
// variance(f - f_Boost): 3.1994213989721786e-31
// stddev(f - f_Boost): 5.6563428104846852e-16
const testcase_ellint_3<double>
data068[10] =
{
  { 0.0000000000000000, -0.29999999999999993, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17586219053197988, -0.29999999999999993, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.35991891074557669, -0.29999999999999993, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.56149538019961731, -0.29999999999999993, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.79232303189667685, -0.29999999999999993, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.0679345542878826, -0.29999999999999993, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.4084400085913955, -0.29999999999999993, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 1.8357382859296454, -0.29999999999999993, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.3604197996171519, -0.29999999999999993, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 2.9562123549913872, -0.29999999999999993, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler068 = 2.5000000000000020e-13;

// Test data for k=-0.29999999999999993, nu=0.80000000000000004.
// max(|f - f_Boost|): 2.2204460492503131e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 6.1197887707781618e-16
// mean(f - f_Boost): 3.4416913763379854e-16
// variance(f - f_Boost): 4.3461914185990199e-31
// stddev(f - f_Boost): 6.5925650687718054e-16
const testcase_ellint_3<double>
data069[10] =
{
  { 0.0000000000000000, -0.29999999999999993, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17604338956191670, -0.29999999999999993, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36146952517410791, -0.29999999999999993, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.56736453393774644, -0.29999999999999993, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.80873149979001091, -0.29999999999999993, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.1077903069860620, -0.29999999999999993, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.4985874311132998, -0.29999999999999993, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.0298167266724954, -0.29999999999999993, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.7483929054985432, -0.29999999999999993, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 3.6283050484567170, -0.29999999999999993, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler069 = 2.5000000000000020e-13;

// Test data for k=-0.29999999999999993, nu=0.90000000000000002.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 5.1301806687926828e-16
// mean(f - f_Boost): 4.1633363423443370e-16
// variance(f - f_Boost): 2.2835347143080263e-31
// stddev(f - f_Boost): 4.7786344433405093e-16
const testcase_ellint_3<double>
data070[10] =
{
  { 0.0000000000000000, -0.29999999999999993, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17622526204962433, -0.29999999999999993, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36304439230777141, -0.29999999999999993, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.57345914744719195, -0.29999999999999993, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.82641512928845162, -0.29999999999999993, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.1534256210757743, -0.29999999999999993, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.6124900353411677, -0.29999999999999993, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.3165905514845089, -0.29999999999999993, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 3.4625619526539824, -0.29999999999999993, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 5.1479514944016787, -0.29999999999999993, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler070 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.0000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 6
// max(|f - f_Boost| / |f_Boost|): 4.2156475739151676e-16
// mean(f - f_Boost): -5.2735593669694933e-17
// variance(f - f_Boost): 3.0473442641042680e-32
// stddev(f - f_Boost): 1.7456644190978597e-16
const testcase_ellint_3<double>
data071[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17456817290292806, -0.19999999999999996, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.34934315932086796, -0.19999999999999996, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.52450880529443988, -0.19999999999999996, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.70020491009844887, -0.19999999999999996, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.87651006649967977, -0.19999999999999996, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.0534305870298994, -0.19999999999999996, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.2308975521670789, -0.19999999999999996, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.4087733584990738, -0.19999999999999996, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.5868678474541662, -0.19999999999999996, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler071 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.10000000000000001.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 6
// max(|f - f_Boost| / |f_Boost|): 4.0890622182605400e-16
// mean(f - f_Boost): -3.8857805861880476e-17
// variance(f - f_Boost): 2.8794792590749608e-32
// stddev(f - f_Boost): 1.6969028431454054e-16
const testcase_ellint_3<double>
data072[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17474469953608965, -0.19999999999999996, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35073860234984255, -0.19999999999999996, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.52912258712951521, -0.19999999999999996, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.71081701558898069, -0.19999999999999996, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.89640758521169384, -0.19999999999999996, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.0860417038089853, -0.19999999999999996, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.2793599255528623, -0.19999999999999996, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.4754938544089076, -0.19999999999999996, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.6731552050562593, -0.19999999999999996, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler072 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.20000000000000001.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 6
// max(|f - f_Boost| / |f_Boost|): 3.9570963716579749e-16
// mean(f - f_Boost): -5.8286708792820721e-17
// variance(f - f_Boost): 3.1158217732380362e-32
// stddev(f - f_Boost): 1.7651690494788412e-16
const testcase_ellint_3<double>
data073[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17492186907740698, -0.19999999999999996, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35215414286134267, -0.19999999999999996, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53388285615182440, -0.19999999999999996, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.72200960282688265, -0.19999999999999996, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.91793087614428526, -0.19999999999999996, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1222602841587976, -0.19999999999999996, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3345489407496247, -0.19999999999999996, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.5531225705475502, -0.19999999999999996, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.7751816279738935, -0.19999999999999996, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler073 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.30000000000000004.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.6785817924053817e-16
// mean(f - f_Boost): -1.1102230246251566e-17
// variance(f - f_Boost): 9.9840208317034302e-32
// stddev(f - f_Boost): 3.1597501217190311e-16
const testcase_ellint_3<double>
data074[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17509968571715159, -0.19999999999999996, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35359030214835629, -0.19999999999999996, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.53879807274537084, -0.19999999999999996, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.73384116418059731, -0.19999999999999996, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.94132799329524031, -0.19999999999999996, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.1628407021801439, -0.19999999999999996, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.3982440216739438, -0.19999999999999996, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.6450634983653640, -0.19999999999999996, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 1.8983924169967099, -0.19999999999999996, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler074 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.40000000000000002.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.3298410018355870e-16
// mean(f - f_Boost): 1.3877787807814457e-17
// variance(f - f_Boost): 9.4370567274974557e-32
// stddev(f - f_Boost): 3.0719792850046133e-16
const testcase_ellint_3<double>
data075[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17527815368535152, -0.19999999999999996, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35504762134297801, -0.19999999999999996, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.54387742353211344, -0.19999999999999996, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.74637910471804259, -0.19999999999999996, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 0.96690539714174639, -0.19999999999999996, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.2087859420184757, -0.19999999999999996, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.4729799844168852, -0.19999999999999996, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 1.7564445064596661, -0.19999999999999996, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.0512956926676802, -0.19999999999999996, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler075 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.50000000000000000.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.3841806057292116e-16
// mean(f - f_Boost): 8.0491169285323847e-17
// variance(f - f_Boost): 8.0538110429953348e-32
// stddev(f - f_Boost): 2.8379237204328335e-16
const testcase_ellint_3<double>
data076[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17545727725228877, -0.19999999999999996, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35652666242062175, -0.19999999999999996, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.54913090549102406, -0.19999999999999996, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.75970161209211551, -0.19999999999999996, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.99504737401590326, -0.19999999999999996, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.2614666007124373, -0.19999999999999996, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.5625255355205496, -0.19999999999999996, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.8954460255613343, -0.19999999999999996, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.2481046259421302, -0.19999999999999996, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler076 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.60000000000000009.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.5317584994994743e-16
// mean(f - f_Boost): -1.3877787807814457e-17
// variance(f - f_Boost): 1.0045745697575397e-31
// stddev(f - f_Boost): 3.1695024369095219e-16
const testcase_ellint_3<double>
data077[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17563706072900442, -0.19999999999999996, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.35802800926807238, -0.19999999999999996, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.55456942250515051, -0.19999999999999996, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.77390003828438203, -0.19999999999999996, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0262441366366397, -0.19999999999999996, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.3228192988439669, -0.19999999999999996, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.6728005754680795, -0.19999999999999996, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.0761587107468511, -0.19999999999999996, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 2.5148333891629315, -0.19999999999999996, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler077 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.70000000000000007.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.1818454249546518e-16
// mean(f - f_Boost): 3.6082248300317589e-17
// variance(f - f_Boost): 8.9638010532618564e-32
// stddev(f - f_Boost): 2.9939607634806868e-16
const testcase_ellint_3<double>
data078[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17581750846781172, -0.19999999999999996, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.35955226882028513, -0.19999999999999996, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.56020489659466499, -0.19999999999999996, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.78908196988531487, -0.19999999999999996, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.0611336754143517, -0.19999999999999996, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.3956969951058884, -0.19999999999999996, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 1.8138131612209609, -0.19999999999999996, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.3256365528879561, -0.19999999999999996, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 2.9058704854500963, -0.19999999999999996, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler078 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.80000000000000004.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.9866614515542431e-16
// mean(f - f_Boost): 1.8318679906315082e-16
// variance(f - f_Boost): 3.1335688610218711e-31
// stddev(f - f_Boost): 5.5978289193417400e-16
const testcase_ellint_3<double>
data079[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17599862486281712, -0.19999999999999996, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36110007227128776, -0.19999999999999996, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.56605039658567224, -0.19999999999999996, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.80537523874517691, -0.19999999999999996, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.1005662342414086, -0.19999999999999996, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.4845340298105778, -0.19999999999999996, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.0043332244969392, -0.19999999999999996, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.7052856676744761, -0.19999999999999996, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 3.5622166386422629, -0.19999999999999996, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler079 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.90000000000000002.
// max(|f - f_Boost|): 2.6645352591003757e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 5.2817178727913890e-16
// mean(f - f_Boost): 3.4694469519536142e-16
// variance(f - f_Boost): 6.6311432369155086e-31
// stddev(f - f_Boost): 8.1431831840598485e-16
const testcase_ellint_3<double>
data080[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17618041435044951, -0.19999999999999996, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36267207636502929, -0.19999999999999996, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.57212028758237743, -0.19999999999999996, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.82293323876704483, -0.19999999999999996, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.1457077279880385, -0.19999999999999996, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.5967346899325681, -0.19999999999999996, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.2856537353421724, -0.19999999999999996, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 3.4034714304613902, -0.19999999999999996, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 5.0448269356200361, -0.19999999999999996, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler080 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.0000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 3.1735566504509645e-16
// mean(f - f_Boost): -3.6082248300317589e-17
// variance(f - f_Boost): 8.2258607846939269e-33
// stddev(f - f_Boost): 9.0696531271564778e-17
const testcase_ellint_3<double>
data081[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17454173353063662, -0.099999999999999978, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.34913506721468096, -0.099999999999999978, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.52382550016538953, -0.099999999999999978, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.69864700854177020, -0.099999999999999978, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.87361792586964859, -0.099999999999999978, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.0487386319621685, -0.099999999999999978, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.2239913752078759, -0.099999999999999978, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.3993423113684051, -0.099999999999999978, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.5747455615173558, -0.099999999999999978, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler081 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.10000000000000001.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 3.0305747373482148e-16
// mean(f - f_Boost): -3.0531133177191807e-17
// variance(f - f_Boost): 1.1508025840536076e-34
// stddev(f - f_Boost): 1.0727546709539920e-17
const testcase_ellint_3<double>
data082[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17471821213559732, -0.099999999999999978, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35052902610011138, -0.099999999999999978, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.52842865990255727, -0.099999999999999978, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.70921799731166713, -0.099999999999999978, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.89340330535868662, -0.099999999999999978, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.0811075784236857, -0.099999999999999978, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.2720133232666426, -0.099999999999999978, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.4653630031861395, -0.099999999999999978, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.6600374067558428, -0.099999999999999978, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler082 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.20000000000000001.
// max(|f - f_Boost|): 2.2204460492503131e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 1.6736714959992433e-16
// mean(f - f_Boost): 5.5511151231257830e-18
// variance(f - f_Boost): 3.8043060629871325e-36
// stddev(f - f_Boost): 1.9504630380981673e-18
const testcase_ellint_3<double>
data083[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17489533344059083, -0.099999999999999978, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35194305707815038, -0.099999999999999978, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53317790741512527, -0.099999999999999978, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.72036681615081222, -0.099999999999999978, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.91480372268244303, -0.099999999999999978, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1170528708071514, -0.099999999999999978, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3266916802718358, -0.099999999999999978, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.5421622241831547, -0.099999999999999978, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.7608656115083421, -0.099999999999999978, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler083 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.30000000000000004.
// max(|f - f_Boost|): 2.2204460492503131e-16 at index 6
// max(|f - f_Boost| / |f_Boost|): 1.9186071760326645e-16
// mean(f - f_Boost): -1.6653345369377347e-17
// variance(f - f_Boost): 3.4238754566884194e-35
// stddev(f - f_Boost): 5.8513891142945016e-18
const testcase_ellint_3<double>
data084[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17507310163441189, -0.099999999999999978, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35337768072524217, -0.099999999999999978, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.53808167801629170, -0.099999999999999978, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.73215166755955019, -0.099999999999999978, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.93806546000201219, -0.099999999999999978, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.1573218723395986, -0.099999999999999978, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.3897859679542097, -0.099999999999999978, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.6331009404328622, -0.099999999999999978, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 1.8826015946315438, -0.099999999999999978, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler084 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.40000000000000002.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.0338059536914377e-16
// mean(f - f_Boost): 2.7755575615628914e-17
// variance(f - f_Boost): 9.5107651574678308e-35
// stddev(f - f_Boost): 9.7523151904908362e-18
const testcase_ellint_3<double>
data085[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17525152094559704, -0.099999999999999978, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35483343742825979, -0.099999999999999978, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.54314913099505446, -0.099999999999999978, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.74463962034766862, -0.099999999999999978, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 0.96349276837570441, -0.099999999999999978, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.2029081382746343, -0.099999999999999978, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.4638022887050806, -0.099999999999999978, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 1.7432413830105224, -0.099999999999999978, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.0336367403076760, -0.099999999999999978, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler085 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.50000000000000000.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.9864616042835278e-16
// mean(f - f_Boost): 1.0547118733938987e-16
// variance(f - f_Boost): 7.5633408838247182e-32
// stddev(f - f_Boost): 2.7501528837184157e-16
const testcase_ellint_3<double>
data086[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17543059564292182, -0.099999999999999978, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35631088838721664, -0.099999999999999978, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.54839023346436444, -0.099999999999999978, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.75790846946088830, -0.099999999999999978, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.99146713686720678, -0.099999999999999978, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.2551692247937198, -0.099999999999999978, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.5524660788146873, -0.099999999999999978, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.8806578570830670, -0.099999999999999978, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.2279868912966849, -0.099999999999999978, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler086 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.60000000000000009.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.6726146516228014e-16
// mean(f - f_Boost): -3.6082248300317589e-17
// variance(f - f_Boost): 1.6073193116120635e-34
// stddev(f - f_Boost): 1.2678009747638087e-17
const testcase_ellint_3<double>
data087[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17561033003590576, -0.099999999999999978, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.35781061668171932, -0.099999999999999978, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.55381585659629196, -0.099999999999999978, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.77204910484575640, -0.099999999999999978, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0224751740393108, -0.099999999999999978, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.3160230906351114, -0.099999999999999978, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.6616282844233206, -0.099999999999999978, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.0592555664850392, -0.099999999999999978, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 2.4913004919173822, -0.099999999999999978, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler087 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.70000000000000007.
// max(|f - f_Boost|): 2.2204460492503131e-16 at index 5
// max(|f - f_Boost| / |f_Boost|): 2.1004074871280821e-16
// mean(f - f_Boost): 3.3306690738754695e-17
// variance(f - f_Boost): 1.3695501826753678e-34
// stddev(f - f_Boost): 1.1702778228589003e-17
const testcase_ellint_3<double>
data088[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17579072847532518, -0.099999999999999978, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.35933322840606297, -0.099999999999999978, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.55943788649460324, -0.099999999999999978, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.78716856504031707, -0.099999999999999978, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.0571501305617423, -0.099999999999999978, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.3882948301743525, -0.099999999999999978, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 1.8011785680114223, -0.099999999999999978, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.3057268183616464, -0.099999999999999978, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 2.8771910188009739, -0.099999999999999978, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler088 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.80000000000000004.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 3.3133043868392355e-16
// mean(f - f_Boost): 1.8041124150158794e-16
// variance(f - f_Boost): 6.1843750436434569e-32
// stddev(f - f_Boost): 2.4868403735751633e-16
const testcase_ellint_3<double>
data089[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17597179535373417, -0.099999999999999978, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36087935387831499, -0.099999999999999978, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.56526935244526444, -0.099999999999999978, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.80339402590612397, -0.099999999999999978, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.0963358646374459, -0.099999999999999978, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.4763748483246868, -0.099999999999999978, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.9896610222794102, -0.099999999999999978, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.6806423920122024, -0.099999999999999978, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 3.5246199613295612, -0.099999999999999978, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler089 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.90000000000000002.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.5624826890976725e-16
// mean(f - f_Boost): 2.3314683517128288e-16
// variance(f - f_Boost): 2.9401198977189756e-31
// stddev(f - f_Boost): 5.4222872459129045e-16
const testcase_ellint_3<double>
data090[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17615353510599349, -0.099999999999999978, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36244964892922371, -0.099999999999999978, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.57132457590110530, -0.099999999999999978, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.82087808820385000, -0.099999999999999978, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.1411894342144451, -0.099999999999999978, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.5875929286844597, -0.099999999999999978, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.2678622986596659, -0.099999999999999978, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 3.3697528941897903, -0.099999999999999978, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 4.9862890417305499, -0.099999999999999978, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler090 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.0000000000000000.
// max(|f - f_Boost|): 2.2204460492503131e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.1203697876423447e-16
// mean(f - f_Boost): -1.9428902930940238e-17
// variance(f - f_Boost): 4.6602749271592373e-35
// stddev(f - f_Boost): 6.8266206333435850e-18
const testcase_ellint_3<double>
data091[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17453292519943295, 0.0000000000000000, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.34906585039886590, 0.0000000000000000, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.52359877559829882, 0.0000000000000000, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.69813170079773179, 0.0000000000000000, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.87266462599716477, 0.0000000000000000, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.0471975511965976, 0.0000000000000000, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.2217304763960306, 0.0000000000000000, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.3962634015954636, 0.0000000000000000, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.5707963267948966, 0.0000000000000000, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler091 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.10000000000000001.
// max(|f - f_Boost|): 2.2204460492503131e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.1019052604815601e-16
// mean(f - f_Boost): 2.7755575615628915e-18
// variance(f - f_Boost): 9.5107651574678312e-37
// stddev(f - f_Boost): 9.7523151904908366e-19
const testcase_ellint_3<double>
data092[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17470938780535167, 0.0000000000000000, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35045931581655582, 0.0000000000000000, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.52819841383849875, 0.0000000000000000, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.70868910807992958, 0.0000000000000000, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.89241311307249638, 0.0000000000000000, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.0794871444666669, 0.0000000000000000, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.2696086247356864, 0.0000000000000000, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.4620562617494721, 0.0000000000000000, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.6557647109660167, 0.0000000000000000, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler092 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.20000000000000001.
// max(|f - f_Boost|): 2.2204460492503131e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.0831888697465320e-16
// mean(f - f_Boost): -1.9428902930940238e-17
// variance(f - f_Boost): 4.6602749271592373e-35
// stddev(f - f_Boost): 6.8266206333435850e-18
const testcase_ellint_3<double>
data093[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17488649304197776, 0.0000000000000000, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35187284488675424, 0.0000000000000000, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53294400750146131, 0.0000000000000000, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.71982347021822823, 0.0000000000000000, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.91377311030258745, 0.0000000000000000, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1153429007215137, 0.0000000000000000, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3241202847784086, 0.0000000000000000, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.5385854914338242, 0.0000000000000000, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.7562036827601815, 0.0000000000000000, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler093 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.30000000000000004.
// max(|f - f_Boost|): 2.2204460492503131e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.0642101770923591e-16
// mean(f - f_Boost): -1.9428902930940238e-17
// variance(f - f_Boost): 4.6602749271592373e-35
// stddev(f - f_Boost): 6.8266206333435850e-18
const testcase_ellint_3<double>
data094[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17506424509761404, 0.0000000000000000, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35330695794774630, 0.0000000000000000, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.53784398359522367, 0.0000000000000000, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.73159289408687844, 0.0000000000000000, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.93699031797084975, 0.0000000000000000, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.1555098909390267, 0.0000000000000000, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.3870184960144325, 0.0000000000000000, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.6291980835772994, 0.0000000000000000, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 1.8774607092226381, 0.0000000000000000, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler094 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.40000000000000002.
// max(|f - f_Boost|): 2.2204460492503131e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.0449580089795878e-16
// mean(f - f_Boost): -1.9428902930940238e-17
// variance(f - f_Boost): 4.6602749271592373e-35
// stddev(f - f_Boost): 6.8266206333435850e-18
const testcase_ellint_3<double>
data095[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17524264820030025, 0.0000000000000000, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35476219513871499, 0.0000000000000000, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.54290749235440094, 0.0000000000000000, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.74406433757109913, 0.0000000000000000, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 0.96236826162553313, 0.0000000000000000, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.2009785880262487, 0.0000000000000000, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.4608000106167567, 0.0000000000000000, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 1.7389349574753439, 0.0000000000000000, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.0278893379868057, 0.0000000000000000, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler095 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.50000000000000000.
// max(|f - f_Boost|): 2.2204460492503131e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.0254203825026289e-16
// mean(f - f_Boost): -1.9428902930940238e-17
// variance(f - f_Boost): 4.6602749271592373e-35
// stddev(f - f_Boost): 6.8266206333435850e-18
const testcase_ellint_3<double>
data096[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17542170661831016, 0.0000000000000000, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35623911740195419, 0.0000000000000000, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.54814449099863127, 0.0000000000000000, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.75731546607718081, 0.0000000000000000, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.99028751188233310, 0.0000000000000000, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.2531022857760581, 0.0000000000000000, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.5491761777615785, 0.0000000000000000, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.8758359693666533, 0.0000000000000000, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.2214414690791831, 0.0000000000000000, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler096 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.60000000000000009.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 2.1742785192400269e-16
// mean(f - f_Boost): 1.3877787807814457e-17
// variance(f - f_Boost): 2.3776912893669577e-35
// stddev(f - f_Boost): 4.8761575952454181e-18
const testcase_ellint_3<double>
data097[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17560142466065651, 0.0000000000000000, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.35773830754879005, 0.0000000000000000, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.55356583986445973, 0.0000000000000000, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.77143701715151514, 0.0000000000000000, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0212334940541210, 0.0000000000000000, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.3137928444460387, 0.0000000000000000, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.6579755004159076, 0.0000000000000000, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.0537461418295506, 0.0000000000000000, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 2.4836470664490253, 0.0000000000000000, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler097 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.70000000000000007.
// max(|f - f_Boost|): 2.2204460492503131e-16 at index 4
// max(|f - f_Boost| / |f_Boost|): 3.0903019454022601e-16
// mean(f - f_Boost): -6.9388939039072284e-17
// variance(f - f_Boost): 5.9442282234173945e-34
// stddev(f - f_Boost): 2.4380787976227090e-17
const testcase_ellint_3<double>
data098[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17578180667760368, 0.0000000000000000, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.35926037139410999, 0.0000000000000000, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.55918341315855080, 0.0000000000000000, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.78653584856932546, 0.0000000000000000, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.0558379029273324, 0.0000000000000000, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.3858662544850615, 0.0000000000000000, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 1.7970491170359040, 0.0000000000000000, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.2992404490153917, 0.0000000000000000, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 2.8678686047727382, 0.0000000000000000, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler098 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.80000000000000004.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.2373744057922657e-16
// mean(f - f_Boost): 1.0269562977782698e-16
// variance(f - f_Boost): 1.4388836606733082e-32
// stddev(f - f_Boost): 1.1995347684303728e-16
const testcase_ellint_3<double>
data099[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17596285706118869, 0.0000000000000000, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36080593896484231, 0.0000000000000000, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.56501022706967863, 0.0000000000000000, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.80273891984116930, 0.0000000000000000, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.0949425007763358, 0.0000000000000000, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.4736985692253419, 0.0000000000000000, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.9848676587180696, 0.0000000000000000, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.6726187823193546, 0.0000000000000000, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 3.5124073655203634, 0.0000000000000000, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler099 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.90000000000000002.
// max(|f - f_Boost|): 2.2204460492503131e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 6.6108624815885066e-16
// mean(f - f_Boost): 2.1371793224034264e-16
// variance(f - f_Boost): 5.6389326618626776e-33
// stddev(f - f_Boost): 7.5092826966779442e-17
const testcase_ellint_3<double>
data100[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17614458024574997, 0.0000000000000000, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36237566578821978, 0.0000000000000000, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.57106058859196640, 0.0000000000000000, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.82019857015755915, 0.0000000000000000, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.1397014388908147, 0.0000000000000000, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.5845952415154960, 0.0000000000000000, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.2620531413370775, 0.0000000000000000, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 3.3587842061975066, 0.0000000000000000, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 4.9672941328980507, 0.0000000000000000, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler100 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.0000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 3.1735566504509645e-16
// mean(f - f_Boost): -5.8286708792820721e-17
// variance(f - f_Boost): 4.1942474344433133e-34
// stddev(f - f_Boost): 2.0479861900030756e-17
const testcase_ellint_3<double>
data101[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17454173353063662, 0.10000000000000009, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.34913506721468096, 0.10000000000000009, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.52382550016538953, 0.10000000000000009, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.69864700854177020, 0.10000000000000009, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.87361792586964859, 0.10000000000000009, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.0487386319621685, 0.10000000000000009, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.2239913752078759, 0.10000000000000009, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.3993423113684051, 0.10000000000000009, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.5747455615173560, 0.10000000000000009, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler101 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.10000000000000001.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 3.0305747373482148e-16
// mean(f - f_Boost): -3.0531133177191807e-17
// variance(f - f_Boost): 1.1508025840536076e-34
// stddev(f - f_Boost): 1.0727546709539920e-17
const testcase_ellint_3<double>
data102[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17471821213559732, 0.10000000000000009, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35052902610011138, 0.10000000000000009, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.52842865990255727, 0.10000000000000009, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.70921799731166713, 0.10000000000000009, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.89340330535868662, 0.10000000000000009, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.0811075784236857, 0.10000000000000009, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.2720133232666426, 0.10000000000000009, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.4653630031861395, 0.10000000000000009, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.6600374067558428, 0.10000000000000009, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler102 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.20000000000000001.
// max(|f - f_Boost|): 2.2204460492503131e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 1.6736714959992433e-16
// mean(f - f_Boost): 5.5511151231257830e-18
// variance(f - f_Boost): 3.8043060629871325e-36
// stddev(f - f_Boost): 1.9504630380981673e-18
const testcase_ellint_3<double>
data103[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17489533344059083, 0.10000000000000009, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35194305707815038, 0.10000000000000009, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53317790741512527, 0.10000000000000009, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.72036681615081222, 0.10000000000000009, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.91480372268244303, 0.10000000000000009, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1170528708071514, 0.10000000000000009, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3266916802718358, 0.10000000000000009, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.5421622241831547, 0.10000000000000009, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.7608656115083421, 0.10000000000000009, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler103 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.30000000000000004.
// max(|f - f_Boost|): 2.2204460492503131e-16 at index 6
// max(|f - f_Boost| / |f_Boost|): 1.9186071760326645e-16
// mean(f - f_Boost): -1.6653345369377347e-17
// variance(f - f_Boost): 3.4238754566884194e-35
// stddev(f - f_Boost): 5.8513891142945016e-18
const testcase_ellint_3<double>
data104[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17507310163441189, 0.10000000000000009, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35337768072524217, 0.10000000000000009, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.53808167801629170, 0.10000000000000009, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.73215166755955019, 0.10000000000000009, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.93806546000201219, 0.10000000000000009, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.1573218723395986, 0.10000000000000009, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.3897859679542097, 0.10000000000000009, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.6331009404328622, 0.10000000000000009, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 1.8826015946315438, 0.10000000000000009, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler104 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.40000000000000002.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.0338059536914377e-16
// mean(f - f_Boost): 2.7755575615628914e-17
// variance(f - f_Boost): 9.5107651574678308e-35
// stddev(f - f_Boost): 9.7523151904908362e-18
const testcase_ellint_3<double>
data105[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17525152094559704, 0.10000000000000009, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35483343742825979, 0.10000000000000009, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.54314913099505446, 0.10000000000000009, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.74463962034766862, 0.10000000000000009, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 0.96349276837570441, 0.10000000000000009, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.2029081382746343, 0.10000000000000009, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.4638022887050806, 0.10000000000000009, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 1.7432413830105224, 0.10000000000000009, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.0336367403076760, 0.10000000000000009, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler105 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.50000000000000000.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.9864616042835278e-16
// mean(f - f_Boost): 9.4368957093138303e-17
// variance(f - f_Boost): 7.7794254682023874e-32
// stddev(f - f_Boost): 2.7891621444803792e-16
const testcase_ellint_3<double>
data106[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17543059564292182, 0.10000000000000009, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35631088838721664, 0.10000000000000009, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.54839023346436455, 0.10000000000000009, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.75790846946088830, 0.10000000000000009, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.99146713686720678, 0.10000000000000009, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.2551692247937198, 0.10000000000000009, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.5524660788146873, 0.10000000000000009, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.8806578570830670, 0.10000000000000009, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.2279868912966849, 0.10000000000000009, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler106 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.60000000000000009.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.6726146516228014e-16
// mean(f - f_Boost): -3.6082248300317589e-17
// variance(f - f_Boost): 1.6073193116120635e-34
// stddev(f - f_Boost): 1.2678009747638087e-17
const testcase_ellint_3<double>
data107[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17561033003590576, 0.10000000000000009, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.35781061668171932, 0.10000000000000009, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.55381585659629196, 0.10000000000000009, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.77204910484575640, 0.10000000000000009, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0224751740393108, 0.10000000000000009, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.3160230906351114, 0.10000000000000009, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.6616282844233206, 0.10000000000000009, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.0592555664850392, 0.10000000000000009, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 2.4913004919173822, 0.10000000000000009, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler107 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.70000000000000007.
// max(|f - f_Boost|): 2.2204460492503131e-16 at index 5
// max(|f - f_Boost| / |f_Boost|): 2.1004074871280821e-16
// mean(f - f_Boost): 3.3306690738754695e-17
// variance(f - f_Boost): 1.3695501826753678e-34
// stddev(f - f_Boost): 1.1702778228589003e-17
const testcase_ellint_3<double>
data108[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17579072847532518, 0.10000000000000009, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.35933322840606297, 0.10000000000000009, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.55943788649460324, 0.10000000000000009, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.78716856504031707, 0.10000000000000009, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.0571501305617423, 0.10000000000000009, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.3882948301743525, 0.10000000000000009, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 1.8011785680114223, 0.10000000000000009, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.3057268183616464, 0.10000000000000009, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 2.8771910188009739, 0.10000000000000009, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler108 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.80000000000000004.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 3.3133043868392355e-16
// mean(f - f_Boost): 1.8041124150158794e-16
// variance(f - f_Boost): 6.1843750436434569e-32
// stddev(f - f_Boost): 2.4868403735751633e-16
const testcase_ellint_3<double>
data109[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17597179535373417, 0.10000000000000009, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36087935387831499, 0.10000000000000009, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.56526935244526444, 0.10000000000000009, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.80339402590612397, 0.10000000000000009, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.0963358646374459, 0.10000000000000009, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.4763748483246868, 0.10000000000000009, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.9896610222794102, 0.10000000000000009, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.6806423920122024, 0.10000000000000009, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 3.5246199613295612, 0.10000000000000009, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler109 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.90000000000000002.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.5624826890976725e-16
// mean(f - f_Boost): 2.3314683517128288e-16
// variance(f - f_Boost): 2.9401198977189756e-31
// stddev(f - f_Boost): 5.4222872459129045e-16
const testcase_ellint_3<double>
data110[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17615353510599349, 0.10000000000000009, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36244964892922371, 0.10000000000000009, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.57132457590110530, 0.10000000000000009, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.82087808820385000, 0.10000000000000009, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.1411894342144451, 0.10000000000000009, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.5875929286844597, 0.10000000000000009, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.2678622986596659, 0.10000000000000009, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 3.3697528941897903, 0.10000000000000009, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 4.9862890417305499, 0.10000000000000009, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler110 = 2.5000000000000020e-13;

// Test data for k=0.20000000000000018, nu=0.0000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 6
// max(|f - f_Boost| / |f_Boost|): 4.2156475739151676e-16
// mean(f - f_Boost): -5.2735593669694933e-17
// variance(f - f_Boost): 3.0473442641042680e-32
// stddev(f - f_Boost): 1.7456644190978597e-16
const testcase_ellint_3<double>
data111[10] =
{
  { 0.0000000000000000, 0.20000000000000018, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17456817290292806, 0.20000000000000018, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.34934315932086796, 0.20000000000000018, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.52450880529443988, 0.20000000000000018, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.70020491009844887, 0.20000000000000018, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.87651006649967977, 0.20000000000000018, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.0534305870298994, 0.20000000000000018, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.2308975521670789, 0.20000000000000018, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.4087733584990738, 0.20000000000000018, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.5868678474541662, 0.20000000000000018, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler111 = 2.5000000000000020e-13;

// Test data for k=0.20000000000000018, nu=0.10000000000000001.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 6
// max(|f - f_Boost| / |f_Boost|): 4.0890622182605400e-16
// mean(f - f_Boost): -3.8857805861880476e-17
// variance(f - f_Boost): 2.8794792590749608e-32
// stddev(f - f_Boost): 1.6969028431454054e-16
const testcase_ellint_3<double>
data112[10] =
{
  { 0.0000000000000000, 0.20000000000000018, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17474469953608965, 0.20000000000000018, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35073860234984255, 0.20000000000000018, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.52912258712951521, 0.20000000000000018, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.71081701558898069, 0.20000000000000018, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.89640758521169384, 0.20000000000000018, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.0860417038089853, 0.20000000000000018, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.2793599255528623, 0.20000000000000018, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.4754938544089076, 0.20000000000000018, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.6731552050562593, 0.20000000000000018, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler112 = 2.5000000000000020e-13;

// Test data for k=0.20000000000000018, nu=0.20000000000000001.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 6
// max(|f - f_Boost| / |f_Boost|): 3.9570963716579749e-16
// mean(f - f_Boost): -5.8286708792820721e-17
// variance(f - f_Boost): 3.1158217732380362e-32
// stddev(f - f_Boost): 1.7651690494788412e-16
const testcase_ellint_3<double>
data113[10] =
{
  { 0.0000000000000000, 0.20000000000000018, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17492186907740698, 0.20000000000000018, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35215414286134267, 0.20000000000000018, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53388285615182440, 0.20000000000000018, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.72200960282688265, 0.20000000000000018, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.91793087614428526, 0.20000000000000018, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1222602841587976, 0.20000000000000018, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3345489407496247, 0.20000000000000018, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.5531225705475502, 0.20000000000000018, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.7751816279738935, 0.20000000000000018, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler113 = 2.5000000000000020e-13;

// Test data for k=0.20000000000000018, nu=0.30000000000000004.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.6785817924053817e-16
// mean(f - f_Boost): -1.1102230246251566e-17
// variance(f - f_Boost): 9.9840208317034302e-32
// stddev(f - f_Boost): 3.1597501217190311e-16
const testcase_ellint_3<double>
data114[10] =
{
  { 0.0000000000000000, 0.20000000000000018, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17509968571715159, 0.20000000000000018, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35359030214835629, 0.20000000000000018, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.53879807274537084, 0.20000000000000018, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.73384116418059731, 0.20000000000000018, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.94132799329524031, 0.20000000000000018, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.1628407021801439, 0.20000000000000018, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.3982440216739438, 0.20000000000000018, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.6450634983653640, 0.20000000000000018, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 1.8983924169967099, 0.20000000000000018, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler114 = 2.5000000000000020e-13;

// Test data for k=0.20000000000000018, nu=0.40000000000000002.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 6
// max(|f - f_Boost| / |f_Boost|): 3.6738449250038925e-16
// mean(f - f_Boost): -3.0531133177191807e-17
// variance(f - f_Boost): 2.7810428396951687e-32
// stddev(f - f_Boost): 1.6676458975739331e-16
const testcase_ellint_3<double>
data115[10] =
{
  { 0.0000000000000000, 0.20000000000000018, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17527815368535152, 0.20000000000000018, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35504762134297801, 0.20000000000000018, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.54387742353211344, 0.20000000000000018, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.74637910471804259, 0.20000000000000018, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 0.96690539714174639, 0.20000000000000018, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.2087859420184757, 0.20000000000000018, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.4729799844168852, 0.20000000000000018, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 1.7564445064596661, 0.20000000000000018, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.0512956926676806, 0.20000000000000018, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler115 = 2.5000000000000020e-13;

// Test data for k=0.20000000000000018, nu=0.50000000000000000.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.3841806057292116e-16
// mean(f - f_Boost): 3.6082248300317589e-17
// variance(f - f_Boost): 8.9638010532618564e-32
// stddev(f - f_Boost): 2.9939607634806868e-16
const testcase_ellint_3<double>
data116[10] =
{
  { 0.0000000000000000, 0.20000000000000018, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17545727725228877, 0.20000000000000018, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35652666242062175, 0.20000000000000018, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.54913090549102406, 0.20000000000000018, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.75970161209211551, 0.20000000000000018, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.99504737401590326, 0.20000000000000018, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.2614666007124373, 0.20000000000000018, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.5625255355205498, 0.20000000000000018, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.8954460255613346, 0.20000000000000018, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.2481046259421302, 0.20000000000000018, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler116 = 2.5000000000000020e-13;

// Test data for k=0.20000000000000018, nu=0.60000000000000009.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.5317584994994743e-16
// mean(f - f_Boost): -1.3877787807814457e-17
// variance(f - f_Boost): 1.0045745697575397e-31
// stddev(f - f_Boost): 3.1695024369095219e-16
const testcase_ellint_3<double>
data117[10] =
{
  { 0.0000000000000000, 0.20000000000000018, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17563706072900442, 0.20000000000000018, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.35802800926807238, 0.20000000000000018, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.55456942250515051, 0.20000000000000018, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.77390003828438203, 0.20000000000000018, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0262441366366397, 0.20000000000000018, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.3228192988439669, 0.20000000000000018, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.6728005754680795, 0.20000000000000018, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.0761587107468511, 0.20000000000000018, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 2.5148333891629315, 0.20000000000000018, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler117 = 2.5000000000000020e-13;

// Test data for k=0.20000000000000018, nu=0.70000000000000007.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.2209418045118284e-16
// mean(f - f_Boost): 2.4980018054066023e-17
// variance(f - f_Boost): 9.1989071679544611e-32
// stddev(f - f_Boost): 3.0329700242426498e-16
const testcase_ellint_3<double>
data118[10] =
{
  { 0.0000000000000000, 0.20000000000000018, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17581750846781172, 0.20000000000000018, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.35955226882028513, 0.20000000000000018, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.56020489659466499, 0.20000000000000018, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.78908196988531498, 0.20000000000000018, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.0611336754143517, 0.20000000000000018, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.3956969951058884, 0.20000000000000018, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 1.8138131612209609, 0.20000000000000018, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.3256365528879561, 0.20000000000000018, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 2.9058704854500963, 0.20000000000000018, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler118 = 2.5000000000000020e-13;

// Test data for k=0.20000000000000018, nu=0.80000000000000004.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.7399960886656824e-16
// mean(f - f_Boost): 1.3877787807814457e-16
// variance(f - f_Boost): 1.7585404776158019e-31
// stddev(f - f_Boost): 4.1934955319110593e-16
const testcase_ellint_3<double>
data119[10] =
{
  { 0.0000000000000000, 0.20000000000000018, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17599862486281712, 0.20000000000000018, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36110007227128776, 0.20000000000000018, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.56605039658567224, 0.20000000000000018, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.80537523874517691, 0.20000000000000018, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.1005662342414086, 0.20000000000000018, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.4845340298105778, 0.20000000000000018, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.0043332244969392, 0.20000000000000018, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.7052856676744761, 0.20000000000000018, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 3.5622166386422633, 0.20000000000000018, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler119 = 2.5000000000000020e-13;

// Test data for k=0.20000000000000018, nu=0.90000000000000002.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.1718503329017390e-16
// mean(f - f_Boost): 2.3592239273284576e-16
// variance(f - f_Boost): 2.9295534376290287e-31
// stddev(f - f_Boost): 5.4125349307224141e-16
const testcase_ellint_3<double>
data120[10] =
{
  { 0.0000000000000000, 0.20000000000000018, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17618041435044951, 0.20000000000000018, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36267207636502929, 0.20000000000000018, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.57212028758237743, 0.20000000000000018, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.82293323876704483, 0.20000000000000018, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.1457077279880388, 0.20000000000000018, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.5967346899325681, 0.20000000000000018, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.2856537353421724, 0.20000000000000018, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 3.4034714304613902, 0.20000000000000018, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 5.0448269356200370, 0.20000000000000018, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler120 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.0000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.2241249691539529e-16
// mean(f - f_Boost): 2.7755575615628914e-17
// variance(f - f_Boost): 2.1399221604302621e-32
// stddev(f - f_Boost): 1.4628472785736254e-16
const testcase_ellint_3<double>
data121[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17461228653000099, 0.30000000000000004, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.34969146102798421, 0.30000000000000004, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.52565822873726309, 0.30000000000000004, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.70284226512408543, 0.30000000000000004, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.88144139195111171, 0.30000000000000004, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.0614897067260520, 0.30000000000000004, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.2428416824174220, 0.30000000000000004, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.4251795877015929, 0.30000000000000004, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.6080486199305128, 0.30000000000000004, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler121 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.10000000000000001.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.1872304407982844e-16
// mean(f - f_Boost): 7.2164496600635178e-17
// variance(f - f_Boost): 4.3555500115139682e-32
// stddev(f - f_Boost): 2.0869954507650391e-16
const testcase_ellint_3<double>
data122[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17478889331392972, 0.30000000000000004, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35108939018329183, 0.30000000000000004, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53028990896115835, 0.30000000000000004, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.71352417052371409, 0.30000000000000004, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.90153086032405894, 0.30000000000000004, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.0945187977283313, 0.30000000000000004, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.2920699268385683, 0.30000000000000004, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.4931243665896394, 0.30000000000000004, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.6960848815118226, 0.30000000000000004, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler122 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.20000000000000001.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 6.2247497610332889e-16
// mean(f - f_Boost): 6.6613381477509390e-17
// variance(f - f_Boost): 1.7591111235252501e-32
// stddev(f - f_Boost): 1.3263148659067538e-16
const testcase_ellint_3<double>
data123[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17496614335337535, 0.30000000000000004, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35250745937139372, 0.30000000000000004, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53506875002836884, 0.30000000000000004, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.72479106622248191, 0.30000000000000004, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.92326451535891607, 0.30000000000000004, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1312092060698349, 0.30000000000000004, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3481473154592321, 0.30000000000000004, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.5722049569662750, 0.30000000000000004, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.8002173372290500, 0.30000000000000004, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler123 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.30000000000000004.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 6.1678685180047551e-16
// mean(f - f_Boost): 1.0547118733938987e-16
// variance(f - f_Boost): 7.5633408838247182e-32
// stddev(f - f_Boost): 2.7501528837184157e-16
const testcase_ellint_3<double>
data124[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17514404084107435, 0.30000000000000004, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35394619108645647, 0.30000000000000004, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.54000325463372689, 0.30000000000000004, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.73670193794067651, 0.30000000000000004, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.94689345491722177, 0.30000000000000004, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.1723274608389140, 0.30000000000000004, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.4128880552936287, 0.30000000000000004, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.6659010047449661, 0.30000000000000004, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 1.9260216862473254, 0.30000000000000004, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler124 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.40000000000000002.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 6.3983279132797385e-16
// mean(f - f_Boost): 1.1657341758564144e-16
// variance(f - f_Boost): 1.8245832308692586e-31
// stddev(f - f_Boost): 4.2715140534349863e-16
const testcase_ellint_3<double>
data125[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17532259000954434, 0.30000000000000004, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35540612770983693, 0.30000000000000004, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.54510265552938919, 0.30000000000000004, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.74932476310965057, 0.30000000000000004, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 0.97272793583093109, 0.30000000000000004, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.2188928987074241, 0.30000000000000004, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.4888771674085941, 0.30000000000000004, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 1.7794558498219191, 0.30000000000000004, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.0822121773175528, 0.30000000000000004, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler125 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.50000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 6.0516138451673425e-16
// mean(f - f_Boost): 4.7184478546569152e-17
// variance(f - f_Boost): 1.9448563670505968e-32
// stddev(f - f_Boost): 1.3945810722401896e-16
const testcase_ellint_3<double>
data126[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17550179513158179, 0.30000000000000004, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35688783251681200, 0.30000000000000004, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.55037700010142798, 0.30000000000000004, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.76273839789895992, 0.30000000000000004, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.0011570518830419, 0.30000000000000004, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.2722987414055109, 0.30000000000000004, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.5799590511080066, 0.30000000000000004, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.9212367220124293, 0.30000000000000004, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.2833505881933971, 0.30000000000000004, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler126 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.60000000000000009.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 5.2121157428443725e-16
// mean(f - f_Boost): 1.9428902930940239e-16
// variance(f - f_Boost): 1.5987596229703424e-31
// stddev(f - f_Boost): 3.9984492281012430e-16
const testcase_ellint_3<double>
data127[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17568166052076745, 0.30000000000000004, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.35839189074731181, 0.30000000000000004, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.55583724744367558, 0.30000000000000004, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.77703498090888223, 0.30000000000000004, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0326772113675962, 0.30000000000000004, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.3345139983717369, 0.30000000000000004, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.6921742922838403, 0.30000000000000004, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.1056608968472186, 0.30000000000000004, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 2.5560975528589061, 0.30000000000000004, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler127 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.70000000000000007.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 6.0088945789059381e-16
// mean(f - f_Boost): 2.1094237467877973e-16
// variance(f - f_Boost): 3.0253363535298873e-31
// stddev(f - f_Boost): 5.5003057674368314e-16
const testcase_ellint_3<double>
data128[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17586219053197988, 0.30000000000000004, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.35991891074557669, 0.30000000000000004, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.56149538019961731, 0.30000000000000004, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.79232303189667685, 0.30000000000000004, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.0679345542878826, 0.30000000000000004, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.4084400085913955, 0.30000000000000004, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 1.8357382859296454, 0.30000000000000004, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.3604197996171519, 0.30000000000000004, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 2.9562123549913872, 0.30000000000000004, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler128 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.80000000000000004.
// max(|f - f_Boost|): 2.2204460492503131e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 6.1197887707781618e-16
// mean(f - f_Boost): 3.4416913763379854e-16
// variance(f - f_Boost): 4.3461914185990199e-31
// stddev(f - f_Boost): 6.5925650687718054e-16
const testcase_ellint_3<double>
data129[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17604338956191670, 0.30000000000000004, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36146952517410791, 0.30000000000000004, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.56736453393774644, 0.30000000000000004, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.80873149979001091, 0.30000000000000004, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.1077903069860620, 0.30000000000000004, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.4985874311132998, 0.30000000000000004, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.0298167266724954, 0.30000000000000004, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.7483929054985432, 0.30000000000000004, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 3.6283050484567170, 0.30000000000000004, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler129 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.90000000000000002.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 5.1301806687926828e-16
// mean(f - f_Boost): 4.1633363423443370e-16
// variance(f - f_Boost): 2.2835347143080263e-31
// stddev(f - f_Boost): 4.7786344433405093e-16
const testcase_ellint_3<double>
data130[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17622526204962433, 0.30000000000000004, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36304439230777141, 0.30000000000000004, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.57345914744719195, 0.30000000000000004, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.82641512928845162, 0.30000000000000004, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.1534256210757743, 0.30000000000000004, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.6124900353411677, 0.30000000000000004, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.3165905514845089, 0.30000000000000004, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 3.4625619526539824, 0.30000000000000004, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 5.1479514944016787, 0.30000000000000004, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler130 = 2.5000000000000020e-13;

// Test data for k=0.40000000000000013, nu=0.0000000000000000.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 1.0831445028587608e-15
// mean(f - f_Boost): 1.7486012637846215e-16
// variance(f - f_Boost): 3.1664095331106078e-31
// stddev(f - f_Boost): 5.6270858649132121e-16
const testcase_ellint_3<double>
data131[10] =
{
  { 0.0000000000000000, 0.40000000000000013, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17467414669441528, 0.40000000000000013, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35018222772483443, 0.40000000000000013, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.52729015917508748, 0.40000000000000013, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.70662374407341244, 0.40000000000000013, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.88859210497602159, 0.40000000000000013, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.0733136290471381, 0.40000000000000013, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.2605612170157066, 0.40000000000000013, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.4497513956433439, 0.40000000000000013, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.6399998658645112, 0.40000000000000013, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler131 = 2.5000000000000020e-13;

// Test data for k=0.40000000000000013, nu=0.10000000000000001.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 1.0263824105456986e-15
// mean(f - f_Boost): 1.7486012637846215e-16
// variance(f - f_Boost): 3.1664095331106078e-31
// stddev(f - f_Boost): 5.6270858649132121e-16
const testcase_ellint_3<double>
data132[10] =
{
  { 0.0000000000000000, 0.40000000000000013, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17485086590796767, 0.40000000000000013, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35158366412506992, 0.40000000000000013, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53194731675711726, 0.40000000000000013, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.71740615528010931, 0.40000000000000013, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.90896157773487030, 0.40000000000000013, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1069605483834348, 0.40000000000000013, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3109353428823001, 0.40000000000000013, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.5195460789903450, 0.40000000000000013, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.7306968836847190, 0.40000000000000013, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler132 = 2.5000000000000020e-13;

// Test data for k=0.40000000000000013, nu=0.20000000000000001.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 9.6644296021947179e-16
// mean(f - f_Boost): 2.0816681711721685e-16
// variance(f - f_Boost): 3.0360740073926687e-31
// stddev(f - f_Boost): 5.5100580826273227e-16
const testcase_ellint_3<double>
data133[10] =
{
  { 0.0000000000000000, 0.40000000000000013, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17502822886437389, 0.40000000000000013, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35300530062530805, 0.40000000000000013, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53675259548210896, 0.40000000000000013, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.72878006428676934, 0.40000000000000013, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.93100219010583574, 0.40000000000000013, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1443487271187611, 0.40000000000000013, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3683427764108813, 0.40000000000000013, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.6008221459300933, 0.40000000000000013, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.8380358826317627, 0.40000000000000013, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler133 = 2.5000000000000020e-13;

// Test data for k=0.40000000000000013, nu=0.30000000000000004.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 9.0271556462838835e-16
// mean(f - f_Boost): 2.0816681711721685e-16
// variance(f - f_Boost): 3.0360740073926687e-31
// stddev(f - f_Boost): 5.5100580826273227e-16
const testcase_ellint_3<double>
data134[10] =
{
  { 0.0000000000000000, 0.40000000000000013, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17520623975982899, 0.40000000000000013, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35444766141612105, 0.40000000000000013, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.54171455841536009, 0.40000000000000013, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.74080517001084012, 0.40000000000000013, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.95496950509296574, 0.40000000000000013, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.1862627879844718, 0.40000000000000013, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.4346501803799458, 0.40000000000000013, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.6971744798077699, 0.40000000000000013, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 1.9677924132520139, 0.40000000000000013, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler134 = 2.5000000000000020e-13;

// Test data for k=0.40000000000000013, nu=0.40000000000000002.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 8.3436329231972794e-16
// mean(f - f_Boost): 2.3037127760972000e-16
// variance(f - f_Boost): 2.9507053793392374e-31
// stddev(f - f_Boost): 5.4320395611033958e-16
const testcase_ellint_3<double>
data135[10] =
{
  { 0.0000000000000000, 0.40000000000000013, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17538490283034375, 0.40000000000000013, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35591129064319948, 0.40000000000000013, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.54684250413264535, 0.40000000000000013, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.75355027742668290, 0.40000000000000013, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 0.98117935026780634, 0.40000000000000013, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.2337464222030736, 0.40000000000000013, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.5125183419289221, 0.40000000000000013, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 1.8140224451130313, 0.40000000000000013, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.1289968719280026, 0.40000000000000013, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler135 = 2.5000000000000020e-13;

// Test data for k=0.40000000000000013, nu=0.50000000000000000.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 5.7013794022122431e-16
// mean(f - f_Boost): 2.3037127760972000e-16
// variance(f - f_Boost): 1.4989821857033475e-31
// stddev(f - f_Boost): 3.8716691306248618e-16
const testcase_ellint_3<double>
data136[10] =
{
  { 0.0000000000000000, 0.40000000000000013, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17556422235224273, 0.40000000000000013, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35739675341763921, 0.40000000000000013, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.55214655195037188, 0.40000000000000013, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.76709520942047438, 0.40000000000000013, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.0100278761577499, 0.40000000000000013, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.2882265661384342, 0.40000000000000013, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.6059059780051876, 0.40000000000000013, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.9600182740224081, 0.40000000000000013, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.3367461373176512, 0.40000000000000013, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler136 = 2.5000000000000020e-13;

// Test data for k=0.40000000000000013, nu=0.60000000000000009.
// max(|f - f_Boost|): 2.2204460492503131e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 8.4792115132836117e-16
// mean(f - f_Boost): 2.3037127760972000e-16
// variance(f - f_Boost): 4.8893797490374802e-31
// stddev(f - f_Boost): 6.9924099915819294e-16
const testcase_ellint_3<double>
data137[10] =
{
  { 0.0000000000000000, 0.40000000000000013, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17574420264267029, 0.40000000000000013, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.35890463689046265, 0.40000000000000013, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.55763773975194486, 0.40000000000000013, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.78153324227761267, 0.40000000000000013, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0420205885765887, 0.40000000000000013, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.3517205230381770, 0.40000000000000013, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.7210360970313896, 0.40000000000000013, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.1500780510169246, 0.40000000000000013, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 2.6186940209850191, 0.40000000000000013, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler137 = 2.5000000000000020e-13;

// Test data for k=0.40000000000000013, nu=0.70000000000000007.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 5.8573292020719759e-16
// mean(f - f_Boost): 2.2759572004815707e-16
// variance(f - f_Boost): 2.9613098824898137e-31
// stddev(f - f_Boost): 5.4417918762938862e-16
const testcase_ellint_3<double>
data138[10] =
{
  { 0.0000000000000000, 0.40000000000000013, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17592484806010436, 0.40000000000000013, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.36043555139631439, 0.40000000000000013, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.56332813669944881, 0.40000000000000013, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.79697424562157548, 0.40000000000000013, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.0778155987523672, 0.40000000000000013, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.4272018169896268, 0.40000000000000013, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 1.8684377907453382, 0.40000000000000013, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.4128677409207473, 0.40000000000000013, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 3.0327078743873246, 0.40000000000000013, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler138 = 2.5000000000000020e-13;

// Test data for k=0.40000000000000013, nu=0.80000000000000004.
// max(|f - f_Boost|): 3.5527136788005009e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 9.5273712585384737e-16
// mean(f - f_Boost): 4.5241588253475131e-16
// variance(f - f_Boost): 1.1866477068555882e-30
// stddev(f - f_Boost): 1.0893336067778265e-15
const testcase_ellint_3<double>
data139[10] =
{
  { 0.0000000000000000, 0.40000000000000013, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17610616300487833, 0.40000000000000013, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36199013167171978, 0.40000000000000013, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.56923097361842434, 0.40000000000000013, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.81354878456624347, 0.40000000000000013, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.1182902719261825, 0.40000000000000013, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.5192950589409022, 0.40000000000000013, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.0678761710223981, 0.40000000000000013, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.8135222249879788, 0.40000000000000013, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 3.7289548002199902, 0.40000000000000013, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler139 = 2.5000000000000020e-13;

// Test data for k=0.40000000000000013, nu=0.90000000000000002.
// max(|f - f_Boost|): 6.2172489379008766e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 1.1718379478872251e-15
// mean(f - f_Boost): 8.4099394115355610e-16
// variance(f - f_Boost): 3.5684096037099424e-30
// stddev(f - f_Boost): 1.8890234523980751e-15
const testcase_ellint_3<double>
data140[10] =
{
  { 0.0000000000000000, 0.40000000000000013, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17628815191971123, 0.40000000000000013, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36356903815378772, 0.40000000000000013, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.57536079447000310, 0.40000000000000013, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.83141355850172571, 0.40000000000000013, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.1646481598721361, 0.40000000000000013, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.6357275034001995, 0.40000000000000013, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.3628787566572402, 0.40000000000000013, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 3.5521010369134962, 0.40000000000000013, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 5.3055535102872513, 0.40000000000000013, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler140 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.0000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.4551389361831220e-16
// mean(f - f_Boost): -1.3877787807814457e-17
// variance(f - f_Boost): 2.5893058141206173e-32
// stddev(f - f_Boost): 1.6091320064309879e-16
const testcase_ellint_3<double>
data141[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17475385514035785, 0.50000000000000000, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35081868470101579, 0.50000000000000000, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.52942862705190574, 0.50000000000000000, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.71164727562630326, 0.50000000000000000, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.89824523594227768, 0.50000000000000000, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.0895506700518853, 0.50000000000000000, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.2853005857432933, 0.50000000000000000, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.4845545520549488, 0.50000000000000000, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.6857503548125961, 0.50000000000000000, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler141 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.10000000000000001.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.7416868347177582e-16
// mean(f - f_Boost): 2.7755575615628915e-18
// variance(f - f_Boost): 5.4326441655972001e-32
// stddev(f - f_Boost): 2.3308033305273100e-16
const testcase_ellint_3<double>
data142[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17493071928248824, 0.50000000000000000, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35222467688034798, 0.50000000000000000, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53411928652008112, 0.50000000000000000, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.72256398117177589, 0.50000000000000000, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.91899583232771009, 0.50000000000000000, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1240549163055360, 0.50000000000000000, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3372938086286021, 0.50000000000000000, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.5570024469132429, 0.50000000000000000, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.7803034946545480, 0.50000000000000000, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler142 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.20000000000000001.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.1198767993730867e-16
// mean(f - f_Boost): 2.7755575615628914e-17
// variance(f - f_Boost): 5.0311947683004831e-32
// stddev(f - f_Boost): 2.2430324938128922e-16
const testcase_ellint_3<double>
data143[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17510822779582402, 0.50000000000000000, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35365094725531487, 0.50000000000000000, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53895933237328697, 0.50000000000000000, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.73408090840070794, 0.50000000000000000, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.94145442818535396, 0.50000000000000000, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1624120186296487, 0.50000000000000000, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3965823372867114, 0.50000000000000000, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.6414308440430099, 0.50000000000000000, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.8922947612264018, 0.50000000000000000, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler143 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.30000000000000004.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.3800262770228813e-16
// mean(f - f_Boost): 5.8286708792820721e-17
// variance(f - f_Boost): 8.5027191584278157e-32
// stddev(f - f_Boost): 2.9159422419567599e-16
const testcase_ellint_3<double>
data144[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17528638488102041, 0.50000000000000000, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35509802222332720, 0.50000000000000000, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.54395740731866193, 0.50000000000000000, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.74625871438752667, 0.50000000000000000, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.96588271186092023, 0.50000000000000000, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.2054319584357329, 0.50000000000000000, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.4651077994832871, 0.50000000000000000, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.7416018368052644, 0.50000000000000000, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 2.0277924458111314, 0.50000000000000000, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler144 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.40000000000000002.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.0439932918341581e-16
// mean(f - f_Boost): 3.0531133177191807e-17
// variance(f - f_Boost): 9.0809736800018602e-32
// stddev(f - f_Boost): 3.0134653938616686e-16
const testcase_ellint_3<double>
data145[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17546519477859268, 0.50000000000000000, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35656644822531680, 0.50000000000000000, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.54912289677411319, 0.50000000000000000, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.75916731611690047, 0.50000000000000000, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 0.99260415631328214, 0.50000000000000000, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.2541925856918670, 0.50000000000000000, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.5456393705347609, 0.50000000000000000, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 1.8631904972952076, 0.50000000000000000, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.1962905366178065, 0.50000000000000000, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler145 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.50000000000000000.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.6797816859260978e-16
// mean(f - f_Boost): 9.4368957093138303e-17
// variance(f - f_Boost): 7.7794254682023874e-32
// stddev(f - f_Boost): 2.7891621444803792e-16
const testcase_ellint_3<double>
data146[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17564466176941509, 0.50000000000000000, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35805679276065394, 0.50000000000000000, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.55446601496200032, 0.50000000000000000, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.77288783578259013, 0.50000000000000000, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.0220246013918972, 0.50000000000000000, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.3101681612463965, 0.50000000000000000, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.6422994881851025, 0.50000000000000000, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 2.0152636030998816, 0.50000000000000000, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.4136715042011945, 0.50000000000000000, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler146 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.60000000000000009.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.9178421578645735e-16
// mean(f - f_Boost): 1.3322676295501878e-16
// variance(f - f_Boost): 1.7749370367472766e-31
// stddev(f - f_Boost): 4.2130001622920411e-16
const testcase_ellint_3<double>
data147[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17582479017522740, 0.50000000000000000, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.35956964546660036, 0.50000000000000000, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.55999790372984193, 0.50000000000000000, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.78751507911209895, 0.50000000000000000, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0546620505035220, 0.50000000000000000, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.3754438357425935, 0.50000000000000000, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.7615727400820127, 0.50000000000000000, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.2134638067565242, 0.50000000000000000, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 2.7090491861753558, 0.50000000000000000, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler147 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.70000000000000007.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.0745105182189226e-16
// mean(f - f_Boost): 4.1633363423443370e-17
// variance(f - f_Boost): 1.9996383743576116e-32
// stddev(f - f_Boost): 1.4140857026211713e-16
const testcase_ellint_3<double>
data148[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17600558435914915, 0.50000000000000000, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.36110561926726259, 0.50000000000000000, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.56573074641137111, 0.50000000000000000, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.80316073084237205, 0.50000000000000000, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.0911910688131461, 0.50000000000000000, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.4530946406380640, 0.50000000000000000, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 1.9144386536785372, 0.50000000000000000, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.4878788958234970, 0.50000000000000000, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 3.1433945297859225, 0.50000000000000000, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler148 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.80000000000000004.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.4380477375534667e-16
// mean(f - f_Boost): 2.3037127760972000e-16
// variance(f - f_Boost): 1.4989821857033475e-31
// stddev(f - f_Boost): 3.8716691306248618e-16
const testcase_ellint_3<double>
data149[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17618704872620228, 0.50000000000000000, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36266535159745827, 0.50000000000000000, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.57167789954529158, 0.50000000000000000, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.81995752984315018, 0.50000000000000000, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.1325112162158122, 0.50000000000000000, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.5479055930718042, 0.50000000000000000, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.1215243941010486, 0.50000000000000000, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.9069405767650132, 0.50000000000000000, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 3.8750701888108066, 0.50000000000000000, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler149 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.90000000000000002.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 3.6192315188521289e-16
// mean(f - f_Boost): 3.5249581031848718e-16
// variance(f - f_Boost): 2.5029385557256515e-31
// stddev(f - f_Boost): 5.0029376927217987e-16
const testcase_ellint_3<double>
data150[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17636918772384180, 0.50000000000000000, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36424950570740700, 0.50000000000000000, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.57785404590231426, 0.50000000000000000, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.83806480521716531, 0.50000000000000000, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.1798568683069752, 0.50000000000000000, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.6678766243739607, 0.50000000000000000, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.4282976450693483, 0.50000000000000000, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 3.6810787666126656, 0.50000000000000000, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 5.5355132096026454, 0.50000000000000000, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler150 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.0000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.3664899092028927e-16
// mean(f - f_Boost): 3.0531133177191807e-17
// variance(f - f_Boost): 7.8758646268991113e-33
// stddev(f - f_Boost): 8.8746068233466605e-17
const testcase_ellint_3<double>
data151[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17485154362988359, 0.60000000000000009, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35160509865544320, 0.60000000000000009, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.53210652578446138, 0.60000000000000009, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.71805304664485659, 0.60000000000000009, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.91082759030195981, 0.60000000000000009, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.1112333229323361, 0.60000000000000009, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.3191461190365270, 0.60000000000000009, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.5332022105084779, 0.60000000000000009, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.7507538029157526, 0.60000000000000009, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler151 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.10000000000000001.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.2335247010355137e-16
// mean(f - f_Boost): 8.6042284408449634e-17
// variance(f - f_Boost): 2.2835347143080263e-33
// stddev(f - f_Boost): 4.7786344433405099e-17
const testcase_ellint_3<double>
data152[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17502858548476194, 0.60000000000000009, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35301673150537388, 0.60000000000000009, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.53683932476326812, 0.60000000000000009, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.72914228589586771, 0.60000000000000009, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.93208036718354692, 0.60000000000000009, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1468984688863377, 0.60000000000000009, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.3733904977062528, 0.60000000000000009, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.6094225663372157, 0.60000000000000009, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.8508766487100685, 0.60000000000000009, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler152 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.20000000000000001.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 2.2547200163366559e-16
// mean(f - f_Boost): -2.4980018054066023e-17
// variance(f - f_Boost): 2.1685495635542404e-32
// stddev(f - f_Boost): 1.4725995937641163e-16
const testcase_ellint_3<double>
data153[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17520627248155893, 0.60000000000000009, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35444873935437748, 0.60000000000000009, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.54172310557682524, 0.60000000000000009, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.74084300280734672, 0.60000000000000009, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.95509001527006121, 0.60000000000000009, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1865688084431796, 0.60000000000000009, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.4352978868932600, 0.60000000000000009, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.6983400371331818, 0.60000000000000009, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.9695980282802217, 0.60000000000000009, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler153 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.30000000000000004.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.9470074709717020e-16
// mean(f - f_Boost): 3.0531133177191807e-17
// variance(f - f_Boost): 1.1508025840536076e-34
// stddev(f - f_Boost): 1.0727546709539920e-17
const testcase_ellint_3<double>
data154[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17538460882640122, 0.60000000000000009, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35590165133735557, 0.60000000000000009, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.54676661152254535, 0.60000000000000009, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.75321709418305305, 0.60000000000000009, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.98012637808992920, 0.60000000000000009, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.2310891277158875, 0.60000000000000009, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.5069157924585623, 0.60000000000000009, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.8039583598337940, 0.60000000000000009, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 2.1134154405060599, 0.60000000000000009, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler154 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.40000000000000002.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 2.8974839914337670e-16
// mean(f - f_Boost): -1.3877787807814457e-17
// variance(f - f_Boost): 2.2849613290816465e-32
// stddev(f - f_Boost): 1.5116088545260797e-16
const testcase_ellint_3<double>
data155[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17556359876533037, 0.60000000000000009, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35737601674244679, 0.60000000000000009, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.55197933771320218, 0.60000000000000009, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.76633591620002905, 0.60000000000000009, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.0075231136019616, 0.60000000000000009, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.2815842073813450, 0.60000000000000009, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.5911666941449827, 0.60000000000000009, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 1.9323227566025762, 0.60000000000000009, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.2925036420985130, 0.60000000000000009, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler155 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.50000000000000000.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 2.1397785842303966e-16
// mean(f - f_Boost): 9.1593399531575410e-17
// variance(f - f_Boost): 1.5339913122479866e-32
// stddev(f - f_Boost): 1.2385440291923362e-16
const testcase_ellint_3<double>
data156[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17574324658480217, 0.60000000000000009, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35887240603169313, 0.60000000000000009, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.55737161826345261, 0.60000000000000009, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.78028227313077458, 0.60000000000000009, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.0376989776486290, 0.60000000000000009, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.3395933991042928, 0.60000000000000009, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.6924049626591784, 0.60000000000000009, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 2.0931011856518920, 0.60000000000000009, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.5239007084492711, 0.60000000000000009, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler156 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.60000000000000009.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.6651378277398083e-16
// mean(f - f_Boost): 1.1934897514720432e-16
// variance(f - f_Boost): 1.7585404776158019e-33
// stddev(f - f_Boost): 4.1934955319110598e-17
const testcase_ellint_3<double>
data157[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17592355661219386, 0.60000000000000009, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.36039141192661606, 0.60000000000000009, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.56295472636903854, 0.60000000000000009, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.79515295130165986, 0.60000000000000009, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0711886441942242, 0.60000000000000009, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.4072952835139891, 0.60000000000000009, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.8174863977376825, 0.60000000000000009, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.3029921578542232, 0.60000000000000009, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 2.8388723099514972, 0.60000000000000009, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler157 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.70000000000000007.
// max(|f - f_Boost|): 4.4408920985006262e-16 at index 9
// max(|f - f_Boost| / |f_Boost|): 2.0027679235921772e-16
// mean(f - f_Boost): -1.3877787807814457e-17
// variance(f - f_Boost): 2.2849613290816465e-32
// stddev(f - f_Boost): 1.5116088545260797e-16
const testcase_ellint_3<double>
data158[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17610453321631936, 0.60000000000000009, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.36193365056369764, 0.60000000000000009, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.56874098962268527, 0.60000000000000009, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.81106198671477181, 0.60000000000000009, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.1086886419010082, 0.60000000000000009, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.4879048567239257, 0.60000000000000009, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 1.9780310073615925, 0.60000000000000009, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.5941545586772712, 0.60000000000000009, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 3.3029735898397159, 0.60000000000000009, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler158 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.80000000000000004.
// max(|f - f_Boost|): 2.2204460492503131e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 7.3044933435043190e-16
// mean(f - f_Boost): 2.6367796834847468e-16
// variance(f - f_Boost): 8.5834655546147173e-33
// stddev(f - f_Boost): 9.2646994309662939e-17
const testcase_ellint_3<double>
data159[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17628618080795252, 0.60000000000000009, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36349976272521012, 0.60000000000000009, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.57474392342151914, 0.60000000000000009, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.82814493499158170, 0.60000000000000009, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.1511281795998280, 0.60000000000000009, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.5864286332503075, 0.60000000000000009, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.1958944866494527, 0.60000000000000009, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 3.0398358172574604, 0.60000000000000009, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 4.0867036409261832, 0.60000000000000009, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler159 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.90000000000000002.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 4.5952142720718732e-16
// mean(f - f_Boost): 4.6351811278100284e-16
// variance(f - f_Boost): 2.1278339779151204e-31
// stddev(f - f_Boost): 4.6128450851021651e-16
const testcase_ellint_3<double>
data160[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17646850384035848, 0.60000000000000009, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36509041515134105, 0.60000000000000009, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.58097838596260631, 0.60000000000000009, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.84656453396163722, 0.60000000000000009, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.1997828426963724, 0.60000000000000009, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.7112436789225605, 0.60000000000000009, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.5193168553672312, 0.60000000000000009, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 3.8656670488606690, 0.60000000000000009, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 5.8709993116265604, 0.60000000000000009, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler160 = 2.5000000000000020e-13;

// Test data for k=0.70000000000000018, nu=0.0000000000000000.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 4.1569224977685422e-16
// mean(f - f_Boost): 7.7715611723760953e-17
// variance(f - f_Boost): 1.6571557210371951e-32
// stddev(f - f_Boost): 1.2873056051447903e-16
const testcase_ellint_3<double>
data161[10] =
{
  { 0.0000000000000000, 0.70000000000000018, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17496737466916723, 0.70000000000000018, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35254687535677931, 0.70000000000000018, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.53536740275997130, 0.70000000000000018, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.72603797651684454, 0.70000000000000018, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.92698296348313447, 0.70000000000000018, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.1400447527693318, 0.70000000000000018, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.3657668117194073, 0.70000000000000018, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.6024686895959164, 0.70000000000000018, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.8456939983747236, 0.70000000000000018, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler161 = 2.5000000000000020e-13;

// Test data for k=0.70000000000000018, nu=0.10000000000000001.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 3.9552278747527691e-16
// mean(f - f_Boost): 1.1102230246251565e-16
// variance(f - f_Boost): 1.3695501826753678e-32
// stddev(f - f_Boost): 1.1702778228589004e-16
const testcase_ellint_3<double>
data162[10] =
{
  { 0.0000000000000000, 0.70000000000000018, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17514462737300920, 0.70000000000000018, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35396527997470451, 0.70000000000000018, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.54015179589433981, 0.70000000000000018, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.73734430854477728, 0.70000000000000018, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.94888950796697047, 0.70000000000000018, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.1772807959736322, 0.70000000000000018, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.4231796401075834, 0.70000000000000018, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.6841856799887471, 0.70000000000000018, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 1.9541347343119564, 0.70000000000000018, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler162 = 2.5000000000000020e-13;

// Test data for k=0.70000000000000018, nu=0.20000000000000001.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 3.7430437016285820e-16
// mean(f - f_Boost): 3.3306690738754695e-17
// variance(f - f_Boost): 1.3695501826753678e-34
// stddev(f - f_Boost): 1.1702778228589003e-17
const testcase_ellint_3<double>
data163[10] =
{
  { 0.0000000000000000, 0.70000000000000018, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17532252613350796, 0.70000000000000018, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35540417596807522, 0.70000000000000018, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.54508913033361928, 0.70000000000000018, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.74927635777718415, 0.70000000000000018, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.97261706337936338, 0.70000000000000018, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.2187303976209327, 0.70000000000000018, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.4887796709222487, 0.70000000000000018, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.7796581281839214, 0.70000000000000018, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 2.0829290325820207, 0.70000000000000018, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler163 = 2.5000000000000020e-13;

// Test data for k=0.70000000000000018, nu=0.30000000000000004.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 4.2570807706941696e-16
// mean(f - f_Boost): 8.8817841970012528e-17
// variance(f - f_Boost): 1.5582437633995295e-32
// stddev(f - f_Boost): 1.2482963443828271e-16
const testcase_ellint_3<double>
data164[10] =
{
  { 0.0000000000000000, 0.70000000000000018, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17550107516328570, 0.70000000000000018, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35686409576571965, 0.70000000000000018, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.55018827316513352, 0.70000000000000018, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.76189759494390275, 0.70000000000000018, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 0.99844623430885626, 0.70000000000000018, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.2652862989039833, 0.70000000000000018, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.5647666808691361, 0.70000000000000018, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 1.8932499694938165, 0.70000000000000018, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 2.2392290510988535, 0.70000000000000018, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler164 = 2.5000000000000020e-13;

// Test data for k=0.70000000000000018, nu=0.40000000000000002.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 4.3719045096496910e-16
// mean(f - f_Boost): 1.3600232051658169e-16
// variance(f - f_Boost): 1.1718213750516114e-32
// stddev(f - f_Boost): 1.0825069861444829e-16
const testcase_ellint_3<double>
data165[10] =
{
  { 0.0000000000000000, 0.70000000000000018, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17568027871494424, 0.70000000000000018, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35834559208180261, 0.70000000000000018, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.55545885451190613, 0.70000000000000018, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.77528120402568113, 0.70000000000000018, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.0267241287600322, 0.70000000000000018, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.3181380338980246, 0.70000000000000018, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.6542840785132087, 0.70000000000000018, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 2.0315595131131823, 0.70000000000000018, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.4342502915307880, 0.70000000000000018, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler165 = 2.5000000000000020e-13;

// Test data for k=0.70000000000000018, nu=0.50000000000000000.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 4.0277361210295499e-16
// mean(f - f_Boost): 1.6930901125533636e-16
// variance(f - f_Boost): 6.3799163752809956e-32
// stddev(f - f_Boost): 2.5258496343371268e-16
const testcase_ellint_3<double>
data166[10] =
{
  { 0.0000000000000000, 0.70000000000000018, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17586014108156545, 0.70000000000000018, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35984923894341653, 0.70000000000000018, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.56091135606739995, 0.70000000000000018, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.78951212635197054, 0.70000000000000018, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.0578865732938731, 0.70000000000000018, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.3789149005151722, 0.70000000000000018, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.7620212286086228, 0.70000000000000018, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 2.2051554347435589, 0.70000000000000018, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.6868019968236996, 0.70000000000000018, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler166 = 2.5000000000000020e-13;

// Test data for k=0.70000000000000018, nu=0.60000000000000009.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 5.8597454441867134e-16
// mean(f - f_Boost): 2.5535129566378598e-16
// variance(f - f_Boost): 2.8561208198482198e-31
// stddev(f - f_Boost): 5.3442687243889785e-16
const testcase_ellint_3<double>
data167[10] =
{
  { 0.0000000000000000, 0.70000000000000018, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17604066659721918, 0.70000000000000018, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.36137563278353424, 0.70000000000000018, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.56655721272747606, 0.70000000000000018, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.80468966552978305, 0.70000000000000018, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.0924902943683852, 0.70000000000000018, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.4499247992499800, 0.70000000000000018, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 1.8953714382113818, 0.70000000000000018, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.4323229949248670, 0.70000000000000018, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 3.0314573496746746, 0.70000000000000018, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler167 = 2.5000000000000020e-13;

// Test data for k=0.70000000000000018, nu=0.70000000000000007.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 8
// max(|f - f_Boost| / |f_Boost|): 3.2316852368580916e-16
// mean(f - f_Boost): 7.7715611723760953e-17
// variance(f - f_Boost): 7.4564398834547797e-34
// stddev(f - f_Boost): 2.7306482533374340e-17
const testcase_ellint_3<double>
data168[10] =
{
  { 0.0000000000000000, 0.70000000000000018, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17622185963747933, 0.70000000000000018, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.36292539360435261, 0.70000000000000018, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.57240892970150015, 0.70000000000000018, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.82093084713182629, 0.70000000000000018, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.1312609022179871, 0.70000000000000018, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.5345768067715795, 0.70000000000000018, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 2.0668847445934424, 0.70000000000000018, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.7483444537551245, 0.70000000000000018, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 3.5408408771788569, 0.70000000000000018, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler168 = 2.5000000000000020e-13;

// Test data for k=0.70000000000000018, nu=0.80000000000000004.
// max(|f - f_Boost|): 1.3322676295501878e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 4.1198716111867353e-16
// mean(f - f_Boost): 2.2482016248659419e-16
// variance(f - f_Boost): 5.4326441655972001e-32
// stddev(f - f_Boost): 2.3308033305273100e-16
const testcase_ellint_3<double>
data169[10] =
{
  { 0.0000000000000000, 0.70000000000000018, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17640372461994805, 0.70000000000000018, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36449916621651091, 0.70000000000000018, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.57848021800372584, 0.70000000000000018, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.83837480968392586, 0.70000000000000018, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.1751669030061143, 0.70000000000000018, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.6381851899173603, 0.70000000000000018, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.3002065924302197, 0.70000000000000018, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 3.2337600665337871, 0.70000000000000018, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 4.4042405729076970, 0.70000000000000018, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler169 = 2.5000000000000020e-13;

// Test data for k=0.70000000000000018, nu=0.90000000000000002.
// max(|f - f_Boost|): 3.5527136788005009e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 8.5869439826269878e-16
// mean(f - f_Boost): 7.4384942649885490e-16
// variance(f - f_Boost): 9.7403930714297352e-31
// stddev(f - f_Boost): 9.8693429727767263e-16
const testcase_ellint_3<double>
data170[10] =
{
  { 0.0000000000000000, 0.70000000000000018, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17658626600478800, 0.70000000000000018, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36609762156017206, 0.70000000000000018, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.58478615187842409, 0.70000000000000018, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.85718862878291846, 0.70000000000000018, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.2255385617397643, 0.70000000000000018, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.7696521899992941, 0.70000000000000018, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.6476314987883507, 0.70000000000000018, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 4.1373434902898083, 0.70000000000000018, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 6.3796094177887763, 0.70000000000000018, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler170 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.0000000000000000.
// max(|f - f_Boost|): 1.5543122344752192e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 7.7898565163847540e-16
// mean(f - f_Boost): 2.3869795029440865e-16
// variance(f - f_Boost): 2.1368406725192426e-31
// stddev(f - f_Boost): 4.6225974002926564e-16
const testcase_ellint_3<double>
data171[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17510154241338899, 0.80000000000000004, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35365068839779396, 0.80000000000000004, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.53926804409084550, 0.80000000000000004, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.73587926028070372, 0.80000000000000004, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.94770942970071170, 0.80000000000000004, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.1789022995388236, 0.80000000000000004, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.4323027881876012, 0.80000000000000004, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.7069629739121677, 0.80000000000000004, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 1.9953027776647294, 0.80000000000000004, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler171 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.10000000000000001.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 8.3898786942190374e-16
// mean(f - f_Boost): 2.3869795029440865e-16
// variance(f - f_Boost): 2.9190059990693968e-31
// stddev(f - f_Boost): 5.4027826155319237e-16
const testcase_ellint_3<double>
data172[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17527903952342144, 0.80000000000000004, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35507705313548549, 0.80000000000000004, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.54411455987643553, 0.80000000000000004, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.74745625666804383, 0.80000000000000004, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.97046953684238557, 0.80000000000000004, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.2183080025184605, 0.80000000000000004, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.4943711151994405, 0.80000000000000004, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.7972401309544201, 0.80000000000000004, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 2.1172616484005085, 0.80000000000000004, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler172 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.20000000000000001.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 7.8513740186068518e-16
// mean(f - f_Boost): 2.8310687127941490e-16
// variance(f - f_Boost): 2.7528339102381189e-31
// stddev(f - f_Boost): 5.2467455724840699e-16
const testcase_ellint_3<double>
data173[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17545718375086419, 0.80000000000000004, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35652404627248163, 0.80000000000000004, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.54911638512920913, 0.80000000000000004, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.75967684282131176, 0.80000000000000004, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.99513526893543769, 0.80000000000000004, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.2622192109995993, 0.80000000000000004, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.5654106676347741, 0.80000000000000004, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.9029531718534984, 0.80000000000000004, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 2.2624789434186798, 0.80000000000000004, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler173 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.30000000000000004.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 7.2825261583337354e-16
// mean(f - f_Boost): 2.6367796834847468e-16
// variance(f - f_Boost): 2.8249350208968825e-31
// stddev(f - f_Boost): 5.3150117788175054e-16
const testcase_ellint_3<double>
data174[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17563597931587369, 0.80000000000000004, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35799220412005128, 0.80000000000000004, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.55428253691111318, 0.80000000000000004, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.77260647376977365, 0.80000000000000004, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.0220015271210958, 0.80000000000000004, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.3115965312302671, 0.80000000000000004, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.6478518468813512, 0.80000000000000004, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.0290458414203481, 0.80000000000000004, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 2.4392042002725693, 0.80000000000000004, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler174 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.40000000000000002.
// max(|f - f_Boost|): 2.2204460492503131e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 8.3462748389836647e-16
// mean(f - f_Boost): 3.3861802251067273e-16
// variance(f - f_Boost): 4.3719465706454422e-31
// stddev(f - f_Boost): 6.6120696991527871e-16
const testcase_ellint_3<double>
data175[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17581543047866136, 0.80000000000000004, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.35948208343061633, 0.80000000000000004, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.55962280893702021, 0.80000000000000004, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.78632063889234116, 0.80000000000000004, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.0514333069550323, 0.80000000000000004, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.3677213138838757, 0.80000000000000004, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.7451736773665165, 0.80000000000000004, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 2.1830100424586831, 0.80000000000000004, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 2.6604037035529724, 0.80000000000000004, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler175 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.50000000000000000.
// max(|f - f_Boost|): 2.6645352591003757e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 9.0388243828581744e-16
// mean(f - f_Boost): 3.8580250105724191e-16
// variance(f - f_Boost): 6.4106456575047741e-31
// stddev(f - f_Boost): 8.0066507713929764e-16
const testcase_ellint_3<double>
data176[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17599554153999472, 0.80000000000000004, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.36099426243351540, 0.80000000000000004, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.56514786174780673, 0.80000000000000004, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.80090697622371010, 0.80000000000000004, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.0838891627679339, 0.80000000000000004, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.4323506654466280, 0.80000000000000004, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.8625761085390575, 0.80000000000000004, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 2.3768757305654766, 0.80000000000000004, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.9478781158239746, 0.80000000000000004, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler176 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.60000000000000009.
// max(|f - f_Boost|): 3.5527136788005009e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 1.0631099169042069e-15
// mean(f - f_Boost): 4.8294701571194306e-16
// variance(f - f_Boost): 1.1633910328160319e-30
// stddev(f - f_Boost): 1.0786060600682865e-15
const testcase_ellint_3<double>
data177[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17617631684170665, 0.80000000000000004, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.36252934193666231, 0.80000000000000004, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.57086932622945163, 0.80000000000000004, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.81646796740150973, 0.80000000000000004, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.1199552158519064, 0.80000000000000004, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.5079766673336394, 0.80000000000000004, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 2.0082747447038165, 0.80000000000000004, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.6315146066775523, 0.80000000000000004, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 3.3418121892288051, 0.80000000000000004, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler177 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.70000000000000007.
// max(|f - f_Boost|): 2.2204460492503131e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 5.6544679145741375e-16
// mean(f - f_Boost): 3.2751579226442120e-16
// variance(f - f_Boost): 4.4236851331020672e-31
// stddev(f - f_Boost): 6.6510789599147505e-16
const testcase_ellint_3<double>
data178[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17635776076721221, 0.80000000000000004, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.36408794649916976, 0.80000000000000004, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.57679992290624138, 0.80000000000000004, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.83312441418142813, 0.80000000000000004, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.1603958891464856, 0.80000000000000004, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.5982855143796213, 0.80000000000000004, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 2.1962484408371821, 0.80000000000000004, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 2.9873281786111869, 0.80000000000000004, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 3.9268876980046397, 0.80000000000000004, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler178 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.80000000000000004.
// max(|f - f_Boost|): 4.4408920985006262e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 9.0176949165011079e-16
// mean(f - f_Boost): 7.0499162063697436e-16
// variance(f - f_Boost): 1.7230805408026989e-30
// stddev(f - f_Boost): 1.3126616246400665e-15
const testcase_ellint_3<double>
data179[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17653987774203392, 0.80000000000000004, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36567072568046877, 0.80000000000000004, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.58295359996558616, 0.80000000000000004, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.85101998309176108, 0.80000000000000004, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.2062322059736537, 0.80000000000000004, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.7090321420917429, 0.80000000000000004, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.4529058049405066, 0.80000000000000004, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 3.5368893360106948, 0.80000000000000004, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 4.9246422058196062, 0.80000000000000004, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler179 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.90000000000000002.
// max(|f - f_Boost|): 4.4408920985006262e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 7.7782721357365268e-16
// mean(f - f_Boost): 8.9928064994637676e-16
// variance(f - f_Boost): 1.5485199571025344e-30
// stddev(f - f_Boost): 1.2443954183066307e-15
const testcase_ellint_3<double>
data180[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17672267223433513, 0.80000000000000004, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36727835537196063, 0.80000000000000004, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.58934569363716649, 0.80000000000000004, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.87032723471138851, 0.80000000000000004, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.2588676111323349, 0.80000000000000004, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.8498731900660019, 0.80000000000000004, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 2.8368381299300420, 0.80000000000000004, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 4.5674844191654058, 0.80000000000000004, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 7.2263259298637115, 0.80000000000000004, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler180 = 2.5000000000000020e-13;

// Test data for k=0.90000000000000013, nu=0.0000000000000000.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 4.3381508715713360e-16
// mean(f - f_Boost): 5.8286708792820721e-17
// variance(f - f_Boost): 4.1942474344433133e-34
// stddev(f - f_Boost): 2.0479861900030756e-17
const testcase_ellint_3<double>
data181[10] =
{
  { 0.0000000000000000, 0.90000000000000013, 0.0000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17525427376115027, 0.90000000000000013, 0.0000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.35492464591297446, 0.90000000000000013, 0.0000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.54388221416157123, 0.90000000000000013, 0.0000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.74797400423532512, 0.90000000000000013, 0.0000000000000000, 
	  0.69813170079773179, 0.0 },
  { 0.97463898451966446, 0.90000000000000013, 0.0000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.2334463254523440, 0.90000000000000013, 0.0000000000000000, 
	  1.0471975511965976, 0.0 },
  { 1.5355247765594915, 0.90000000000000013, 0.0000000000000000, 
	  1.2217304763960306, 0.0 },
  { 1.8882928567775128, 0.90000000000000013, 0.0000000000000000, 
	  1.3962634015954636, 0.0 },
  { 2.2805491384227707, 0.90000000000000013, 0.0000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler181 = 2.5000000000000020e-13;

// Test data for k=0.90000000000000013, nu=0.10000000000000001.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 4.1500594295134815e-16
// mean(f - f_Boost): 9.1593399531575410e-17
// variance(f - f_Boost): 1.0357223256482469e-33
// stddev(f - f_Boost): 3.2182640128619758e-17
const testcase_ellint_3<double>
data182[10] =
{
  { 0.0000000000000000, 0.90000000000000013, 0.10000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17543204932716244, 0.90000000000000013, 0.10000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35636022898551184, 0.90000000000000013, 0.10000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.54880278898382595, 0.90000000000000013, 0.10000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.75988834774529268, 0.90000000000000013, 0.10000000000000001, 
	  0.69813170079773179, 0.0 },
  { 0.99853303003568117, 0.90000000000000013, 0.10000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.2759958823999022, 0.90000000000000013, 0.10000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.6051187364639401, 0.90000000000000013, 0.10000000000000001, 
	  1.2217304763960306, 0.0 },
  { 1.9941406879519474, 0.90000000000000013, 0.10000000000000001, 
	  1.3962634015954636, 0.0 },
  { 2.4295011187834890, 0.90000000000000013, 0.10000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler182 = 2.5000000000000020e-13;

// Test data for k=0.90000000000000013, nu=0.20000000000000001.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.9533518431433547e-16
// mean(f - f_Boost): 1.0269562977782698e-16
// variance(f - f_Boost): 1.4388836606733082e-32
// stddev(f - f_Boost): 1.1995347684303728e-16
const testcase_ellint_3<double>
data183[10] =
{
  { 0.0000000000000000, 0.90000000000000013, 0.20000000000000001, 
	  0.0000000000000000, 0.0 },
  { 0.17561047321968409, 0.90000000000000013, 0.20000000000000001, 
	  0.17453292519943295, 0.0 },
  { 0.35781659944356109, 0.90000000000000013, 0.20000000000000001, 
	  0.34906585039886590, 0.0 },
  { 0.55388150905215283, 0.90000000000000013, 0.20000000000000001, 
	  0.52359877559829882, 0.0 },
  { 0.77246874123251441, 0.90000000000000013, 0.20000000000000001, 
	  0.69813170079773179, 0.0 },
  { 1.0244466254771925, 0.90000000000000013, 0.20000000000000001, 
	  0.87266462599716477, 0.0 },
  { 1.3234824077640801, 0.90000000000000013, 0.20000000000000001, 
	  1.0471975511965976, 0.0 },
  { 1.6849848968804240, 0.90000000000000013, 0.20000000000000001, 
	  1.2217304763960306, 0.0 },
  { 2.1185749045502278, 0.90000000000000013, 0.20000000000000001, 
	  1.3962634015954636, 0.0 },
  { 2.6076835743348417, 0.90000000000000013, 0.20000000000000001, 
	  1.5707963267948966, 0.0 },
};
const double toler183 = 2.5000000000000020e-13;

// Test data for k=0.90000000000000013, nu=0.30000000000000004.
// max(|f - f_Boost|): 6.6613381477509392e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 3.9712691025502371e-16
// mean(f - f_Boost): 6.9388939039072284e-17
// variance(f - f_Boost): 5.9442282234173945e-34
// stddev(f - f_Boost): 2.4380787976227090e-17
const testcase_ellint_3<double>
data184[10] =
{
  { 0.0000000000000000, 0.90000000000000013, 0.30000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17578954966746221, 0.90000000000000013, 0.30000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.35929429810867447, 0.90000000000000013, 0.30000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.55912757154240822, 0.90000000000000013, 0.30000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.78578314722025389, 0.90000000000000013, 0.30000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.0526941001131365, 0.90000000000000013, 0.30000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.3769682234538601, 0.90000000000000013, 0.30000000000000004, 
	  1.0471975511965976, 0.0 },
  { 1.7779437432911240, 0.90000000000000013, 0.30000000000000004, 
	  1.2217304763960306, 0.0 },
  { 2.2676509341813635, 0.90000000000000013, 0.30000000000000004, 
	  1.3962634015954636, 0.0 },
  { 2.8256506968858517, 0.90000000000000013, 0.30000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler184 = 2.5000000000000020e-13;

// Test data for k=0.90000000000000013, nu=0.40000000000000002.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 4.7042235432234642e-16
// mean(f - f_Boost): 1.8041124150158794e-16
// variance(f - f_Boost): 8.5834655546147173e-33
// stddev(f - f_Boost): 9.2646994309662939e-17
const testcase_ellint_3<double>
data185[10] =
{
  { 0.0000000000000000, 0.90000000000000013, 0.40000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17596928293938452, 0.90000000000000013, 0.40000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36079388642472821, 0.90000000000000013, 0.40000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.56455096667115612, 0.90000000000000013, 0.40000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.79990996997869435, 0.90000000000000013, 0.40000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.0836647913872215, 0.90000000000000013, 0.40000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.4378726836091849, 0.90000000000000013, 0.40000000000000002, 
	  1.0471975511965976, 0.0 },
  { 1.8880446720682853, 0.90000000000000013, 0.40000000000000002, 
	  1.2217304763960306, 0.0 },
  { 2.4505848932025232, 0.90000000000000013, 0.40000000000000002, 
	  1.3962634015954636, 0.0 },
  { 3.1000689868578624, 0.90000000000000013, 0.40000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler185 = 2.5000000000000020e-13;

// Test data for k=0.90000000000000013, nu=0.50000000000000000.
// max(|f - f_Boost|): 8.8817841970012523e-16 at index 7
// max(|f - f_Boost| / |f_Boost|): 4.3939646155354115e-16
// mean(f - f_Boost): 1.5820678100908481e-16
// variance(f - f_Boost): 1.0089970755557622e-32
// stddev(f - f_Boost): 1.0044884646205561e-16
const testcase_ellint_3<double>
data186[10] =
{
  { 0.0000000000000000, 0.90000000000000013, 0.50000000000000000, 
	  0.0000000000000000, 0.0 },
  { 0.17614967734498183, 0.90000000000000013, 0.50000000000000000, 
	  0.17453292519943295, 0.0 },
  { 0.36231594750319435, 0.90000000000000013, 0.50000000000000000, 
	  0.34906585039886590, 0.0 },
  { 0.57016256984349567, 0.90000000000000013, 0.50000000000000000, 
	  0.52359877559829882, 0.0 },
  { 0.81494025918293422, 0.90000000000000013, 0.50000000000000000, 
	  0.69813170079773179, 0.0 },
  { 1.1178482279283477, 0.90000000000000013, 0.50000000000000000, 
	  0.87266462599716477, 0.0 },
  { 1.5081455873012106, 0.90000000000000013, 0.50000000000000000, 
	  1.0471975511965976, 0.0 },
  { 2.0213599730863998, 0.90000000000000013, 0.50000000000000000, 
	  1.2217304763960306, 0.0 },
  { 2.6822467012926832, 0.90000000000000013, 0.50000000000000000, 
	  1.3962634015954636, 0.0 },
  { 3.4591069002104686, 0.90000000000000013, 0.50000000000000000, 
	  1.5707963267948966, 0.0 },
};
const double toler186 = 2.5000000000000020e-13;

// Test data for k=0.90000000000000013, nu=0.60000000000000009.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 4.4914274070443813e-16
// mean(f - f_Boost): 3.4694469519536142e-16
// variance(f - f_Boost): 2.5224926888894056e-31
// stddev(f - f_Boost): 5.0224423231027804e-16
const testcase_ellint_3<double>
data187[10] =
{
  { 0.0000000000000000, 0.90000000000000013, 0.60000000000000009, 
	  0.0000000000000000, 0.0 },
  { 0.17633073723493825, 0.90000000000000013, 0.60000000000000009, 
	  0.17453292519943295, 0.0 },
  { 0.36386108723492810, 0.90000000000000013, 0.60000000000000009, 
	  0.34906585039886590, 0.0 },
  { 0.57597424744716241, 0.90000000000000013, 0.60000000000000009, 
	  0.52359877559829882, 0.0 },
  { 0.83098051948501150, 0.90000000000000013, 0.60000000000000009, 
	  0.69813170079773179, 0.0 },
  { 1.1558706545698916, 0.90000000000000013, 0.60000000000000009, 
	  0.87266462599716477, 0.0 },
  { 1.5905576379415669, 0.90000000000000013, 0.60000000000000009, 
	  1.0471975511965976, 0.0 },
  { 2.1875186010215084, 0.90000000000000013, 0.60000000000000009, 
	  1.2217304763960306, 0.0 },
  { 2.9885767771316853, 0.90000000000000013, 0.60000000000000009, 
	  1.3962634015954636, 0.0 },
  { 3.9549939883570238, 0.90000000000000013, 0.60000000000000009, 
	  1.5707963267948966, 0.0 },
};
const double toler187 = 2.5000000000000020e-13;

// Test data for k=0.90000000000000013, nu=0.70000000000000007.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 9
// max(|f - f_Boost| / |f_Boost|): 5.5442489886293633e-16
// mean(f - f_Boost): 4.3576253716537392e-16
// variance(f - f_Boost): 2.2187568928205130e-31
// stddev(f - f_Boost): 4.7103682370070737e-16
const testcase_ellint_3<double>
data188[10] =
{
  { 0.0000000000000000, 0.90000000000000013, 0.70000000000000007, 
	  0.0000000000000000, 0.0 },
  { 0.17651246700160939, 0.90000000000000013, 0.70000000000000007, 
	  0.17453292519943295, 0.0 },
  { 0.36542993547358982, 0.90000000000000013, 0.70000000000000007, 
	  0.34906585039886590, 0.0 },
  { 0.58199897877674867, 0.90000000000000013, 0.70000000000000007, 
	  0.52359877559829882, 0.0 },
  { 0.84815633587352857, 0.90000000000000013, 0.70000000000000007, 
	  0.69813170079773179, 0.0 },
  { 1.1985495623872375, 0.90000000000000013, 0.70000000000000007, 
	  0.87266462599716477, 0.0 },
  { 1.6892158134027691, 0.90000000000000013, 0.70000000000000007, 
	  1.0471975511965976, 0.0 },
  { 2.4029722191094236, 0.90000000000000013, 0.70000000000000007, 
	  1.2217304763960306, 0.0 },
  { 3.4201084941340061, 0.90000000000000013, 0.70000000000000007, 
	  1.3962634015954636, 0.0 },
  { 4.6985482312992444, 0.90000000000000013, 0.70000000000000007, 
	  1.5707963267948966, 0.0 },
};
const double toler188 = 2.5000000000000020e-13;

// Test data for k=0.90000000000000013, nu=0.80000000000000004.
// max(|f - f_Boost|): 1.7763568394002505e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 4.9362432595976420e-16
// mean(f - f_Boost): 3.0531133177191805e-16
// variance(f - f_Boost): 1.1508025840536076e-32
// stddev(f - f_Boost): 1.0727546709539920e-16
const testcase_ellint_3<double>
data189[10] =
{
  { 0.0000000000000000, 0.90000000000000013, 0.80000000000000004, 
	  0.0000000000000000, 0.0 },
  { 0.17669487107954862, 0.90000000000000013, 0.80000000000000004, 
	  0.17453292519943295, 0.0 },
  { 0.36702314729628421, 0.90000000000000013, 0.80000000000000004, 
	  0.34906585039886590, 0.0 },
  { 0.58825099711365492, 0.90000000000000013, 0.80000000000000004, 
	  0.52359877559829882, 0.0 },
  { 0.86661711422209031, 0.90000000000000013, 0.80000000000000004, 
	  0.69813170079773179, 0.0 },
  { 1.2469779109884802, 0.90000000000000013, 0.80000000000000004, 
	  0.87266462599716477, 0.0 },
  { 1.8105469760531578, 0.90000000000000013, 0.80000000000000004, 
	  1.0471975511965976, 0.0 },
  { 2.6989505165893752, 0.90000000000000013, 0.80000000000000004, 
	  1.2217304763960306, 0.0 },
  { 4.0935213267757433, 0.90000000000000013, 0.80000000000000004, 
	  1.3962634015954636, 0.0 },
  { 5.9820740813645727, 0.90000000000000013, 0.80000000000000004, 
	  1.5707963267948966, 0.0 },
};
const double toler189 = 2.5000000000000020e-13;

// Test data for k=0.90000000000000013, nu=0.90000000000000002.
// max(|f - f_Boost|): 2.6645352591003757e-15 at index 8
// max(|f - f_Boost| / |f_Boost|): 4.9577148062669782e-16
// mean(f - f_Boost): 5.9119376061289588e-16
// variance(f - f_Boost): 1.7340883003959522e-31
// stddev(f - f_Boost): 4.1642385863395872e-16
const testcase_ellint_3<double>
data190[10] =
{
  { 0.0000000000000000, 0.90000000000000013, 0.90000000000000002, 
	  0.0000000000000000, 0.0 },
  { 0.17687795394604169, 0.90000000000000013, 0.90000000000000002, 
	  0.17453292519943295, 0.0 },
  { 0.36864140434751286, 0.90000000000000013, 0.90000000000000002, 
	  0.34906585039886590, 0.0 },
  { 0.59474595366817051, 0.90000000000000013, 0.90000000000000002, 
	  0.52359877559829882, 0.0 },
  { 0.88654237226056665, 0.90000000000000013, 0.90000000000000002, 
	  0.69813170079773179, 0.0 },
  { 1.3026595810616726, 0.90000000000000013, 0.90000000000000002, 
	  0.87266462599716477, 0.0 },
  { 1.9653635459278080, 0.90000000000000013, 0.90000000000000002, 
	  1.0471975511965976, 0.0 },
  { 3.1451407527189468, 0.90000000000000013, 0.90000000000000002, 
	  1.2217304763960306, 0.0 },
  { 5.3745230680316132, 0.90000000000000013, 0.90000000000000002, 
	  1.3962634015954636, 0.0 },
  { 8.9942562031858717, 0.90000000000000013, 0.90000000000000002, 
	  1.5707963267948966, 0.0 },
};
const double toler190 = 2.5000000000000020e-13;

template<typename Ret, unsigned int Num>
  void
  test(const testcase_ellint_3<Ret> (&data)[Num], Ret toler)
  {
    bool test __attribute__((unused)) = true;
    const Ret eps = std::numeric_limits<Ret>::epsilon();
    Ret max_abs_diff = -Ret(1);
    Ret max_abs_frac = -Ret(1);
    unsigned int num_datum = Num;
    for (unsigned int i = 0; i < num_datum; ++i)
  	 {
	const Ret f = std::ellint_3(data[i].k, data[i].nu,
		     data[i].phi);
	const Ret f0 = data[i].f0;
	const Ret diff = f - f0;
	if (std::abs(diff) > max_abs_diff)
	  max_abs_diff = std::abs(diff);
	if (std::abs(f0) > Ret(10) * eps
	 && std::abs(f) > Ret(10) * eps)
	  {
	    const Ret frac = diff / f0;
	    if (std::abs(frac) > max_abs_frac)
	      max_abs_frac = std::abs(frac);
	  }
      }
    VERIFY(max_abs_frac < toler);
  }

int
main()
{
  test(data001, toler001);
  test(data002, toler002);
  test(data003, toler003);
  test(data004, toler004);
  test(data005, toler005);
  test(data006, toler006);
  test(data007, toler007);
  test(data008, toler008);
  test(data009, toler009);
  test(data010, toler010);
  test(data011, toler011);
  test(data012, toler012);
  test(data013, toler013);
  test(data014, toler014);
  test(data015, toler015);
  test(data016, toler016);
  test(data017, toler017);
  test(data018, toler018);
  test(data019, toler019);
  test(data020, toler020);
  test(data021, toler021);
  test(data022, toler022);
  test(data023, toler023);
  test(data024, toler024);
  test(data025, toler025);
  test(data026, toler026);
  test(data027, toler027);
  test(data028, toler028);
  test(data029, toler029);
  test(data030, toler030);
  test(data031, toler031);
  test(data032, toler032);
  test(data033, toler033);
  test(data034, toler034);
  test(data035, toler035);
  test(data036, toler036);
  test(data037, toler037);
  test(data038, toler038);
  test(data039, toler039);
  test(data040, toler040);
  test(data041, toler041);
  test(data042, toler042);
  test(data043, toler043);
  test(data044, toler044);
  test(data045, toler045);
  test(data046, toler046);
  test(data047, toler047);
  test(data048, toler048);
  test(data049, toler049);
  test(data050, toler050);
  test(data051, toler051);
  test(data052, toler052);
  test(data053, toler053);
  test(data054, toler054);
  test(data055, toler055);
  test(data056, toler056);
  test(data057, toler057);
  test(data058, toler058);
  test(data059, toler059);
  test(data060, toler060);
  test(data061, toler061);
  test(data062, toler062);
  test(data063, toler063);
  test(data064, toler064);
  test(data065, toler065);
  test(data066, toler066);
  test(data067, toler067);
  test(data068, toler068);
  test(data069, toler069);
  test(data070, toler070);
  test(data071, toler071);
  test(data072, toler072);
  test(data073, toler073);
  test(data074, toler074);
  test(data075, toler075);
  test(data076, toler076);
  test(data077, toler077);
  test(data078, toler078);
  test(data079, toler079);
  test(data080, toler080);
  test(data081, toler081);
  test(data082, toler082);
  test(data083, toler083);
  test(data084, toler084);
  test(data085, toler085);
  test(data086, toler086);
  test(data087, toler087);
  test(data088, toler088);
  test(data089, toler089);
  test(data090, toler090);
  test(data091, toler091);
  test(data092, toler092);
  test(data093, toler093);
  test(data094, toler094);
  test(data095, toler095);
  test(data096, toler096);
  test(data097, toler097);
  test(data098, toler098);
  test(data099, toler099);
  test(data100, toler100);
  test(data101, toler101);
  test(data102, toler102);
  test(data103, toler103);
  test(data104, toler104);
  test(data105, toler105);
  test(data106, toler106);
  test(data107, toler107);
  test(data108, toler108);
  test(data109, toler109);
  test(data110, toler110);
  test(data111, toler111);
  test(data112, toler112);
  test(data113, toler113);
  test(data114, toler114);
  test(data115, toler115);
  test(data116, toler116);
  test(data117, toler117);
  test(data118, toler118);
  test(data119, toler119);
  test(data120, toler120);
  test(data121, toler121);
  test(data122, toler122);
  test(data123, toler123);
  test(data124, toler124);
  test(data125, toler125);
  test(data126, toler126);
  test(data127, toler127);
  test(data128, toler128);
  test(data129, toler129);
  test(data130, toler130);
  test(data131, toler131);
  test(data132, toler132);
  test(data133, toler133);
  test(data134, toler134);
  test(data135, toler135);
  test(data136, toler136);
  test(data137, toler137);
  test(data138, toler138);
  test(data139, toler139);
  test(data140, toler140);
  test(data141, toler141);
  test(data142, toler142);
  test(data143, toler143);
  test(data144, toler144);
  test(data145, toler145);
  test(data146, toler146);
  test(data147, toler147);
  test(data148, toler148);
  test(data149, toler149);
  test(data150, toler150);
  test(data151, toler151);
  test(data152, toler152);
  test(data153, toler153);
  test(data154, toler154);
  test(data155, toler155);
  test(data156, toler156);
  test(data157, toler157);
  test(data158, toler158);
  test(data159, toler159);
  test(data160, toler160);
  test(data161, toler161);
  test(data162, toler162);
  test(data163, toler163);
  test(data164, toler164);
  test(data165, toler165);
  test(data166, toler166);
  test(data167, toler167);
  test(data168, toler168);
  test(data169, toler169);
  test(data170, toler170);
  test(data171, toler171);
  test(data172, toler172);
  test(data173, toler173);
  test(data174, toler174);
  test(data175, toler175);
  test(data176, toler176);
  test(data177, toler177);
  test(data178, toler178);
  test(data179, toler179);
  test(data180, toler180);
  test(data181, toler181);
  test(data182, toler182);
  test(data183, toler183);
  test(data184, toler184);
  test(data185, toler185);
  test(data186, toler186);
  test(data187, toler187);
  test(data188, toler188);
  test(data189, toler189);
  test(data190, toler190);
  return 0;
}
