// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

#nullable enable

using System.Threading;
using System.Threading.Tasks;
using NuGet.Protocol.Model;

namespace NuGet.Commands
{
    /// <summary>A class that caches the vulnerability database for a package source, so it only needs to be read once.</summary>
    internal interface IVulnerabilityInformationProvider
    {
        /// <summary>Get the vulnerability database for the package source.</summary>
        /// <param name="cancellationToken">A cancelation token to cancel the operation.</param>
        /// <returns>null if the package source doesn't contain any vulnerability data, or the result if it does.</returns>
        Task<GetVulnerabilityInfoResult?> GetVulnerabilityInformationAsync(CancellationToken cancellationToken);
    }
}
