# Process for Updating source-build for 2.1

## Source Build Repo Structure

The source-build repo pulls together all of the repos used to build the dotnet core product and builds them in succession to establish a baseline of packages needed.  It then packages all source into a tarball that can be used by partner teams to build from source.

The following are the key source-build sub-directories:

* patches - Contains a directory for each repo that requires patches to its source to build correctly.
* repos - Contains projects, props and targets to orchestrate the build, including one project for each repo.  \<RepositoryReference> tags are used to identify dependencies between repositories.  The cli project is the top-level project, which rolls up all others.
* src - Contains a submodule for each repo.

## Build Stages

The source-build process consists of 3 main stages:

1. **Build source-build repo**

    * Install tools (CLI and BuildTools)
    * Apply temporary patches to repos as applicable
    * Build each repo

1. **Generate tarball**
    * Copy Tools to tarball
    * Copy sources to tarball
        * Create prebuilt packages directory
        * Copy each restored package to the prebuilt directory
        * Remove any packages generated as part of the source-build build

1. **Build tarball in an offline environment**

## Auto-dependency flow API

Source-build defines a set of properties to assist in building and placing output.  These are:

* `DotNetPackageVersionPropsPath` - To identify the versions of built pacakges to depend on.
* `DotNetBuildFromSource` - Identifies that the build is from source-build.  Both online and offline builds will have this defined.
* `DotNetBuildOffline` - Identifies that build is intended to be offline.
* `DotNetRestoreSourcePropsPath` - Where to restore packages from during build.
* `DotNetOutputBlobFeedDir` - Where to place output during build.

These are defined in [Auto-dependency flow API](https://github.com/dotnet/source-build/blob/dev/release/2.1/Documentation/auto-dependency-flow/api.md)

## Updating Source-build for 2.1

### 2.1-Specific Source-build Goals

Source-build has been updated to the commit SHAs identified in the 2.1-preview1 prodcon build.  The goal is to get source-build to build correctly with these SHAs.  Once that is complete, we can enable auto-update of commit SHAs from each successful prodcon build and ensure that source-build doesn't get out of sync.  To take a measured approach to onboarding repos, a known good project has been defined which contains the repos that can successfully build in source-build.  The goal with the 2.1 exercise is to add repos to the known-good project and get them to build correctly.

### Repo Owners Responsibilities

Within these three stages, these are the things for repo owners to validate to ensure their repos are buildng correctly.

* Make sure the 2.1-preview1 commit SHA matches what we shipped in preview1 or is a later SHA from the 2.1 release branch that is expected to ship in the next release.
* Validate the build command used to build the repo (see source-build/repos/\<reponame>.proj)
* Incorporate logic from patches into the repo code base to eliminate patches in source-build
* Ensure that packages restored during stage 1 build are archived at either:
  * `$NUGET_PACKAGES` (bin/obj/x64/Release/nuget-packages/\<reponame>) or
  * \<root>/packages
* Ensure built packages end up in `$(DotNetOutputBlobFeedDir)packages/`
* Ensure that dependency versions for repo dependencies are picked up from `$(DotNetPackageVersionPropsPath)`
* Ensure that all other dependent packages are picked up from `$(DotNetRestoreSourcePropsPath)`.  This is the only place that packages can be restored from during the offline build!
* Ensure that the repo builds from the tarball in offline mode.
