use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestRequest;
use Apache::TestUtil;
use Apache::TestConfig ();

my $tests = 3;
my $server_suppresses_interim = 1;
if (!have_min_apache_version("2.4.10")) { 
  $tests = 1;
  $server_suppresses_interim = 0;
}

plan tests => $tests, need_module 'proxy';

Apache::TestRequest::module("proxy_http_reverse");
Apache::TestRequest::user_agent(requests_redirectable => 0);

my $r = GET("/reverse/");
ok t_cmp($r->code, 200, "reverse proxy to index.html");
if (have_cgi) {
  if ($server_suppresses_interim) {
        # XXX: This doesn't work in 2.2.x w/o at least r1588519 because LWP 
        # sees the unexpected interim response and stops.
        $r = GET("/reverse/modules/cgi/nph-interim1.pl");
        ok t_cmp($r->code, 200, "small number of interim responses - CVE-2008-2364");

        $r = GET("/reverse/modules/cgi/nph-interim2.pl");
        ok t_cmp($r->code, 502, "large number of interim responses - CVE-2008-2364");
  }
} else {
    skip "skipping tests without CGI module" foreach (1..2);
}

