/* The following code was generated by CSFlex 1.4 on 08/12/2005 */

#line 1 "csharp.flex"
/*
	[The "BSD licence"]
	Copyright (c) 2002-2005 Kunle Odutola
	All rights reserved.
	
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:
	1. Redistributions of source code MUST RETAIN the above copyright
	   notice, this list of conditions and the following disclaimer.
	2. Redistributions in binary form MUST REPRODUCE the above copyright
	   notice, this list of conditions and the following disclaimer in 
	   the documentation and/or other materials provided with the 
	   distribution.
	3. The name of the author may not be used to endorse or promote products
	   derived from this software without specific prior WRITTEN permission.
	
	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
	IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
	NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
	DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
	THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

namespace Kunle.CSharpParser
{
	using System;
	using System.IO;
	using System.Text;
	using System.Globalization;
	using antlr;
	using symID = CSharpTokenTypes;

	/// <summary>
	/// A Lexer for the C# language including preprocessors directives.
	/// </summary>
	///
	/// <remarks>
	/// <para>
	/// The Lexer defined below is based on the "C# Language Specification" as 
	/// documented in the ECMA-334 standard dated December 2001.
	/// </para>
	///
	/// <para>
	/// History
	/// </para>
	///
	/// <para>
	/// 01-Dec-2005 kunle	  Created lexer from ECMA spec <br />
	/// </para>
	///
	/// </remarks>

#line default
/**
 * This class is a scanner generated by <a href="http://www.sourceforge.net/projects/csflex/">C# Flex</a>, based on
 * <a href="http://www.jflex.de/">JFlex</a>, version 1.4
 * on 08/12/2005 from the specification file
 * <tt>csharp.flex</tt>
 */
public sealed class CSharpFlexLexer: TokenStream {

  /** This character denotes the end of file */
  public const int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private const int ZZ_BUFFERSIZE = 16384;
  /**
   * This is used in 'if' statements to eliminate dead code
   * warnings for 'break;' after the end of a user action
   * block of code. The Java version does this by emitting
   * a second 'case' which is impossible to reach. Since this
   * is impossible for the compiler to deduce during semantic
   * analysis, the warning is stifled. However, C# does not
   * permit 'case' blocks to flow into each other, so the C#
   * output mode needs a different approach. In this case,
   * the entire user code is wrapped up in an 'if' statement
   * whose condition is always true. No warning is emitted
   * because the compiler doesn't strictly propagate the value
   * of 'static readonly' fields, and thus does not semantically
   * detect the fact that the 'if' will always be true.
   */
   public static readonly bool ZZ_SPURIOUS_WARNINGS_SUCK = true;

  /** lexical states */
  public const int YYINITIAL_PP = 8;
  public const int YYINITIAL_CHAR = 6;
  public const int YYINITIAL_VERBATIM = 4;
  public const int PP_HOOVER = 12;
  public const int YYINITIAL_STRING = 2;
  public const int YYINITIAL = 0;
  public const int PP_SYMBOLS = 10;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static readonly int[] ZZ_LEXSTATE = new int[]{ 
     0,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7, 7
  };
  static CSharpFlexLexer()
  {
    ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);
    ZZ_ACTION = zzUnpackAction();
    ZZ_ROWMAP = zzUnpackRowMap();
    ZZ_TRANS = zzUnpackTrans();
    ZZ_ATTRIBUTE = zzUnpackAttribute();
  }


  /** 
   * Translates characters to character classes
   */
  private static readonly ushort[] ZZ_CMAP_PACKED = new ushort[] {
    9, 3, 1, 1, 1, 5, 2, 1, 1, 4, 14, 3, 4, 0, 1, 1, 1, 52, 1, 25,
    1, 26, 1, 2, 1, 64, 1, 53, 1, 24, 1, 50, 1, 51, 1, 8, 1, 63, 1, 60,
    1, 18, 1, 19, 1, 7, 1, 14, 9, 10, 1, 61, 1, 62, 1, 67, 1, 55, 1, 68,
    1, 69, 1, 70, 3, 9, 1, 20, 1, 17, 1, 21, 5, 2, 1, 16, 1, 22, 7, 2,
    1, 13, 2, 2, 1, 15, 2, 2, 1, 58, 1, 11, 1, 59, 1, 65, 1, 2, 1, 0,
    1, 31, 1, 35, 1, 36, 1, 34, 1, 29, 1, 30, 1, 44, 1, 40, 1, 42, 1, 48,
    1, 38, 1, 32, 1, 43, 1, 41, 1, 37, 1, 46, 1, 2, 1, 28, 1, 33, 1, 27,
    1, 12, 1, 45, 1, 47, 1, 23, 1, 39, 1, 49, 1, 56, 1, 54, 1, 57, 1, 66,
    33, 3, 1, 1, 1, 0, 4, 2, 4, 0, 1, 2, 7, 0, 2, 3, 1, 0, 1, 2,
    3, 0, 1, 3, 1, 2, 5, 0, 23, 2, 1, 0, 31, 2, 1, 0, 0x0128, 2, 2, 0,
    18, 2, 28, 0, 94, 2, 2, 0, 9, 2, 2, 0, 7, 2, 14, 0, 2, 2, 14, 0,
    5, 2, 9, 0, 1, 2, 17, 0, 70, 3, 26, 0, 2, 3, 24, 0, 1, 2, 11, 0,
    1, 2, 1, 0, 3, 2, 1, 0, 1, 2, 1, 0, 20, 2, 1, 0, 44, 2, 1, 0,
    8, 2, 2, 0, 26, 2, 12, 0, 130, 2, 1, 0, 4, 3, 5, 0, 57, 2, 2, 0,
    2, 2, 2, 0, 2, 2, 3, 0, 38, 2, 2, 0, 2, 2, 55, 0, 38, 2, 2, 0,
    1, 2, 7, 0, 39, 2, 9, 0, 41, 3, 1, 0, 3, 3, 1, 0, 1, 3, 1, 0,
    2, 3, 1, 0, 1, 3, 11, 0, 27, 2, 5, 0, 3, 2, 46, 0, 26, 2, 5, 0,
    11, 2, 8, 3, 13, 0, 10, 3, 6, 0, 1, 3, 99, 2, 1, 0, 1, 2, 7, 3,
    2, 0, 6, 3, 2, 2, 2, 3, 1, 0, 4, 3, 2, 0, 10, 3, 3, 2, 19, 0,
    1, 2, 1, 0, 27, 2, 83, 0, 38, 2, 0x015b, 0, 3, 3, 1, 0, 53, 2, 2, 0,
    1, 3, 1, 2, 16, 3, 2, 0, 1, 2, 4, 3, 3, 0, 10, 2, 2, 3, 2, 0,
    10, 3, 17, 0, 3, 3, 1, 0, 8, 2, 2, 0, 2, 2, 2, 0, 22, 2, 1, 0,
    7, 2, 1, 0, 1, 2, 3, 0, 4, 2, 2, 0, 1, 3, 1, 0, 7, 3, 2, 0,
    2, 3, 2, 0, 3, 3, 9, 0, 1, 3, 4, 0, 2, 2, 1, 0, 3, 2, 2, 3,
    2, 0, 10, 3, 4, 2, 4, 3, 1, 0, 1, 3, 8, 0, 1, 3, 2, 0, 6, 2,
    4, 0, 2, 2, 2, 0, 22, 2, 1, 0, 7, 2, 1, 0, 2, 2, 1, 0, 2, 2,
    1, 0, 2, 2, 2, 0, 1, 3, 1, 0, 5, 3, 4, 0, 2, 3, 2, 0, 3, 3,
    11, 0, 4, 2, 1, 0, 1, 2, 7, 0, 12, 3, 3, 2, 12, 0, 3, 3, 1, 0,
    7, 2, 1, 0, 1, 2, 1, 0, 3, 2, 1, 0, 22, 2, 1, 0, 7, 2, 1, 0,
    2, 2, 1, 0, 5, 2, 2, 0, 1, 3, 1, 2, 8, 3, 1, 0, 3, 3, 1, 0,
    3, 3, 2, 0, 1, 2, 15, 0, 1, 2, 5, 0, 10, 3, 17, 0, 3, 3, 1, 0,
    8, 2, 2, 0, 2, 2, 2, 0, 22, 2, 1, 0, 7, 2, 1, 0, 2, 2, 2, 0,
    4, 2, 2, 0, 1, 3, 1, 2, 6, 3, 3, 0, 7, 3, 8, 0, 2, 3, 4, 0,
    2, 2, 1, 0, 3, 2, 4, 0, 10, 3, 18, 0, 2, 3, 1, 0, 6, 2, 3, 0,
    3, 2, 1, 0, 4, 2, 3, 0, 2, 2, 1, 0, 1, 2, 1, 0, 2, 2, 3, 0,
    2, 2, 3, 0, 3, 2, 3, 0, 8, 2, 1, 0, 3, 2, 4, 0, 71, 3, 8, 2,
    1, 3, 3, 2, 1, 3, 23, 2, 1, 3, 10, 2, 1, 3, 5, 2, 11, 3, 1, 0,
    3, 3, 1, 0, 4, 3, 7, 0, 2, 3, 9, 0, 2, 2, 4, 0, 10, 3, 18, 0,
    2, 3, 1, 0, 8, 2, 1, 0, 3, 2, 1, 0, 23, 2, 1, 0, 10, 2, 1, 0,
    5, 2, 4, 0, 7, 3, 1, 0, 3, 3, 1, 0, 4, 3, 7, 0, 2, 3, 7, 0,
    1, 2, 1, 0, 2, 2, 4, 0, 10, 3, 18, 0, 2, 3, 1, 0, 8, 2, 1, 0,
    3, 2, 1, 0, 23, 2, 1, 0, 16, 2, 4, 0, 6, 3, 2, 0, 3, 3, 1, 0,
    4, 3, 9, 0, 1, 3, 8, 0, 2, 2, 4, 0, 10, 3, 21, 0, 18, 2, 3, 0,
    24, 2, 1, 0, 9, 2, 1, 0, 1, 2, 2, 0, 7, 2, 58, 0, 48, 2, 1, 3,
    2, 2, 7, 3, 4, 0, 8, 2, 8, 3, 1, 0, 10, 3, 39, 0, 2, 2, 1, 0,
    1, 2, 2, 0, 2, 2, 1, 0, 1, 2, 2, 0, 1, 2, 6, 0, 4, 2, 1, 0,
    7, 2, 1, 0, 3, 2, 1, 0, 1, 2, 1, 0, 1, 2, 2, 0, 2, 2, 1, 0,
    4, 2, 1, 3, 2, 2, 6, 3, 1, 0, 2, 3, 1, 2, 2, 0, 5, 2, 1, 0,
    1, 2, 1, 0, 6, 3, 2, 0, 10, 3, 2, 0, 2, 2, 34, 0, 1, 2, 23, 0,
    2, 3, 6, 0, 10, 3, 11, 0, 1, 3, 1, 0, 1, 3, 1, 0, 1, 3, 4, 0,
    2, 3, 8, 2, 1, 0, 34, 2, 6, 0, 23, 3, 4, 2, 4, 0, 6, 3, 1, 0,
    1, 3, 1, 0, 21, 3, 3, 0, 7, 3, 1, 0, 1, 3, 70, 0, 34, 2, 1, 0,
    5, 2, 1, 0, 2, 2, 37, 0, 6, 2, 74, 0, 38, 2, 10, 0, 39, 2, 9, 0,
    90, 2, 5, 0, 68, 2, 5, 0, 82, 2, 6, 0, 7, 2, 1, 0, 63, 2, 1, 0,
    1, 2, 1, 0, 4, 2, 2, 0, 7, 2, 1, 0, 1, 2, 1, 0, 4, 2, 2, 0,
    39, 2, 1, 0, 1, 2, 1, 0, 4, 2, 2, 0, 31, 2, 1, 0, 1, 2, 1, 0,
    4, 2, 2, 0, 7, 2, 1, 0, 1, 2, 1, 0, 4, 2, 2, 0, 7, 2, 1, 0,
    7, 2, 1, 0, 23, 2, 1, 0, 31, 2, 1, 0, 1, 2, 1, 0, 4, 2, 2, 0,
    7, 2, 1, 0, 39, 2, 1, 0, 19, 2, 69, 0, 85, 2, 12, 0, 0x026c, 2, 2, 0,
    8, 2, 9, 0, 1, 1, 26, 2, 5, 0, 75, 2, 149, 0, 52, 2, 108, 0, 88, 2,
    8, 0, 41, 2, 0x0557, 0, 156, 2, 4, 0, 90, 2, 6, 0, 22, 2, 2, 0, 6, 2,
    2, 0, 38, 2, 2, 0, 6, 2, 2, 0, 8, 2, 1, 0, 1, 2, 1, 0, 1, 2,
    1, 0, 1, 2, 1, 0, 31, 2, 2, 0, 53, 2, 1, 0, 7, 2, 1, 0, 1, 2,
    3, 0, 3, 2, 1, 0, 7, 2, 3, 0, 4, 2, 2, 0, 6, 2, 4, 0, 13, 2,
    5, 0, 3, 2, 1, 0, 7, 2, 3, 0, 12, 1, 4, 3, 24, 0, 1, 6, 1, 6,
    5, 3, 1, 1, 15, 0, 2, 2, 30, 0, 1, 1, 10, 0, 7, 3, 3, 0, 6, 3,
    5, 0, 1, 2, 10, 3, 22, 0, 12, 2, 36, 0, 13, 3, 4, 0, 1, 3, 32, 0,
    1, 2, 4, 0, 1, 2, 2, 0, 10, 2, 1, 0, 1, 2, 3, 0, 5, 2, 6, 0,
    1, 2, 1, 0, 1, 2, 1, 0, 1, 2, 1, 0, 4, 2, 1, 0, 3, 2, 1, 0,
    7, 2, 37, 0, 36, 3, 0x02dd, 0, 60, 3, 78, 0, 1, 3, 0x028b, 0, 30, 3, 0x086c, 0,
    1, 1, 4, 0, 2, 2, 1, 3, 25, 0, 15, 3, 1, 0, 5, 2, 11, 0, 84, 2,
    4, 0, 2, 3, 2, 0, 2, 2, 2, 0, 90, 2, 1, 0, 3, 2, 6, 0, 40, 2,
    4, 0, 94, 2, 17, 0, 24, 2, 200, 0, 10, 3, 0x0176, 0, 0x19b6, 2, 74, 0, 0x51a6, 2,
    90, 0, 0x048d, 2, 0x0773, 0, 0x2ba4, 2, 0x215c, 0, 0x012e, 2, 210, 0, 7, 2, 12, 0, 5, 2,
    5, 0, 1, 2, 1, 0, 10, 2, 1, 0, 13, 2, 1, 0, 5, 2, 1, 0, 1, 2,
    1, 0, 2, 2, 1, 0, 2, 2, 1, 0, 108, 2, 33, 0, 0x016b, 2, 18, 0, 64, 2,
    2, 0, 54, 2, 40, 0, 12, 2, 55, 0, 2, 2, 24, 0, 3, 2, 25, 0, 1, 2,
    6, 0, 3, 2, 1, 0, 1, 2, 1, 0, 135, 2, 2, 0, 1, 3, 4, 0, 1, 2,
    11, 0, 10, 3, 7, 0, 26, 2, 4, 0, 1, 2, 1, 0, 26, 2, 11, 0, 89, 2,
    3, 0, 6, 2, 2, 0, 6, 2, 2, 0, 6, 2, 2, 0, 3, 2, 3, 0, 2, 2,
    3, 0, 2, 2, 25, 0, 0 };

  /** 
   * Translates characters to character classes
   */
  private static readonly char[] ZZ_CMAP;

  /** 
   * Translates DFA states to action switch labels.
   */
  private static readonly int [] ZZ_ACTION;

  private static readonly ushort[] ZZ_ACTION_PACKED_0 = new ushort[] {
    8, 0, 1, 1, 1, 2, 1, 3, 2, 4, 1, 5, 1, 6, 1, 7,
    1, 3, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 18, 3, 1, 12,
    1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 19, 1, 20,
    1, 21, 1, 22, 1, 23, 1, 24, 1, 25, 1, 26, 1, 27, 1, 28,
    1, 29, 1, 30, 1, 31, 1, 1, 1, 2, 1, 32, 1, 33, 3, 34,
    1, 35, 1, 36, 1, 37, 1, 38, 3, 39, 9, 40, 1, 41, 1, 42,
    1, 43, 2, 44, 1, 41, 1, 45, 1, 41, 3, 43, 1, 46, 1, 47,
    1, 48, 3, 41, 1, 49, 1, 50, 2, 51, 4, 49, 1, 52, 1, 0,
    1, 53, 1, 54, 1, 55, 1, 56, 2, 0, 1, 57, 1, 58, 1, 59,
    4, 3, 1, 0, 1, 60, 1, 61, 1, 62, 1, 57, 12, 3, 1, 63,
    10, 3, 1, 64, 15, 3, 1, 65, 1, 66, 1, 67, 11, 3, 1, 68,
    1, 69, 1, 70, 1, 71, 1, 72, 1, 73, 1, 74, 1, 75, 1, 76,
    1, 77, 1, 78, 1, 79, 1, 80, 1, 81, 1, 82, 1, 83, 1, 84,
    1, 85, 2, 84, 1, 86, 1, 84, 1, 87, 1, 88, 1, 89, 1, 90,
    1, 91, 1, 92, 1, 93, 1, 94, 1, 95, 1, 96, 15, 97, 7, 0,
    1, 98, 1, 0, 1, 99, 1, 0, 1, 100, 3, 43, 1, 101, 1, 102,
    1, 103, 1, 104, 1, 105, 3, 0, 2, 52, 1, 0, 1, 106, 1, 57,
    1, 0, 6, 3, 1, 7, 1, 3, 1, 107, 4, 3, 1, 108, 9, 3,
    1, 109, 4, 3, 1, 110, 5, 3, 1, 111, 19, 3, 1, 112, 4, 3,
    1, 113, 1, 3, 1, 114, 3, 3, 1, 115, 9, 3, 1, 116, 1, 117,
    1, 0, 2, 118, 1, 119, 1, 120, 3, 0, 1, 121, 1, 0, 1, 122,
    1, 123, 1, 124, 1, 125, 1, 126, 1, 127, 1, 128, 1, 129, 1, 130,
    9, 0, 2, 99, 3, 43, 2, 105, 3, 0, 1, 131, 5, 3, 1, 132,
    1, 133, 1, 134, 1, 3, 1, 135, 5, 3, 1, 136, 1, 137, 9, 3,
    1, 138, 1, 139, 14, 3, 1, 140, 1, 141, 1, 142, 1, 3, 1, 143,
    4, 3, 1, 144, 3, 3, 1, 145, 5, 3, 1, 146, 1, 3, 1, 147,
    7, 3, 1, 0, 2, 118, 1, 119, 2, 0, 1, 148, 2, 0, 1, 149,
    3, 0, 1, 150, 1, 151, 2, 0, 1, 152, 2, 0, 1, 133, 2, 43,
    1, 133, 2, 0, 1, 153, 1, 3, 1, 154, 3, 3, 1, 155, 5, 3,
    1, 156, 1, 157, 1, 158, 1, 3, 1, 159, 1, 160, 8, 3, 1, 161,
    1, 162, 6, 3, 1, 163, 1, 164, 1, 165, 1, 3, 1, 166, 15, 3,
    1, 167, 1, 168, 1, 0, 2, 118, 1, 119, 4, 0, 1, 169, 1, 0,
    1, 170, 1, 0, 1, 171, 2, 0, 1, 157, 1, 43, 1, 157, 1, 0,
    1, 172, 1, 173, 1, 3, 1, 174, 1, 175, 1, 3, 1, 176, 1, 177,
    5, 3, 1, 178, 1, 179, 1, 180, 1, 3, 1, 181, 1, 182, 1, 183,
    3, 3, 1, 184, 2, 3, 1, 185, 6, 3, 1, 186, 1, 187, 2, 3,
    1, 188, 3, 3, 1, 189, 1, 190, 2, 118, 1, 119, 4, 0, 1, 191,
    1, 0, 1, 192, 1, 0, 1, 43, 1, 0, 3, 3, 1, 193, 1, 194,
    3, 3, 1, 195, 1, 3, 1, 196, 1, 3, 1, 197, 7, 3, 1, 198,
    2, 3, 1, 199, 1, 200, 1, 0, 1, 201, 2, 195, 1, 3, 1, 202,
    1, 203, 1, 204, 1, 205, 1, 3, 1, 206, 1, 207, 1, 208, 1, 209,
    2, 3, 1, 210, 1, 211, 1, 212, 1, 3, 1, 213, 1, 0, 1, 214,
    1, 3, 1, 215, 1, 216, 1, 217, 1, 218, 1, 219, 0 };

  private static int [] zzUnpackAction() {
    int [] result = new int[655];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(ushort[] packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.Length;
    while (i + 1 < l) {
      int count = packed[i++];
      int value = packed[i++];
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static readonly int [] ZZ_ROWMAP;

  private static readonly ushort[] ZZ_ROWMAP_PACKED_0 = new ushort[] {
    0, 0, 0, 71, 0, 142, 0, 213, 0, 0x011c, 0, 0x0163, 0, 0x01aa, 0, 0x01f1,
    0, 0x0238, 0, 0x027f, 0, 0x02c6, 0, 0x030d, 0, 0x0238, 0, 0x0354, 0, 0x039b, 0, 0x03e2,
    0, 0x0429, 0, 0x0470, 0, 0x04b7, 0, 0x04fe, 0, 0x0238, 0, 0x0238, 0, 0x0545, 0, 0x058c,
    0, 0x05d3, 0, 0x061a, 0, 0x0661, 0, 0x06a8, 0, 0x06ef, 0, 0x0736, 0, 0x077d, 0, 0x07c4,
    0, 0x080b, 0, 0x0852, 0, 0x0899, 0, 0x08e0, 0, 0x0927, 0, 0x096e, 0, 0x09b5, 0, 0x09fc,
    0, 0x0238, 0, 0x0238, 0, 0x0a43, 0, 0x0a8a, 0, 0x0ad1, 0, 0x0b18, 0, 0x0238, 0, 0x0238,
    0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0b5f, 0, 0x0ba6, 0, 0x0bed,
    0, 0x0238, 0, 0x0c34, 0, 0x0c7b, 0, 0x0238, 0, 0x0cc2, 0, 0x0d09, 0, 0x0d50, 0, 0x0d97,
    0, 0x0dde, 0, 0x0238, 0, 0x0e25, 0, 0x0238, 0, 0x0e6c, 0, 0x0eb3, 0, 0x0238, 0, 0x0efa,
    0, 0x0238, 0, 0x0f41, 0, 0x0238, 0, 0x0f88, 0, 0x0fcf, 0, 0x1016, 0, 0x105d, 0, 0x10a4,
    0, 0x10eb, 0, 0x1132, 0, 0x1179, 0, 0x0238, 0, 0x11c0, 0, 0x1207, 0, 0x124e, 0, 0x0238,
    0, 0x1295, 0, 0x12dc, 0, 0x1323, 0, 0x136a, 0, 0x13b1, 0, 0x13f8, 0, 0x0238, 0, 0x0238,
    0, 0x143f, 0, 0x1486, 0, 0x14cd, 0, 0x1514, 0, 0x0238, 0, 0x155b, 0, 0x15a2, 0, 0x0238,
    0, 0x15e9, 0, 0x1630, 0, 0x1677, 0, 0x16be, 0, 0x1705, 0, 0x174c, 0, 0x0238, 0, 0x0238,
    0, 0x1793, 0, 0x17da, 0, 0x1821, 0, 0x04fe, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x1868,
    0, 0x18af, 0, 0x18f6, 0, 0x193d, 0, 0x1984, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x19cb,
    0, 0x1a12, 0, 0x1a59, 0, 0x1aa0, 0, 0x1ae7, 0, 0x1b2e, 0, 0x1b75, 0, 0x1bbc, 0, 0x1c03,
    0, 0x1c4a, 0, 0x1c91, 0, 0x1cd8, 0, 0x1d1f, 0, 0x1d66, 0, 0x1dad, 0, 0x1df4, 0, 0x1e3b,
    0, 0x1e82, 0, 0x1ec9, 0, 0x1f10, 0, 0x1f57, 0, 0x1f9e, 0, 0x1fe5, 0, 0x202c, 0, 0x2073,
    0, 0x20ba, 0, 0x2101, 0, 0x2148, 0, 0x218f, 0, 0x21d6, 0, 0x221d, 0, 0x2264, 0, 0x22ab,
    0, 0x22f2, 0, 0x2339, 0, 0x2380, 0, 0x23c7, 0, 0x240e, 0, 0x2455, 0, 0x249c, 0, 0x02c6,
    0, 0x02c6, 0, 0x24e3, 0, 0x252a, 0, 0x2571, 0, 0x25b8, 0, 0x25ff, 0, 0x2646, 0, 0x268d,
    0, 0x26d4, 0, 0x271b, 0, 0x2762, 0, 0x27a9, 0, 0x27f0, 0, 0x0238, 0, 0x0238, 0, 0x0238,
    0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238,
    0, 0x2837, 0, 0x0238, 0, 0x287e, 0, 0x28c5, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x290c,
    0, 0x2953, 0, 0x0238, 0, 0x299a, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238,
    0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x29e1, 0, 0x2a28,
    0, 0x2a6f, 0, 0x2ab6, 0, 0x2afd, 0, 0x2b44, 0, 0x2b8b, 0, 0x2bd2, 0, 0x2c19, 0, 0x2c60,
    0, 0x2ca7, 0, 0x2cee, 0, 0x2d35, 0, 0x2d7c, 0, 0x2dc3, 0, 0x2e0a, 0, 0x2e51, 0, 0x2e98,
    0, 0x2edf, 0, 0x2f26, 0, 0x2f6d, 0, 0x0238, 0, 0x2fb4, 0, 0x2ffb, 0, 0x1323, 0, 0x0238,
    0, 0x3042, 0, 0x3089, 0, 0x30d0, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x3117,
    0, 0x315e, 0, 0x31a5, 0, 0x31ec, 0, 0x3233, 0, 0x0238, 0, 0x327a, 0, 0x0238, 0, 0x32c1,
    0, 0x3308, 0, 0x334f, 0, 0x3396, 0, 0x33dd, 0, 0x3424, 0, 0x346b, 0, 0x34b2, 0, 0x34f9,
    0, 0x3540, 0, 0x02c6, 0, 0x3587, 0, 0x35ce, 0, 0x3615, 0, 0x365c, 0, 0x02c6, 0, 0x36a3,
    0, 0x36ea, 0, 0x3731, 0, 0x3778, 0, 0x37bf, 0, 0x3806, 0, 0x384d, 0, 0x3894, 0, 0x38db,
    0, 0x3922, 0, 0x3969, 0, 0x39b0, 0, 0x39f7, 0, 0x3a3e, 0, 0x02c6, 0, 0x3a85, 0, 0x3acc,
    0, 0x3b13, 0, 0x3b5a, 0, 0x3ba1, 0, 0x02c6, 0, 0x3be8, 0, 0x3c2f, 0, 0x3c76, 0, 0x3cbd,
    0, 0x3d04, 0, 0x3d4b, 0, 0x3d92, 0, 0x3dd9, 0, 0x3e20, 0, 0x3e67, 0, 0x3eae, 0, 0x3ef5,
    0, 0x3f3c, 0, 0x3f83, 0, 0x3fca, 0, 0x4011, 0, 0x4058, 0, 0x409f, 0, 0x40e6, 0, 0x02c6,
    0, 0x412d, 0, 0x4174, 0, 0x41bb, 0, 0x4202, 0, 0x02c6, 0, 0x4249, 0, 0x4290, 0, 0x42d7,
    0, 0x431e, 0, 0x4365, 0, 0x02c6, 0, 0x43ac, 0, 0x43f3, 0, 0x443a, 0, 0x4481, 0, 0x44c8,
    0, 0x450f, 0, 0x4556, 0, 0x459d, 0, 0x45e4, 0, 0x0238, 0, 0x0238, 0, 0x462b, 0, 0x4672,
    0, 0x46b9, 0, 0x4700, 0, 0x0238, 0, 0x4747, 0, 0x478e, 0, 0x47d5, 0, 0x0238, 0, 0x481c,
    0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238, 0, 0x0238,
    0, 0x0238, 0, 0x4863, 0, 0x48aa, 0, 0x48f1, 0, 0x4938, 0, 0x497f, 0, 0x49c6, 0, 0x4a0d,
    0, 0x4a54, 0, 0x4a9b, 0, 0x4ae2, 0, 0x0238, 0, 0x4b29, 0, 0x4b70, 0, 0x4bb7, 0, 0x4bfe,
    0, 0x0238, 0, 0x4c45, 0, 0x4c8c, 0, 0x4cd3, 0, 0x0238, 0, 0x4d1a, 0, 0x4d61, 0, 0x4da8,
    0, 0x4def, 0, 0x4e36, 0, 0x02c6, 0, 0x02c6, 0, 0x4e7d, 0, 0x4ec4, 0, 0x02c6, 0, 0x4f0b,
    0, 0x4f52, 0, 0x4f99, 0, 0x4fe0, 0, 0x5027, 0, 0x02c6, 0, 0x02c6, 0, 0x506e, 0, 0x50b5,
    0, 0x50fc, 0, 0x5143, 0, 0x518a, 0, 0x51d1, 0, 0x5218, 0, 0x525f, 0, 0x52a6, 0, 0x02c6,
    0, 0x02c6, 0, 0x52ed, 0, 0x5334, 0, 0x537b, 0, 0x53c2, 0, 0x5409, 0, 0x5450, 0, 0x5497,
    0, 0x54de, 0, 0x5525, 0, 0x556c, 0, 0x55b3, 0, 0x55fa, 0, 0x5641, 0, 0x5688, 0, 0x02c6,
    0, 0x02c6, 0, 0x02c6, 0, 0x56cf, 0, 0x02c6, 0, 0x5716, 0, 0x575d, 0, 0x57a4, 0, 0x57eb,
    0, 0x02c6, 0, 0x5832, 0, 0x5879, 0, 0x58c0, 0, 0x02c6, 0, 0x5907, 0, 0x594e, 0, 0x5995,
    0, 0x59dc, 0, 0x5a23, 0, 0x02c6, 0, 0x5a6a, 0, 0x02c6, 0, 0x5ab1, 0, 0x5af8, 0, 0x5b3f,
    0, 0x5b86, 0, 0x5bcd, 0, 0x5c14, 0, 0x5c5b, 0, 0x5ca2, 0, 0x5ce9, 0, 0x5d30, 0, 0x5d77,
    0, 0x5dbe, 0, 0x5e05, 0, 0x0238, 0, 0x5e4c, 0, 0x5e93, 0, 0x0238, 0, 0x5eda, 0, 0x5f21,
    0, 0x5f68, 0, 0x0238, 0, 0x0238, 0, 0x5faf, 0, 0x5ff6, 0, 0x0238, 0, 0x603d, 0, 0x6084,
    0, 0x1207, 0, 0x60cb, 0, 0x6112, 0, 0x0238, 0, 0x6159, 0, 0x61a0, 0, 0x02c6, 0, 0x61e7,
    0, 0x02c6, 0, 0x622e, 0, 0x6275, 0, 0x62bc, 0, 0x02c6, 0, 0x6303, 0, 0x634a, 0, 0x6391,
    0, 0x63d8, 0, 0x641f, 0, 0x02c6, 0, 0x02c6, 0, 0x02c6, 0, 0x6466, 0, 0x02c6, 0, 0x02c6,
    0, 0x64ad, 0, 0x64f4, 0, 0x653b, 0, 0x6582, 0, 0x65c9, 0, 0x6610, 0, 0x6657, 0, 0x669e,
    0, 0x02c6, 0, 0x02c6, 0, 0x66e5, 0, 0x672c, 0, 0x6773, 0, 0x67ba, 0, 0x6801, 0, 0x6848,
    0, 0x02c6, 0, 0x02c6, 0, 0x02c6, 0, 0x688f, 0, 0x02c6, 0, 0x68d6, 0, 0x691d, 0, 0x6964,
    0, 0x69ab, 0, 0x69f2, 0, 0x6a39, 0, 0x6a80, 0, 0x6ac7, 0, 0x6b0e, 0, 0x6b55, 0, 0x6b9c,
    0, 0x6be3, 0, 0x6c2a, 0, 0x6c71, 0, 0x6cb8, 0, 0x6cff, 0, 0x02c6, 0, 0x6d46, 0, 0x6d8d,
    0, 0x6dd4, 0, 0x6e1b, 0, 0x6e62, 0, 0x6ea9, 0, 0x6ef0, 0, 0x6f37, 0, 0x0238, 0, 0x6f7e,
    0, 0x0238, 0, 0x6fc5, 0, 0x0238, 0, 0x700c, 0, 0x7053, 0, 0x1207, 0, 0x709a, 0, 0x0238,
    0, 0x70e1, 0, 0x02c6, 0, 0x02c6, 0, 0x7128, 0, 0x02c6, 0, 0x02c6, 0, 0x716f, 0, 0x02c6,
    0, 0x02c6, 0, 0x71b6, 0, 0x71fd, 0, 0x7244, 0, 0x728b, 0, 0x72d2, 0, 0x02c6, 0, 0x02c6,
    0, 0x02c6, 0, 0x7319, 0, 0x02c6, 0, 0x02c6, 0, 0x02c6, 0, 0x7360, 0, 0x73a7, 0, 0x73ee,
    0, 0x02c6, 0, 0x7435, 0, 0x747c, 0, 0x02c6, 0, 0x74c3, 0, 0x750a, 0, 0x7551, 0, 0x7598,
    0, 0x75df, 0, 0x7626, 0, 0x02c6, 0, 0x02c6, 0, 0x766d, 0, 0x76b4, 0, 0x02c6, 0, 0x76fb,
    0, 0x7742, 0, 0x7789, 0, 0x02c6, 0, 0x0238, 0, 0x0238, 0, 0x77d0, 0, 0x0238, 0, 0x7817,
    0, 0x785e, 0, 0x78a5, 0, 0x78ec, 0, 0x0238, 0, 0x7933, 0, 0x0238, 0, 0x797a, 0, 0x79c1,
    0, 0x7a08, 0, 0x7a4f, 0, 0x7a96, 0, 0x7add, 0, 0x02c6, 0, 0x02c6, 0, 0x7b24, 0, 0x7b6b,
    0, 0x7bb2, 0, 0x02c6, 0, 0x7bf9, 0, 0x02c6, 0, 0x7c40, 0, 0x02c6, 0, 0x7c87, 0, 0x7cce,
    0, 0x7d15, 0, 0x7d5c, 0, 0x7da3, 0, 0x7dea, 0, 0x7e31, 0, 0x02c6, 0, 0x7e78, 0, 0x7ebf,
    0, 0x02c6, 0, 0x0238, 0, 0x7f06, 0, 0x0238, 0, 0x1207, 0, 0x0238, 0, 0x7f4d, 0, 0x02c6,
    0, 0x02c6, 0, 0x02c6, 0, 0x02c6, 0, 0x7f94, 0, 0x02c6, 0, 0x02c6, 0, 0x02c6, 0, 0x02c6,
    0, 0x7fdb, 0, 0x8022, 0, 0x02c6, 0, 0x02c6, 0, 0x02c6, 0, 0x8069, 0, 0x02c6, 0, 0x80b0,
    0, 0x02c6, 0, 0x80f7, 0, 0x02c6, 0, 0x02c6, 0, 0x02c6, 0, 0x0238, 0, 0x02c6, 0 };

  private static int [] zzUnpackRowMap() {
    int [] result = new int[655];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(ushort[] packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.Length;
    while (i + 1 < l) {
      int high = packed[i++] << 16;
      result[j++] = high | packed[i++];
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static readonly int [] ZZ_TRANS;

  private static readonly ushort[] ZZ_TRANS_PACKED_0 = new ushort[] {
    1, 9, 1, 10, 1, 11, 1, 9, 1, 12, 2, 13, 1, 14, 1, 15,
    1, 11, 1, 16, 1, 9, 1, 17, 1, 11, 1, 18, 3, 11, 1, 19,
    1, 20, 4, 11, 1, 21, 1, 22, 1, 9, 1, 23, 1, 24, 1, 25,
    1, 26, 1, 27, 1, 28, 1, 29, 1, 30, 1, 31, 1, 32, 1, 33,
    3, 11, 1, 34, 1, 35, 1, 36, 1, 37, 1, 38, 1, 39, 1, 40,
    2, 11, 1, 41, 1, 42, 1, 43, 1, 44, 1, 45, 1, 46, 1, 47,
    1, 48, 1, 49, 1, 50, 1, 51, 1, 52, 1, 53, 1, 54, 1, 55,
    1, 56, 1, 57, 1, 58, 1, 59, 1, 60, 1, 61, 1, 9, 1, 62,
    1, 11, 1, 9, 1, 12, 2, 13, 1, 14, 1, 15, 1, 11, 1, 16,
    1, 9, 1, 17, 1, 11, 1, 18, 3, 11, 1, 19, 1, 20, 4, 11,
    1, 21, 1, 22, 1, 63, 1, 23, 1, 24, 1, 25, 1, 26, 1, 27,
    1, 28, 1, 29, 1, 30, 1, 31, 1, 32, 1, 33, 3, 11, 1, 34,
    1, 35, 1, 36, 1, 37, 1, 38, 1, 39, 1, 40, 2, 11, 1, 41,
    1, 42, 1, 43, 1, 44, 1, 45, 1, 46, 1, 47, 1, 48, 1, 49,
    1, 50, 1, 51, 1, 52, 1, 53, 1, 54, 1, 55, 1, 56, 1, 57,
    1, 58, 1, 59, 1, 60, 1, 61, 4, 64, 1, 65, 2, 66, 4, 64,
    1, 67, 13, 64, 1, 68, 45, 64, 25, 69, 1, 70, 45, 69, 4, 71,
    1, 72, 2, 73, 4, 71, 1, 74, 12, 71, 1, 73, 46, 71, 4, 75,
    1, 76, 7, 75, 1, 77, 15, 75, 1, 78, 1, 79, 2, 75, 1, 80,
    1, 75, 1, 81, 7, 75, 1, 82, 4, 75, 1, 83, 23, 75, 1, 84,
    1, 85, 1, 86, 1, 84, 1, 87, 2, 88, 1, 89, 1, 84, 1, 86,
    1, 90, 1, 84, 2, 86, 1, 90, 3, 86, 2, 84, 4, 86, 1, 84,
    1, 91, 1, 84, 1, 92, 2, 86, 1, 93, 3, 86, 1, 94, 15, 86,
    1, 95, 1, 96, 1, 97, 1, 98, 1, 99, 1, 100, 15, 84, 1, 101,
    1, 102, 2, 101, 1, 103, 2, 104, 1, 105, 19, 101, 1, 106, 2, 101,
    1, 107, 3, 101, 1, 108, 36, 101, 72, 0, 1, 10, 71, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 23, 11,
    26, 0, 1, 13, 72, 0, 1, 109, 1, 110, 46, 0, 1, 111, 70, 0,
    1, 112, 25, 0, 1, 16, 1, 0, 2, 113, 1, 16, 1, 0, 1, 114,
    1, 115, 1, 0, 1, 116, 1, 117, 1, 118, 1, 119, 6, 0, 1, 115,
    1, 118, 1, 0, 1, 114, 1, 0, 1, 117, 8, 0, 1, 119, 29, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    5, 11, 1, 120, 1, 121, 7, 11, 1, 122, 1, 123, 7, 11, 31, 0,
    1, 16, 1, 0, 2, 113, 1, 16, 1, 124, 1, 114, 1, 115, 1, 0,
    1, 116, 1, 117, 1, 118, 1, 119, 1, 124, 5, 0, 1, 115, 1, 118,
    1, 0, 1, 114, 1, 0, 1, 117, 8, 0, 1, 119, 45, 0, 1, 125,
    36, 0, 1, 126, 12, 0, 1, 127, 12, 0, 1, 128, 3, 0, 1, 128,
    58, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 1, 11, 1, 129, 10, 11, 1, 130, 1, 131, 9, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    2, 11, 1, 132, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 3, 11, 1, 133, 3, 0, 5, 11, 1, 134, 8, 11,
    1, 135, 3, 11, 1, 136, 4, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 4, 11, 1, 137, 1, 138,
    4, 11, 1, 139, 4, 11, 1, 140, 7, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 6, 11, 1, 141,
    1, 142, 1, 143, 14, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 10, 11, 1, 144, 12, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    1, 145, 1, 11, 1, 146, 5, 11, 1, 147, 4, 11, 1, 148, 1, 11,
    1, 149, 4, 11, 1, 150, 2, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 151, 7, 11,
    1, 152, 12, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 1, 11, 1, 153, 2, 11, 1, 154, 5, 11,
    1, 155, 1, 11, 1, 156, 10, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 4, 11, 1, 157, 1, 158,
    4, 11, 1, 159, 2, 11, 1, 160, 9, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 1, 161, 5, 11, 2, 0, 4, 11, 3, 0, 8, 11,
    1, 162, 9, 11, 1, 163, 1, 164, 3, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 1, 165, 5, 11, 2, 0, 4, 11, 3, 0, 2, 11,
    1, 166, 1, 11, 1, 167, 18, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 3, 11, 1, 168, 2, 11,
    1, 169, 7, 11, 1, 170, 1, 11, 1, 171, 6, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11,
    1, 172, 7, 11, 1, 173, 12, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 174, 7, 11,
    1, 175, 12, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 10, 11, 1, 176, 4, 11, 1, 177, 7, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 1, 178, 5, 11, 2, 0,
    4, 11, 3, 0, 1, 11, 1, 179, 2, 11, 1, 180, 18, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    13, 11, 1, 181, 9, 11, 76, 0, 1, 182, 68, 0, 1, 183, 1, 0,
    1, 184, 69, 0, 1, 185, 1, 186, 70, 0, 1, 187, 70, 0, 1, 188,
    7, 0, 1, 189, 62, 0, 1, 190, 70, 0, 1, 191, 70, 0, 1, 192,
    11, 0, 1, 193, 58, 0, 1, 194, 12, 0, 1, 195, 4, 0, 1, 196,
    6, 0, 1, 196, 2, 0, 2, 196, 1, 0, 3, 196, 2, 0, 4, 196,
    1, 0, 1, 197, 1, 0, 23, 196, 22, 0, 1, 62, 24, 0, 1, 63,
    45, 0, 1, 63, 69, 0, 4, 64, 3, 0, 4, 64, 1, 0, 13, 64,
    1, 0, 45, 64, 5, 0, 1, 66, 65, 0, 5, 198, 1, 0, 5, 198,
    1, 199, 1, 200, 1, 201, 1, 202, 8, 198, 1, 203, 1, 204, 1, 205,
    1, 198, 1, 206, 1, 207, 1, 198, 1, 208, 1, 209, 3, 198, 1, 210,
    5, 198, 1, 211, 3, 198, 1, 212, 25, 198, 25, 69, 1, 0, 45, 69,
    25, 0, 1, 213, 50, 0, 1, 73, 65, 0, 5, 214, 1, 0, 5, 214,
    1, 215, 1, 216, 1, 217, 1, 218, 8, 214, 1, 219, 1, 220, 1, 221,
    1, 214, 1, 222, 1, 223, 1, 214, 1, 224, 1, 225, 3, 214, 1, 226,
    5, 214, 1, 227, 3, 214, 1, 228, 25, 214, 5, 0, 1, 75, 106, 0,
    1, 229, 58, 0, 1, 230, 69, 0, 1, 231, 3, 0, 1, 232, 8, 0,
    1, 233, 71, 0, 1, 234, 57, 0, 1, 235, 71, 0, 1, 236, 71, 0,
    1, 237, 40, 0, 1, 85, 71, 0, 2, 86, 5, 0, 2, 86, 1, 0,
    6, 86, 2, 0, 4, 86, 3, 0, 23, 86, 26, 0, 1, 88, 72, 0,
    1, 238, 73, 0, 1, 90, 3, 0, 1, 90, 56, 0, 4, 239, 3, 0,
    18, 239, 1, 240, 45, 239, 2, 0, 2, 86, 5, 0, 2, 86, 1, 0,
    6, 86, 2, 0, 4, 86, 3, 0, 1, 86, 1, 241, 21, 86, 23, 0,
    2, 86, 5, 0, 2, 86, 1, 0, 6, 86, 2, 0, 4, 86, 3, 0,
    4, 86, 1, 242, 18, 86, 23, 0, 2, 86, 5, 0, 2, 86, 1, 0,
    6, 86, 2, 0, 4, 86, 3, 0, 2, 86, 1, 243, 20, 86, 76, 0,
    1, 244, 68, 0, 1, 245, 71, 0, 1, 246, 71, 0, 1, 247, 15, 0,
    4, 102, 3, 0, 64, 102, 5, 0, 1, 104, 72, 0, 1, 248, 91, 0,
    1, 249, 73, 0, 1, 250, 68, 0, 1, 251, 41, 0, 4, 109, 1, 252,
    2, 253, 64, 109, 8, 110, 1, 254, 62, 110, 16, 0, 1, 255, 15, 0,
    1, 255, 50, 0, 2, 255, 67, 0, 1, 0x0100, 3, 0, 1, 0x0100, 3, 0,
    1, 0x0101, 44, 0, 1, 0x0101, 9, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 10, 11, 1, 0x0102, 12, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    13, 11, 1, 0x0103, 1, 11, 1, 0x0104, 7, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 6, 11, 1, 0x0105,
    2, 11, 1, 0x0106, 13, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 14, 11, 1, 0x0107, 8, 11, 30, 0,
    2, 0x0108, 3, 0, 1, 0x0108, 2, 0, 1, 0x0108, 2, 0, 2, 0x0108, 7, 0,
    3, 0x0108, 2, 0, 3, 0x0108, 44, 0, 1, 128, 3, 0, 1, 128, 2, 0,
    1, 115, 2, 0, 1, 117, 1, 118, 1, 119, 6, 0, 1, 115, 1, 118,
    3, 0, 1, 117, 8, 0, 1, 119, 29, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 1, 0x0109, 5, 11, 2, 0, 4, 11, 3, 0, 12, 11, 1, 0x010a,
    10, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 19, 11, 1, 0x010b, 3, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 11, 1, 0x010c,
    13, 11, 1, 0x010d, 7, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 1, 0x010e, 2, 11, 1, 0x010f, 1, 0x0110,
    11, 11, 1, 0x0111, 6, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 1, 0x0112, 18, 11, 1, 0x0113, 3, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 6, 11, 1, 0x0114, 16, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 1, 0x0115, 5, 11, 2, 0, 4, 11, 3, 0, 23, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    2, 11, 1, 0x0116, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 5, 11, 1, 0x0117, 17, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    10, 11, 1, 0x0118, 12, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 1, 11, 1, 0x0119, 21, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 3, 11, 1, 0x011a,
    3, 0, 2, 11, 1, 0x011b, 11, 11, 1, 0x011c, 8, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 6, 11,
    1, 0x011d, 16, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 7, 11, 1, 0x011e, 15, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 6, 11,
    1, 0x011f, 16, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 9, 11, 1, 0x0120, 4, 11, 1, 0x0121, 8, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 1, 11, 1, 0x0122, 2, 11, 1, 0x0123, 18, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x0124,
    3, 11, 1, 0x0125, 18, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 12, 11, 1, 0x0126, 10, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    10, 11, 1, 0x0127, 12, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 22, 11, 1, 0x0128, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 15, 11,
    1, 0x0129, 7, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 3, 11, 1, 0x012a, 1, 11, 1, 0x012b, 3, 11,
    1, 0x012c, 13, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 1, 0x012d,
    5, 11, 2, 0, 4, 11, 3, 0, 23, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x012e,
    20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 6, 11, 1, 0x012f, 16, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 10, 11, 1, 0x0130,
    12, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 1, 0x0131, 22, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x0132, 5, 11, 1, 0x0133,
    16, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 4, 11, 1, 0x0134, 18, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 14, 11, 1, 0x0135,
    8, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 2, 11, 1, 0x0136, 1, 11, 1, 0x0137, 18, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    1, 0x0138, 22, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 21, 11, 1, 0x0139, 1, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11,
    1, 0x013a, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 2, 11, 1, 0x013b, 20, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 5, 11,
    1, 0x013c, 17, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 20, 11, 1, 0x013d, 2, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 16, 11,
    1, 0x013e, 6, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 1, 0x013f, 22, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 19, 11, 1, 0x0140,
    3, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 1, 0x0141, 22, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 7, 11, 1, 0x0142, 15, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 1, 0x0143, 22, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 1, 0x0144, 22, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 5, 11,
    1, 0x0145, 9, 11, 1, 0x0146, 7, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 11, 1, 0x0147, 21, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 8, 11, 1, 0x0148, 14, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 10, 11, 1, 0x0149, 4, 11,
    1, 0x014a, 7, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 1, 11, 1, 0x014b, 21, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 15, 11,
    1, 0x014c, 7, 11, 76, 0, 1, 0x014d, 70, 0, 1, 0x014e, 17, 0, 2, 196,
    5, 0, 2, 196, 1, 0, 6, 196, 2, 0, 4, 196, 3, 0, 23, 196,
    30, 0, 2, 0x014f, 3, 0, 1, 0x014f, 2, 0, 1, 0x014f, 2, 0, 2, 0x014f,
    7, 0, 3, 0x014f, 2, 0, 3, 0x014f, 43, 0, 2, 0x0150, 3, 0, 1, 0x0151,
    2, 0, 1, 0x0150, 2, 0, 2, 0x0150, 7, 0, 3, 0x0150, 2, 0, 3, 0x0150,
    43, 0, 2, 0x0152, 3, 0, 1, 0x0152, 2, 0, 1, 0x0152, 2, 0, 2, 0x0152,
    7, 0, 3, 0x0152, 2, 0, 3, 0x0152, 58, 0, 1, 0x0153, 55, 0, 2, 0x0154,
    3, 0, 1, 0x0154, 2, 0, 1, 0x0154, 2, 0, 2, 0x0154, 7, 0, 3, 0x0154,
    2, 0, 3, 0x0154, 43, 0, 2, 0x0155, 3, 0, 1, 0x0156, 2, 0, 1, 0x0155,
    2, 0, 2, 0x0155, 7, 0, 3, 0x0155, 2, 0, 3, 0x0155, 58, 0, 1, 0x0157,
    55, 0, 2, 0x0158, 3, 0, 1, 0x0158, 2, 0, 1, 0x0158, 2, 0, 2, 0x0158,
    7, 0, 3, 0x0158, 2, 0, 3, 0x0158, 58, 0, 1, 0x0159, 70, 0, 1, 0x015a,
    70, 0, 1, 0x015b, 70, 0, 1, 0x015c, 70, 0, 1, 0x015d, 70, 0, 1, 0x015e,
    70, 0, 1, 0x015f, 70, 0, 1, 0x0160, 70, 0, 1, 0x0161, 80, 0, 1, 0x0162,
    80, 0, 1, 0x0163, 54, 0, 1, 0x0164, 75, 0, 1, 0x0165, 8, 0, 1, 0x0166,
    62, 0, 1, 0x0167, 77, 0, 1, 0x0168, 59, 0, 1, 0x0169, 68, 0, 1, 0x016a,
    42, 0, 4, 238, 1, 0x016b, 2, 0x016c, 64, 238, 2, 0, 2, 86, 5, 0,
    2, 86, 1, 0, 1, 0x016d, 5, 86, 2, 0, 4, 86, 3, 0, 23, 86,
    23, 0, 2, 86, 5, 0, 2, 86, 1, 0, 6, 86, 2, 0, 4, 86,
    3, 0, 5, 86, 1, 0x016e, 17, 86, 23, 0, 2, 86, 5, 0, 2, 86,
    1, 0, 6, 86, 2, 0, 4, 86, 3, 0, 3, 86, 1, 0x016f, 19, 86,
    21, 0, 4, 248, 1, 0x0170, 2, 0x0171, 64, 248, 12, 0, 1, 0x0172, 90, 0,
    1, 0x0173, 68, 0, 1, 0x0174, 45, 0, 1, 253, 65, 0, 7, 110, 1, 0x0175,
    1, 254, 62, 110, 10, 0, 1, 0x0100, 3, 0, 1, 0x0100, 5, 0, 1, 117,
    1, 118, 1, 119, 7, 0, 1, 118, 3, 0, 1, 117, 8, 0, 1, 119,
    37, 0, 1, 0x0100, 3, 0, 1, 0x0100, 58, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 14, 11, 1, 0x0176, 8, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 10, 11, 1, 0x0177, 12, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 14, 11, 1, 0x0178, 8, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 4, 11, 1, 0x0179, 18, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 13, 11, 1, 0x017a, 9, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 1, 0x017b, 22, 11, 30, 0, 2, 0x0108, 1, 0, 2, 113, 1, 0x0108,
    1, 0, 1, 114, 1, 0x0108, 2, 0, 2, 0x0108, 7, 0, 3, 0x0108, 1, 114,
    1, 0, 3, 0x0108, 36, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 2, 11, 1, 0x017c, 20, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11,
    1, 0x017d, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 10, 11, 1, 0x017e, 12, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 6, 11,
    1, 0x017f, 16, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 1, 0x0180,
    5, 11, 2, 0, 4, 11, 3, 0, 23, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 7, 11, 1, 0x0181,
    15, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 10, 11, 1, 0x0182, 12, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x0183,
    20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 5, 11, 1, 0x0184, 17, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x0185,
    20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 16, 11, 1, 0x0186, 6, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 14, 11, 1, 0x0187,
    8, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 6, 11, 1, 0x0188, 16, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 4, 11, 1, 0x0189,
    18, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 2, 11, 1, 0x018a, 20, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x018b,
    20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 5, 11, 1, 0x018c, 17, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 4, 11, 1, 0x018d,
    18, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 2, 11, 1, 0x018e, 20, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x018f, 22, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 11, 11, 1, 0x0190, 11, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 17, 11, 1, 0x0191, 5, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 1, 0x0192, 5, 11, 2, 0,
    4, 11, 3, 0, 15, 11, 1, 0x0193, 7, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x0194, 8, 11,
    1, 0x0195, 13, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 5, 11, 1, 0x0196, 17, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x0197,
    22, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 1, 11, 1, 0x0198, 21, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x0199,
    20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 1, 0x019a, 22, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 4, 11, 1, 0x019b, 18, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 2, 11, 1, 0x019c, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 15, 11, 1, 0x019d, 7, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 8, 11, 1, 0x019e, 14, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 4, 11, 1, 0x019f, 18, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 2, 11, 1, 0x01a0, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 5, 11, 1, 0x01a1, 17, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 2, 11, 1, 0x01a2, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 9, 11, 1, 0x01a3, 13, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 2, 11, 1, 0x01a4, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 6, 11, 1, 0x01a5, 16, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 1, 0x01a6, 5, 11, 1, 0x01a7, 16, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 9, 11, 1, 0x01a8,
    13, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 1, 11, 1, 0x01a9, 21, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x01aa,
    20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 1, 11, 1, 0x01ab, 21, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 11, 1, 0x01ac,
    21, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 5, 11, 1, 0x01ad, 17, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x01ae,
    20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 2, 11, 1, 0x01af, 20, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 5, 11, 1, 0x01b0,
    17, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 13, 11, 1, 0x01b1, 9, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 1, 0x01b2, 5, 11, 2, 0, 4, 11, 3, 0, 23, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 10, 11, 1, 0x01b3, 12, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 4, 11, 1, 0x01b4, 18, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 7, 11, 1, 0x01b5, 15, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x01b6, 22, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    5, 11, 1, 0x01b7, 17, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 1, 0x01b8, 18, 11, 1, 0x01b9, 3, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 18, 11, 1, 0x01ba, 4, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 4, 11, 1, 0x01bb, 18, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 5, 11, 1, 0x01bc, 17, 11, 30, 0, 2, 0x01bd, 3, 0, 1, 0x01bd,
    2, 0, 1, 0x01bd, 2, 0, 2, 0x01bd, 7, 0, 3, 0x01bd, 2, 0, 3, 0x01bd,
    43, 0, 2, 0x01be, 3, 0, 1, 0x01be, 2, 0, 1, 0x01be, 2, 0, 2, 0x01be,
    7, 0, 3, 0x01be, 2, 0, 3, 0x01be, 43, 0, 2, 0x0150, 3, 0, 1, 0x01bf,
    2, 0, 1, 0x0150, 2, 0, 2, 0x0150, 7, 0, 3, 0x0150, 2, 0, 3, 0x0150,
    43, 0, 2, 0x01c0, 3, 0, 1, 0x01c0, 2, 0, 1, 0x01c0, 2, 0, 2, 0x01c0,
    7, 0, 3, 0x01c0, 2, 0, 3, 0x01c0, 43, 0, 2, 0x01c1, 3, 0, 1, 0x01c1,
    2, 0, 1, 0x01c1, 2, 0, 2, 0x01c1, 7, 0, 3, 0x01c1, 2, 0, 3, 0x01c1,
    43, 0, 2, 0x01c2, 3, 0, 1, 0x01c2, 2, 0, 1, 0x01c2, 2, 0, 2, 0x01c2,
    2, 0, 1, 0x01c3, 4, 0, 3, 0x01c2, 2, 0, 3, 0x01c2, 43, 0, 2, 0x0155,
    3, 0, 1, 0x01c4, 2, 0, 1, 0x0155, 2, 0, 2, 0x0155, 2, 0, 1, 0x01c3,
    4, 0, 3, 0x0155, 2, 0, 3, 0x0155, 43, 0, 2, 0x01c5, 3, 0, 1, 0x01c5,
    2, 0, 1, 0x01c5, 2, 0, 2, 0x01c5, 2, 0, 1, 0x01c6, 4, 0, 3, 0x01c5,
    2, 0, 3, 0x01c5, 63, 0, 1, 0x01c7, 83, 0, 1, 0x01c8, 65, 0, 1, 0x01c9,
    62, 0, 1, 0x01ca, 71, 0, 1, 0x01cb, 68, 0, 1, 0x01cc, 13, 0, 1, 0x01cd,
    57, 0, 1, 0x01ce, 83, 0, 1, 0x01cf, 69, 0, 1, 0x01d0, 34, 0, 1, 0x016c,
    67, 0, 2, 86, 5, 0, 2, 86, 1, 0, 6, 86, 2, 0, 4, 86,
    3, 0, 2, 86, 1, 0x01d1, 20, 86, 23, 0, 2, 86, 5, 0, 2, 86,
    1, 0, 6, 86, 2, 0, 4, 86, 3, 0, 6, 86, 1, 0x01d2, 16, 86,
    23, 0, 2, 86, 5, 0, 2, 86, 1, 0, 6, 86, 2, 0, 4, 86,
    3, 0, 4, 86, 1, 0x01d3, 18, 86, 26, 0, 1, 0x0171, 94, 0, 1, 0x01d4,
    74, 0, 1, 0x01d5, 68, 0, 1, 0x01d6, 41, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 17, 11, 1, 0x01d7, 5, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 1, 11, 1, 0x01d8, 21, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 17, 11, 1, 0x01d9, 5, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 3, 11, 1, 0x01da, 19, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x01db, 20, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 10, 11, 1, 0x01dc, 12, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 20, 11, 1, 0x01dd, 2, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 1, 11, 1, 0x01de, 21, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 10, 11, 1, 0x01df, 12, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 18, 11, 1, 0x01e0, 4, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 11, 1, 0x01e1, 21, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 15, 11, 1, 0x01e2, 7, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x01e3, 22, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    2, 11, 1, 0x01e4, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 1, 0x01e5, 22, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 4, 11,
    1, 0x01e6, 18, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 7, 11, 1, 0x01e7, 15, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 7, 11,
    1, 0x01e8, 15, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 5, 11, 1, 0x01e9, 17, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 16, 11,
    1, 0x01ea, 6, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 1, 11, 1, 0x01eb, 21, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 9, 11,
    1, 0x01ec, 13, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 14, 11, 1, 0x01ed, 8, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 15, 11,
    1, 0x01ee, 7, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 11, 11, 1, 0x01ef, 11, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11,
    1, 0x01f0, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 2, 11, 1, 0x01f1, 20, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x01f2,
    22, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 10, 11, 1, 0x01f3, 12, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 9, 11, 1, 0x01f4,
    13, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 1, 0x01f5, 5, 11,
    2, 0, 4, 11, 3, 0, 23, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 17, 11, 1, 0x01f6, 5, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 16, 11, 1, 0x01f7, 6, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 5, 11, 1, 0x01f8, 17, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 11, 11, 1, 0x01f9, 11, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 13, 11, 1, 0x01fa, 9, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 6, 11, 1, 0x01fb, 16, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 15, 11, 1, 0x01fc, 7, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 1, 0x01fd, 22, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 11, 11, 1, 0x01fe, 11, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    9, 11, 1, 0x01ff, 13, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 1, 11, 1, 0x0200, 21, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    4, 11, 1, 0x0201, 18, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 6, 11, 1, 0x0202, 16, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    1, 11, 1, 0x0203, 21, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 15, 11, 1, 0x0204, 7, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    10, 11, 1, 0x0205, 12, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 5, 11, 1, 0x0206, 17, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    1, 0x0207, 22, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 1, 0x0208,
    5, 11, 2, 0, 4, 11, 3, 0, 23, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 15, 11, 1, 0x0209,
    7, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 2, 11, 1, 0x020a, 20, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x020b,
    20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 4, 11, 1, 0x020c, 18, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 16, 11, 1, 0x020d,
    6, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 2, 11, 1, 0x020e, 20, 11, 30, 0, 2, 0x020f, 3, 0,
    1, 0x020f, 2, 0, 1, 0x020f, 2, 0, 2, 0x020f, 7, 0, 3, 0x020f, 2, 0,
    3, 0x020f, 43, 0, 2, 0x0210, 3, 0, 1, 0x0210, 2, 0, 1, 0x0210, 2, 0,
    2, 0x0210, 7, 0, 3, 0x0210, 2, 0, 3, 0x0210, 43, 0, 2, 0x0150, 3, 0,
    1, 0x0211, 2, 0, 1, 0x0150, 2, 0, 2, 0x0150, 7, 0, 3, 0x0150, 2, 0,
    3, 0x0150, 43, 0, 2, 0x0212, 3, 0, 1, 0x0212, 2, 0, 1, 0x0212, 2, 0,
    2, 0x0212, 7, 0, 3, 0x0212, 2, 0, 3, 0x0212, 43, 0, 2, 0x0213, 3, 0,
    1, 0x0213, 2, 0, 1, 0x0213, 2, 0, 2, 0x0213, 7, 0, 3, 0x0213, 2, 0,
    3, 0x0213, 43, 0, 2, 0x0214, 3, 0, 1, 0x0214, 2, 0, 1, 0x0214, 2, 0,
    2, 0x0214, 2, 0, 1, 0x01c3, 4, 0, 3, 0x0214, 2, 0, 3, 0x0214, 43, 0,
    2, 0x0155, 3, 0, 1, 0x0215, 2, 0, 1, 0x0155, 2, 0, 2, 0x0155, 2, 0,
    1, 0x01c3, 4, 0, 3, 0x0155, 2, 0, 3, 0x0155, 43, 0, 2, 0x0216, 3, 0,
    1, 0x0216, 2, 0, 1, 0x0216, 2, 0, 2, 0x0216, 2, 0, 1, 0x01c6, 4, 0,
    3, 0x0216, 2, 0, 3, 0x0216, 64, 0, 1, 0x0217, 77, 0, 1, 0x0218, 61, 0,
    1, 0x0219, 71, 0, 1, 0x021a, 71, 0, 1, 0x021b, 81, 0, 1, 0x021c, 71, 0,
    1, 0x021d, 30, 0, 2, 86, 5, 0, 2, 86, 1, 0, 6, 86, 2, 0,
    4, 86, 3, 0, 2, 86, 1, 0x021e, 20, 86, 23, 0, 2, 86, 5, 0,
    2, 86, 1, 0, 1, 0x021f, 5, 86, 2, 0, 4, 86, 3, 0, 23, 86,
    50, 0, 1, 0x0220, 53, 0, 1, 0x0221, 60, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x0222, 22, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    2, 11, 1, 0x0223, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 9, 11, 1, 0x0224, 13, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    3, 11, 1, 0x0225, 19, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 14, 11, 1, 0x0226, 8, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    14, 11, 1, 0x0227, 8, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x0228, 20, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    14, 11, 1, 0x0229, 8, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 9, 11, 1, 0x022a, 13, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    9, 11, 1, 0x022b, 13, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 5, 11, 1, 0x022c, 17, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    8, 11, 1, 0x022d, 14, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 4, 11, 1, 0x022e, 18, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    1, 0x022f, 22, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 17, 11, 1, 0x0230, 5, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 9, 11,
    1, 0x0231, 13, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 4, 11, 1, 0x0232, 18, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 7, 11,
    1, 0x0233, 15, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 3, 11, 1, 0x0234, 19, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 13, 11,
    1, 0x0235, 9, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 5, 11, 1, 0x0236, 17, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 4, 11,
    1, 0x0237, 18, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 4, 11, 1, 0x0238, 18, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11,
    1, 0x0239, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 14, 11, 1, 0x023a, 8, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11,
    1, 0x023b, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 1, 0x023c, 22, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 15, 11, 1, 0x023d,
    7, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 1, 0x023e, 22, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 19, 11, 1, 0x023f, 3, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 3, 11, 1, 0x0240, 10, 11, 1, 0x0241, 8, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 9, 11,
    1, 0x0242, 13, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 7, 11, 1, 0x0243, 15, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11,
    1, 0x0244, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 15, 11, 1, 0x0245, 7, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 4, 11,
    1, 0x0246, 18, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 9, 11, 1, 0x0247, 13, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 9, 11,
    1, 0x0248, 13, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 1, 11, 1, 0x0249, 21, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x024a,
    22, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 6, 11, 1, 0x024b, 16, 11, 30, 0, 2, 0x024c, 3, 0,
    1, 0x024c, 2, 0, 1, 0x024c, 2, 0, 2, 0x024c, 7, 0, 3, 0x024c, 2, 0,
    3, 0x024c, 43, 0, 2, 0x024d, 3, 0, 1, 0x024d, 2, 0, 1, 0x024d, 2, 0,
    2, 0x024d, 7, 0, 3, 0x024d, 2, 0, 3, 0x024d, 43, 0, 2, 0x0150, 3, 0,
    1, 0x024e, 2, 0, 1, 0x0150, 2, 0, 2, 0x0150, 7, 0, 3, 0x0150, 2, 0,
    3, 0x0150, 43, 0, 2, 0x024f, 3, 0, 1, 0x024f, 2, 0, 1, 0x024f, 2, 0,
    2, 0x024f, 7, 0, 3, 0x024f, 2, 0, 3, 0x024f, 43, 0, 2, 0x0250, 3, 0,
    1, 0x0250, 2, 0, 1, 0x0250, 2, 0, 2, 0x0250, 7, 0, 3, 0x0250, 2, 0,
    3, 0x0250, 43, 0, 2, 0x0251, 3, 0, 1, 0x0251, 2, 0, 1, 0x0251, 2, 0,
    2, 0x0251, 2, 0, 1, 0x01c3, 4, 0, 3, 0x0251, 2, 0, 3, 0x0251, 43, 0,
    2, 0x0155, 3, 0, 1, 0x0252, 2, 0, 1, 0x0155, 2, 0, 2, 0x0155, 2, 0,
    1, 0x01c3, 4, 0, 3, 0x0155, 2, 0, 3, 0x0155, 43, 0, 2, 0x0253, 3, 0,
    1, 0x0253, 2, 0, 1, 0x0253, 2, 0, 2, 0x0253, 2, 0, 1, 0x01c6, 4, 0,
    3, 0x0253, 2, 0, 3, 0x0253, 75, 0, 1, 0x0254, 73, 0, 1, 0x0255, 55, 0,
    1, 0x0256, 82, 0, 1, 0x0257, 31, 0, 2, 86, 5, 0, 2, 86, 1, 0,
    6, 86, 2, 0, 4, 86, 3, 0, 5, 86, 1, 0x0258, 17, 86, 53, 0,
    1, 0x0259, 40, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 11, 11, 1, 0x025a, 11, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 5, 11, 1, 0x025b,
    17, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 15, 11, 1, 0x025c, 7, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 13, 11, 1, 0x025d,
    9, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 12, 11, 1, 0x025e, 10, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 5, 11, 1, 0x025f,
    17, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 9, 11, 1, 0x0260, 13, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 5, 11, 1, 0x0261,
    17, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 1, 0x0262, 22, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x0263, 22, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    5, 11, 1, 0x0264, 17, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    1, 0x0265, 5, 11, 2, 0, 4, 11, 3, 0, 23, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 7, 11,
    1, 0x0266, 15, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 7, 11, 1, 0x0267, 15, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 10, 11,
    1, 0x0268, 12, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 4, 11, 1, 0x0269, 18, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 4, 11,
    1, 0x026a, 18, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 4, 11, 1, 0x026b, 18, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 15, 11,
    1, 0x026c, 7, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 5, 11, 1, 0x026d, 17, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 5, 11,
    1, 0x026e, 17, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 1, 0x026f, 22, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x0270, 22, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 2, 11, 1, 0x0271, 20, 11, 30, 0, 2, 0x0150, 3, 0, 1, 0x0150,
    2, 0, 1, 0x0150, 2, 0, 2, 0x0150, 7, 0, 3, 0x0150, 2, 0, 3, 0x0150,
    58, 0, 1, 0x0272, 70, 0, 1, 0x01c3, 55, 0, 2, 0x0155, 3, 0, 1, 0x0155,
    2, 0, 1, 0x0155, 2, 0, 2, 0x0155, 2, 0, 1, 0x01c3, 4, 0, 3, 0x0155,
    2, 0, 3, 0x0155, 58, 0, 1, 0x01c6, 88, 0, 1, 0x0273, 72, 0, 1, 0x0274,
    28, 0, 2, 86, 5, 0, 2, 86, 1, 0, 6, 86, 2, 0, 4, 86,
    3, 0, 1, 0x0275, 22, 86, 48, 0, 1, 0x0276, 45, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x0277,
    20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0,
    4, 11, 3, 0, 12, 11, 1, 0x0278, 10, 11, 23, 0, 2, 11, 5, 0,
    2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x0279, 22, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 12, 11, 1, 0x027a, 10, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 1, 0x027b, 22, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    5, 11, 1, 0x027c, 17, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x027d, 20, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    2, 11, 1, 0x027e, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x027f, 20, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    1, 11, 1, 0x0280, 21, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 9, 11, 1, 0x0281, 13, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    9, 11, 1, 0x0282, 13, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0,
    6, 11, 2, 0, 4, 11, 3, 0, 5, 11, 1, 0x0283, 17, 11, 23, 0,
    2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0,
    1, 0x0284, 22, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 2, 11, 1, 0x0285, 20, 11, 23, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11,
    1, 0x0286, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11,
    2, 0, 4, 11, 3, 0, 12, 11, 1, 0x0287, 10, 11, 58, 0, 1, 0x0288,
    35, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 7, 11, 1, 0x0289, 15, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 10, 11, 1, 0x028a, 12, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 2, 11, 1, 0x028b, 20, 11, 23, 0, 2, 11, 5, 0, 2, 11,
    1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 2, 11, 1, 0x028c, 20, 11,
    23, 0, 2, 11, 5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11,
    3, 0, 7, 11, 1, 0x028d, 15, 11, 62, 0, 1, 0x028e, 31, 0, 2, 11,
    5, 0, 2, 11, 1, 0, 6, 11, 2, 0, 4, 11, 3, 0, 9, 11,
    1, 0x028f, 13, 11, 21, 0, 0 };

  private static int [] zzUnpackTrans() {
    int [] result = new int[33086];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(ushort[] packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.Length;
    while (i + 1 < l) {
      int count = packed[i++];
      int value = packed[i++];
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private const int ZZ_UNKNOWN_ERROR = 0;
  private const int ZZ_NO_MATCH = 1;
  private const int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static readonly String[] ZZ_ERROR_MSG = new string[] {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static readonly int [] ZZ_ATTRIBUTE;

  private static readonly ushort[] ZZ_ATTRIBUTE_PACKED_0 = new ushort[] {
    8, 0, 1, 9, 3, 1, 1, 9, 7, 1, 2, 9, 18, 1, 2, 9,
    4, 1, 7, 9, 3, 1, 1, 9, 2, 1, 1, 9, 5, 1, 1, 9,
    1, 1, 1, 9, 2, 1, 1, 9, 1, 1, 1, 9, 1, 1, 1, 9,
    8, 1, 1, 9, 3, 1, 1, 9, 6, 1, 2, 9, 4, 1, 1, 9,
    2, 1, 1, 9, 5, 1, 1, 0, 2, 9, 2, 1, 2, 0, 3, 9,
    4, 1, 1, 0, 3, 9, 54, 1, 11, 9, 1, 1, 1, 9, 2, 1,
    3, 9, 2, 1, 1, 9, 1, 1, 11, 9, 14, 1, 7, 0, 1, 9,
    1, 0, 1, 1, 1, 0, 1, 9, 3, 1, 4, 9, 1, 1, 3, 0,
    1, 1, 1, 9, 1, 0, 1, 9, 1, 1, 1, 0, 75, 1, 2, 9,
    1, 0, 3, 1, 1, 9, 3, 0, 1, 9, 1, 0, 9, 9, 9, 0,
    1, 1, 1, 9, 4, 1, 1, 9, 3, 0, 1, 9, 71, 1, 1, 0,
    3, 1, 2, 0, 1, 9, 2, 0, 1, 9, 3, 0, 2, 9, 2, 0,
    1, 9, 2, 0, 3, 1, 1, 9, 2, 0, 56, 1, 1, 0, 3, 1,
    4, 0, 1, 9, 1, 0, 1, 9, 1, 0, 1, 9, 2, 0, 2, 1,
    1, 9, 1, 0, 42, 1, 2, 9, 1, 1, 1, 9, 4, 0, 1, 9,
    1, 0, 1, 9, 1, 0, 1, 1, 1, 0, 24, 1, 1, 9, 1, 0,
    1, 9, 1, 1, 1, 9, 17, 1, 1, 0, 5, 1, 1, 9, 1, 1, 0 };

  private static int [] zzUnpackAttribute() {
    int [] result = new int[655];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(ushort[] packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.Length;
    while (i + 1 < l) {
      int count = packed[i++];
      int value = packed[i++];
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private System.IO.TextReader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char[] zzBuffer = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private bool zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private bool zzAtEOF;


  /** the stack of open (nested) input streams to read from */
  private System.Collections.Stack zzStreams = new System.Collections.Stack();

  /**
   * inner class used to store info for nested
   * input streams
   */
  private sealed class ZzFlexStreamInfo {
    public System.IO.TextReader zzReader;
    public int zzEndRead;
    public int zzStartRead;
    public int zzCurrentPos;
    public int zzMarkedPos;
    public int zzPushbackPos;
    public int yyline;
    public int yycolumn;
    public char [] zzBuffer;
    public bool zzAtEOF;

    /** sets all values stored in this class */
    public ZzFlexStreamInfo(System.IO.TextReader zzReader, int zzEndRead, int zzStartRead,
                  int zzCurrentPos, int zzMarkedPos, int zzPushbackPos,
                  char [] zzBuffer, bool zzAtEOF, int yyline, int yycolumn) {
      this.zzReader      = zzReader;
      this.zzEndRead     = zzEndRead;
      this.zzStartRead   = zzStartRead;
      this.zzCurrentPos  = zzCurrentPos;
      this.zzMarkedPos   = zzMarkedPos;
      this.zzPushbackPos = zzPushbackPos;
      this.zzBuffer      = zzBuffer;
      this.zzAtEOF       = zzAtEOF;
      this.yyline         = yyline;
      this.yycolumn       = yycolumn;
    }
  }

  /** denotes if the user-EOF-code has already been executed */
  private bool zzEOFDone;

  /* user code: */
	private FileInfo fileinfo;
	private StringBuilder stringBuf = new StringBuilder();
	
	public void SetFileInfo(FileInfo fileinfo)
	{
		this.fileinfo = fileinfo;
	}
	
	public int Line
	{
		get { return yyline+1; }
	}
	
	public int Column
	{
		get { return yycolumn+1; }
	}
	
	private bool IsLetterCharacter(string s)
	{
		return ( (UnicodeCategory.LowercaseLetter == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Ll
		         (UnicodeCategory.ModifierLetter  == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Lm
		         (UnicodeCategory.OtherLetter     == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Lo
		         (UnicodeCategory.TitlecaseLetter == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Lt
		         (UnicodeCategory.UppercaseLetter == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Lu
		         (UnicodeCategory.LetterNumber    == Char.GetUnicodeCategory(s, 1))     //UNICODE class Nl
		        );
	}

	private bool IsIdentifierCharacter(string s)
	{
		return ( (UnicodeCategory.LowercaseLetter      == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Ll
		         (UnicodeCategory.ModifierLetter       == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Lm
		         (UnicodeCategory.OtherLetter          == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Lo
		         (UnicodeCategory.TitlecaseLetter      == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Lt
		         (UnicodeCategory.UppercaseLetter      == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Lu
		         (UnicodeCategory.LetterNumber         == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Nl		         
		         (UnicodeCategory.NonSpacingMark       == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Mn		         
		         (UnicodeCategory.SpacingCombiningMark == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Mc
		         (UnicodeCategory.DecimalDigitNumber   == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Nd
		         (UnicodeCategory.ConnectorPunctuation == Char.GetUnicodeCategory(s, 1)) ||  //UNICODE class Pc
		         (UnicodeCategory.Format               == Char.GetUnicodeCategory(s, 1))     //UNICODE class Cf
		        );
	}

	private IToken MakeToken(int type, string lexeme)
	{
		return new CustomHiddenStreamToken(type, lexeme, fileinfo, Line, Column);
	}


  /**
   * Creates a new scanner
   * There is also a System.IO.Stream version of this constructor.
   *
   * @param   in  the System.IO.TextReader to read input from.
   */
  public CSharpFlexLexer(TextReader @in) {
    this.zzReader = @in;
  }

  /**
   * Creates a new scanner.
   * There is also TextReader version of this constructor.
   *
   * @param   in  the System.IO.Stream to read input from.
   */
  public CSharpFlexLexer(Stream @in) : this(new StreamReader(@in))
  {
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(ushort[] packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1606) {
      int  count = packed[i++];
      char value = (char)packed[i++];
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   System.IO.IOException  if any I/O-Error occurs
   */
  private bool zzRefill() {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      Array.Copy(zzBuffer, zzStartRead,
                 zzBuffer, 0,
                 zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.Length) {
      /* if not: blow it up */
      char[] newBuffer = new char[zzCurrentPos*2];
      Array.Copy(zzBuffer, 0, newBuffer, 0, zzBuffer.Length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.Read(zzBuffer, zzEndRead,
                                            zzBuffer.Length-zzEndRead);

    if (numRead <= 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public void yyclose() {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.Close();
  }


  /**
   * Stores the current input stream on a stack, and
   * reads from a new stream. Lexical state, line,
   * char, and column counting remain untouched.
   *
   * The current input stream can be restored with
   * yypopstream (usually in an <<EOF>> action).
   *
   * @param reader the new input stream to read from
   *
   * @see #yypopStream()
   */
  public void yypushStream(TextReader reader) {
    zzStreams.Push(
      new ZzFlexStreamInfo(zzReader, zzEndRead, zzStartRead, zzCurrentPos,
                        zzMarkedPos, zzPushbackPos, zzBuffer, zzAtEOF,
                        yyline, yycolumn)
    );
    zzAtEOF  = false;
    zzBuffer = new char[ZZ_BUFFERSIZE];
    zzReader = reader;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yycolumn = 0;
  }
    

  /**
   * Closes the current input stream and continues to
   * read from the one on top of the stream stack. 
   *
   * @throws System.InvalidOperationException
   *         if there is no further stream to read from.
   *
   * @throws System.IO.IOException
   *         if there was an error in closing the stream.
   *
   * @see #yypushStream(TextReader)
   */
  public void yypopStream() {
    zzReader.Close();
    ZzFlexStreamInfo s = (ZzFlexStreamInfo) zzStreams.Pop();
    zzBuffer      = s.zzBuffer;
    zzReader      = s.zzReader;
    zzEndRead     = s.zzEndRead;
    zzStartRead   = s.zzStartRead;
    zzCurrentPos  = s.zzCurrentPos;
    zzMarkedPos   = s.zzMarkedPos ;
    zzPushbackPos = s.zzPushbackPos;
    zzAtEOF       = s.zzAtEOF;
    yyline         = s.yyline;
    yycolumn       = s.yycolumn;
  }


  /**
   * Returns true iff there are still streams left 
   * to read from on the stream stack.
   */
  public bool yymoreStreams() {
    return zzStreams.Count != 0;
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   *
   * @see #yypushStream(System.IO.TextReader)
   * @see #yypopStream()
   */
  public void yyreset(System.IO.TextReader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex/CSFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (IndexOutOfRangeException) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Exception(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() {
    if (!zzEOFDone) {
      zzEOFDone = true;
        yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   System.IO.IOException  if any I/O-Error occurs
   */
  public IToken nextToken() {
    int zzInput = 0;
    int zzAction;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      // cached fields:
      int zzCurrentPosL;
      int zzMarkedPosL = zzMarkedPos;
      int zzEndReadL = zzEndRead;
      char [] zzBufferL = zzBuffer;
      char [] zzCMapL = ZZ_CMAP;

      bool zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
          break;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        bool zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          bool eof = zzRefill();
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            bool eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
          break;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];


        while (true) {
          goto zzForAction_skip;
        zzForAction: break;
        zzForAction_skip:
          if (!ZZ_SPURIOUS_WARNINGS_SUCK) goto zzForAction;
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            goto zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            bool eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
            goto zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) goto zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) goto zzForAction;
          }

        }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 108: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 234 "csharp.flex"
                return MakeToken(symID.REF, "ref");				
#line default
          }
          break;
        case 149: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 368 "csharp.flex"
                                  	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, Int32.Parse(yytext().Substring(2), NumberStyles.HexNumber).ToString()); 
#line default
          }
          break;
        case 4: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 330 "csharp.flex"
                       	return MakeToken(symID.NEWLINE, yytext()); 		
#line default
          }
          break;
        case 174: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 248 "csharp.flex"
                  return MakeToken(symID.TYPEOF, "typeof");			
#line default
          }
          break;
        case 72: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 314 "csharp.flex"
                             return MakeToken(symID.BIN_OR_ASSIGN, "|=");	
#line default
          }
          break;
        case 187: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 268 "csharp.flex"
                  return MakeToken(symID.LITERAL_module, "module");		
#line default
          }
          break;
        case 215: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 222 "csharp.flex"
                    return MakeToken(symID.NAMESPACE, "namespace");	
#line default
          }
          break;
        case 180: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 241 "csharp.flex"
                  return MakeToken(symID.STATIC, "static");			
#line default
          }
          break;
        case 14: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 277 "csharp.flex"
                            return MakeToken(symID.LOG_NOT, "!");			
#line default
          }
          break;
        case 156: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 204 "csharp.flex"
                               return MakeToken(symID.EVENT, "event");			
#line default
          }
          break;
        case 78: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 306 "csharp.flex"
                             return MakeToken(symID.LTE, "<=");			
#line default
          }
          break;
        case 209: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 226 "csharp.flex"
                   return MakeToken(symID.OPERATOR, "operator");		
#line default
          }
          break;
        case 98: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 350 "csharp.flex"
              	yybegin(PP_SYMBOLS); return MakeToken(symID.PP_COND_IF, stringBuf.ToString()+yytext()); 		
#line default
          }
          break;
        case 93: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 409 "csharp.flex"
               	stringBuf.Append( "\b" );  	
#line default
          }
          break;
        case 115: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 263 "csharp.flex"
                return MakeToken(symID.LITERAL_get, "get");			
#line default
          }
          break;
        case 102: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 435 "csharp.flex"
                             	return MakeToken(symID.LOG_AND, "&&");			
#line default
          }
          break;
        case 60: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 303 "csharp.flex"
                             return MakeToken(symID.DEC, "--");			
#line default
          }
          break;
        case 86: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 406 "csharp.flex"
               	stringBuf.Append( "\0" );  	
#line default
          }
          break;
        case 63: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 186 "csharp.flex"
                            return MakeToken(symID.AS, "as");					
#line default
          }
          break;
        case 190: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 401 "csharp.flex"
                            	stringBuf.Append(Int32.Parse(yytext().Substring(2), NumberStyles.HexNumber).ToString()); 
#line default
          }
          break;
        case 155: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 246 "csharp.flex"
                 return MakeToken(symID.THROW, "throw");			
#line default
          }
          break;
        case 217: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 231 "csharp.flex"
                    return MakeToken(symID.PROTECTED, "protected");	
#line default
          }
          break;
        case 54: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 310 "csharp.flex"
                             return MakeToken(symID.STAR_ASSIGN, "*=");	
#line default
          }
          break;
        case 161: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 236 "csharp.flex"
                 return MakeToken(symID.SBYTE, "sbyte");			
#line default
          }
          break;
        case 13: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 276 "csharp.flex"
                            return MakeToken(symID.CLOSE_PAREN, ")");		
#line default
          }
          break;
        case 192: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 348 "csharp.flex"
                 	yybegin(PP_SYMBOLS); return MakeToken(symID.PP_DEFINE, stringBuf.ToString()+yytext()); 		
#line default
          }
          break;
        case 216: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 217 "csharp.flex"
                    return MakeToken(symID.INTERFACE, "interface");	
#line default
          }
          break;
        case 62: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 318 "csharp.flex"
                             return MakeToken(symID.DEREF, "->");			
#line default
          }
          break;
        case 46: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 432 "csharp.flex"
                            	return MakeToken(symID.OPEN_PAREN, "(");		
#line default
          }
          break;
        case 25: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 289 "csharp.flex"
                            return MakeToken(symID.PLUS, "+");			
#line default
          }
          break;
        case 124: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 381 "csharp.flex"
                 	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, "\t");  	
#line default
          }
          break;
        case 23: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 287 "csharp.flex"
                            return MakeToken(symID.COLON, ":");			
#line default
          }
          break;
        case 103: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 436 "csharp.flex"
                             	return MakeToken(symID.LOG_OR, "||");			
#line default
          }
          break;
        case 15: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 294 "csharp.flex"
                            return MakeToken(symID.BIN_AND, "&");			
#line default
          }
          break;
        case 84: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 417 "csharp.flex"
                                  	throw new SemanticException("CS1009: Unrecognized escape sequence '" +yytext()+ "'", fileinfo.FullName, yyline, yycolumn); 
#line default
          }
          break;
        case 26: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 293 "csharp.flex"
                            return MakeToken(symID.MOD, "%");				
#line default
          }
          break;
        case 218: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 359 "csharp.flex"
                   	yybegin(PP_HOOVER); return MakeToken(symID.PP_ENDREGION, stringBuf.ToString()+yytext()); 
#line default
          }
          break;
        case 6: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 291 "csharp.flex"
                            return MakeToken(symID.STAR, "*");			
#line default
          }
          break;
        case 137: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 203 "csharp.flex"
                              return MakeToken(symID.ENUM, "enum");				
#line default
          }
          break;
        case 213: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 270 "csharp.flex"
                   return MakeToken(symID.LITERAL_property, "property");	
#line default
          }
          break;
        case 151: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 351 "csharp.flex"
               	yybegin(PP_SYMBOLS); return MakeToken(symID.PP_COND_ELIF, stringBuf.ToString()+yytext()); 	
#line default
          }
          break;
        case 141: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 188 "csharp.flex"
                              return MakeToken(symID.BOOL, "bool");				
#line default
          }
          break;
        case 188: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 232 "csharp.flex"
                  return MakeToken(symID.PUBLIC, "public");			
#line default
          }
          break;
        case 163: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 189 "csharp.flex"
                               return MakeToken(symID.BREAK, "break");			
#line default
          }
          break;
        case 12: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 275 "csharp.flex"
                            return MakeToken(symID.OPEN_PAREN, "(");		
#line default
          }
          break;
        case 145: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 224 "csharp.flex"
                return MakeToken(symID.NULL, "null");				
#line default
          }
          break;
        case 44: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 423 "csharp.flex"
                       	yybegin(YYINITIAL);
  									return MakeToken(symID.NEWLINE, yytext());
  								
#line default
          }
          break;
        case 181: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 237 "csharp.flex"
                  return MakeToken(symID.SEALED, "sealed");			
#line default
          }
          break;
        case 10: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 321 "csharp.flex"
            	yybegin(YYINITIAL_CHAR);					
#line default
          }
          break;
        case 119: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 400 "csharp.flex"
                               	stringBuf.Append(Int32.Parse(yytext().Substring(2), NumberStyles.HexNumber).ToString()); 
#line default
          }
          break;
        case 203: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 205 "csharp.flex"
                               return MakeToken(symID.EXPLICIT, "explicit");		
#line default
          }
          break;
        case 173: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 252 "csharp.flex"
                  return MakeToken(symID.UNSAFE, "unsafe");			
#line default
          }
          break;
        case 131: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 328 "csharp.flex"
                        	return MakeToken(symID.ML_COMMENT, yytext());	
#line default
          }
          break;
        case 178: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 243 "csharp.flex"
                  return MakeToken(symID.STRUCT, "struct");			
#line default
          }
          break;
        case 9: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 274 "csharp.flex"
                            return MakeToken(symID.DOT, ".");		
#line default
          }
          break;
        case 168: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 258 "csharp.flex"
                 return MakeToken(symID.WHILE, "while");			
#line default
          }
          break;
        case 120: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 373 "csharp.flex"
                 	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, "\\");  	
#line default
          }
          break;
        case 152: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 354 "csharp.flex"
               	yybegin(PP_SYMBOLS); return MakeToken(symID.PP_UNDEFINE, stringBuf.ToString()+yytext()); 	
#line default
          }
          break;
        case 38: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 367 "csharp.flex"
                           	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, yytext()); 
#line default
          }
          break;
        case 33: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 414 "csharp.flex"
                              	stringBuf.Append(yytext()); 
#line default
          }
          break;
        case 127: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 375 "csharp.flex"
                 	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, "\a");  	
#line default
          }
          break;
        case 126: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 378 "csharp.flex"
                 	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, "\f");  	
#line default
          }
          break;
        case 51: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 447 "csharp.flex"
                       	yybegin(YYINITIAL);
  									return MakeToken(symID.NEWLINE, yytext());
  								
#line default
          }
          break;
        case 7: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 332 "csharp.flex"
                    	return MakeToken(symID.INT_LITERAL, yytext()); 	
#line default
          }
          break;
        case 138: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 220 "csharp.flex"
                return MakeToken(symID.LOCK, "lock");				
#line default
          }
          break;
        case 95: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 408 "csharp.flex"
               	stringBuf.Append( "\v" );  	
#line default
          }
          break;
        case 101: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 438 "csharp.flex"
                             	return MakeToken(symID.NOT_EQUAL, "!=");		
#line default
          }
          break;
        case 139: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 221 "csharp.flex"
                return MakeToken(symID.LONG, "long");				
#line default
          }
          break;
        case 67: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 215 "csharp.flex"
               return MakeToken(symID.IN, "in");					
#line default
          }
          break;
        case 205: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 185 "csharp.flex"
                                 return MakeToken(symID.ABSTRACT, "abstract");		
#line default
          }
          break;
        case 27: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 296 "csharp.flex"
                            return MakeToken(symID.BIN_XOR, "^");			
#line default
          }
          break;
        case 11: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 325 "csharp.flex"
            	yybegin(YYINITIAL_STRING);
  									stringBuf.Length = 0;
  								
#line default
          }
          break;
        case 90: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 412 "csharp.flex"
               	stringBuf.Append( "\r" );  	
#line default
          }
          break;
        case 81: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 305 "csharp.flex"
                             return MakeToken(symID.SHIFTR, ">>");			
#line default
          }
          break;
        case 116: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 316 "csharp.flex"
                              return MakeToken(symID.SHIFTL_ASSIGN, "<<=");	
#line default
          }
          break;
        case 170: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 356 "csharp.flex"
                	yybegin(PP_HOOVER); return MakeToken(symID.PP_ERROR, stringBuf.ToString()+yytext()); 	
#line default
          }
          break;
        case 61: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 309 "csharp.flex"
                             return MakeToken(symID.MINUS_ASSIGN, "-=");	
#line default
          }
          break;
        case 148: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 370 "csharp.flex"
                                     yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, Int32.Parse(yytext().Substring(2), NumberStyles.HexNumber).ToString()); 
#line default
          }
          break;
        case 194: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 207 "csharp.flex"
                               return MakeToken(symID.FINALLY, "finally");		
#line default
          }
          break;
        case 56: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 334 "csharp.flex"
                     	return MakeToken(symID.LONG_LITERAL, yytext()); 
#line default
          }
          break;
        case 82: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 343 "csharp.flex"
                     	return MakeToken(symID.IDENTIFIER, yytext().Substring(1));	
#line default
          }
          break;
        case 184: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 201 "csharp.flex"
                               return MakeToken(symID.DOUBLE, "double");			
#line default
          }
          break;
        case 165: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 195 "csharp.flex"
                               return MakeToken(symID.CLASS, "class");			
#line default
          }
          break;
        case 206: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 199 "csharp.flex"
                               return MakeToken(symID.DELEGATE, "delegate");		
#line default
          }
          break;
        case 34: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 418 "csharp.flex"
                                   	throw new SemanticException("CS1039: Unterminated string literal", fileinfo.FullName, yyline, yycolumn); 
#line default
          }
          break;
        case 22: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 286 "csharp.flex"
                            return MakeToken(symID.COMMA, ",");			
#line default
          }
          break;
        case 59: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 338 "csharp.flex"
                       	return MakeToken(symID.DECIMAL_LITERAL, yytext());
#line default
          }
          break;
        case 77: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 315 "csharp.flex"
                             return MakeToken(symID.BIN_XOR_ASSIGN, "^=");	
#line default
          }
          break;
        case 35: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 397 "csharp.flex"
            	yybegin(YYINITIAL); 
  									return MakeToken(symID.STRING_LITERAL, stringBuf.ToString());
  								
#line default
          }
          break;
        case 133: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 177 "csharp.flex"
                                return MakeToken(symID.TRUE, "true");			
#line default
          }
          break;
        case 195: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 179 "csharp.flex"
                                return MakeToken(symID.DEFAULT, "default");	
#line default
          }
          break;
        case 73: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 280 "csharp.flex"
                             return MakeToken(symID.EQUAL, "==");			
#line default
          }
          break;
        case 167: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 269 "csharp.flex"
                 return MakeToken(symID.LITERAL_param, "param");		
#line default
          }
          break;
        case 177: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 206 "csharp.flex"
                  return MakeToken(symID.EXTERN, "extern");			
#line default
          }
          break;
        case 185: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 225 "csharp.flex"
                  return MakeToken(symID.OBJECT, "object");			
#line default
          }
          break;
        case 129: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 379 "csharp.flex"
                 	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, "\n");  	
#line default
          }
          break;
        case 53: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 311 "csharp.flex"
                             return MakeToken(symID.DIV_ASSIGN, "/=");		
#line default
          }
          break;
        case 40: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 362 "csharp.flex"
                                   	throw new SemanticException("CS1024: Preprocessor directive expected", fileinfo.FullName, yyline, yycolumn); 
#line default
          }
          break;
        case 88: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 404 "csharp.flex"
               	stringBuf.Append( "\"" );  	
#line default
          }
          break;
        case 146: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 212 "csharp.flex"
                return MakeToken(symID.GOTO, "goto");				
#line default
          }
          break;
        case 201: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 357 "csharp.flex"
                  	yybegin(PP_HOOVER); return MakeToken(symID.PP_WARNING, stringBuf.ToString()+yytext()); 	
#line default
          }
          break;
        case 58: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 337 "csharp.flex"
                     	return MakeToken(symID.FLOAT_LITERAL, yytext());
#line default
          }
          break;
        case 87: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 403 "csharp.flex"
               	stringBuf.Append( "'" );  	
#line default
          }
          break;
        case 75: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 302 "csharp.flex"
                             return MakeToken(symID.INC, "++");			
#line default
          }
          break;
        case 83: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 322 "csharp.flex"
              	yybegin(YYINITIAL_VERBATIM);
  									stringBuf.Length = 0;
  								
#line default
          }
          break;
        case 69: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 278 "csharp.flex"
                             return MakeToken(symID.LOG_AND, "&&");		
#line default
          }
          break;
        case 91: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 410 "csharp.flex"
               	stringBuf.Append( "\f" );  	
#line default
          }
          break;
        case 197: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 194 "csharp.flex"
                               return MakeToken(symID.CHECKED, "checked");		
#line default
          }
          break;
        case 5: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 292 "csharp.flex"
                            return MakeToken(symID.DIV, "/");				
#line default
          }
          break;
        case 16: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 295 "csharp.flex"
                            return MakeToken(symID.BIN_OR, "|");			
#line default
          }
          break;
        case 158: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 209 "csharp.flex"
                               return MakeToken(symID.FLOAT, "float");			
#line default
          }
          break;
        case 172: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 253 "csharp.flex"
                  return MakeToken(symID.USHORT, "ushort");			
#line default
          }
          break;
        case 71: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 279 "csharp.flex"
                             return MakeToken(symID.LOG_OR, "||");			
#line default
          }
          break;
        case 123: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 372 "csharp.flex"
                 	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, "\"");  	
#line default
          }
          break;
        case 147: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 256 "csharp.flex"
                return MakeToken(symID.VOID, "void");				
#line default
          }
          break;
        case 43: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 439 "csharp.flex"
                    	return MakeToken(symID.PP_IDENT, yytext());	
#line default
          }
          break;
        case 113: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 223 "csharp.flex"
                return MakeToken(symID.NEW, "new");				
#line default
          }
          break;
        case 74: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 308 "csharp.flex"
                             return MakeToken(symID.PLUS_ASSIGN, "+=");	
#line default
          }
          break;
        case 66: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 219 "csharp.flex"
               return MakeToken(symID.IS, "is");					
#line default
          }
          break;
        case 94: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 411 "csharp.flex"
               	stringBuf.Append( "\n" );  	
#line default
          }
          break;
        case 171: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 353 "csharp.flex"
                	yybegin(PP_SYMBOLS); return MakeToken(symID.PP_COND_ENDIF, stringBuf.ToString()+yytext()); 	
#line default
          }
          break;
        case 193: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 211 "csharp.flex"
                   return MakeToken(symID.FOREACH, "foreach");		
#line default
          }
          break;
        case 68: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 281 "csharp.flex"
                             return MakeToken(symID.NOT_EQUAL, "!=");		
#line default
          }
          break;
        case 118: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 402 "csharp.flex"
                                 	stringBuf.Append(Int32.Parse(yytext().Substring(2), NumberStyles.HexNumber).ToString()); 
#line default
          }
          break;
        case 142: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 190 "csharp.flex"
                              return MakeToken(symID.BYTE, "byte");				
#line default
          }
          break;
        case 166: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 196 "csharp.flex"
                               return MakeToken(symID.CONST, "const");			
#line default
          }
          break;
        case 111: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 264 "csharp.flex"
                return MakeToken(symID.LITERAL_set, "set");			
#line default
          }
          break;
        case 31: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 301 "csharp.flex"
                            return MakeToken(symID.QUESTION, "?");		
#line default
          }
          break;
        case 3: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 344 "csharp.flex"
                    	return MakeToken(symID.IDENTIFIER, yytext());	
#line default
          }
          break;
        case 153: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 250 "csharp.flex"
                 return MakeToken(symID.ULONG, "ulong");			
#line default
          }
          break;
        case 199: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 230 "csharp.flex"
                   return MakeToken(symID.PRIVATE, "private");		
#line default
          }
          break;
        case 79: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 304 "csharp.flex"
                             return MakeToken(symID.SHIFTL, "<<");			
#line default
          }
          break;
        case 150: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 352 "csharp.flex"
               	yybegin(PP_SYMBOLS); return MakeToken(symID.PP_COND_ELSE, stringBuf.ToString()+yytext()); 	
#line default
          }
          break;
        case 52: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 329 "csharp.flex"
                         	return MakeToken(symID.SL_COMMENT, yytext());	
#line default
          }
          break;
        case 140: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 187 "csharp.flex"
                              return MakeToken(symID.BASE, "base");				
#line default
          }
          break;
        case 183: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 244 "csharp.flex"
                  return MakeToken(symID.SWITCH, "switch");			
#line default
          }
          break;
        case 122: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 371 "csharp.flex"
                 	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, "'");  	
#line default
          }
          break;
        case 65: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 213 "csharp.flex"
               return MakeToken(symID.IF, "if");					
#line default
          }
          break;
        case 92: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 407 "csharp.flex"
               	stringBuf.Append( "\a" );  	
#line default
          }
          break;
        case 49: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 457 "csharp.flex"
            	throw new SemanticException("PP_HOOVER: Unexpected input '"+yytext()+"'", fileinfo.FullName, yyline, yycolumn); 	
#line default
          }
          break;
        case 80: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 307 "csharp.flex"
                             return MakeToken(symID.GTE, ">=");			
#line default
          }
          break;
        case 136: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 202 "csharp.flex"
                              return MakeToken(symID.ELSE, "else");				
#line default
          }
          break;
        case 204: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 265 "csharp.flex"
                   return MakeToken(symID.LITERAL_assembly, "assembly");	
#line default
          }
          break;
        case 85: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 405 "csharp.flex"
               	stringBuf.Append( "\\" );  	
#line default
          }
          break;
        case 42: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 426 "csharp.flex"
                            	return MakeToken(symID.WHITESPACE, yytext());	
#line default
          }
          break;
        case 128: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 377 "csharp.flex"
                 	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, "\b");  	
#line default
          }
          break;
        case 30: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 300 "csharp.flex"
                            return MakeToken(symID.GTHAN, ">");			
#line default
          }
          break;
        case 18: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 282 "csharp.flex"
                            return MakeToken(symID.OPEN_CURLY, "{");		
#line default
          }
          break;
        case 157: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 178 "csharp.flex"
                                 return MakeToken(symID.FALSE, "false");		
#line default
          }
          break;
        case 2: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 331 "csharp.flex"
                            	return MakeToken(symID.WHITESPACE, yytext()); 	
#line default
          }
          break;
        case 130: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 376 "csharp.flex"
                 	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, "\v");  	
#line default
          }
          break;
        case 99: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 429 "csharp.flex"
                         	return MakeToken(symID.SL_COMMENT, yytext());	
#line default
          }
          break;
        case 47: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 433 "csharp.flex"
                            	return MakeToken(symID.CLOSE_PAREN, ")");		
#line default
          }
          break;
        case 89: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 413 "csharp.flex"
               	stringBuf.Append( "\t" );  	
#line default
          }
          break;
        case 196: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 198 "csharp.flex"
                               return MakeToken(symID.DECIMAL, "decimal");		
#line default
          }
          break;
        case 97: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 384 "csharp.flex"
                                  	throw new SemanticException("CS1009: Unrecognized escape sequence '" +yytext()+ "'", fileinfo.FullName, yyline, yycolumn); 
#line default
          }
          break;
        case 8: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 290 "csharp.flex"
                            return MakeToken(symID.MINUS, "-");			
#line default
          }
          break;
        case 132: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 249 "csharp.flex"
                return MakeToken(symID.UINT, "uint");				
#line default
          }
          break;
        case 28: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 297 "csharp.flex"
                            return MakeToken(symID.BIN_NOT, "~");			
#line default
          }
          break;
        case 36: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 390 "csharp.flex"
               	stringBuf.Append( yytext() ); 	
#line default
          }
          break;
        case 70: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 313 "csharp.flex"
                             return MakeToken(symID.BIN_AND_ASSIGN, "&=");	
#line default
          }
          break;
        case 32: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 339 "csharp.flex"
                                 	yybegin(YYINITIAL_PP);
  									stringBuf.Length = 0;
  									stringBuf.Append( yytext() );
								
#line default
          }
          break;
        case 212: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 257 "csharp.flex"
                   return MakeToken(symID.VOLATILE, "volatile");		
#line default
          }
          break;
        case 24: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 288 "csharp.flex"
                            return MakeToken(symID.SEMI, ";");			
#line default
          }
          break;
        case 189: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 229 "csharp.flex"
                  return MakeToken(symID.PARAMS, "params");			
#line default
          }
          break;
        case 55: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 333 "csharp.flex"
                     	return MakeToken(symID.UINT_LITERAL, yytext()); 
#line default
          }
          break;
        case 144: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 193 "csharp.flex"
                              return MakeToken(symID.CHAR, "char");				
#line default
          }
          break;
        case 21: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 285 "csharp.flex"
                            return MakeToken(symID.CLOSE_BRACK, "]");		
#line default
          }
          break;
        case 121: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 374 "csharp.flex"
                 	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, "\0");  	
#line default
          }
          break;
        case 210: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 218 "csharp.flex"
                   return MakeToken(symID.INTERNAL, "internal");		
#line default
          }
          break;
        case 186: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 267 "csharp.flex"
                  return MakeToken(symID.LITERAL_method, "method");		
#line default
          }
          break;
        case 107: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 247 "csharp.flex"
                return MakeToken(symID.TRY, "try");				
#line default
          }
          break;
        case 125: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 380 "csharp.flex"
                 	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, "\r");  	
#line default
          }
          break;
        case 134: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 271 "csharp.flex"
                return MakeToken(symID.LITERAL_type, "type");			
#line default
          }
          break;
        case 76: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 312 "csharp.flex"
                             return MakeToken(symID.MOD_ASSIGN, "%=");		
#line default
          }
          break;
        case 109: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 210 "csharp.flex"
                             return MakeToken(symID.FOR, "for");				
#line default
          }
          break;
        case 207: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 197 "csharp.flex"
                               return MakeToken(symID.CONTINUE, "continue");		
#line default
          }
          break;
        case 112: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 227 "csharp.flex"
                return MakeToken(symID.OUT, "out");				
#line default
          }
          break;
        case 50: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 454 "csharp.flex"
           	return MakeToken(symID.PP_STRING, yytext());					
#line default
          }
          break;
        case 57: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 336 "csharp.flex"
                      	return MakeToken(symID.DOUBLE_LITERAL, yytext());
#line default
          }
          break;
        case 100: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 428 "csharp.flex"
                                	return MakeToken(symID.PP_FILENAME, yytext());	
#line default
          }
          break;
        case 106: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 335 "csharp.flex"
                     	return MakeToken(symID.ULONG_LITERAL, yytext());
#line default
          }
          break;
        case 117: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 317 "csharp.flex"
                              return MakeToken(symID.SHIFTR_ASSIGN, ">>=");	
#line default
          }
          break;
        case 200: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 369 "csharp.flex"
                              	yybegin(YYINITIAL); return MakeToken(symID.CHAR_LITERAL, Int32.Parse(yytext().Substring(2), NumberStyles.HexNumber).ToString()); 
#line default
          }
          break;
        case 159: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 208 "csharp.flex"
                               return MakeToken(symID.FIXED, "fixed");			
#line default
          }
          break;
        case 45: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 427 "csharp.flex"
                 	return MakeToken(symID.PP_NUMBER, yytext());	
#line default
          }
          break;
        case 20: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 284 "csharp.flex"
                            return MakeToken(symID.OPEN_BRACK, "[");		
#line default
          }
          break;
        case 160: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 266 "csharp.flex"
                 return MakeToken(symID.LITERAL_field, "field");		
#line default
          }
          break;
        case 214: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 251 "csharp.flex"
                    return MakeToken(symID.UNCHECKED, "unchecked");	
#line default
          }
          break;
        case 169: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 349 "csharp.flex"
                	yybegin(PP_SYMBOLS); return MakeToken(symID.PP_UNDEFINE, stringBuf.ToString()+yytext()); 	
#line default
          }
          break;
        case 19: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 283 "csharp.flex"
                            return MakeToken(symID.CLOSE_CURLY, "}");		
#line default
          }
          break;
        case 202: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 233 "csharp.flex"
                   return MakeToken(symID.READONLY, "readonly");		
#line default
          }
          break;
        case 143: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 191 "csharp.flex"
                              return MakeToken(symID.CASE, "case");				
#line default
          }
          break;
        case 39: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 385 "csharp.flex"
                                   	throw new SemanticException("CS1003: Syntax error, 'char' expected", fileinfo.FullName, yyline, yycolumn); 
#line default
          }
          break;
        case 17: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 298 "csharp.flex"
                            return MakeToken(symID.ASSIGN, "=");			
#line default
          }
          break;
        case 211: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 214 "csharp.flex"
                   return MakeToken(symID.IMPLICIT, "implicit");		
#line default
          }
          break;
        case 110: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 261 "csharp.flex"
                return MakeToken(symID.LITERAL_add, "add");			
#line default
          }
          break;
        case 208: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 228 "csharp.flex"
                   return MakeToken(symID.OVERRIDE, "override");		
#line default
          }
          break;
        case 48: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 434 "csharp.flex"
                            	return MakeToken(symID.LOG_NOT, "!");			
#line default
          }
          break;
        case 198: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 255 "csharp.flex"
                   return MakeToken(symID.VIRTUAL, "virtual");		
#line default
          }
          break;
        case 191: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 358 "csharp.flex"
                 	yybegin(PP_HOOVER); return MakeToken(symID.PP_REGION, stringBuf.ToString()+yytext()); 	
#line default
          }
          break;
        case 105: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 450 "csharp.flex"
                         	yybegin(YYINITIAL);
  									return MakeToken(symID.SL_COMMENT, yytext());
  								
#line default
          }
          break;
        case 104: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 437 "csharp.flex"
                             	return MakeToken(symID.EQUAL, "==");			
#line default
          }
          break;
        case 182: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 239 "csharp.flex"
                  return MakeToken(symID.SIZEOF, "sizeof");			
#line default
          }
          break;
        case 176: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 262 "csharp.flex"
                  return MakeToken(symID.LITERAL_remove, "remove");		
#line default
          }
          break;
        case 164: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 192 "csharp.flex"
                               return MakeToken(symID.CATCH, "catch");			
#line default
          }
          break;
        case 162: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 238 "csharp.flex"
                 return MakeToken(symID.SHORT, "short");			
#line default
          }
          break;
        case 1: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 462 "csharp.flex"
                       	throw new SemanticException("Illegal character '"+yytext()+"' at line "+yyline+", column "+yycolumn, fileinfo.FullName, yyline, yycolumn); 	
#line default
          }
          break;
        case 135: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 245 "csharp.flex"
                return MakeToken(symID.THIS, "this");				
#line default
          }
          break;
        case 64: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 200 "csharp.flex"
                            return MakeToken(symID.DO, "do");					
#line default
          }
          break;
        case 41: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 442 "csharp.flex"
            	throw new SemanticException("PP_SYMBOLS: Unexpected input '"+yytext()+"'", fileinfo.FullName, yyline, yycolumn); 
#line default
          }
          break;
        case 179: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 242 "csharp.flex"
                  return MakeToken(symID.STRING, "string");			
#line default
          }
          break;
        case 175: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 235 "csharp.flex"
                  return MakeToken(symID.RETURN, "return");			
#line default
          }
          break;
        case 37: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 391 "csharp.flex"
            	yybegin(YYINITIAL); 
  									return MakeToken(symID.STRING_LITERAL, stringBuf.ToString());
  								
#line default
          }
          break;
        case 219: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 240 "csharp.flex"
                     return MakeToken(symID.STACKALLOC, "stackalloc");	
#line default
          }
          break;
        case 96: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 389 "csharp.flex"
               	stringBuf.Append( "\"" ); 		
#line default
          }
          break;
        case 154: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 254 "csharp.flex"
                 return MakeToken(symID.USING, "using");			
#line default
          }
          break;
        case 29: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 299 "csharp.flex"
                            return MakeToken(symID.LTHAN, "<");			
#line default
          }
          break;
        case 114: 
          if (ZZ_SPURIOUS_WARNINGS_SUCK)
          {
#line 216 "csharp.flex"
                return MakeToken(symID.INT, "int");				
#line default
          }
          break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              if (ZZ_SPURIOUS_WARNINGS_SUCK)
              { return new CustomHiddenStreamToken(Token.EOF_TYPE, "EOF"); }
              break;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
          break;
      }
    }
  }


}
#line 466 "csharp.flex"

} // End of namespace declaration

#line default
