/*
 *========================================================================
 * $Id: commands.h 91 2002-04-15 01:36:09Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

 /*
  * The following enumerates and defines all the base
  * commands recognized by xmlsysd.  
  *
  * init      - opens all /proc files and does a sendall.  Note that
  *             toggling a proc-derived field group does NOT cause the
  *             files to be closed -- they just aren't rewound and
  *             processed and sent on a "send" command.  This command
  *             should therefore be the first thing sent to the daemon.
  * sendall   - sends all non-PID fields, regardless of the state of their
  *             toggle controls.  PID fields are sent according to their
  *             controls, which may be in their default (running, no root)
  *             state.
  * send      - sends an update of all fields according to the state of 
  *             their controls.
  * on fgrp1 [fgrp2 fgrp3...]
  *           - turns the control toggle for a given list of field groups
  *             "on" (send if available).
  * off fgrp1 [fgrp2 fgpr3...]
  *           - turns the control toggle for a given list of field groups
  *             "off" (do NOT send).
  * adduser X - causes user X to be added to the user list.  If this list
  *             is not empty, only processes belonging to users on this
  *             list are monitored.
  * rmuser X  - removes user X from the user list, if they are there to
  *             begin with.
  * clrusers  - clears user list.
  * addtask X - causes task X to be added to the task list.  If this list
  *             is not empty, only processes whose name matches an entry on
  *             this list are monitored.
  * rmtask X  - removes task X from the task list, if it is there to be
  *             removed.
  * clrtask   - clears task list.
  *
  *             Note that user/task controls are combined with an "and"
  *             operator to facilitate task exclusion over inclusion.
  *             If both lists are non-empty, only tasks matching one of
  *             the task names belonging to users matching one of the
  *             user names are monitored.  However, if either list is
  *             empty, only the other list is used -- a null list is
  *             is promiscuous.
  *
  * compress  - short for off whitespace;on compress (minimum packet size).
  * expand    - short for on whitespace;off compress (easiest to read).
  *
  * verbose N - controls verbosity (for debugging only).
  * quit      - causes this instance of xmlsysd to exit.
  */
 typedef enum { 
   INIT,
   SENDALL,
   SEND,
   ON,
   OFF,
   ADDUSER,
   RMUSER,
   CLRUSER,
   ADDTASK,
   RMTASK,
   CLRTASK,
   COMPRESS,
   EXPAND,
   RUNTIME,
   VERBOSE,
   QUIT,
   N_COMMANDS
 } Commands;

 /* 
  * if you add new commands that share leading characters (like sendall and
  * send) be sure the LONGEST one is first or the shorter one will match
  * accidentally in the parsing loop.
  */
 static char *commands[] = {
  "init",
  "sendall",
  "send",
  "on",
  "off",
  "adduser",
  "rmuser",
  "clruser",
  "addtask",
  "rmtask",
  "clrtask",
  "compress",
  "expand",
  "runtime",
  "verbose",
  "quit",
  "n_commands"
 };

