
SET(COLLECTION_PATH ${TEST_NIST_DATA_ROOT} )

MACRO(TEST_NIST_PHANTOM_DATASET MASTER_DATASET_ID DATASET_ID ROI_X ROI_Y ROI_Z ROI_DX ROI_DY ROI_DZ)

SET(DATASET_ROI ${TEMP}/${DATASET_ID}_ROI.mha)

EXTRACT_REGION_OF_INTEREST(${MASTER_DATASET_ID} ${DATASET_ID} ${ROI_X} ${ROI_Y} ${ROI_Z} ${ROI_DX} ${ROI_DY} ${ROI_DZ} )
GENERATE_FEATURES( ${DATASET_ID} )

SCREEN_SHOT_FEATURES( ${DATASET_ID} 001 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 002 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 003 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 004 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 005 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 006 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 007 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 008 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 009 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 010 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 011 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 012 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 013 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 014 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 015 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 016 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 017 )
SCREEN_SHOT_FEATURES( ${DATASET_ID} 018 )

ENDMACRO(TEST_NIST_PHANTOM_DATASET)


# These phantoms have been arranged in the following configuration. If you look
# along the axial view, 
#             A
#    
#        CR1     CL1          
#        CR2     CL2          
#        CR3     CL3          
# R      CR4     CL4       L
#        CR5     CL5          
#        CR6     CL6          
#        CR7     CL7          
#        
#             P
#
# The configration CL1 and CL7 have an alternating pattern of 6.350 mm and 7.144 mm balls.
# The others have an alternating pattern of 5.556 mm and 7.938 mm balls.
#
CONVERT_DICOM_TO_META( ${COLLECTION_PATH} NIST_A "BX0317/20000101-135244-7-1")

#
# Extract ROI and compute features for it
#
# CR1 ..
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCR1 
  160  95   60
   70  40  110
  )

# CL1 ..
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCL1 
  274 91 52
  77 43 129  )

# CR2 ..
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCR2
  176 139 81
  61 40 117
  )

# CL2
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCL2
  283 141 58
   64 48  118  )

# CR3 
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCR3 
  170 200 44 
   70  40 110
  )

# CL3
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCL3
  264 191  49
   76  49 115  )

# CR4
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCR4
  127 248  65
  63  40   117  )

# CL4
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCL4
  309 240 43
   72 46 121  )

# CR5 ..
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCR5 
  168  291   75
   70   40  110
  )

# CL5
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCL5
  298 296 76
  63 35 120  )

# CR6
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCR6
  168 338 37
  64 40 118  )

# CL6
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCL6
  305 345 63
  63 36 118  )

# CR7
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCR7 
  160 392   85
   70  40  110
  )

# CL7
TEST_NIST_PHANTOM_DATASET(NIST_A NISTCL7 
  310 390 120 
   70  40 110
  )


SET(VOLUME_NIST_BEAD_A    89.801 ) # Diameter 5.556 mm
SET(VOLUME_NIST_BEAD_B   134.066 ) # Diameter 6.350 mm
SET(VOLUME_NIST_BEAD_C   190.907 ) # Diameter 7.144 mm
SET(VOLUME_NIST_BEAD_D   261.897 ) # Diameter 7.938 mm

#
# From the same feature images and ROI, use different sets of seed points
#
COMPUTE_SEGMENTATIONS( NISTCR1 001  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 002  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 003  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 004  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 005  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 006  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 007  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 008  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 009  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 010  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 011  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 012  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 013  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 014  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 015  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 016  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 017  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR1 018  ${VOLUME_NIST_BEAD_D} AROUND_SEED)

COMPUTE_SEGMENTATIONS( NISTCL1 001  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 002  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 003  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 004  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 005  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 006  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 007  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 008  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 009  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 010  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 011  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 012  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 013  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 014  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 015  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 016  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 017  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL1 018  ${VOLUME_NIST_BEAD_B} AROUND_SEED)

COMPUTE_SEGMENTATIONS( NISTCR2 001  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 002  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 003  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 004  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 005  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 006  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 007  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 008  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 009  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 010  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 011  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 012  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 013  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 014  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 015  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 016  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 017  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR2 018  ${VOLUME_NIST_BEAD_D} AROUND_SEED)

COMPUTE_SEGMENTATIONS( NISTCL2 001  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 002  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 003  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 004  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 005  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 006  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 007  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 008  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 009  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 010  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 011  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 012  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 013  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 014  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 015  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 016  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 017  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL2 018  ${VOLUME_NIST_BEAD_A} AROUND_SEED)

COMPUTE_SEGMENTATIONS( NISTCR3 001  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 002  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 003  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 004  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 005  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 006  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 007  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 008  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 009  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 010  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 011  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 012  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 013  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 014  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 015  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 016  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 017  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR3 018  ${VOLUME_NIST_BEAD_D} AROUND_SEED)

COMPUTE_SEGMENTATIONS( NISTCL3 001  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 002  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 003  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 004  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 005  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 006  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 007  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 008  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 009  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 010  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 011  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 012  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 013  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 014  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 015  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 016  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 017  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL3 018  ${VOLUME_NIST_BEAD_D} AROUND_SEED)

COMPUTE_SEGMENTATIONS( NISTCR4 001  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 002  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 003  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 004  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 005  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 006  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 007  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 008  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 009  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 010  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 011  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 012  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 013  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 014  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 015  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 016  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 017  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR4 018  ${VOLUME_NIST_BEAD_D} AROUND_SEED)

COMPUTE_SEGMENTATIONS( NISTCL4 001  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 002  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 003  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 004  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 005  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 006  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 007  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 008  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 009  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 010  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 011  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 012  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 013  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 014  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 015  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 016  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 017  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL4 018  ${VOLUME_NIST_BEAD_A} AROUND_SEED)

COMPUTE_SEGMENTATIONS( NISTCR5 001  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 002  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 003  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 004  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 005  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 006  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 007  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 008  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 009  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 010  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 011  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 012  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 013  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 014  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 015  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 016  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 017  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR5 018  ${VOLUME_NIST_BEAD_D} AROUND_SEED)

COMPUTE_SEGMENTATIONS( NISTCL5 001  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 002  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 003  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 004  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 005  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 006  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 007  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 008  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 009  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 010  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 011  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 012  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 013  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 014  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 015  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 016  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 017  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL5 018  ${VOLUME_NIST_BEAD_D} AROUND_SEED)

COMPUTE_SEGMENTATIONS( NISTCR6 001  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 002  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 003  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 004  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 005  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 006  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 007  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 008  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 009  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 010  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 011  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 012  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 013  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 014  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 015  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 016  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 017  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR6 018  ${VOLUME_NIST_BEAD_A} AROUND_SEED)

COMPUTE_SEGMENTATIONS( NISTCL6 001  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 002  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 003  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 004  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 005  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 006  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 007  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 008  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 009  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 010  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 011  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 012  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 013  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 014  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 015  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 016  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 017  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL6 018  ${VOLUME_NIST_BEAD_D} AROUND_SEED)

COMPUTE_SEGMENTATIONS( NISTCR7 001  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 002  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 003  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 004  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 005  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 006  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 007  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 008  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 009  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 010  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 011  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 012  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 013  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 014  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 015  ${VOLUME_NIST_BEAD_A} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 016  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 017  ${VOLUME_NIST_BEAD_D} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCR7 018  ${VOLUME_NIST_BEAD_D} AROUND_SEED)

COMPUTE_SEGMENTATIONS( NISTCL7 001  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 002  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 003  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 004  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 005  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 006  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 007  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 008  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 009  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 010  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 011  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 012  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 013  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 014  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 015  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 016  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 017  ${VOLUME_NIST_BEAD_B} AROUND_SEED)
COMPUTE_SEGMENTATIONS( NISTCL7 018  ${VOLUME_NIST_BEAD_C} AROUND_SEED)
