/***************************************************************************
                          dcsplash.cpp  -  description
                             -------------------
    begin                : Fre Apr 12 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcsplash.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qlabel.h>
#include <qpixmap.h>

#include "dciconloader.h"

/** */
DCSplash::DCSplash( QWidget * parent ) : QWidget( parent )
{
	setupUi(this);
	
	setWindowFlags(Qt::SplashScreen);
	
	QPalette palette = Frame_PIXMAP->palette();
	palette.setBrush( Frame_PIXMAP->backgroundRole(), QBrush(g_pIconLoader->GetPixmap(eiSPLASH)) );
	palette.setColor( Frame_PIXMAP->foregroundRole(), QColor(255, 255, 255) );
	
	Frame_PIXMAP->setPalette(palette);
	
	// no tr() since translator hasn't been loaded yet
	Frame_PIXMAP->setText( QString::fromAscii("Valknut ") + QString::fromAscii(PACKAGE_VERSION) + QString::fromAscii("\n\n\nhttp://wxdcgui.sourceforge.net") );
}

/** */
DCSplash::~DCSplash()
{
}

/** */
void DCSplash::mouseDoubleClickEvent( QMouseEvent * event )
{
	hide();

	QWidget::mouseDoubleClickEvent( event );    // standard event processing
}

/** */
void DCSplash::mousePressEvent( QMouseEvent * event )
{
	hide();

	QWidget::mousePressEvent( event );    // standard event processing
}

/** */
void DCSplash::mouseReleaseEvent( QMouseEvent * event )
{
	hide();

	QWidget::mouseReleaseEvent( event );    // standard event processing
}

