//
// The developer of the original code and/or files is Tripwire, Inc.
// Portions created by Tripwire, Inc. are copyright (C) 2000 Tripwire,
// Inc. Tripwire is a registered trademark of Tripwire, Inc.  All rights
// reserved.
// 
// This program is free software.  The contents of this file are subject
// to the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.  You may redistribute it and/or modify it
// only in compliance with the GNU General Public License.
// 
// This program is distributed in the hope that it will be useful.
// However, this program is distributed AS-IS WITHOUT ANY
// WARRANTY; INCLUDING THE IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS
// FOR A PARTICULAR PURPOSE.  Please see the GNU General Public License
// for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
// 
// Nothing in the GNU General Public License or any other license to use
// the code or files shall permit you to use Tripwire's trademarks,
// service marks, or other intellectual property without Tripwire's
// prior written consent.
// 
// If you have any questions, please contact Tripwire, Inc. at either
// info@tripwire.org or www.tripwire.org.
//
//
// Name....: twprintstrings.cpp
// Date....: 05/11/99
// Creator.: Brian McFeely (bmcfeely)
//

#include "stdtwprint.h"
#include "twprint.h"
#include "twprintstrings.h"

TSS_BeginStringtable( cTWPrint )
    
    TSS_StringEntry( twprint::STR_TWPRINT_USAGE_SUMMARY,           
                _T("Usage:\n")
                _T("\n")
                _T("Print Database:  twprint [-m d|--print-dbfile] [options] [object1 [object2...]]\n")    
                _T("Print Report:  twprint [-m r|--print-report] [options]\n")
				_T("Type 'twprint [mode] --help' OR\n")
				_T("'twprint --help mode [mode...]' OR\n")
				_T("'twprint --help all' for extended help\n")
                _T("\n")
				),

	TSS_StringEntry( twprint::STR_TWPRINT_HELP_PRINT_DATABASE,
                _T("Print Database mode:\n")
                _T("  -m d                 --print-dbfile\n")
				_T("  -v                   --verbose\n")
				_T("  -s                   --silent, --quiet\n")
                _T("  -c cfgfile           --cfgfile cfgfile\n")
                _T("  -d database          --dbfile database\n")
                _T("  -L localkey	       --local-keyfile localkey\n")
                _T("[object1 [object2 ...]\n")
                _T("\n")
				_T("The -v and -s options are mutually exclusive.\n")
                _T("\n")
				),

	TSS_StringEntry( twprint::STR_TWPRINT_HELP_PRINT_REPORT,
                _T("Print Report mode:\n")
                _T("  -m r                 --print-report\n")
				_T("  -v                   --verbose\n")
				_T("  -s                   --silent, --quiet\n")
                _T("  -c cfgfile           --cfgfile cfgfile\n")
                _T("  -r report            --twrfile report\n")
                _T("  -L localkey	       --local-keyfile localkey\n")
				_T("  -t { 0|1|2|3|4 }     --report-level { 0|1|2|3|4 }\n")
                _T("\n")
				_T("The -v and -s options are mutually exclusive.\n")
                _T("\n")
              ),
    
    TSS_StringEntry( twprint::STR_TWPRINT_VERSION, _T("twprint: Tripwire database and report printer.\n") ),

TSS_EndStringtable( cTWPrint )

