C    Copyright (c) 2014, Sandia Corporation.
C    Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
C    the U.S. Government retains certain rights in this software.
C    
C    Redistribution and use in source and binary forms, with or without
C    modification, are permitted provided that the following conditions are
C    met:
C    
C        * Redistributions of source code must retain the above copyright
C          notice, this list of conditions and the following disclaimer.
C    
C        * Redistributions in binary form must reproduce the above
C          copyright notice, this list of conditions and the following
C          disclaimer in the documentation and/or other materials provided
C          with the distribution.
C    
C        * Neither the name of Sandia Corporation nor the names of its
C          contributors may be used to endorse or promote products derived
C          from this software without specific prior written permission.
C    
C    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
C    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
C    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
C    A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
C    OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
C    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
C    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
C    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
C    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
C    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
C    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
C    

C $Id: erasel.F,v 1.1 1998/04/10 04:30:15 gdsjaar Exp $
C $Log: erasel.F,v $
C Revision 1.1  1998/04/10 04:30:15  gdsjaar
C Added the ifdef needsdoubleescape to the graphics symbol
C plotting. Required moving some .f to .F files and specifying in Imakefile
C
C Revision 1.1.1.1  1990/11/30 11:06:49  gdsjaar
C FASTQ Version 2.0X
C
c Revision 1.1  90/11/30  11:06:48  gdsjaar
c Initial revision
c 
C
CC* FILE: [.MAIN]ERASEL.FOR
CC* MODIFIED BY: TED BLACKER
CC* MODIFICATION DATE: 7/6/90
CC* MODIFICATION: COMPLETED HEADER INFORMATION
C
      SUBROUTINE ERASEL (MP, ML, MS, MR, N, COOR, ILINE, LTYPE, LCON,
     &   NLPS, IFLINE, ILLIST, NSPR, IFSIDE, ISLIST, LINKP, LINKL,
     &   LINKS, LINKR, IBAD, ALPHA)
C***********************************************************************
C
C  SUBROUTINE ERASEL = ERASES A LINE, AND ALL DATA DEPENDANT ON THAT
C                      LINE (I.E. SIDES OR REGIONS)
C
C***********************************************************************
C
      DIMENSION COOR(2, MP), ILINE(ML), LTYPE(ML), LCON(3, ML), NLPS(MS)
      DIMENSION NSPR(MR), IFLINE(MS), ILLIST(MS*3), IFSIDE(MR)
      DIMENSION ISLIST(MR*4), LINKP(2, MP), LINKL(2, ML), LINKS(2, MS)
      DIMENSION LINKR(2, MR), N(29)
C
      LOGICAL NUMPLT, ALPHA, ADDLNK, TEST, GETMAX
C
      IZ = 0
      KNUM = 0
      ADDLNK = .FALSE.
      TEST = .FALSE.
      GETMAX = .FALSE.
C
C  ERASE ANY REGIONS USING THAT LINE
C
      DO 120 I = 1, N(22)
         CALL LTSORT(MR, LINKR, I, II, ADDLNK)
         IF (II .GT. 0) THEN
            DO 110 J = IFSIDE(II), IFSIDE(II) + NSPR(II) - 1
               CALL LTSORT(MS, LINKS, ISLIST(J), IPNTR, ADDLNK)
               IF ((ISLIST(J) .GT. 0) .AND. (IPNTR .GT. 0)) THEN
                  JJ = ISLIST(J)
                  DO 100 K = IFLINE(JJ), IFLINE(JJ) + NLPS(JJ) - 1
                     KK = ILLIST(K)
                     IF (KK .EQ. IBAD) THEN
                        ADDLNK = .TRUE.
                        CALL LTSORT(MR, LINKR, I, IZ, ADDLNK)
                        ADDLNK = .FALSE.
                     END IF
  100             CONTINUE
               ELSE IF (ISLIST(J) .LT. 0) THEN
                  JJ = IABS(ISLIST(J))
                  IF (JJ .EQ. IBAD) THEN
                     ADDLNK = .TRUE.
                     CALL LTSORT(MR, LINKR, I, IZ, ADDLNK)
                     ADDLNK = .FALSE.
                  END IF
               END IF
  110       CONTINUE
C
            CALL LTSORT(MR, LINKR, I, IPNTR, ADDLNK)
            IF ((.NOT.ALPHA) .AND. (IPNTR .LE. 0)) THEN
               CALL REGEXT (MP, ML, MS, MR, N, II, COOR, ILINE,
     &            LTYPE, LCON, NLPS, IFLINE, ILLIST, NSPR, IFSIDE,
     &            ISLIST, LINKP, LINKL, LINKS, LINKR, XMIN, XMAX,
     &            YMIN, YMAX)
               XMID = (XMAX + XMIN)/2.
               YMID = (YMAX + YMIN)/2.
#if NeedsDoubleEscape
               CALL MPD2SY(1, XMID, YMID, '\\CDI')
#else
               CALL MPD2SY(1, XMID, YMID, '\CDI')
#endif
               CALL PLTFLU
            END IF
         END IF
  120 CONTINUE
C
C  ERASE ANY SIDES USING THAT LINE
C
      DO 150 I = 1, N(20)
         CALL LTSORT(MS, LINKS, I, II, ADDLNK)
         IF (II .GT. 0) THEN
            DO 130 J = IFLINE(II), NLPS(II) + IFLINE(II) - 1
               JJ = ILLIST(J)
               IF (JJ .EQ. IBAD) THEN
                  ADDLNK = .TRUE.
                  CALL LTSORT(MS, LINKS, I, IZ, ADDLNK)
                  ADDLNK = .FALSE.
                  GO TO 140
               END IF
  130       CONTINUE
  140       CONTINUE
         END IF
  150 CONTINUE
C
C  DELETE THE LINE
C
      CALL LTSORT(ML, LINKL, IBAD, II, ADDLNK)
      IF (II .GT. 0) THEN
         LT = LTYPE(II)
         IP1 = LCON(1, II)
         IP2 = LCON(2, II)
         IP3 = LCON(3, II)
         CALL LTSORT(MP, LINKP, IP1, IPNTR1, ADDLNK)
         CALL LTSORT(MP, LINKP, IP2, IPNTR2, ADDLNK)
         IF (IP3 .NE. 0) THEN
            CALL LTSORT(MP, LINKP, IABS(IP3), IPNTR3, ADDLNK)
         ELSE
            IPNTR3 = 0
         END IF
         IF ((IPNTR1 .GT. 0) .AND. (IPNTR2 .GT. 0) .AND.
     &      ((LT .EQ. 1) .OR. (IPNTR3 .GT. 0))) THEN
            IF (.NOT.ALPHA) THEN
               CALL DLINE(MP, ML, COOR, LINKP, KNUM, LT, IP1, IP2,
     &            IP3, NUMPLT, DUM1, DUM2, TEST, GETMAX, DUM3, DUM4,
     &            DUM5, DUM6)
               CALL PLTFLU
            END IF
         END IF
         ADDLNK = .TRUE.
         CALL LTSORT(ML, LINKL, IBAD, IZ, ADDLNK)
         ADDLNK = .FALSE.
      END IF
C
      RETURN
C
      END
