/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;

public class TeXPath {
    private Path base;
    private Path relative;
    private boolean foundByKpsewhich = false;

    public TeXPath(TeXParser teXParser, String string) throws IOException {
        this(teXParser, string, "tex", true);
    }

    public TeXPath(TeXParser teXParser, String string, boolean bl) throws IOException {
        this(teXParser, string, "tex", bl);
    }

    public TeXPath(TeXParser teXParser, String string, String string2) throws IOException {
        this(teXParser, string, string2, true);
    }

    public TeXPath(TeXParser teXParser, String string, String string2, boolean bl) throws IOException {
        this.init(teXParser, string, string2, bl);
    }

    public TeXPath(TeXParser teXParser, File file) throws IOException {
        this.init(teXParser, file);
    }

    private void init(TeXParser teXParser, File file) throws IOException {
        File file2 = teXParser == null ? null : teXParser.getCurrentParentFile();
        Path path = file.toPath();
        if (path.isAbsolute()) {
            this.base = null;
            this.relative = path;
        } else {
            this.base = file2 == null ? null : file2.toPath();
            this.relative = this.base == null ? path : this.base.relativize(path);
        }
    }

    private void init(TeXParser teXParser, String string, String string2) throws IOException {
        this.init(teXParser, string, string2, true);
    }

    private void init(TeXParser teXParser, String string, String string2, boolean bl) throws IOException {
        File file = teXParser == null ? null : teXParser.getCurrentParentFile();
        this.base = file == null ? null : file.toPath();
        String[] stringArray = string.split("/");
        int n = stringArray.length - 1;
        for (int i = 0; i < n; ++i) {
            file = file == null ? new File(stringArray[i]) : new File(file, stringArray[i]);
        }
        if (!string2.isEmpty() && !stringArray[n].contains(".")) {
            int n2 = n;
            stringArray[n2] = stringArray[n2] + "." + string2;
        }
        File file2 = file == null ? new File(stringArray[n]) : new File(file, stringArray[n]);
        this.relative = this.base == null ? file2.toPath() : this.base.relativize(file2.toPath());
        if (!file2.exists() && bl && teXParser != null) {
            try {
                String string3 = teXParser.getListener().getTeXApp().kpsewhich(stringArray[n]);
                if (string3 != null && !string3.isEmpty()) {
                    this.foundByKpsewhich = true;
                    this.init(teXParser, string3, "", false);
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
    }

    public Path getRelativePath() {
        return this.relative;
    }

    public Path getBaseDir() {
        return this.base;
    }

    public boolean isHidden() {
        String string;
        int n;
        if (this.base != null) {
            for (n = this.base.getNameCount() - 1; n >= 0; --n) {
                string = this.base.getName(n).toString();
                if (!string.startsWith(".") || string.equals(".") || string.equals("..")) continue;
                return true;
            }
        }
        for (n = this.relative.getNameCount() - 1; n >= 0; --n) {
            string = this.relative.getName(n).toString();
            if (!string.startsWith(".") || string.equals(".") || string.equals("..")) continue;
            return true;
        }
        return false;
    }

    public String getTeXPath(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Path> iterator = this.relative.iterator();
        while (iterator.hasNext()) {
            Path path = iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append(path.toString());
                stringBuilder.append('/');
                continue;
            }
            if (bl) {
                String string = path.toString();
                int n = string.lastIndexOf(".");
                if (n != -1) {
                    string = string.substring(0, n);
                }
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append(path.toString());
        }
        return stringBuilder.toString();
    }

    public File getFile() {
        return this.base == null ? this.relative.toFile() : this.base.resolve(this.relative).toFile();
    }

    public Path getPath() {
        return this.base == null ? this.relative : this.base.resolve(this.relative);
    }

    public Path getRelative() {
        return this.relative;
    }

    public Path getFileName() {
        return this.relative.getFileName();
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TeXPath)) {
            return false;
        }
        TeXPath teXPath = (TeXPath)object;
        if (this.base == null && teXPath.base == null) {
            return this.relative.equals(teXPath.relative);
        }
        if (this.base == null || teXPath.base == null) {
            return false;
        }
        return this.relative.equals(teXPath.relative);
    }

    public String toString() {
        return this.base == null ? this.relative.toString() : this.base.resolve(this.relative).toString();
    }

    public boolean wasFoundByKpsewhich() {
        return this.foundByKpsewhich;
    }
}

