## TFSA-2020-007: Null pointer dereference in TFLite

### CVE Number
CVE-2020-15209

### Impact
A crafted TFLite model can force a node to have as input a tensor backed by a
`nullptr` buffer. This can be achieved by changing a buffer index in the
flatbuffer serialization to convert a read-only tensor to a read-write one. The
runtime assumes that these buffers are written to before a possible read, hence
they are [initialized with
`nullptr`](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/lite/core/subgraph.cc#L1224-L1227):
```cc
  TfLiteTensorReset(type, name, ConvertArrayToTfLiteIntArray(rank, dims),
                    GetLegacyQuantization(quantization),
                    /*buffer=*/nullptr, required_bytes, allocation_type,
                    nullptr, is_variable, &tensor);
```

However, by changing the buffer index for a tensor and implicitly converting
that tensor to be a read-write one, as there is nothing in the model that writes
to it, we get a null pointer dereference.

### Vulnerable Versions
TensorFlow 1.15.0, 1.15.1, 1.15.2, 1.15.3, 2.0.0, 2.0.1, 2.0.2, 2.1.0, 2.1.1,
2.2.0, 2.3.0.

### Patches
We have patched the issue in
[0b5662bc](https://github.com/tensorflow/tensorflow/commit/0b5662bc) and will
release patch releases for all versions between 1.15 and 2.3.

We recommend users to upgrade to TensorFlow 1.15.4, 2.0.3, 2.1.2, 2.2.1, or
2.3.1.

### Workarounds
A potential workaround would be to add a custom `Verifier` to the model loading
code to ensure that no operator reuses tensors as both inputs and outputs. Care
should be taken to check all types of inputs (i.e., constant or variable tensors
as well as optional tensors).

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been discovered by members of the Aivul Team and is also
discoverable through a variant analysis of [another
vulnerability reported by members of the Aivul Team from Qihoo
360](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-005.md).
