#ifndef SRC_CORE_COMMAND_DEF_H_
#define SRC_CORE_COMMAND_DEF_H_

#define STR_NONE ""

#define STR_ADDMAX N_("Computes a new image combining the image in memory with the image <b>filename</b>. At each pixel location, the new value is determined as the max of value in current image and in <b>filename</b>")
#define STR_ASINH N_("Stretches the image to show faint objects using an hyperbolic arcsin transformation. The mandatory argument <b>stretch</b>, typically between 1 and 1000, will give the strength of the stretch. The black point can be offset by providing an optional <b>offset</b> argument in the normalized pixel value of [0, 1]. Finally the option <b>-human</b> enables using human eye luminous efficiency weights to compute the luminance used to compute the stretch value for each pixel, instead of the simple mean of the channels pixel values. This stretch method preserves lightness from the L*a*b* color space")
#define STR_AUTOGHS N_("Application of the generalized hyperbolic stretch with a symmetry point SP defined as k.sigma from the median of each channel (the provided <b>shadowsclip</b> value is the k here and can be negative). By default, SP and the stretch are computed per channel; SP can be computed as a mean of image channels by passing <b>-linked</b>. The stretch amount <b>D</b> is provided in the second mandatory argument.\nImplicit values of 13 for <b>B</b>, making it very focused on the SP brightness range, 0.7 for <b>HP</b>, 0 for <b>LP</b> are used but can be changed with the options of the same names")
#define STR_AUTOSTRETCH N_("Auto-stretches the currently loaded image, with different parameters for each channel (unlinked) unless <b>-linked</b> is passed. Arguments are optional, <b>shadowclip</b> is the shadows clipping point, measured in sigma units from the main histogram peak (default is -2.8), <b>targetbg</b> is the target background value, giving a final brightness to the image, range [0, 1], default is 0.25. The default values are those used in the Auto-stretch rendering from the GUI.\n\nDo not use the unlinked version after color calibration, it will alter the white balance")

#define STR_BG N_("Returns the background level of the loaded image")
#define STR_BGNOISE N_("Returns the background noise level of the loaded image")
#define STR_BINXY N_("Computes the numerical binning of the in-memory image (sum of the pixels 2x2, 3x3..., like the analogic binning of CCD camera). If the optional argument <b>-sum</b> is passed, then the sum of pixels is computed, while it is the average when no optional argument is provided")
#define STR_BOXSELECT N_("Make a selection area in the currently loaded image with the arguments <b>x</b>, <b>y</b>, <b>width</b> and <b>height</b>, with <b>x</b> and <b>y</b> being the coordinates of the top left corner starting at (0, 0), and <b>width</b> and <b>height</b>, the size of the selection. The <b>-clear</b> argument deletes any selection area. If no argument is passed, the current selection is printed")

#define STR_CALIBRATE N_("Calibrates the sequence <b>sequencename</b> using bias, dark and flat given in argument.\n\nFor bias, a uniform level can be specified instead of an image, by entering a quoted expression starting with an = sign, such as -bias=\"=256\" or -bias=\"=64*$OFFSET\".\n\nBy default, cosmetic correction is not activated. If you wish to apply some, you will need to specify it with <b>-cc=</b> option.\nYou can use <b>-cc=dark</b> to detect hot and cold pixels from the masterdark (a masterdark must be given with the <b>-dark=</b> option), optionally followed by <b>siglo</b> and <b>sighi</b> for cold and hot pixels respectively. A value of 0 deactivates the correction. If sigmas are not provided, only hot pixels detection with a sigma of 3 will be applied.\nAlternatively, you can use <b>-cc=bpm</b> followed by the path to your Bad Pixel Map to specify which pixels must be corrected. An example file can be obtained with a <i>find_hot</i> command on a masterdark.\n\nThree options apply to color images (in CFA format): <b>-cfa</b> for cosmetic correction purposes, <b>-debayer</b> to demosaic images before saving them, and <b>-equalize_cfa</b> to equalize the mean intensity of RGB layers of the master flat, to avoid tinting the calibrated image.\nThe <b>-fix_xtrans</b> option is dedicated to X-Trans images by applying a correction on darks and biases to remove a rectangle pattern caused by autofocus.\nIt is also possible to optimize the dark subtraction with <b>-opt</b>, which requires both bias and dark masters to be provided.\nBy default, frames marked as excluded will not be processed. The argument <b>-all</b> can be used to force processing of all frames even if marked as excluded.\nThe output sequence name starts with the prefix \"pp_\" unless otherwise specified with option <b>-prefix=</b>.\nIf <b>-fitseq</b> is provided, the output sequence will be a FITS sequence (single file)")
#define STR_CALIBRATE_SINGLE N_("Calibrates the image <b>imagename</b> using bias, dark and flat given in argument.\n\nFor bias, a uniform level can be specified instead of an image, by entering a quoted expression starting with an = sign, such as -bias=\"=256\" or -bias=\"=64*$OFFSET\".\n\nBy default, cosmetic correction is not activated. If you wish to apply some, you will need to specify it with <b>-cc=</b> option.\nYou can use <b>-cc=dark</b> to detect hot and cold pixels from the masterdark (a masterdark must be given with the <b>-dark=</b> option), optionally followed by <b>siglo</b> and <b>sighi</b> for cold and hot pixels respectively. A value of 0 deactivates the correction. If sigmas are not provided, only hot pixels detection with a sigma of 3 will be applied.\nAlternatively, you can use <b>-cc=bpm</b> followed by the path to your Bad Pixel Map to specify which pixels must be corrected. An example file can be obtained with a <i>find_hot</i> command on a masterdark.\n\nThree options apply to color images (in CFA format): <b>-cfa</b> for cosmetic correction purposes, <b>-debayer</b> to demosaic images before saving them, and <b>-equalize_cfa</b> to equalize the mean intensity of RGB layers of the master flat, to avoid tinting the calibrated image.\nThe <b>-fix_xtrans</b> option is dedicated to X-Trans images by applying a correction on darks and biases to remove a rectangle pattern caused by autofocus.\nIt is also possible to optimize the dark subtraction with <b>-opt</b>, which requires both bias and dark masters to be provided.\nThe output filename starts with the prefix \"pp_\" unless otherwise specified with option <b>-prefix=</b>")
#define STR_CAPABILITIES N_("Lists Siril capabilities, based on compilation options and runtime")
#define STR_CATSEARCH N_("Searches an object by <b>name</b> and adds it to the user annotation catalog. The object is first searched in the annotation catalogs, if not found a request is made to SIMBAD.\nThe object can be a solar system object, in that case the prefix 'a:' for asteroid, 'p:' for planet or 'c:' for comet is needed, and the search is done for the date and Earth location found in the image's header, using the IMCCE Miriade service")
#define STR_CD N_("Sets the new current working directory.\n\nThe argument <b>directory</b> can contain the ~ token, expanded as the home directory, directories with spaces in the name can be protected using single or double quotes")
#define STR_CDG N_("Returns the coordinates of the center of gravity of the image. Only pixels with values above 15.7% of max ADU and having four neighbors filling the same condition are used to compute it, and it is computed only if there are at least 50 of them")
#define STR_CLAHE N_("Equalizes the histogram of an image using Contrast Limited Adaptive Histogram Equalization.\n\n<b>cliplimit</b> sets the threshold for contrast limiting.\n<b>tilesize</b> sets the size of grid for histogram equalization. Input image will be divided into equally sized rectangular tiles")
#define STR_CLEAR N_("Clears the graphical output logs")
#define STR_CLEARSTAR N_("Clears all the stars saved in memory and displayed on the screen")
#define STR_CLOSE N_("Properly closes the opened image and the opened sequence, if any")
#define STR_CONVERT N_("Converts all images of the current working directory that are in a supported format into Siril's sequence of FITS images (several files) or a FITS sequence (single file) if <b>-fitseq</b> is provided or a SER sequence (single file) if <b>-ser</b> is provided. The argument <b>basename</b> is the base name of the new sequence, numbers and the extension will be put behind it.\nFor FITS images, Siril will try to make a symbolic link; if not possible, files will be copied. The option <b>-debayer</b> applies demosaicing to CFA input images; in this case no symbolic link is done.\n<b>-start=index</b> sets the starting index number, useful to continue an existing sequence (not used with -fitseq or <b>-ser</b>; make sure you remove or clear the target .seq if it exists in that case).\nThe <b>-out=</b> option changes the output directory to the provided argument.\n\nSee also CONVERTRAW and LINK")
#define STR_CONVERTRAW N_("Same as CONVERT but converts only DSLR RAW files found in the current working directory")
#define STR_COSME N_("Applies the local mean to a set of pixels on the loaded image (cosmetic correction). The coordinates of these pixels are in a text file [.lst file], the FIND_HOT command can also create it for single hot pixels, but manual operation is needed to remove rows or columns. COSME is adapted to correct residual hot and cold pixels after calibration.\nInstead of providing the list of bad pixels, it's also possible to detect them in the current image using the FIND_COSME command")
#define STR_COSME_CFA N_("Same function as COSME but applying to RAW CFA images")
#define STR_CROP N_("Crops to a selected area of the loaded image.\n\nIf a selection is active, no further arguments are required. Otherwise, or in scripts, arguments have to be given, with <b>x</b> and <b>y</b> being the coordinates of the top left corner, and <b>width</b> and <b>height</b> the size of the selection. Alternatively, the selection can be made using the BOXSELECT command")

#define STR_DDP N_("Performs a DDP (digital development processing) on the loaded image, as described first by Kunihiko Okano. This implementation is the one described in IRIS.\n\nIt combines a linear distribution on low levels (below <b>level</b>) and a non-linear one on high levels.\nIt uses a Gaussian filter of standard deviation <b>sigma</b> and multiplies the resulting image by <b>coef</b>. Typical values for <b>sigma</b> are within 0.7 and 2. The level argument should be in the range [0, 65535] for 16-bit images and may be given either in the range [0, 1] or [0, 65535] for 32-bit images in which case it will be scaled automatically")
#define STR_DENOISE N_("Denoises the image using the non-local Bayesian algorithm described by <a href=\"https://www.ipol.im/pub/art/2013/16\">Lebrun, Buades and Morel</a>.\n\nIt is strongly recommended to apply cosmetic correction to remove salt and pepper noise before running denoise, and by default this command will apply cosmetic correction automatically. However, if this has already been carried out earlier in the workflow it may be disabled here using the optional command <b>-nocosmetic</b>.\n\nAn optional argument <b>-mod=m</b> may be given, where 0 &lt;= m &lt;= 1. The output pixel is computed as : <i>out=m x d + (1 − m) x in</i>, where <i>d</i> is the denoised pixel value. A modulation value of 1 will apply no modulation. If the parameter is omitted, it defaults to 1.\n\nThe optional argument <b>-vst</b> can be used to apply the generalised Anscombe variance stabilising transform prior to NL-Bayes. This is useful with photon-starved images such as single subs, where the noise follows a Poisson or Poisson-Gaussian distribution rather than being primarily Gaussian. It cannot be used in conjunction with DA3D or SOS, and for denoising stacked images it is usually not beneficial.\n\nThe optional argument <b>-da3d</b> can be used to enable Data-Adaptive Dual Domain Denoising (DA3D) as a final stage denoising algorithm. This uses the output of BM3D as a guide image to refine the denoising. It improves detail and reduces staircasing artefacts.\n\nThe optional argument <b>-sos=<i>n</i></b> can be used to enable Strengthen-Operate-Subtract (SOS) iterative denoise boosting, with the number of iterations specified by n. In particular, this booster may produce better results if the un-boosted NL-Bayes algorithm produces artefacts in background areas. If both -da3d and -sos=n are specified, the last to be specified will apply.\n\nThe optional argument <b>-rho=r</b> may be specified, where 0 &lt; r &lt; 1. This is used by the SOS booster to determine the amount of noisy image added in to the intermediate result between each iteration. If -sos=n is not specified then the parameter is ignored.\n\nThe default is not to apply DA3D or SOS, as the improvement in denoising is usually relatively small and these techniques requires additional processing time.\n\nIn very rare cases, blocky coloured artefacts may be found in the output when denoising colour images. The optional argument <b>-indep</b> can be used to prevent this by denoising each channel separately. This is slower but will eliminate artefacts")
#define STR_DUMPHEADER N_("Dumps the FITS header of the loaded image in the console")

#define STR_ENTROPY N_("Computes the entropy of the loaded image on the displayed layer, only in the selected area if one has been selected or in the whole image. The entropy is one way of measuring the noise or the details in an image")
#define STR_EXIT N_("Quits the application")
#define STR_EXTRACT N_("Extracts <b>NbPlans</b> planes of wavelet domain of the loaded image.\nSee also WAVELET and WRECONS. For color extraction, see SPLIT")
#define STR_EXTRACTGREEN N_("Extracts green signal from the loaded CFA image. It reads the Bayer matrix information from the image or the preferences and exports only the averaged green filter data as a new half-sized FITS file. A new file is created, its name is prefixed with \"Green_\"")
#define STR_EXTRACTHA N_("Extracts H-Alpha signal from the loaded CFA image. It reads the Bayer matrix information from the image or the preferences and exports only the red filter data as a new half-sized FITS file. A new file is created, its name is prefixed with \"Ha_\"")
#define STR_EXTRACTHAOIII N_("Extracts H-Alpha and O-III signals from the loaded CFA image. It reads the Bayer matrix information from the image or the preferences and exports only the red filter data for H-Alpha as a new half-sized FITS file (like EXTRACTHA) and keeps the three others for O-III with an interpolated replacement for the red pixel. The output files names start with the prefix \"Ha_\" and \"OIII_\"\n\nThe optional argument <b>-resample={ha|oiii}</b> sets whether to upsample the Ha image or downsample the OIII image to have images the same size. If this argument is not provided, no resampling will be carried out and the OIII image will have twice the height and width of the Ha image")

#define STR_FDIV N_("Divides the loaded image by the image given in argument. The resulting image is multiplied by the value of the <b>scalar</b> argument. See also IDIV")
#define STR_FFILL N_("Same command as FILL but this is a symmetric fill of a region defined by the mouse or with BOXSELECT. Used to process an image in the Fourier (FFT) domain")
#define STR_FFTD N_("Applies a Fast Fourier Transform to the loaded image. <b>modulus</b> and <b>phase</b> given in argument are the names of the saved in FITS files")
#define STR_FFTI N_("Retrieves corrected image applying an inverse transformation. The <b>modulus</b> and <b>phase</b> arguments are the input file names, the result will be the new loaded image")
#define STR_FILL N_("Fills the loaded image entirely or only the selection if there is one with pixels having the <b>value</b> intensity expressed in ADU")
#define STR_FIND_COSME N_("Applies an automatic detection and replacement of cold and hot pixels in the loaded image, with the thresholds passed in arguments in sigma units")
#define STR_FIND_COSME_CFA N_("Same command as FIND_COSME but for CFA images")
#define STR_FIND_HOT N_("Saves a list file <b>filename</b> (text format) in the working directory which contains the coordinates of the pixels which have an intensity <b>hot_sigma</b> times higher and <b>cold_sigma</b> lower than standard deviation, extracted from the loaded image. We generally use this command on a master-dark file. The COSME command can apply this list of bad pixels to a loaded image, see also SEQCOSME to apply it to a sequence")
#define STR_FINDSTAR N_("Detects stars in the currently loaded image, having a level greater than a threshold computed by Siril.\nAfter that, a PSF is applied and Siril rejects all detected structures that don't fulfill a set of prescribed detection criteria, that can be tuned with command SETFINDSTAR.\nFinally, an ellipse is drawn around detected stars.\n\nOptional parameter <b>-out=</b> allows the results to be saved to the given path.\nOption <b>-layer=</b> specifies the layer onto which the detection is performed (for color images only).\nYou can also limit the maximum number of stars detected by passing a value to option <b>-maxstars=</b>.\n\n\nSee also CLEARSTAR")
#define STR_FIXXTRANS N_("Fixes the Fujifilm X-Trans Auto Focus pixels in the loaded image.\n\nIndeed, because of the phase detection auto focus system, the photosites used for auto focus get a little less light than the surrounding photosites. The camera compensates for this and increases the values from these specific photosites giving a visible square in the middle of the dark/bias frames")
#define STR_FIXBANDING N_("Tries to remove the horizontal or vertical banding in the loaded image.\n<b>amount</b> defines the amount of correction, between 0 and 4.\n<b>sigma</b> defines the highlight protection level of the algorithm, higher sigma gives higher protection, between 0 and 5. Values of 1 and 1 are often good enough.\n<b>-vertical</b> option enables to perform vertical banding removal, horizontal is the default")
#define STR_FMEDIAN N_("Performs a median filter of size <b>ksize</b> x <b>ksize</b> (<b>ksize</b> MUST be odd) to the loaded image with a modulation parameter <b>modulation</b>.\n\nThe output pixel is computed as : out=mod x m + (1 − mod) x in, where m is the median-filtered pixel value. A modulation's value of 1 will apply no modulation")
#define STR_FMUL N_("Multiplies the loaded image by the <b>scalar</b> given in argument")

#define STR_GAUSS N_("Applies to the loaded image a Gaussian blur with the given <b>sigma</b>.\n\nSee also UNSHARP, the same with a blending parameter")
#define STR_GET N_("Gets a value from the settings using its name, or list all with <b>-a</b> (name and value list) or with <b>-A</b> (detailed list)\n\nSee also SET to update values")
#define STR_GETREF N_("Prints information about the reference image of the sequence given in argument. First image has index 0")
#define STR_GHT N_("Generalised hyperbolic stretch based on the work of the ghsastro.co.uk team.\n\nThe argument <b>-D=</b> defines the strength of the stretch, between 0 and 10. This is the only mandatory argument. The following optional arguments further tailor the stretch:\n<b>B</b> defines the intensity of the stretch near the focal point, between -5 and 15;\n<b>LP</b> defines a shadow preserving range between 0 and SP where the stretch will be linear, preserving shadow detail;\n<b>SP</b> defines the symmetry point of the stretch, between 0 and 1, which is the point at which the stretch will be most intense;\n<b>HP</b> defines a region between HP and 1 where the stretch is linear, preserving highlight details and preventing star bloat.\nIf omitted B, LP and SP default to 0.0 ad HP defaults to 1.0.\nAn optional argument (either <b>-human</b>, <b>-even</b> or <b>-independent</b>) can be passed to select either human-weighted or even-weighted luminance or independent colour channels for colour stretches. The argument is ignored for mono images. Alternatively, the argument <b>-sat</b> specifies that the stretch is performed on image saturation - the image must be color and all channels must be selected for this to work.\nOptionally the parameter <b>[channels]</b> may be used to specify the channels to apply the stretch to: this may be R, G, B, RG, RB or GB. The default is all channels")
#define STR_GREY_FLAT N_("Equalizes the mean intensity of RGB layers in the loaded CFA image. This is the same process used on flats during calibration when the option equalize CFA is used")

#define STR_HELP N_("Lists the available commands or help for one command")
#define STR_HISTO N_("Calculates the histogram of the <b>layer</b> of the loaded image and produces file histo_[channel name].dat in the working directory.\nlayer = 0, 1 or 2 with 0=red, 1=green and 2=blue")

#define STR_IADD N_("Adds the image <b>filename</b> to the loaded image.\nResult will be in 32 bits per channel if allowed in the preferences")
#define STR_IDIV N_("Divides the loaded image by the image <b>filename</b>.\nResult will be in 32 bits per channel if allowed in the preferences.\n\nSee also FDIV")
#define STR_INSPECTOR N_("Splits the loaded image in a nine-panel mosaic showing the image corners and the center for a closer inspection (GUI only)")
#define STR_INVGHT N_("Inverts a generalised hyperbolic stretch. It provides the inverse transformation of GHT, if provided with the same parameters, undoes a GHT command, possibly returning to a linear image. It can also work the same way as GHT but for images in negative")
#define STR_INVMTF N_("Inverts a midtones transfer function. It provides the inverse transformation of MTF, if provided with the same parameters, undoes a MTF command, possibly returning to a linear image. It can also work the same way as MTF but for images in negative")
#define STR_INVMODASINH N_("Inverts a modified arcsinh stretch. It provides the inverse transformation of MODASINH, if provided with the same parameters, undoes a MODASINH command, possibly returning to a linear image. It can also work the same way as MODASINH but for images in negative")
#define STR_IMUL N_("Multiplies image <b>filename</b> by the loaded image.\nResult will be in 32 bits per channel if allowed in the preferences")
#define STR_ISUB N_("Subtracts the loaded image by the image <b>filename</b>.\nResult will be in 32 bits per channel if allowed in the preferences, so capable of storing negative values. To clip negative value, use 16 bit mode or use the THRESHLO command")

#define STR_LIGHTCURVE N_("Analyses several stars with aperture photometry in a sequence of images and produces a light curve for one, calibrated by the others. The first coordinates, in pixels if <b>-at=</b> is used or in degrees if <b>-wcs=</b> is used, are for the star whose light will be plotted, the others for the comparison stars.\nAlternatively, a list of target and reference stars can be passed in the format of the NINA exolpanet plugin star list, with the <b>-ninastars=</b> option. Siril will verify that all reference stars can be used before actually using them. A data file is created in the current directory named light_curve.dat, gnuplot plots the result to a PNG image if available\nThe ring radii for aperture photometry can either be configured in the settings or set to a factor of the reference image's FWHM if <b>-autoring</b> is passed.\n\nSee also SEQPSF for operations on single star")
#define STR_LMATCH N_("Computes and applies a linear function between a <b>reference</b> image and the loaded image.\n\nThe algorithm will ignore all reference pixels whose values are outside of the [<b>low</b>, <b>high</b>] range")
#define STR_LINK N_("Same as CONVERT but converts only FITS files found in the current working directory. This is useful to avoid conversions of JPEG results or other files that may end up in the directory. The additional argument <b>-date</b> enables sorting files with their DATE-OBS value instead of with their name alphanumerically")
#define STR_LINSTRETCH N_("Stretches the image linearly to a new black point BP.\nThe argument <b>[channels]</b> may optionally be used to specify the channels to apply the stretch to: this may be R, G, B, RG, RB or GB. The default is all channels.\nOptionally the parameter <b>-sat</b> may be used to apply the linear stretch to the image saturation channel. This argument only works if all channels are selected")
#define STR_LIVESTACK N_("Process the provided image for live stacking. Only possible after START_LS. The process involves calibrating the incoming file if configured in START_LS, demosaicing if it's an OSC image, registering and stacking. The temporary result will be in the file live_stack_00001.fit until a new option to change it is added")
#define STR_LOAD N_("Loads the image <b>filename</b> from the current working directory, which becomes the 'currently loaded image' used in many of the single-image commands.\nIt first attempts to load <b>filename</b>, then <b>filename</b>.fit, <b>filename</b>.fits and finally all supported formats.\nThis scheme is applicable to every Siril command that involves reading files")
#define STR_LOG N_("Computes and applies a logarithmic scale to the loaded image, using the following formula: log(1 - (value - min) / (max - min)), with min and max being the minimum and maximum pixel value for the channel")
#define STR_LS N_("Lists files and directories in the working directory")

#define STR_JSONMETADATA N_("Dumps metadata and statistics of the currently loaded image in JSON form. The file name is required, even if the image is already loaded. Image data may not be read from the file if it is the current loaded image and if the <b>-stats_from_loaded</b> option is passed. Statistics can be disabled by providing the <b>-nostats</b> option. A file containing the JSON data is created with default file name '$(FITS_file_without_ext).json' and can be changed with the <b>-out=</b> option")

#define STR_MAKEPSF N_("Generates a PSF for use with deconvolution, any of the three methods exposed by RL, SB or WIENER commands. One of the following must be given as the first argument: <b>clear</b> (clears the existing PSF), <b>load</b> (loads a PSF from a file), <b>save</b> (saves the current PSF), <b>blind</b> (blind estimate of tke PSF), <b>stars</b> (generates a PSF based on measured stars from the image) or <b>manual</b> (generates a PSF manually based on a function and parameters).\n\nNo additional arguments are required when using the <b>clear</b> argument.\n\nTo load a previously saved PSF the <b>load</b> argument requires the PSF <i>filename</i> as a second argument. This may be in any format that Siril has been compiled with support for, but it must be square and should ideally be odd.\n\nTo save a previously generated PSF the argument <b>save</b> is used. Optionally, a filename may be provided (this must have one of the extensions \".fit\", \".fits\", \".fts\" or \".tif\") but if none is provided the PSF will be named based on the name of the open file or sequence.\n\nFor <b>blind</b>, the following optional arguments may be provided: <b>-l0</b> uses the l0 descent method, <b>-si</b> uses the spectral irregularity method, <b>-multiscale</b> configures the l0 method to do a multi-scale PSF estimate, <b>-lambda=</b> provides the regularization constant.\n\nFor PSF from detected <b>stars</b> the only optional parameter is <b>-sym</b>, which configures the PSF to be symmetric.\n\nFor a <b>manual</b> PSF, one of <b>-gaussian</b>, <b>-moffat</b>, <b>-disc</b> or <b>-airy</b> can be provided to specify the PSF function, Gaussian by default. For Gaussian or Moffat PSFs the optional arguments <b>-fwhm=</b>, <b>-angle=</b> and <b>-ratio=</b> may be provided. For Moffat PSFs the optional argument <b>-beta=</b> may also be provided. If these values are omitted, they default to the same values as in the deconvolution dialog. For disc PSFs only the argument <b>-fwhm=</b> is required, which for this function is used to set the <i>diameter</i> of the PSF. For Airy PSFs the following arguments may be provided: <b>-dia=</b> (sets the telescope diameter), <b>-fl=</b> (sets the telescope focal length), <b>-wl=</b> (sets the wavelength to calculate the Airy diffraction pattern for), <b>-pixelsize=</b> (sets the sensor pixel size), <b>-obstruct=</b> (sets the central obstruction as a percentage of the overall aperture area). If these parameters are not provided, wavelength will default to 525nm and central obstruction will default to 0%. Siril will attempt to read the others from the open image, but some imaging software may not provide all of them in which case you will get bad results, and note the metadata may not be populated for SER format videos. You will learn from experience which are safe to omit for your particular imaging setup.\n\nFor any of the above PSF generation options the optional argument <b>-ks=</b> may be provided to set the PSF dimension, and the optional argument <b>-savepsf=<i>filename</i></b> may be used to save the generated PSF: a filename must be provided and the same filename extension requirements apply as for <b>makepsf save <i>filename</i></b>")
#define STR_MERGE N_("Merges several sequences of the same type (FITS images, FITS sequence or SER) and same image properties into a new sequence with base name <b>newseq</b> created in the current working directory, with the same type. The input sequences can be in different directories, can specified either in absolute or relative path, with the exact .seq name or with only the base name with or without the trailing '_'")
#define STR_MIRRORX N_("Flips the loaded image about the horizontal axis. Option <b>-bottomup</b> will only flip it if it's not already bottom-up")
#define STR_MIRRORX_SINGLE N_("Flips the image about the horizontal axis, only if needed (if it's not already bottom-up). It takes the image file name as argument, allowing it to avoid reading image data entirely if no flip is required. Image is overwritten if a flip is made")
#define STR_MIRRORY N_("Flips the image about the vertical axis")
#define STR_MODASINH N_("Modified arcsinh stretch based on the work of the ghsastro.co.uk team.\n\nThe argument <b>-D=</b> defines the strength of the stretch, between 0 and 10. This is the only mandatory argument. The following optional arguments further tailor the stretch:\n<b>LP</b> defines a shadow preserving range between 0 and SP where the stretch will be linear, preserving shadow detail;\n<b>SP</b> defines the symmetry point of the stretch, between 0 and 1, which is the point at which the stretch will be most intense;\n<b>HP</b> defines a region between HP and 1 where the stretch is linear, preserving highlight details and preventing star bloat.\nIf omitted LP and SP default to 0.0 ad HP defaults to 1.0.\nAn optional argument (either <b>-human</b>, <b>-even</b> or <b>-independent</b>) can be passed to select either human-weighted or even-weighted luminance or independent colour channels for colour stretches. The argument is ignored for mono images. Alternatively, the argument <b>-sat</b> specifies that the stretch is performed on image saturation - the image must be color and all channels must be selected for this to work.\nOptionally the parameter <b>[channels]</b> may be used to specify the channels to apply the stretch to: this may be R, G, B, RG, RB or GB. The default is all channels")
#define STR_MTF N_("Applies midtones transfer function to the current loaded image.\n\nThree parameters are needed, <b>low</b>, <b>midtones</b> and <b>high</b> where midtones balance parameter defines a nonlinear histogram stretch in the [0,1] range. For an automatic determination of the parameters, see AUTOSTRETCH.\nOptionally the parameter <b>[channels]</b> may be used to specify the channels to apply the stretch to: this may be R, G, B, RG, RB or GB. The default is all channels")

#define STR_NEG N_("Changes pixel values of the currently loaded image to a negative view, like 1-value for 32 bits, 65535-value for 16 bits. This does not change the display mode")
#define STR_NEW N_("Creates a new image filled with zeros with a size of <b>width</b> x <b>height</b>.\n\nThe image is in 32-bit format, and it contains <b>nb_channel</b> channels, <b>nb_channel</b> being 1 or 3. It is not saved, but becomes the loaded image and it is displayed and can be saved afterwards")
#define STR_NOMAD N_("Displays stars from the local catalog by default, for the loaded plate solved image, in GUI only, down to the provided <b>limit_magnitude</b> (13 by default).\nAn alternate online catalog can be specified with <b>-catalog=</b>, taking values tycho2, nomad, gaia, ppmxl, brightstars, apass.\nStars with no B-V information will be kept; they can be excluded by passing <b>-photo</b>")
#define STR_NOZERO N_("Replaces null values by <b>level</b> values. Useful before an idiv or fdiv operation, mostly for 16-bit images")

#define STR_OFFSET N_("Adds the constant <b>value</b> (specified in ADU) to the current image. This constant can take a negative value.\n\nIn 16-bit mode, values of pixels that fall outside of [0, 65535] are clipped. In 32-bit mode, no clipping occurs")

#define STR_PARSE N_("Parses the string <b>str</b> using the information contained in the header of the image currently loaded. Main purpose of this command is to debug path parsing of header keys which can be used in other commands.\nOption <b>-r</b> specifies the string is to be interpreted in read mode. In read mode, all wilcards defined in string <b>str</b> are used to find a file name matching the pattern. Otherwise, default mode is write mode and wildcards, if any, are removed from the string to be parsed.\n\nIf <b>str</b> starts with <i>$def</i> prefix, it will be recognized as a reserved keyword and looked for in the strings stored in gui_prepro.dark_lib, gui_prepro.flat_lib, gui_prepro.bias_lib or gui_prepro.stack_default for <i>$defdark</i>, <i>$defflat</i>, <i>$defbias</i> or <i>$defstack</i> respectively.\nThe keyword <i>$seqname$</i> can also be used when a sequence is loaded")
#define STR_PCC N_("Run the Photometric Color Correction on the loaded image.\nIf the image has already been plate solved, the PCC can reuse the astrometric solution, otherwise, or if WCS or other image metadata is erroneous or missing, arguments for the plate solving must be passed:\n  the approximate image center coordinates can be provided in decimal degrees or degree/hour minute second values (J2000 with colon separators), with right ascension and declination values separated by a comma or a space.\n  focal length and pixel size can be passed with <b>-focal=</b> (in mm) and <b>-pixelsize=</b> (in microns), overriding values from image and settings.\n  you can force the plate solving to be remade using the <b>-platesolve</b> flag.\n\nUnless <b>-noflip</b> is specified and the image is detected as being upside-down, the image will be flipped if a plate solving is run.\nFor faster star detection in big images, downsampling the image is possible with <b>-downscale</b>.\n\nThe limit magnitude of stars used for plate solving and PCC is automatically computed from the size of the field of view, but can be altered by passing a +offset or -offset value to <b>-limitmag=</b>, or simply an absolute positive value for the limit magnitude.\nThe star catalog used is NOMAD by default, it can be changed by providing <b>-catalog=apass</b>. If installed locally, the remote NOMAD (the complete version) can be forced by providing <b>-catalog=nomad</b>")
#define STR_PLATESOLVE N_("Plate solve the loaded image.\nIf the image has already been plate solved nothing will be done, unless the <b>-platesolve</b> argument is passed to force a new solve. If WCS or other image metadata is erroneous or missing, arguments must be passed:\n  the approximate image center coordinates can be provided in decimal degrees or degree/hour minute second values (J2000 with colon separators), with right ascension and declination values separated by a comma or a space (not mandatory for astrometry.net).\n  focal length and pixel size can be passed with <b>-focal=</b> (in mm) and <b>-pixelsize=</b> (in microns), overriding values from image and settings.\n\nUnless <b>-noflip</b> is specified, if the image is detected as being upside-down, it will be flipped.\nFor faster star detection in big images, downsampling the image is possible with <b>-downscale</b>.\n\nImages can be either plate solved by Siril using a star catalog and the global registration algorithm or by astrometry.net's local solve-field command (enabled with <b>-localasnet</b>).\nThe following options apply to Siril's plate solve only.\nThe limit magnitude of stars used for plate solving is automatically computed from the size of the field of view, but can be altered by passing a +offset or -offset value to <b>-limitmag=</b>, or simply an absolute positive value for the limit magnitude.\nThe choice of the star catalog is automatic unless the <b>-catalog=</b> option is passed: if local catalogs are installed, they are used, otherwise the choice is based on the field of view and limit magnitude. If the option is passed, it forces the use of the remote catalog given in argument, with possible values: tycho2, nomad, gaia, ppmxl, brightstars, apass")
#define STR_PM N_("This command evaluates the expression given in argument as in PixelMath tool. The full expression must be between double quotes and variables (that are image names, without extension, located in the working directory in that case) must be surrounded by the token $, e.g. \"$image1$ * 0.5 + $image2$ * 0.5\". A maximum of 10 images can be used in the expression.\nImage can be rescaled with the option <b>-rescale</b> followed by <b>low</b> and <b>high</b> values in the range [0, 1]. If no low and high values are provided, default values are set to 0 and 1")
#define STR_PSF N_("Performs a PSF (Point Spread Function) on the selected star and display the results. For headless operation, the selection can be given in pixels using BOXSELECT. If provided, the <b>channel</b> argument selects the image channel on which the star will be analyzed. It can be omitted for monochrome images or when run from the GUI with one of the channels active in the view")
#define STR_REBAYER N_("Builds a Bayer masked colour image from 4 separate images containing the data from Bayer subchannels CFA0, CFA1, CFA2 and CFA3. (The corresponding command to split the CFA pattern into subchannels is <b>split_cfa</b>.) This function can be used as part of a workflow applying some processing to the individual Bayer subchannels prior to demosaicing. The fifth parameter <b><i>bayerpattern</i></b> specifies the Bayer matrix pattern to recreate: <i>bayerpattern</i> should be one of 'RGGB', 'BGGR', 'GRBG' or 'GBRG'")
#define STR_REGISTER N_("Finds and optionally performs geometric transforms on images of the sequence given in argument so that they may be superimposed on the reference image. Using stars for registration, this algorithm only works with deep sky images. Star detection options can be changed using <b>SETFINDSTAR</b> or the <i>Dynamic PSF</i> dialog. The detection is done on the green layer for colour images, unless specified by the <b>-layer=</b> option with an argument ranging from 0 to 2 for red to blue.\n\nThe <b>-2pass</b> and <b>-noout</b> options will only compute the transforms but not generate the transformed images, <b>-2pass</b> adds a preliminary pass to the algorithm to find a good reference image before computing the transforms, based on image quality and framing. To generate transformed images after this pass, use SEQAPPLYREG. <b>-nostarlist</b> disables saving the star lists to disk.\n\nThe option <b>-transf=</b> specifies the use of either <b>shift</b>, <b>similarity</b>, <b>affine</b> or <b>homography</b> (default) transformations respectively.\nThe option <b>-drizzle</b> activates the sub-pixel stacking by up-scaling by 2 the generated images.\nThe option <b>-minpairs=</b> will specify the minimum number of star pairs a frame must have with the reference frame, otherwise the frame will be dropped and excluded from the sequence.\nThe option <b>-maxstars=</b> will specify the maximum number of star to find within each frame (must be between 100 and 2000). With more stars, a more accurate registration can be computed, but will take more time to run.\n\nThe pixel interpolation method can be specified with the <b>-interp=</b> argument followed by one of the methods in the list <b>no</b>[ne], <b>ne</b>[arest], <b>cu</b>[bic], <b>la</b>[nczos4], <b>li</b>[near], <b>ar</b>[ea]}. If <b>none</b> is passed, the transformation is forced to shift and a pixel-wise shift is applied to each image without any interpolation.\nClamping of the bicubic and lanczos4 interpolation methods is the default, to avoid artefacts, but can be disabled with the <b>-noclamp</b> argument.\n\nAll images of the sequence will be registered unless the option <b>-selected</b> is passed, in that case the excluded images will not be processed\n\nIf created, the output sequence name starts with the prefix \"r_\" unless otherwise specified with <b>-prefix=</b> option")
#define STR_RELOADSCRIPTS N_("Rescans the scripts folders and updates the Scripts menu")
#define STR_REQUIRES N_("Returns an error if the version of Siril is older than the one passed in argument")
#define STR_RESAMPLE N_("Resamples the loaded image, either with a factor <b>factor</b> or for the target width or height provided by either of <b>-width=</b> or <b>-height=</b>. This is generally used to resize images, a factor of 0.5 divides size by 2.\nIn the graphical user interface, we can see that several interpolation algorithms are proposed.\n\nThe pixel interpolation method can be specified with the <b>-interp=</b> argument followed by one of the methods in the list <b>no</b>[ne], <b>ne</b>[arest], <b>cu</b>[bic], <b>la</b>[nczos4], <b>li</b>[near], <b>ar</b>[ea]}. If <b>none</b> is passed, the transformation is forced to shift and a pixel-wise shift is applied to each image without any interpolation.\nClamping of the bicubic and lanczos4 interpolation methods is the default, to avoid artefacts, but can be disabled with the <b>-noclamp</b> argument")
#define STR_RGBCOMP N_("Creates an RGB composition using three independent images, or an LRGB composition using the optional luminance image and three monochrome images or a color image. Result image is called composed_rgb.fit or composed_lrgb.fit unless another name is provided in the optional argument")
#define STR_RGRADIENT N_("Creates two images, with a radial shift (<b>dR</b> in pixels) and a rotational shift (<b>dalpha</b> in degrees) with respect to the point (<b>xc</b>, <b>yc</b>).\n\nBetween these two images, the shifts have the same amplitude, but an opposite sign. The two images are then added to create the final image. This process is also called Larson Sekanina filter")
#define STR_RL N_("Restores an image using the Richardson-Lucy method.\n\nOptionally, a PSF may be loaded using the argument <b>-loadpsf=<i>filename</i></b> (created with MAKEPSF).\n\nThe number of iterations is provide by <b>-iters</b> (the default is 10).\n\nThe type of regularization can be set with <b>-tv</b> for Total Variation, or <b>-fh</b> for the Frobenius norm of the Hessian matrix (the default is none) and <b>-alpha=</b> provides the regularization strength (lower value = more regularization, default = 3000).\n\nBy default the gradient descent method is used with a default step size of 0.0005, however the multiplicative method may be specified with <b>-mul</b>.\n\nThe stopping criterion may be activated by specifying a stopping limit with <b>-stop=</b>")
#define STR_RMGREEN N_("Applies a chromatic noise reduction filter. It removes green tint in the current image. This filter is based on PixInsight's SCNR and it is also the same filter used by HLVG plugin in Photoshop.\nLightness is preserved by default but this can be disabled with the <b>-nopreserve</b> switch.\n\n<b>Type</b> can take values 0 for average neutral, 1 for maximum neutral, 2 for maximum mask, 3 for additive mask, defaulting to 0. The last two can take an <b>amount</b> argument, a value between 0 and 1, defaulting to 1")
#define STR_ROTATE N_("Rotates the loaded image by an angle of <b>degree</b> value. The option <b>-nocrop</b> can be added to avoid cropping to the image size (black borders will be added).\n\nNote: if a selection is active, i.e. by using a command `boxselect` before `rotate`, the resulting image will be a rotated crop. In this particular case, the option <b>-nocrop</b> will be ignored if passed.\n\nThe pixel interpolation method can be specified with the <b>-interp=</b> argument followed by one of the methods in the list <b>no</b>[ne], <b>ne</b>[arest], <b>cu</b>[bic], <b>la</b>[nczos4], <b>li</b>[near], <b>ar</b>[ea]}. If <b>none</b> is passed, the transformation is forced to shift and a pixel-wise shift is applied to each image without any interpolation.\nClamping of the bicubic and lanczos4 interpolation methods is the default, to avoid artefacts, but can be disabled with the <b>-noclamp</b> argument")
#define STR_ROTATEPI N_("Rotates the loaded image of an angle of 180° around its center. This is equivalent to the command \"ROTATE 180\" or \"ROTATE -180\"")

#define STR_SATU N_("Enhances the color saturation of the loaded image. Try iteratively to obtain best results.\n<b>amount</b> can be a positive number to increase color saturation, negative to decrease it, 0 would do nothing, 1 would increase it by 100%\n<b>background_factor</b> is a factor to (median + sigma) used to set a threshold for which only pixels above it would be modified. This allows background noise to not be color saturated, if chosen carefully. Defaults to 1. Setting 0 disables the threshold.\n<b>hue_range_index</b> can be [0, 6], meaning: 0 for pink to orange, 1 for orange to yellow, 2 for yellow to cyan, 3 for cyan, 4 for cyan to magenta, 5 for magenta to pink, 6 for all (default)")
#define STR_SAVE N_("Saves current image to <b>filename</b>.fit (or .fits, depending on your preferences, see SETEXT) in the current working directory. The image remains loaded. <b>filename</b> can contain a path as long as the directory already exists")
#define STR_SAVEBMP N_("Saves current image under the form of a bitmap file with 8-bit per channel: <b>filename</b>.bmp (BMP 24-bit)")
#define STR_SAVEJPG N_("Saves current image into a JPG file: <b>filename</b>.jpg.\n\nThe compression quality can be adjusted using the optional <b>quality</b> value, 100 being the best and default, while a lower value increases the compression ratio")
#define STR_SAVEPNG N_("Saves current image into a PNG file: <b>filename</b>.png, with 16 bits per channel if the loaded image is 16 or 32 bits, and 8 bits per channel if the loaded image is 8 bits")
#define STR_SAVEPNM N_("Saves current image under the form of a NetPBM file format with 16-bit per channel.\n\nThe extension of the output will be <b>filename</b>.ppm for RGB image and <b>filename</b>.pgm for gray-level image")
#define STR_SAVETIF N_("Saves current image under the form of a uncompressed TIFF file with 16-bit per channel: <b>filename</b>.tif. The option <b>-astro</b> allows saving in Astro-TIFF format, while <b>-deflate</b> enables compression.\n\nSee also SAVETIF32 and SAVETIF8")
#define STR_SAVETIF32 N_("Same command as SAVETIF but the output file is saved in 32-bit per channel: <b>filename</b>.tif. The option <b>-astro</b> allows saving in Astro-TIFF format, while <b>-deflate</b> enables compression")
#define STR_SAVETIF8 N_("Same command as SAVETIF but the output file is saved in 8-bit per channel: <b>filename</b>.tif. The option <b>-astro</b> allows saving in Astro-TIFF format, while <b>-deflate</b> enables compression")
#define STR_SB N_("Restores an image using the Split Bregman method.\n\nOptionally, a PSF may be loaded using the argument <b>-loadpsf=<i>filename</i></b>.\n\nThe number of iterations is provide by <b>-iters</b> (the default is 1).\n\nThe regularization factor <b>-alpha=</b> provides the regularization strength (lower value = more regularization, default = 3000)")
#define STR_SELECT N_("This command allows easy mass selection of images in the sequence <b>sequencename</b> (from <b>from</b> to <b>to</b> included). This is a selection for later processing.\nSee also UNSELECT")
#define STR_SEQAPPLYREG N_("Applies geometric transforms on images of the sequence given in argument so that they may be superimposed on the reference image, using registration data previously computed (see REGISTER).\n\nThe output sequence name starts with the prefix <b>\"r_\"</b> unless otherwise specified with <b>-prefix=</b> option.\n\nThe option <b>-drizzle</b> activates up-scaling by 2 the images created in the transformed sequence.\n\nThe pixel interpolation method can be specified with the <b>-interp=</b> argument followed by one of the methods in the list <b>no</b>[ne], <b>ne</b>[arest], <b>cu</b>[bic], <b>la</b>[nczos4], <b>li</b>[near], <b>ar</b>[ea]}. If <b>none</b> is passed, the transformation is forced to shift and a pixel-wise shift is applied to each image without any interpolation.\nClamping of the bicubic and lanczos4 interpolation methods is the default, to avoid artefacts, but can be disabled with the <b>-noclamp</b> argument.\n\nThe registration is done on the first layer for which data exists for RGB images unless specified by <b>-layer=</b> option (0, 1 or 2 for R, G and B respectively).\n\nAutomatic framing of the output sequence can be specified using <b>-framing=</b> keyword followed by one of the methods in the list { current | min | max | cog } :\n<b>-framing=max</b> (bounding box) adds a black border around each image as required so that no part of the image is cropped when registered.\n<b>-framing=min</b> (common area) crops each image to the area it has in common with all images of the sequence.\n<b>-framing=cog</b> determines the best framing position as the center of gravity (cog) of all the images.\n\nFiltering out images:\nImages to be registered can be selected based on some filters, like those selected or with best FWHM, with some of the <b>-filter-*</b> options.\nSee the command reference for the complete documentation on this command")
#define STR_SEQCLEAN N_("This command clears selection, registration and/or statistics data stored for the sequence <b>sequencename</b>.\n\nYou can specify to clear only registration, statistics and/or selection with <b>-reg</b>, <b>-stat</b> and <b>-sel</b> options respectively. All are cleared if no option is passed")
#define STR_SEQCOSME N_("Same command as COSME but for the the sequence <b>sequencename</b>. Only selected images in the sequence are processed.\n\nThe output sequence name starts with the prefix \"cosme_\" unless otherwise specified with option <b>-prefix=</b>")
#define STR_SEQCOSME_CFA N_("Same command as COSME_CFA but for the the sequence <b>sequencename</b>. Only selected images in the sequence are processed.\n\nThe output sequence name starts with the prefix \"cosme_\" unless otherwise specified with option <b>-prefix=</b>")
#define STR_SEQCROP N_("Crops the sequence given in argument <b>sequencename</b>. Only selected images in the sequence are processed.\n\nThe crop selection is specified by the upper left corner position <b>x</b> and <b>y</b> and the selection <b>width</b> and <b>height</b>, like for CROP.\nThe output sequence name starts with the prefix \"cropped_\" unless otherwise specified with <b>-prefix=</b> option")
#define STR_SEQEXTRACTHA N_("Same command as EXTRACT_HA but for the sequence <b>sequencename</b>.\n\nThe output sequence name starts with the prefix \"Ha_\" unless otherwise specified with option <b>-prefix=</b>")
#define STR_SEQEXTRACTGREEN N_("Same command as EXTRACT_GREEN but for the sequence <b>sequencename</b>.\n\nThe output sequence name starts with the prefix \"Green_\" unless otherwise specified with option <b>-prefix=</b>")
#define STR_SEQEXTRACTHAOIII N_("Same command as EXTRACT_HAOIII but for the sequence <b>sequencename</b>.\n\nThe output sequences names start with the prefixes \"Ha_\" and \"OIII_\"")
#define STR_SEQFINDSTAR N_("Same command as FINDSTAR but for the sequence <b>sequencename</b>.\n\nThe option <b>-out=</b> is not available for this process as all the star list files are saved with the default name <i>seqname_seqnb.lst</i>")
#define STR_SEQFIND_COSME N_("Same command as FIND_COSME but for the sequence <b>sequencename</b>.\n\nThe output sequence name starts with the prefix \"cc_\" unless otherwise specified with <b>-prefix=</b> option")
#define STR_SEQFIND_COSME_CFA N_("Same command as FIND_COSME_CFA but for the sequence <b>sequencename</b>.\n\nThe output sequence name starts with the prefix \"cc_\" unless otherwise specified with <b>-prefix=</b> option")
#define STR_SEQFIXBANDING N_("Same command as FIXBANDING but for the sequence <b>sequencename</b>.\n\nThe output sequence name starts with the prefix \"unband_\" unless otherwise specified with <b>-prefix=</b> option")
#define STR_SEQGHT N_("Same command as GHT but the sequence must be specified as the first argument. In addition, the optional argument <b>-prefix=</b> can be used to set a custom prefix")
#define STR_SEQHEADER N_("Prints the FITS header value for the given key for all images in the sequence")
#define STR_SEQINVGHT N_("Same command as INVGHT but the sequence must be specified as the first argument. In addition, the optional argument <b>-prefix=</b> can be used to set a custom prefix")
#define STR_SEQINVMODASINH N_("Same command as INVMODASINH but the sequence must be specified as the first argument. In addition, the optional argument <b>-prefix=</b> can be used to set a custom prefix")
#define STR_SEQLINSTRETCH N_("Same command as LINSTRETCH but the sequence must be specified as the first argument. In addition, the optional argument <b>-prefix=</b> can be used to set a custom prefix")
#define STR_SEQMERGE_CFA N_("Same command as MERGE_CFA but for the sequence <b>sequencename</b>.\n\nThe Bayer pattern to be reconstructed must be provided as the second argment as one of RGGB, BGGR, GBRG or GRBG.\n\nThe input filenames contain the identifying prefix \"CFA_\" and a number unless otherwise specified with <b>-prefixin=</b> option.\n\nNote: all 4 sets of input files <b>must</b> be present and <b>must</b> be consistently named, the only difference being the number after the identifying prefix.\n\nThe output sequence name starts with the prefix \"mCFA_\" and a number unless otherwise specified with <b>-prefixout=</b> option")
#define STR_SEQMODASINH N_("Same command as MODASINH but the sequence must be specified as the first argument. In addition, the optional argument <b>-prefix=</b> can be used to set a custom prefix")
#define STR_SEQMTF N_("Same command as MTF but for the sequence <b>sequencename</b>.\n\nThe output sequence name starts with the prefix \"mtf_\" unless otherwise specified with <b>-prefix=</b> option")
#define STR_SEQPLATESOLVE N_("Plate solve a sequence. A new sequence will be created with the prefix \"ps_\". If the input sequence is SER, providing the metadata is mandatory and the output sequence will be in the FITS cube format, as SER cannot store WCS data.\nIf WCS or other image metadata are erroneous or missing, arguments must be passed:\n  the approximate image center coordinates can be provided in decimal degrees or degree/hour minute second values (J2000 with colon separators), with right ascension and declination values separated by a comma or a space (not mandatory for astrometry.net). A single catalogue extract will be done for the entire sequence, if there is a lot of drift that may not succeed for all images.\n  focal length and pixel size can be passed with <b>-focal=</b> (in mm) and <b>-pixelsize=</b> (in microns), overriding values from images and settings.\n\nUnless <b>-noflip</b> is specified, if images are detected as being upside-down (negative parity), they will be flipped.\nFor faster star detection in big images, downsampling the image is possible with <b>-downscale</b>.\n\nImages can be either plate solved by Siril using a star catalogue and the global registration algorithm or by astrometry.net's local solve-field command (enabled with <b>-localasnet</b>).\nThe following options apply to Siril's plate solve only.\nThe limit magnitude of stars used for plate solving is automatically computed from the size of the field of view, but can be altered by passing a +offset or -offset value to <b>-limitmag=</b>, or simply an absolute positive value for the limit magnitude.\nThe choice of the star catalog is automatic unless the <b>-catalog=</b> option is passed: if local catalogs are installed, they are used, otherwise the choice is based on the field of view and limit magnitude. If the option is passed, it forces the use of the remote catalog given in argument, with possible values: tycho2, nomad, gaia, ppmxl, brightstars, apass")
#define STR_SEQPSF N_("Same command as PSF but runs on sequences. This is similar to the one-star registration, except results can be used for photometry analysis rather than aligning images and the coordinates of the star can be provided by options.\nThis command is what is called internally by the menu that appears on right click in the image, with the PSF for the sequence entry. By default, it will run with parallelisation activated; if registration data already exists for the sequence, they will be used to shift the search window in each image. If there is no registration data and if there is significant shift between images in the sequence, the default settings will fail to find stars in the initial position of the search area.\nThe follow star option can then be activated by going in the registration tab, selecting the one-star registration and checking the follow star movement box (default in headless if no registration data is available).\n\nResults will be displayed in the Plot tab, from which they can also be exported to a comma-separated values (CSV) file for external analysis.\n\nWhen creating a light curve, the first star for which seqpsf has been run, marked 'V' in the display, will be considered as the variable star. All others are averaged to create a reference light curve subtracted to the light curve of the variable star.\n\nCurrently, in headless operation, the command prints some analysed data in the console, another command allows several stars to be analysed and plotted as a light curve: LIGHT_CURVE. Arguments are mandatory in headless, with -at= allowing coordinates in pixels to be provided for the target star and -wcs= allowing J2000 equatorial coordinates to be provided")
#define STR_SEQRL N_("The same as the RL command, but applies to a sequence which must be specified as the first argument")
#define STR_SEQSB N_("The same as the SB command, but applies to a sequence which must be specified as the first argument")
#define STR_SEQSETMAG N_("Same as SETMAG command but for the loaded sequence.\n\nThis command is only valid after having run SEQPSF or its graphical counterpart (select the area around a star and launch the PSF analysis for the sequence, it will appear in the graphs).\nThis command has the same goal as SETMAG but recomputes the reference magnitude for each image of the sequence where the reference star has been found.\nWhen running the command, the last star that has been analysed will be considered as the reference star. Displaying the magnitude plot before typing the command makes it easy to understand.\nTo reset the reference star and magnitude offset, see SEQUNSETMAG")
#define STR_SEQSPLIT_CFA N_("Same command as SPLIT_CFA but for the sequence <b>sequencename</b>.\n\nThe output sequences names start with the prefix \"CFA_\" and a number unless otherwise specified with <b>-prefix=</b> option.\n<i>Limitation:</i> the sequence always outputs a sequence of FITS files, no matter the type of input sequence")
#define STR_SEQSTARNET N_("This command calls <a href=\"https://www.starnetastro.com/\">Starnet++</a> to remove stars from the sequence <b>sequencename</b>. See STARNET")
#define STR_SEQSTAT N_("Same command as STAT for sequence <b>sequencename</b>.\n\nData is saved as a csv file <b>output_file</b>.\nThe optional parameter defines the number of statistical values computed: <b>basic</b>, <b>main</b> (default) or <b>full</b> (more detailed but longer to compute).\n\t<b>basic</b> includes mean, median, sigma, bgnoise, min and max\n\t<b>main</b> includes basic with the addition of avgDev, MAD and the square root of BWMV\n\t<b>full</b> includes main with the addition of location and scale.\n\nIf <b>-cfa</b> is passed and the images are CFA, statistics are made on per-filter extractions")
#define STR_SEQSUBSKY N_("Same command as SUBSKY but for the sequence <b>sequencename</b>.\nDithering, required for low dynamic gradients, can be disabled with <b>-nodither</b>.\n\nThe output sequence name starts with the prefix \"bkg_\" unless otherwise specified with <b>-prefix=</b> option. Only selected images in the sequence are processed")
#define STR_SEQTILT N_("Same command as TILT but for the sequence <b>sequencename</b>. It generally gives better results")
#define STR_SEQUNSETMAG N_("Resets the magnitude calibration and reference star for the sequence. See SEQSETMAG")
#define STR_SEQWIENER N_("The same as the <b>WIENER</b> command, but applies to a sequence which must be specified as the first argument")
#define STR_SET N_("Updates a setting value, using its variable name, with the given value, or a set of values using an existing ini file with <b>-import=</b> option.\nSee GET to get values or the list of variables")
#define STR_SET16 N_("Forbids images to be saved with 32 bits per channel on processing, use 16 bits instead")
#define STR_SET32 N_("Allows images to be saved with 32 bits per channel on processing")
#define STR_SETCOMPRESS N_("Defines if images are compressed or not.\n\n<b>0</b> means no compression while <b>1</b> enables compression.\nIf compression is enabled, the type must be explicitly written in the option <b>-type=</b> (\"rice\", \"gzip1\", \"gzip2\").\nAssociated to the compression, the quantization value must be within [0, 256] range.\n\nFor example, \"setcompress 1 -type=rice 16\" sets the rice compression with a quantization of 16")
#define STR_SETCPU N_("Defines the number of processing threads used for calculation.\n\nCan be as high as the number of virtual threads existing on the system, which is the number of CPU cores or twice this number if hyperthreading (Intel HT) is available. The default value is the maximum number of threads available, so this should mostly be used to limit processing power. This is reset on every Siril run. See also SETMEM")
#define STR_SETEXT N_("Sets the extension used and recognized by sequences.\n\nThe argument <b>extension</b> can be \"fit\", \"fts\" or \"fits\"")
#define STR_SETFINDSTAR N_("Defines stars detection parameters for FINDSTAR and REGISTER commands.\n\nPassing no parameter lists the current values.\nPassing <b>reset</b> resets all values to defaults. You can then still pass values after this keyword.\n\nConfigurable values:\n\n<b>-radius=</b> defines the radius of the initial search box and must be between 3 and 50.\n<b>-sigma=</b> defines the threshold above noise and must be greater than or equal to 0.05.\n<b>-roundness=</b> defines minimum star roundness and must between 0 and 0.95. <b>-maxR</b> allows an upper bound to roundness to be set, to visualize only the areas where stars are significantly elongated, do not change for registration.\n<b>-minA</b> and <b>-maxA</b> define limits for the minimum and maximum amplitude of stars to keep, normalized between 0 and 1.\n<b>-focal=</b> defines the focal length of the telescope.\n<b>-pixelsize=</b> defines the pixel size of the sensor.\n<b> -gaussian</b> and <b>-moffat</b> configure the solver model to be used (Gaussian is the default).\nIf Moffat is selected, <b>-minbeta=</b> defines the minimum value of beta for which candidate stars will be accepted and must be greater than or equal to 0.0 and less than 10.0.\n<b>-convergence=</b> defines the number of iterations performed to fit PSF and should be set between 1 and 3 (more tolerant).\n<b>-relax=</b> relaxes the checks that are done on star candidates to assess if they are stars or not, to allow objects not shaped like stars to still be accepted (off by default)")
#define STR_SETMAG N_("Calibrates the magnitudes by selecting a star and giving the known apparent magnitude.\n\nAll PSF computations will return the calibrated apparent magnitude afterwards, instead of an apparent magnitude relative to ADU values. Note that the provided value must match the magnitude for the observation filter to be meaningful.\nTo reset the magnitude constant see UNSETMAG")
#define STR_SETMEM N_("Sets a new ratio of used memory on free memory.\n\n<b>Ratio</b> value should be between 0.05 and 2, depending on other activities of the machine. A higher ratio should allow siril to process faster, but setting the ratio of used memory above 1 will require the use of on-disk memory, which is very slow and unrecommended, even sometimes not supported, leading to system crash. A fixed amount of memory can also be set in the generic settings, with SET, instead of a ratio")
#define STR_SETPHOT N_("Gets or sets photometry settings, mostly used by SEQPSF. If arguments are provided, they will update the settings. None are mandatory, any can be provided, default values are shown in the command's syntax. At the end of the command, the active configuration will be printed. Aperture is dynamic unless forced, the <b>aperture</b> value from settings is not used if dynamic, FWHM is used instead. Gain is used only if not available from the FITS header")
#define STR_SETREF N_("Sets the reference image of the sequence given in first argument. <b>image_number</b> is the sequential number of the image in the sequence, not the number in the filename, starting at 1")
#define STR_SHOW N_("Shows a point on the loaded plate solved image using the temporary user annotations catalog, based on its equatorial coordinates. The <b>-clear</b> option clears this catalog first and can be used alone. Several points can be passed using a CSV file with the option <b>-file=</b> containing a name (cannot start with a digit), RA and Dec. This is only available from the GUI of Siril")
#define STR_SPLIT N_("Splits the loaded color image into three distinct files (one for each color) and saves them in <b>file1</b>.fit, <b>file2</b>.fit and <b>file3</b>.fit files. A last argument can optionally be supplied, <b>-hsl</b>, <b>-hsv</b> or <b>lab</b> to perform an HSL, HSV or CieLAB extraction. If no option are provided, the extraction is of RGB type, meaning no conversion is done")
#define STR_SPLIT_CFA N_("Splits the loaded CFA image into four distinct files (one for each channel) and saves them in files")
#define STR_SSO N_("Searches and displays Solar System objects in the current loaded and plate solved image's field of view, using the online IMCCE SkyBoT cone search tool. Use <b>-mag=</b> to change the limit magnitude, defaults to 20")
#define STR_STACK N_("Stacks the <b>sequencename</b> sequence, using options.\n\nRejection type:\nThe allowed types are: <b>sum</b>, <b>max</b>, <b>min</b>, <b>med</b> (or <b>median</b>) and <b>rej</b> (or <b>mean</b>). If no argument other than the sequence name is provided, sum stacking is assumed.\n\nStacking with rejection:\nTypes <b>rej</b> or <b>mean</b> require the use of additional arguments for rejection type and values. The rejection type is one of <b>n[one], p[ercentile], s[igma], m[edian], w[insorized], l[inear], g[eneralized], [m]a[d]</b> for Percentile, Sigma, Median, Winsorized, Linear-Fit, Generalized Extreme Studentized Deviate Test or k-MAD clipping. If omitted, the default Winsorized is used.\nThe <b>sigma low</b> and <b>sigma high</b> parameters of rejection are mandatory unless <b>none</b> is selected.\nOptionally, rejection maps can be created, showing where pixels were rejected in one (<b>-rejmap</b>) or two (<b>-rejmaps</b>, for low and high rejections) newly created images.\n\nNormalization of input images:\nFor <b>med</b> (or <b>median</b>) and <b>rej</b> (or <b>mean</b>) stacking types, different types of normalization are allowed: <b>-norm=add</b> for additive, <b>-norm=mul</b> for multiplicative. Options <b>-norm=addscale</b> and <b>-norm=mulscale</b> apply same normalization but with scale operations. <b>-nonorm</b> is the option to disable normalization. Otherwise addtive with scale method is applied by default.\n<b>-fastnorm</b> option specifies to use faster estimators for location and scale than the default IKSS.\n<b>-rgb_equal</b> will use normalization to equalize color image backgrounds, useful if PCC and unlinked AUTOSTRETCH will not be used.\n\nOther options for rejection stacking:\n<b>-weight_from_noise</b> is an option to add larger weights to frames with lower background noise.\n<b>-weight_from_nbstack</b> weights input images based on how many images were used to create them, useful for live stacking.\n<b>-weight_from_nbstars</b> or <b>-weight_from_wfwhm</b> weight input images based on number of stars or wFWHM computed during registration step.\n\nOutputs:\nResult image name can be set with the <b>-out=</b> option. Otherwise, it will be named as <b>sequencename</b>_stacked.fit.\n<b>-output_norm</b> applies a normalization to rescale result in the [0, 1] range (median and mean stacking only).\n\nFiltering out images:\nImages to be stacked can be selected based on some filters, like manual selection or best FWHM, with some of the <b>-filter-*</b> options.\nSee the command reference for the complete documentation on this command")
#define STR_STACKALL N_("Opens all sequences in the current directory and stacks them with the optionally specified stacking type and filtering or with sum stacking. See STACK command for options description")
#define STR_STARNET N_("Calls <a href=\"https://www.starnetastro.com/\">StarNet</a> to remove stars from the loaded image.\n\n<b>Prerequisite:</b> StarNet is an external program, with no affiliation with Siril, and must be installed correctly prior the first use of this command, with the path to its CLI version installation correctly set in Preferences / Miscellaneous.\n\nThe starless image is loaded on completion, and a star mask image is created in the working directory unless the optional parameter <b>-nostarmask</b> is provided.\n\nOptionally, parameters may be passed to the command:\n- The option <b>-stretch</b> is for use with linear images and will apply a pre-stretch before running StarNet and the inverse stretch to the generated starless and starmask images.\n- To improve star removal on images with very tight stars, the parameter <b>-upscale</b> may be provided. This will upsample the image by a factor of 2 prior to StarNet processing and rescale it to the original size afterwards, at the expense of more processing time.\n- The optional parameter <b>-stride=value</b> may be provided, however the author of StarNet <i>strongly</i> recommends that the default stride of 256 be used")
#define STR_START_LS N_("Initializes a livestacking session, using the optional calibration files and waits for input files to be provided by the LIVESTACK command until STOP_LS is called. Default processing will use shift-only registration and 16-bit processing because it's faster, it can be changed to rotation with <b>-rotate</b> and <b>-32bits</b>\n\n<i>Note that the live stacking commands put Siril in a state in which it's not able to process other commands. After START_LS, only LIVESTACK, STOP_LS and EXIT can be called until STOP_LS is called to return Siril in its normal, non-live-stacking, state</i>")
#define STR_STAT N_("Returns statistics of the current image, the basic list by default or the main list if <b>main</b> is passed. If a selection is made, statistics are computed within the selection. If <b>-cfa</b> is passed and the image is CFA, statistics are made on per-filter extractions")
#define STR_STOP_LS N_("Stops the live stacking session. Only possible after START_LS")
#define STR_SUBSKY N_("Computes a synthetic background gradient using either the polynomial function model of <b>degree</b> degrees or the RBF model (if <b>-rbf</b> is provided instead) and subtracts it from the image.\nThe number of samples per horizontal line and the tolerance to exclude brighter areas can be adjusted with the optional arguments. Tolerance is in MAD units: median + tolerance * mad.\nDithering, required for low dynamic gradients, can be enabled with <b>-dither</b>.\nFor RBF, the additional smoothing parameter is also available")
#define STR_SYNTHSTAR N_("Fixes imperfect stars from the loaded image. No matter how much coma, tracking drift or other distortion your stars have, if Siril's star finder routine can detect it, synthstar will fix it. To use intensive care, you may wish to manually detect all the stars you wish to fix. This can be done using the findstar console command or the Dynamic PSF dialog. If you have not run star detection, it will be run automatically with default settings.\n\nFor best results synthstar should be run before stretching.\n\nThe output of synthstar is a fully corrected synthetic star mask comprising perfectly round star PSFs (Moffat or Gaussian profiles depending on star saturation) computed to match the intensity, FWHM, hue and saturation measured for each star detected in the input image. This can then be recombined with the starless image to produce an image with perfect stars.\n\nNo parameters are required for this command")
#define STR_SYNTHSTARUNCLIP N_("Re-profiles clipped stars of the loaded image to desaturate them, scaling the output so that all pixel values are &lt;= 1.0")
#define STR_THRESHLO N_("Replaces values below <b>level</b> in the loaded image with <b>level</b>")
#define STR_THRESHHI N_("Replaces values above <b>level</b> in the loaded image with <b>level</b>")
#define STR_THRESH N_("Replaces values below <b>lo</b> with <b>lo</b> and values above <b>hi</b> with <b>hi</b> in the loaded image")
#define STR_TILT N_("Computes the sensor tilt as the FWHM difference between the best and worst corner truncated mean values. The <b>clear</b> option allows to clear the drawing")

#define STR_UNSELECT N_("Allows easy mass unselection of images in the sequence <b>sequencename</b> (from <b>from</b> to <b>to</b> included). See SELECT")
#define STR_UNSETMAG N_("Resets the magnitude calibration to 0. See SETMAG")
#define STR_UNSHARP N_("Applies an unsharp mask, actually a Gaussian filtered image  with sigma <b>sigma</b> and a blend with the parameter <b>amount</b> used as such: out = in * (1 + amount) + filtered * (-amount).\n\nSee also GAUSS, the same without blending")

#define STR_VISU N_("Displays the loaded image with <b>low</b> and <b>high</b> as the low and high threshold, GUI only")

#define STR_WAVELET N_("Computes the wavelet transform of the loaded image on (<b>nbr_layers</b>=1...6) layer(s) using linear (<b>type</b>=1) or bspline (<b>type</b>=2) version of the 'à trous' algorithm. The result is stored in a file as a structure containing the layers, ready for weighted reconstruction with WRECONS.\n\nSee also EXTRACT")
#define STR_WIENER N_("Restores an image using the Wiener deconvolution method.\n\nOptionally, a PSF created by MAKEPSF may be loaded using the argument <b>-loadpsf=<i>filename</i></b>.\n\nThe parameter <b>-alpha=</b> provides the Gaussian noise modelled regularization factor")
#define STR_WRECONS N_("Reconstructs to current image from the layers previously computed with wavelets and weighted with coefficients <b>c1</b>, <b>c2</b>, ..., <b>cn</b> according to the number of layers used for wavelet transform, after the use of WAVELET")

#endif /* SRC_CORE_COMMAND_DEF_H_ */
