/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "titanic/support/strings.h"
#include "titanic/support/files_manager.h"
#include "titanic/titanic.h"

namespace Titanic {

void Strings::load() {
	Common::SeekableReadStream *r = g_vm->_filesManager->getResource("TEXT/STRINGS");
	while (r->pos() < r->size())
		push_back(readStringFromStream(r));
	delete r;
}

} // End of namespace Titanic
