% This LilyPond file was generated by Rosegarden 15.12
\include "nederlands.ly"
\version "2.12.0"
\header {
    composer = "Steve Conrad"
    copyright = "2005"
    subtitle = "Apologies to Jim Morrison et al"
    title = "Stormy Riders"
    tagline = "Created using Rosegarden 15.12 and LilyPond"
}
#(set-global-staff-size 18)
#(set-default-paper-size "a4")
global = { 
    \time 9/4
    \skip 2.*150 \skip 64 
}
globalTempo = {
    \override Score.MetronomeMark #'transparent = ##t
    \tempo 4 = 104  \skip 2 \skip 2.*149 \skip 64 
}
\score {
    << % common
        % Force offset of colliding notes in chords:
        \override Score.NoteColumn #'force-hshift = #1.0
        % Allow fingerings inside the staff (configured from export options):
        \override Score.Fingering #'staff-padding = #'()

        \context Staff = "track 2, gtr1" << 
            \set Staff.instrumentName = \markup { \center-column { "gtr1 " } }
            \set Staff.midiInstrument = "Acoustic Guitar (nylon)"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 1" {
                % Segment: rhythm fig 1 - gtr
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'() 
                \time 9/4
                
                \repeat unfold 8 {
                    \clef "bass"
                    e, 8 \sustainOn [ e ] < d' b > [ e ] e, [ < cis' a > \sustainOff \sustainOn ] e [ g, ] e [ < a cis' > ] b, \sustainOff \sustainOn [ e ] < b g > [ e ] b, [ < cis' a > \sustainOff \sustainOn ] e [ g, ]  |
                    e, 8 \sustainOff \sustainOn [ e ] < b d' > [ e ] e, [ < cis' a > \sustainOff \sustainOn ] e [ g, ] e [ < cis' a > ] b, \sustainOff \sustainOn [ e ] < b g > [ e ] b, [ < cis' a > \sustainOff \sustainOn ] e [ g, ]  |
                    a, 8 \sustainOff \sustainOn [ e ] < a c' e' > [ e ] a, [ < b e' d' > \sustainOff \sustainOn ] fis [ a, ] fis [ < b e' d' > ] a, \sustainOff \sustainOn [ g ] < c' e' > [ g ] a, [ < d' fis' e' > \sustainOff \sustainOn ] a [ a, ]  |
                    e, 8 \sustainOff \sustainOn [ e ] < b d' > [ e ] e, [ < cis' a > \sustainOff \sustainOn ] e [ g, ] e [ < cis' a > ] b, \sustainOff \sustainOn [ e ] < b g > [ e ] b, [ < cis' a > \sustainOff \sustainOn ] e [ g, ]  |
%% 5
                    fis, 8 \sustainOff \sustainOn [ d ] < d' a > [ d ] fis, [ < d' a > \sustainOff \sustainOn ] d [ fis, ] d [ < a d' > ] e, \sustainOff \sustainOn [ c ] < c' g > [ c ] e, [ < c' g > \sustainOff \sustainOn ] c [ e, ]  |
                    e, 8 \sustainOff \sustainOn [ e ] < b d' > [ e ] e, [ < cis' a > \sustainOff \sustainOn ] e [ g, ] e [ < cis' a > ] b, \sustainOff \sustainOn [ e ] < b g > [ e ] b, [ < cis' a > \sustainOff \sustainOn ] e [ g, \sustainOff ]  |
                } % close repeat
            } % Voice

            \context Voice = "voice 2" {
                % Segment: Nylon Guitar
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*144 
                \clef "treble_8"
                \key d \major
                < d' b e, > 1 r4 r r2.  |
%% 50
                r2. r r  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 3, bass" << 
            \set Staff.instrumentName = \markup { \center-column { "bass " } }
            \set Staff.midiInstrument = "Picked Bass"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 3" {
                % Segment: rhythm fig 2 - bass
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'() 
                \time 9/4
                
                \repeat unfold 8 {
                    \clef "bass"
                    e,, 8 [ g,, ] b,, [ g,, ] e,, [ cis, ] a,, [ e,, ] a,, [ cis, ] e,, [ g,, ] b,, [ g,, ] e,, [ cis, ] a,, [ e,, ]  |
                    e,, 8 [ g,, ] b,, [ g,, ] e,, [ cis, ] a,, [ e,, ] a,, [ cis, ] e,, [ g,, ] b,, [ g,, ] e,, [ cis, ] a,, [ e,, ]  |
                    a,, 8 [ c, ] e, [ c, ] a,, [ fis, ] d, [ a,, ] d, [ fis, ] a,, [ c, ] e, [ c, ] a,, [ fis, ] d, [ a,, ]  |
                    e,, 8 [ g,, ] b,, [ g,, ] e,, [ cis, ] a,, [ e,, ] a,, [ cis, ] e,, [ g,, ] b,, [ g,, ] e,, [ cis, ] a,, [ e,, ]  |
%% 5
                    d,, 8 [ a,, ] d, [ a,, ] d,, [ d, ] a,, [ d,, ] a,, [ d, ] c,, [ g,, ] c, [ g,, ] c,, [ c, ] g,, [ c,, ]  |
                    e,, 8 [ g,, ] b,, [ g,, ] e,, [ cis, ] a,, [ e,, ] a,, [ cis, ] e,, [ g,, ] b,, [ g,, ] e,, [ cis, ] a,, [ e,, ]  |
                } % close repeat
            } % Voice

            \context Voice = "voice 4" {
                % Segment: Acoustic Bass
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*144 
                \clef "bass"
                \key b \minor
                e, \breve _~ e, 4 _~  |
%% 50
                e, \breve r4  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 4, violin" << 
            \set Staff.instrumentName = \markup { \center-column { "violin " } }
            \set Staff.midiInstrument = "Violin"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 5" {
                % Segment: breather
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*36 
                \clef "treble"
                \key e \minor
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' >  |
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' >  |
%% 15
                r4 < c'' e' > 4. < d'' fis' > _~ < d'' fis' > 4 r < e'' g' > 4. < fis'' a' >  |
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' >  |
                r4 < d'' fis' > 4. < d'' fis' > _~ < d'' fis' > 4 r < c'' e' > 4. < c'' e' >  |
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' >  |
            } % Voice

            \context Voice = "voice 6" {
                % Segment: breather - horn (copied) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*72 
%% 25
                \clef "treble"
                \key e \minor
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' >  |
                r4 < d'' b' > 4. r32 < cis'' a' > 4. _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' >  |
                r4 < c'' e' > 4. < d'' fis' > _~ < d'' fis' > 4 r < e'' g' > 4. < fis'' a' > 
                % warning: overlong bar truncated here |
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' > 
                % warning: overlong bar truncated here |
                r4 < d'' fis' > 4. < d'' fis' > _~ < d'' fis' > 4 r < c'' e' > 4. < c'' e' > 
                % warning: overlong bar truncated here |
%% 30
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. _~ < b' g' > 4 _~ < g' b' > 16. r32 
                % warning: overlong bar truncated here |
            } % Voice

            \context Voice = "voice 7" {
                % Segment: outro (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*108 
                \clef "treble"
                \key b \minor
                < fis'' d'' > 8. < fis'' d'' > < e'' cis'' > < d'' b' > < fis'' d'' > 1. 
                % warning: overlong bar truncated here |
                < fis'' d'' > 8. [ < fis'' d'' > ] < e'' cis'' > [ < d'' b' > ] < e'' cis'' > 16. < d'' b' > [ < cis'' a' > ] < b' g' > _~ < b' g' > 4. _~ < b' g' > 2.  |
                g'' 8. g'' fis'' e'' b'' 1.  |
%% 40
                fis'' 8. [ fis'' ] e'' [ d'' ] e'' 16. [ d'' ] cis'' [ b' _~ ] b' 4. _~ b' 2.  |
                r4 e'' 16. [ fis'' ] e'' [ d'' _~ ] d'' 4 d'' 16. [ e'' ] d'' [ c'' ] g' 1  |
                fis' 8. [ fis' ] e' [ d' ] e' 16. [ d' ] cis' [ b _~ ] b 4. _~ b 2.  |
            } % Voice

            \context Voice = "voice 8" {
                % Segment: breather
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*126 
                \clef "treble"
                \key e \minor
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' >  |
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' >  |
%% 45
                r4 < c'' e' > 4. < d'' fis' > _~ < d'' fis' > 4 r < e'' g' > 4. < fis'' a' >  |
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' >  |
                r4 < d'' fis' > 4. < d'' fis' > _~ < d'' fis' > 4 r < c'' e' > 4. < c'' e' >  |
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. _~ < b' g' >  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 5, organ" << 
            \set Staff.instrumentName = \markup { \center-column { "organ " } }
            \set Staff.midiInstrument = "Rock Organ"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 9" {
                % Segment: main theme
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*18 
                \key b \minor
                d' 32 [ dis' ] e' 16 g' 8 [ b' ] g' [ e' ] fis' 16 g' 8. [ fis' 16 ] g' 8. d' 8 d' 32 [ dis' ] e' 8. _~ e' 2.  |
                d' 32 [ dis' ] e' 16 g' 8 [ d'' ] g' [ e' ] fis' 16 g' 8. [ fis' 16 ] g' 8. d' 8 d' 32 [ dis' ] e' 8. _~ e' 2.  |
                d' 32 [ dis' ] e' 16 a' 8 [ c'' ] a' [ e' ] cis'' 16 d'' 8. [ cis'' 16 ] d'' 8. c'' 8 d'' 32 [ dis'' ] e'' 8. _~ e'' 2.  |
%% 10
                d' 32 [ dis' ] e' 16 g' 8 [ b' ] g' [ e' ] fis' 16 g' 8. [ fis' 16 ] g' 8. d' 8 d' 32 [ dis' ] e' 8. _~ e' 2.  |
                c' 32 [ cis' ] d' 16 fis' 8 [ a' ] fis' [ d' ] ais' 16 b' 8. [ ais' 16 ] b' 8. a' 8 b' 16 c'' 8. _~ c'' 2.  |
                d'' 32 [ dis'' ] e'' 16 d'' 8 [ b' ] g' [ e' ] fis' 16 g' 8. [ fis' 16 ] g' 8. d' 8 d' 32 [ dis' ] e' 8. _~ e' 2.  |
            } % Voice

            \context Voice = "voice 10" {
                % Segment: Acoustic Bass (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*36 
                r4 r r r2. r  |
            } % Voice

            \context Voice = "voice 11" {
                % Segment: main theme
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*54 
                \key b \minor
                d' 32 [ dis' ] e' 16 g' 8 [ b' ] g' [ e' ] fis' 16 [ g' ] g' 8 [ e' ] \times 2/3 { b' [ d'' fis'' ] } d'' 32 dis'' e'' 8. g'' 16 e'' d'' 8 a' 32 ais' b' 16 g' 8 d' 32 dis' e' 16 d' 8  |
%% 20
                d' 32 [ dis' ] e' 16 g' 8 [ d'' ] g' [ e' ] fis' 16 g' 8. [ fis' 16 ] g' 8. d' 8 d' 32 [ dis' ] e' 16 [ d' b a' ] g' e' 8 [ b' 16 a' ] g' [ e' ] d'' 8 [ b' ]  |
                d' 32 [ dis' ] e' 16 a' 8 [ c'' ] a' [ e' ] cis'' 16 d'' 8. [ cis'' 16 ] d'' 8. c'' 8 d'' 32 [ e'' ] d'' 16 [ c'' a' ] \times 4/5 { dis'' [ e'' d'' c'' a' ] } \times 4/5 { g' [ a' e' d' c' ] } g' 32 gis' a' 8.  |
                d' 32 [ dis' ] e' 16 g' 8 [ b' ] g' [ e' ] fis' 16 g' 8. [ fis' 16 ] g' 8. d' 8 dis' 32 [ e' ] g' 16 [ a' g' ais' ] a' [ g' a' d''' ] d''' 64 dis''' e''' 32 b'' 16 [ g'' b'' ] a'' [ g'' ] e''  |
                c'' 64 cis'' d'' 32 e'' 16 fis'' a'' b'' d'' 64 dis'' e'' 32 fis'' 16 d'' b' a' a' 64 ais' b' 32 d'' 16 a' fis' e' e' 64 f' fis' 32 e' 16 a' ais' b' \times 4/5 { c'' [ g'' e'' g'' b' ] } \times 4/5 { a'' [ c'' e' c'' a'' ] } \times 2/3 { d'' [ e'' b' ais' a' g' ] } \times 2/3 { e' [ g' dis' e' g' b' ] }  |
                d'' 32 [ dis'' ] e'' 16 d'' 8 [ b' ] g' [ e' ] fis' 16 g' 8. [ fis' 16 ] g' 8. d' 8 d' 32 [ dis' ] e' 8. _~ e' 2.  |
            } % Voice

            \context Voice = "voice 12" {
                % Segment: main theme
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*90 
                \key b \minor
                d' 32 [ dis' ] e' 16 g' 8 [ b' ] g' [ e' ] fis' 16 g' 8. [ fis' 16 ] g' 8. d' 8 d' 32 [ dis' ] e' 8. _~ e' 2.  |
                d' 32 [ dis' ] e' 16 g' 8 [ d'' ] g' [ e' ] fis' 16 g' 8. [ fis' 16 ] g' 8. d' 8 d' 32 [ dis' ] e' 8. _~ e' 2.  |
                d' 32 [ dis' ] e' 16 a' 8 [ c'' ] a' [ e' ] cis'' 16 d'' 8. [ cis'' 16 ] d'' 8. c'' 8 d'' 32 [ dis'' ] e'' 8. _~ e'' 2.  |
                d' 32 [ dis' ] e' 16 g' 8 [ b' ] g' [ e' ] fis' 16 g' 8. [ fis' 16 ] g' 8. d' 8 d' 32 [ dis' ] e' 8. _~ e' 2.  |
%% 35
                c' 32 [ cis' ] d' 16 fis' 8 [ a' ] fis' [ d' ] ais' 16 b' 8. [ ais' 16 ] b' 8. a' 8 b' 16 c'' 8. _~ c'' 2.  |
                d'' 32 [ dis'' ] e'' 16 d'' 8 [ b' ] g' [ e' ] fis' 16 g' 8. [ fis' 16 ] g' 8. d' 8 d' 32 [ dis' ] e' 8. _~ e' 2.  |
            } % Voice

            \context Voice = "voice 13" {
                % Segment: Organ 3 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*108 
                \clef "treble"
                \key d \major
                e' 8 [ e' ] < d'' b' > [ e' ] e' [ < cis'' a' > ] e' [ e' ] e' [ < cis'' a' > ] e' [ e' ] < b' g' > [ e' ] e' [ < cis'' a' > ] e' [ e' ]  |
                e' 8 [ e' ] < b' d'' > [ e' ] e' [ < a' cis'' > ] e' [ e' ] e' [ < a' cis'' > ] e' [ e' ] < g' b' > [ e' ] e' [ < a' cis'' > ] e' [ e' ]  |
                e' 8 [ e' ] < c'' a' > [ e' ] e' [ < d'' b' > ] e' [ e' ] e' [ < d'' b' > ] a' [ a' ] < e'' c'' > [ a' ] a' [ < fis'' d'' > ] a' [ a' ]  |
%% 40
                e' 8 [ e' ] < b' d'' > [ e' ] e' [ < a' cis'' > ] e' [ e' ] e' [ < a' cis'' > ] e' [ e' ] < g' b' > [ e' ] e' [ < a' cis'' > ] e' [ e' ]  |
                fis' 8 [ fis' ] < d'' a' > [ fis' ] fis' [ < d'' a' > ] fis' [ fis' ] fis' [ < d'' a' > ] e' [ e' ] < c'' g' > [ e' ] e' [ < c'' g' > ] e' [ e' ]  |
                e' 8 [ e' ] < b' d'' > [ e' ] e' [ < a' cis'' > ] e' [ e' ] e' [ < a' cis'' > ] e' [ e' ] < g' b' > [ e' ] e' [ < a' cis'' > ] e' [ e' ]  |
            } % Voice

            \context Voice = "voice 14" {
                % Segment: Organ 3
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*126 
                \clef "treble"
                e' 8 [ e' ] < d'' b' > [ e' ] e' [ < cis'' a' > ] e' [ e' ] e' [ < cis'' a' > ] e' [ e' ] < b' g' > [ e' ] e' [ < cis'' a' > ] e' [ e' ]  |
                e' 8 [ e' ] < b' d'' > [ e' ] e' [ < a' cis'' > ] e' [ e' ] e' [ < a' cis'' > ] e' [ e' ] < g' b' > [ e' ] e' [ < a' cis'' > ] e' [ e' ]  |
%% 45
                e' 8 [ e' ] < c'' a' > [ e' ] e' [ < d'' b' > ] e' [ e' ] e' [ < d'' b' > ] a' [ a' ] < e'' c'' > [ a' ] a' [ < fis'' d'' > ] a' [ a' ]  |
                e' 8 [ e' ] < b' d'' > [ e' ] e' [ < a' cis'' > ] e' [ e' ] e' [ < a' cis'' > ] e' [ e' ] < g' b' > [ e' ] e' [ < a' cis'' > ] e' [ e' ]  |
                fis' 8 [ fis' ] < d'' a' > [ fis' ] fis' [ < d'' a' > ] fis' [ fis' ] fis' [ < d'' a' > ] e' [ e' ] < c'' g' > [ e' ] e' [ < c'' g' > ] e' [ e' ]  |
                e' 8 [ e' ] < b' d'' > [ e' ] e' [ < a' cis'' > ] e' [ e' ] e' [ < a' cis'' > ] e' [ e' ] < g' b' > [ e' ] e' [ < a' cis'' > ] e' [ e' ]  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 6, gtr2" << 
            \set Staff.instrumentName = \markup { \center-column { "gtr2 " } }
            \set Staff.midiInstrument = "Slap Bass 2"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 15" {
                % Segment: breather - horn (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*36 
                \clef "treble"
                \key e \minor
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' >  |
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' >  |
%% 15
                r4 < c'' e' > 4. < d'' fis' > _~ < d'' fis' > 4 r < e'' g' > 4. < fis'' a' > 
                % warning: overlong bar truncated here |
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' > 
                % warning: overlong bar truncated here |
                r4 < d'' fis' > 4. < d'' fis' > _~ < d'' fis' > 4 r < c'' e' > 4. < c'' e' > 
                % warning: overlong bar truncated here |
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. _~ < b' g' > 4 _~ < g' b' > 16. r32 
                % warning: overlong bar truncated here |
            } % Voice

            \context Voice = "voice 16" {
                % Segment: breather - horn (copied) (copied) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*72 
%% 25
                \clef "treble"
                \key e \minor
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' >  |
                r4 < d'' b' > 4. r32 < cis'' a' > 4. _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' >  |
                r4 < c'' e' > 4. < d'' fis' > _~ < d'' fis' > 4 r < e'' g' > 4. < fis'' a' > 
                % warning: overlong bar truncated here |
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. < cis'' a' > 
                % warning: overlong bar truncated here |
                r4 < d'' fis' > 4. < d'' fis' > _~ < d'' fis' > 4 r < c'' e' > 4. < c'' e' > 
                % warning: overlong bar truncated here |
%% 30
                r4 < d'' b' > 4. < cis'' a' > _~ < cis'' a' > 4 r < b' g' > 4. _~ < b' g' > 4 _~ < g' b' > 16. r64 r 
                % warning: overlong bar truncated here |
            } % Voice

            \context Voice = "voice 17" {
                % Segment: gtr2
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*144 
                \clef "treble"
                r2. r r  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 7, horn" << 
            \set Staff.instrumentName = \markup { \center-column { "horn " } }
            \set Staff.midiInstrument = "Trombone"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 18" {
                % Segment: Trombone
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'() 
                \time 9/4
                
                r2. r r  |
            } % Voice

            \context Voice = "voice 19" {
                % Segment: main theme -gtr
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*90 
                \clef "treble_8"
                \key d \major
                e 8 [ g ] b [ g ] e g 4 g d 8 e 4 a, 16 [ b, ] d [ e g a ] b [ cis' ] e' 8 r  |
                e 8 [ g ] b [ g ] e g 4 g d 8 a 8. [ bes 16 ] a [ g ] e 8 e 4 d 8 [ b, ]  |
                e 8 a c' a e d' 4 d' g 8 e 16 [ d ] b, 8 a 16 g e 8 c' 16 [ b a b ] e' 8 [ b _~ ]  |
                b 4 a g 8 e 4. b 4 b 8 [ b ] a [ g ] b 4. g 8  |
%% 35
                d 4 a a 8 _~ < a d > 2 d 8 c 4 g g 8 _~ < g c > 4 c 8  |
                e \breve _~ e 4  |
            } % Voice

            \context Voice = "voice 20" {
                % Segment: outro
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*108 
                \clef "treble"
                \key b \minor
                r2. r r 
                % warning: overlong bar truncated here |
                r2. r r  |
                r2. r r  |
%% 40
                r2. r r  |
                r2. r r  |
                fis' 8. [ fis' ] e' [ d' ] e' 16. [ d' ] cis' [ b _~ ] b 4. _~ b 2.  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 8, gtr3" << 
            \set Staff.instrumentName = \markup { \center-column { "gtr3 " } }
            \set Staff.midiInstrument = "Electric Guitar (jazz)"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 21" {
                % Segment: main theme - gtr (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*18 
                \clef "treble_8"
                \key d \major
                e 8 [ g ] b [ g ] e g 4 g d 8 e 4 a, 16 [ b, ] d [ e g a ] b [ cis' ] e' 8 r  |
                e 8 [ g ] b [ g ] e g 4 g d 8 a 8. [ bes 16 ] a [ g ] e 8 e 4 d 8 [ b, ]  |
                e 8 a c' a e d' 4 d' g 8 e 16 [ d ] b, 8 a 16 g e 8 c' 16 [ b a b ] e' 8 [ b _~ ]  |
%% 10
                b 4 a g 8 e 4. b 4 b 8 [ b ] a [ g ] b 4. g 8  |
                d 4 a 32 _~ [ < d' a > _~ ] < fis' d' a > 16 _~ < fis' d' a > 8 _~ [ < fis' d' a > _~ ] < fis' d' a > 32 _~ [ < d' fis' a > _~ ] < fis' d' a > 8. _~ < fis' d' a > 4 d 8 c 4 g 32 _~ [ < c' g > _~ ] < e' c' g > 8. _~ < c' e' g > 8 [ e' 32 _~ < c' e' > _~ < g c' e' > _~ < c g c' e' > _~ ] < e' c' g c > 8 _~ [ < e' c' g c > ]  |
                e 32 _~ [ < e g > _~ ] < b g e > 8. _~ < b g e > \breve  |
            } % Voice

            \context Voice = "voice 22" {
                % Segment: Jazz Guitar - unbent
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*54 
                \clef "treble_8"
                \key e \minor
                e 8 [ g ] b [ g ] e g 4 g d 8 e 4 r2.  |
%% 20
                e 8 [ g ] d' [ g ] e g 4 g d 8 e 4 r2.  |
                e 8 [ a ] c' [ a ] e d' 4 d' a 8 d' 4 r2.  |
                e 8 [ g ] b [ g ] e g 4 g d 8 e 4 r2.  |
                d 8 [ fis ] a [ fis ] d b 4 b a 8 c' 4 r2.  |
                e' 8 [ d' ] b [ g ] e g 4 g d 8 e 4 r2.  |
            } % Voice

            \context Voice = "voice 23" {
                % Segment: main theme - gtr
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*90 
                \clef "treble_8"
                \key d \major
                e 8 [ g ] b [ g ] e g 4 g d 8 e 4 a, 16 [ b, ] d [ e g a ] b [ cis' ] e' 8 r  |
                e 8 [ g ] b [ g ] e g 4 g d 8 a 8. [ bes 16 ] a [ g ] e 8 e 4 d 8 [ b, ]  |
                e 8 a c' a e d' 4 d' g 8 e 16 [ d ] b, 8 a 16 g e 8 c' 16 [ b a b ] e' 8 [ b _~ ]  |
                b 4 a g 8 e 4. b 4 b 8 [ b ] a [ g ] b 4. g 8  |
%% 35
                d 4 a 32 _~ [ < d' a > _~ ] < fis' d' a > 16 _~ < fis' d' a > 8 _~ [ < fis' d' a > _~ ] < fis' d' a > 32 _~ [ < d' fis' a > _~ ] < fis' d' a > 8. _~ < fis' d' a > 4 d 8 c 4 g 32 _~ [ < c' g > _~ ] < e' c' g > 8. _~ < c' e' g > 8 [ e' 32 _~ < c' e' > _~ < g c' e' > _~ < c g c' e' > _~ ] < e' c' g c > 8 _~ [ < e' c' g c > ]  |
                e 32 _~ [ < e g > _~ ] < b g e > 8. _~ < b g e > \breve  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 9, gtr3a" << 
            \set Staff.instrumentName = \markup { \center-column { "gtr3a " } }
            \set Staff.midiInstrument = "Guitar harmonics"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 24" {
                % Segment: jazz guitar - bent
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*54 
                \clef "treble_8"
                \key g \major
                e 8 r r4 r8 g 4 g r8 e 4 r2.  |
%% 20
                e 8 r r64 r4 r8 g 4 r8 g 4 r8 e 4 r r2  |
                e 8 r r4 r64 r8 d' 4 d' r8 r e' 4 r64 r2 r4 
                % warning: overlong bar truncated here |
                e 8 r r64 r4 r8 g 4 r8 g 4 r8 e 4 r r2  |
                d 8 r r4 r64 r8 b 4 b r8 r c' 4 r64 r2 r4  |
                e' 8 r r4 r8 g 4 g r8 e 4 r2.  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 10, high hat" << 
            \set Staff.instrumentName = \markup { \center-column { "high hat " } }
            \set Staff.midiInstrument = ""
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 25" {
                % Segment: ride
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'() 
                \time 9/4
                
                \repeat unfold 8 {
                    \clef "bass"
                    \key gis \minor
                    gis, 8 ais, 16 ais, gis, 8 fis, ais, 16 ais, ais, 8 fis, fis, 16 ais, fis, 8 ais, fis, gis, fis, gis, ais, 16 fis, ais, 8 fis, 16 gis, e, [ e, ]  |
                    gis, 8 ais, 16 ais, gis, 8 fis, ais, 16 ais, ais, 8 fis, fis, 16 ais, fis, 8 ais, fis, gis, fis, gis, ais, 16 fis, ais, 8 fis, 16 gis, e, [ e, ]  |
                    gis, 8 ais, 16 ais, gis, 8 fis, ais, 16 ais, ais, 8 fis, fis, 16 ais, fis, 8 ais, fis, gis, fis, gis, ais, 16 fis, ais, 8 fis, 16 gis, e, [ e, ]  |
                    gis, 8 ais, 16 ais, gis, 8 fis, ais, 16 ais, ais, 8 fis, fis, 16 ais, fis, 8 ais, fis, gis, fis, gis, ais, 16 fis, ais, 8 fis, 16 gis, e, [ e, ]  |
%% 5
                    gis, 8 ais, 16 ais, gis, 8 fis, ais, 16 ais, ais, 8 fis, fis, 16 ais, fis, 8 ais, fis, gis, fis, gis, ais, 16 fis, ais, 8 fis, 16 gis, e, [ e, ]  |
                    gis, 8 ais, 16 ais, gis, 8 fis, ais, 16 ais, ais, 8 fis, fis, 16 ais, fis, 8 ais, fis, gis, fis, gis, ais, 16 fis, ais, 8 fis, 16 gis, e, [ e, ]  |
                } % close repeat
            } % Voice

            \context Voice = "voice 26" {
                % Segment: Creative SBLive! 8MB Soundfont #9
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*144 
                \clef "bass"
                cis 1 r4 r r2.  |
%% 50
                r2. r r  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 11, drums" << 
            \set Staff.instrumentName = \markup { \center-column { "drums " } }
            \set Staff.midiInstrument = ""
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 27" {
                % Segment: kick & snare
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'() 
                \time 9/4
                
                \repeat unfold 8 {
                    \clef "bass"
                    < e e, b,, > 8 -\accent _~ [ < e b,, > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e e, > -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e e, > -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > [ < b,, e > _~ ]  |
                    < b,, e e, > 8 -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e e, > -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e e, > -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > [ < b,, e > _~ ]  |
                    < b,, e e, > 8 -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e e, > -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e e, > -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > [ < b,, e > ]  |
                    < e e, b,, > 8 -\accent _~ [ < e b,, > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e e, > -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e e, > -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > [ < b,, e > _~ ]  |
%% 5
                    < b,, e e, > 8 -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e e, > -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e e, > -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > [ < b,, e > _~ ]  |
                    < b,, e e, > 8 -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e e, > -\accent _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, e > _~ [ < b,, e > _~ ] < b,, c e e, > -\accent _~ [ < b,, c e > 16 _~ ] < e c b,, > _~ [ < b,, c e > 8 _~ < b,, b, e > _~ ] < b,, b, e > 16 _~ [ < b,, b, e > < b,, e a, > 8 ]  |
                } % close repeat
            } % Voice

            \context Voice = "voice 28" {
                % Segment: Creative SBLive! 8MB Soundfont #10[D]
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*144 
                \clef "bass"
                d, 4 r r r2. r  |
%% 50
                r2. r r  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 12, gtr harmonics" << 
            \set Staff.instrumentName = \markup { \center-column { "gtr harmonics " } }
            \set Staff.midiInstrument = "Guitar harmonics"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 29" {
                % Segment: disclaimer (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'() 
                \time 9/4
                
                \key e \minor
                r2. r r  |
                e' 16 [ g' b' d'' ] fis'' b'' 1 r16 r8 r2.  |
                e' 16 [ fis' g' a' ] b' [ c'' e'' fis'' ] a'' 2 _~ a'' _~ a'' r4  |
                e' 16 [ g' b' d'' ] fis'' b'' 1 e'' 8. [ fis'' ] d'' [ b' ] g'  |
%% 5
                < d' a' > 1 r4 r16 c'' 8. [ e'' ] g'' [ b'' ] d'''  |
                c''' 16 a'' c''' g'' b'' g'' a'' fis'' a'' e'' g'' e'' fis'' d'' fis'' c'' e'' c'' d'' b' d'' a' c'' a' b' g' b' fis' a' [ fis' g' e' ] g' [ d' fis' d' ]  |
            } % Voice

            \context Voice = "voice 30" {
                % Segment: Guitar harmonics (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*18 
                e' 8. r16 r4 r r2. r  |
            } % Voice

            \context Voice = "voice 31" {
                % Segment: Volume control
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*123 
                \clef "treble"
                r2. r r  |
                r2. r r  |
                r2. r r  |
%% 45
                r2. r r  |
                r2. r r  |
                r2. r r  |
                r2. r r  |
                r2. r r  |
%% 50
                r2. r r  |
                 |
            } % Voice

            \context Voice = "voice 32" {
                % Segment: Volume Control
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'() 
                \time 9/4
                
                \clef "treble"
                r2. r r  |
                r2. r r  |
                r2. r r  |
                r2. r r  |
%% 5
                r2. r r  |
                r2. r r  |
                r2. r r  |
                r2. r r  |
            } % Voice

            \context Voice = "voice 33" {
                % Segment: disclaimer
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*126 
                \clef "treble"
                \key e \minor
                b 16 [ fis' g' d'' ] e'' b'' 8. _~ b'' 4 _~ b'' 1.  |
                d' 16 [ fis' g' b' ] d'' 2 _~ d'' 1.  |
%% 45
                a 16 [ e' b' c'' ] g'' a'' 8. a'' 4 _~ a'' 1.  |
                b 16 [ fis' g' d'' ] e'' b'' 1 b' 8. [ g' ] fis' [ g' ] a'  |
                fis' 16 c'' d'' fis'' a'' _~ a'' 1 c'' 8. [ e'' ] g'' [ b'' ] d'''  |
                c''' 16 [ a'' c''' g'' b'' g'' a'' fis'' a'' e'' g'' e'' fis'' d'' fis'' c'' e'' c'' d'' b' d'' a' c'' a' b' g' b' fis' a' fis' g' e' g' d' fis' d' ]  |
            } % Voice

            \context Voice = "voice 34" {
                % Segment: Guitar harmonics
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*144 
                e' 8. r16 r4 r r2. r  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 14, Choir Aahs" << 
            \set Staff.instrumentName = \markup { \center-column { "Choir Aahs " } }
            \set Staff.midiInstrument = "Choir Aahs"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 35" {
                % Segment: Choir Aahs track by Aere Greenway
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'() 
                \time 9/4
                
                r2. r r  |
                \clef "treble"
                e 1 g 2. -\tenuto r16 e 4 -\tenuto r16 d 8 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 e 4. -\tenuto g -\tenuto b -\tenuto g 2.. -\tenuto  |
                e 2. d 4 -\tenuto r8 e 1 -\tenuto r8  |
%% 5
                g 2 -\tenuto r8 a 2 -\tenuto r8 b 2 d' 4 -\tenuto r16 b 8 -\tenuto r16  |
                a 8. -\tenuto b 2 -\tenuto r16 r8 g 4. -\tenuto r16 e 2. -\tenuto r16 r8  |
                r16 e 4 g e 1. -\tenuto r16 r8  |
                e 4 g -\tenuto e 1. r4  |
                a 4 -\tenuto r16 c' 4 a 1. -\tenuto r16 r8  |
%% 10
                e 4 -\tenuto g -\tenuto e 1. r4  |
                r4 b 2. r16 d' 2 -\tenuto r16 r8 b 4 -\tenuto r16 a 8. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 16 b 2 -\tenuto r16 r8 g 2 -\tenuto r8 e 2 -\tenuto r8 d 4 -\tenuto  |
                e 1 -\tenuto r4 r16 b' 2 -\tenuto r16 r8 a' 4 -\tenuto  |
                e' 1 g' 2. -\tenuto r16 e' 4 -\tenuto r16 g' 8 -\tenuto 
                % warning: overlong bar truncated here |
%% 15
                \skip 4 a' 1 -\tenuto r4 b' 4. -\tenuto r16 d'' 4 -\tenuto r16  |
                b' 8. a' 4 -\tenuto r16 b' 1 -\tenuto a' 2 r16 e' 8. -\tenuto  |
                d' 4.. -\tenuto r16 e' 4. -\tenuto c' -\tenuto b 2 -\tenuto r8 g 4. -\tenuto  |
                r16 e 2. -\tenuto d 4 -\tenuto r16 e 1 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 2.*2 \skip 4 \skip 8 r8 r4  |
%% 20
                r16 e 4 g -\tenuto e 1. -\tenuto r16 r8  |
                r8 a 4 c' a 1. r8  |
                e 4 -\tenuto g -\tenuto e 1. -\tenuto r4  |
                r4 a 4. -\tenuto r16 b 4. d' 2 -\tenuto r16 r8 b 4 -\tenuto r16 a 8. -\tenuto  |
                b 2. g 4. e 1 -\tenuto r8  |
%% 25
                r4 b' 1 -\tenuto r16 a' 4.. -\tenuto b' 4. d'' 32 -\tenuto [ bes' -\staccato ] r16  |
                r4 b' 1 -\tenuto r8 a' 2 -\tenuto r16 e' 4 -\tenuto d' 16 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4 e' 4. g' 2. b' 4. -\tenuto r16 e'' 4. -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 224640 + 8400 < 233280  &&  35/16 < 9/4
                r16  |
                \skip 16 d'' 4.. e'' 1 -\tenuto r8 g'' 4. -\tenuto e'' 4  |
                d'' 4 -\tenuto r16 e'' 4. -\tenuto d'' 2. -\tenuto r16 b' 2 -\tenuto a' 4 -\tenuto 
                % warning: overlong bar truncated here |
%% 30
                \skip 8 e' \breve d' 4 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 e' 2. -\tenuto r16 g' 2 -\tenuto r16 e' 2 -\tenuto r16 d' 8. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 16 r16 e' 4. -\tenuto g' -\tenuto r16 b' 2. -\tenuto g' 4 -\tenuto e' 8 -\tenuto r16 d' 8 -\tenuto  |
                e' 4.. -\tenuto r16 a' 4.. r16 b' 2 -\tenuto d'' -\tenuto b' 8 -\tenuto a' 
                % warning: overlong bar truncated here |
                \skip 8 b' 2 -\tenuto r8 a' 4. e' 2.. -\tenuto d' 4 -\tenuto 
                % warning: overlong bar truncated here |
%% 35
                \skip 4 r8 b 1 -\tenuto r8 a 2 -\tenuto r4  |
                e 4. -\tenuto d 2 -\tenuto r16 e 4. g 2 -\tenuto r16 r e 4 
                % warning: bar too short, padding with rests
                % 302400 + 8400 < 311040  &&  35/16 < 9/4
                r16  |
                \skip 8 \skip 16 e 1 -\tenuto r16 r4 b' 2 -\tenuto r4  |
                a' 4 -\tenuto b' 2. d'' -\tenuto r16 b' 4.. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4*2 r16 r8 a' 4.. -\tenuto b' -\tenuto d'' 2 -\tenuto r8 
                % warning: bar too short, padding with rests
                % 328320 + 8400 < 336960  &&  35/16 < 9/4
                r16  |
%% 40
                g'' 2. -\tenuto e'' 1 d'' 4 -\tenuto r8 b' -\tenuto 
                % warning: overlong bar truncated here |
                \skip 4*2 a' 4.. e' 1 d' 4 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 345600 + 8400 < 354240  &&  35/16 < 9/4
                r16  |
                \skip 4 e' 1 -\tenuto d' 4. -\tenuto b -\tenuto a 4 -\tenuto  |
                b 4. e 1. -\tenuto r8 r16 d 8. -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 e 2.. -\tenuto g 1 -\tenuto 
                % warning: overlong bar truncated here |
%% 45
                \skip 4 r16 e 4. -\tenuto g 4.. b 2.. g 8. -\tenuto 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 380160 + 8400 < 388800  &&  35/16 < 9/4
                r16  |
                \skip 16 r16 e 2 -\tenuto r8 r16 d 4 -\tenuto r16 e 2 -\tenuto r8 g 2 -\tenuto  |
                r16 b 4.. -\tenuto d' 1 -\tenuto r16 b 2 -\tenuto r16 r8  |
                a 4 -\tenuto r16 b 2 -\tenuto r16 r8 g 2.. e 4. -\tenuto  |
                d 2 -\tenuto r16 e 1. -\tenuto 
                % warning: overlong bar truncated here |
%% 50
                \skip 4 r16 r8 r4 r2. r 
                % warning: bar too short, padding with rests
                % 423360 + 8400 < 432000  &&  35/16 < 9/4
                r16  |
            } % Voice

            \context Voice = "voice 36" {
                % Segment: Volume fade
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 2.*126 
                \clef "treble"
                r2. r r  |
                r2. r r  |
%% 45
                r2. r r  |
                r2. r r  |
                r2. r r  |
                r2. r r  |
                r2. r r  |
%% 50
                r2. r r  |
                \skip 64  |
                \bar "|."
            } % Voice
        >> % Staff (final) ends

    >> % notes

    \layout {
        indent = 3.0\cm
        short-indent = 1.5\cm
        \context { \Staff \RemoveEmptyStaves }
        \context { \GrandStaff \accepts "Lyrics" }
    }
%     uncomment to enable generating midi file from the lilypond source
%         \midi {
%         } 
} % score
