% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggscatmat.R
\name{scatmat}
\alias{scatmat}
\title{Plots the lowertriangle and density plots of the scatter plot matrix.}
\usage{
scatmat(data, columns = 1:ncol(data), color = NULL, alpha = 1)
}
\arguments{
\item{data}{a data matrix. Should contain numerical (continuous) data.}

\item{columns}{an option to choose the column to be used in the raw dataset. Defaults to \code{1:ncol(data)}}

\item{color}{an option to group the dataset by the factor variable and color them by different colors. Defaults to \code{NULL}}

\item{alpha}{an option to set the transparency in scatterplots for large data. Defaults to \code{1}.}
}
\description{
Function for making scatterplots in the lower triangle and diagonal density plots.
}
\examples{
# small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

data(flea)

p_(scatmat(flea, columns=2:4))
p_(scatmat(flea, columns= 2:4, color="species"))
}
\author{
Mengjia Ni, Di Cook
}
