% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bit.R
\name{length.bit}
\alias{length.bit}
\alias{length<-.bit}
\alias{length.bitwhich}
\alias{length<-.bitwhich}
\alias{length.ri}
\title{Getting and setting length of bit, bitwhich and ri objects}
\usage{
\method{length}{bit}(x)

\method{length}{bit}(x) <- value

\method{length}{bitwhich}(x)

\method{length}{bitwhich}(x) <- value

\method{length}{ri}(x)
}
\arguments{
\item{x}{a \code{\link[=bit]{bit()}}, \code{\link[=bitwhich]{bitwhich()}} or \code{\link[=ri]{ri()}}
object}

\item{value}{the new number of bits}
}
\value{
the length A bit vector with the new length
}
\description{
Query the number of bits in a \code{\link[=bit]{bit()}} vector or change the number
of bits in a bit vector.
Query the number of bits in a bitwhich()] vector or change the number of bits in a bit
vector.
}
\details{
NOTE that the length does NOT reflect the number of selected (\code{TRUE})
bits, it reflects the sum of both, \code{TRUE} and \code{FALSE} bits.
Increasing the length of a \code{\link[=bit]{bit()}} object will set new bits to
\code{FALSE}.  The behaviour of increasing the length of a
\code{\link[=bitwhich]{bitwhich()}} object is different and depends on the content of the
object:
\itemize{
\item TRUE -- all included, new bits are set to \code{TRUE}
\item positive integers -- some included, new bits are set to \code{FALSE}
\item negative integers -- some excluded, new bits are set to \code{TRUE}
\item FALSE -- all excluded:, new bits are set to \code{FALSE}
}

Decreasing the length of bit or bitwhich removes any previous information
about the status bits above the new length.
}
\examples{

  stopifnot(length(ri(1, 1, 32)) == 32)

  x <- as.bit(ri(32, 32, 32))
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 1)
  length(x) <- 16
  stopifnot(length(x) == 16)
  stopifnot(sum(x) == 0)
  length(x) <- 32
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 0)

  x <- as.bit(ri(1, 1, 32))
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 1)
  length(x) <- 16
  stopifnot(length(x) == 16)
  stopifnot(sum(x) == 1)
  length(x) <- 32
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 1)

  x <- as.bitwhich(bit(32))
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 0)
  length(x) <- 16
  stopifnot(length(x) == 16)
  stopifnot(sum(x) == 0)
  length(x) <- 32
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 0)

  x <- as.bitwhich(!bit(32))
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 32)
  length(x) <- 16
  stopifnot(length(x) == 16)
  stopifnot(sum(x) == 16)
  length(x) <- 32
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 32)

  x <- as.bitwhich(ri(32, 32, 32))
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 1)
  length(x) <- 16
  stopifnot(length(x) == 16)
  stopifnot(sum(x) == 0)
  length(x) <- 32
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 0)

  x <- as.bitwhich(ri(2, 32, 32))
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 31)
  length(x) <- 16
  stopifnot(length(x) == 16)
  stopifnot(sum(x) == 15)
  length(x) <- 32
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 31)

  x <- as.bitwhich(ri(1, 1, 32))
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 1)
  length(x) <- 16
  stopifnot(length(x) == 16)
  stopifnot(sum(x) == 1)
  length(x) <- 32
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 1)

  x <- as.bitwhich(ri(1, 31, 32))
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 31)
  message("NOTE the change from 'some excluded' to 'all excluded' here")
  length(x) <- 16
  stopifnot(length(x) == 16)
  stopifnot(sum(x) == 16)
  length(x) <- 32
  stopifnot(length(x) == 32)
  stopifnot(sum(x) == 32)

}
\seealso{
\code{\link[=length]{length()}}, \code{\link[=sum.bit]{sum()}},
\code{\link[=poslength]{poslength()}}, \code{\link[=maxindex]{maxindex()}}
}
\author{
Jens Oehlschlägel
}
\keyword{classes}
\keyword{logic}
