#
# PySNMP MIB module SIP-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/SIP-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:28:05 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, Integer, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "OctetString", "Integer", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ConstraintsIntersection, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ConstraintsIntersection", "ValueSizeConstraint")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ObjectGroup, NotificationGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "NotificationGroup", "ModuleCompliance")
( mib_2, IpAddress, ObjectIdentity, Gauge32, Counter32, Integer32, Unsigned32, Counter64, MibScalar, MibTable, MibTableRow, MibTableColumn, iso, ModuleIdentity, TimeTicks, Bits, NotificationType, MibIdentifier, ) = mibBuilder.importSymbols("SNMPv2-SMI", "mib-2", "IpAddress", "ObjectIdentity", "Gauge32", "Counter32", "Integer32", "Unsigned32", "Counter64", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "iso", "ModuleIdentity", "TimeTicks", "Bits", "NotificationType", "MibIdentifier")
( DisplayString, TextualConvention, TruthValue, RowStatus, TimeStamp, DateAndTime, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TextualConvention", "TruthValue", "RowStatus", "TimeStamp", "DateAndTime")
sipMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 9998))
if mibBuilder.loadTexts: sipMIB.setLastUpdated('200003020000Z')
if mibBuilder.loadTexts: sipMIB.setOrganization('IETF SIP Working Group, SIP MIB Team')
if mibBuilder.loadTexts: sipMIB.setContactInfo('SIP MIB Team email: sip-mib@egroups.com\n\n                 Co-editor  Kevin Lingle\n                            Cisco Systems, Inc.\n                 postal:    7025 Kit Creek Road\n                            P.O. Box 14987\n                            Research Triangle Park, NC 27709\n                            USA\n                 email:     klingle@cisco.com\n                 phone:     +1-919-392-2029\n                 Co-editor  Joon Maeng\n                            VTEL Corporation\n                 postal:    108 Wild Basin Rd.\n                            Austin, TX 78746\n                            USA\n                 email:     joon_maeng@vtel.com\n                 phone:     +1-512-437-4567\n\n                 Co-editor  Dave Walker\n                            SS8 Networks, Inc.\n                 postal:    135 Michael Cowpland Drive, Suite 200\n                            Kanata, ON  K2M 2E9\n                            Canada\n                 email:     drwalker@ss8networks.com\n                 phone:     +1 613 592 2459')
if mibBuilder.loadTexts: sipMIB.setDescription('Initial version of Session Initiation Protocol (SIP)\n                 MIB module.  SIP is an application-layer signalling\n                 protocol for creating, modifying and terminating\n                 multimedia sessions with one or more participants.\n                 These sessions include Internet multimedia conferences\n                 and Internet telephone calls.  SIP is defined in\n                 RFC 2543 (March 1999).\n\n                 This MIB is defined for the management of SIP User\n                 Agents (UAs), Proxy and Redirect Servers, and\n                 registrars.\n\n                 A User Agent is an application that contains both a\n                 User Agent Client (UAC) and a User Agent Server (UAS).\n                 A UAC is an application that initiates a SIP request.\n                 A UAS is an application that contacts the user when a\n                 SIP request is received and that returns a response on\n                 behalf of the user.  The response accepts, rejects, or\n                 redirects the request.\n\n                 A Proxy Server acts as both a client and a server.\n                 It accepts requests from other clients, either\n                 responding to them or passing them on to other\n                 servers, possibly after modification.\n\n                 A Redirect Server accepts requests from clients and\n                 returns zero or more addresses to that client. Unlike\n                 a Proxy server it does not initiate requests.  Unlike\n                 a User Agent Server it does not accept calls.\n\n                 A Registrar is a server that accepts REGISTER\n                 requests.  A Registrar is typically co-located with a\n                 Proxy or Redirect Server.\n\n                 A SIP transaction occurs between a client and a server\n                 and comprises all messages from the first request sent\n                 from the client to the server up to a final (non-1xx)\n                 response sent from the server to the client.')
sipMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1))
sipCommon = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 1))
sipUA = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 2))
sipServer = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 3))
sipProxy = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 4))
sipRedir = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 5))
sipReg = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 6))
class SipServerActions(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2,))
    namedValues = NamedValues(("redirect", 1), ("proxy", 2),)

sipCommonCfg = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1))
sipCommonStats = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2))
sipCommonStatsSummary = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 1))
sipCommonStatsMethod = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2))
sipCommonStatsInfo = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 3))
sipCommonStatsSuccess = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 4))
sipCommonStatsRedirect = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 5))
sipCommonStatsErrClient = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6))
sipCommonStatsErrServer = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 7))
sipCommonStatsGlobalFail = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 8))
sipCommonStatsTrans = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9))
sipProtocolVersion = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 1), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipProtocolVersion.setDescription("This object will reflect the version of SIP supported by\n             this user agent.  It will follow the same format as SIP\n             version information contained in the SIP messages\n             generated by this SIP entity.  For example, entities\n             supporting SIP version 2 will return 'SIP/2.0' as dictated\n             by RFC 2543.")
sipServiceOperStatus = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6,))).clone(namedValues=NamedValues(("up", 1), ("down", 2), ("testing", 3), ("unknown", 4), ("halted", 5), ("restarting", 6),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipServiceOperStatus.setDescription('This object contains the current operational state of the\n             SIP application.\n\n             up(1)         : The application is operating normally, and\n                             is processing (receiving and possibly\n                             issuing) SIP requests and responses.\n             down(2)       : The application is currently unable to\n                             process SIP messages.\n             testing(3)    : The application is currently in test mode\n                             and unable to process SIP messages.\n             unknown(4)    : The operational status of the application\n                             cannot be determined for some reason.\n             halted(5)     : The application has been manually\n                             prevented from processing SIP messages.\n             restarting(6) : The application is booting and will soon\n                             be able to process SIP messages.')
sipServiceAdminStatus = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("shutdown", 1), ("reset", 2), ("restart", 3), ("stop", 4), ("rts", 5),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipServiceAdminStatus.setDescription("This object is used to affect the overall operational\n             state of the SIP server application.\n\n             shutdown(1) : Immediately kill the application, don't\n                           restart.\n             reset(2)    : Restart application, reinitialize data,\n                           requires rts.\n             restart(3)  : Restart application, no data loss, requires\n                           rts.\n             stop(4)     : Stop processing new requests, requires rts.\n             rts(5)      : Return to service.")
sipServiceStartTime = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipServiceStartTime.setDescription('The value of sysUpTime at the time the SIP entity was last\n             started. If the current state was entered prior to the\n             last re-initialization of the local network management\n             subsystem, then this object contains a zero value.')
sipServiceLastChange = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 5), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipServiceLastChange.setDescription('The value of sysUpTime at the time the SIP entity entered\n             its current operational state.  If the current state was\n             entered prior to the last re-initialization of the local\n             network management subsystem, then this object contains a\n             zero value.')
sipPortTable = MibTable((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 6), )
if mibBuilder.loadTexts: sipPortTable.setDescription('This table contains the list of ports that this SIP entity\n             is allowed to use.  These ports can be advertised using\n             the Contact header in a REGISTER request or response.\n             Port 5060 (the default SIP port registered with IANA) must\n             always be present in this table.')
sipPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 6, 1), ).setIndexNames((0, "SIP-MIB", "sipPort"))
if mibBuilder.loadTexts: sipPortEntry.setDescription('Specification of a particular port.')
sipPort = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 6, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)))
if mibBuilder.loadTexts: sipPort.setDescription('This object reflects a particular port that can be used by\n             the SIP application.')
sipTransport = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 6, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("udp", 1), ("tcp", 2), ("udpAndTcp", 3),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sipTransport.setDescription('This object will specify the transport protocol the SIP\n             application will use to receive SIP messages.\n\n             udp(1)       : Use User Datagram Protocol.\n             tcp(2)       : Use Transmission Control Protocol.\n             udpAndTcp(3) : Use both UDP and TCP.')
sipPortStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 6, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sipPortStatus.setDescription('The row status of the entry. This object is required to\n             create or delete rows remotely by a manager.  The row\n             associated with port 5060 need not be created and cannot\n             be deleted.  It is always present in the table.')
sipUriSupportedTable = MibTable((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 7), )
if mibBuilder.loadTexts: sipUriSupportedTable.setDescription('This table contains a list of URIs supported by the SIP\n             entity. These are in addition to the SIP URL which must\n             necessarily be supported.  Normally the list of URIs\n             supported by an entity is static (i.e. will not change\n             over time).\n\n             A URI is a Uniform Resource Identifier (as defined in RFC\n             2396).\n\n             URIs could, for example, contain URLs for phones, fax, or\n             irc if they were defined) or a mailto: (RFC 2368) URL.')
sipUriSupportedEntry = MibTableRow((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 7, 1), ).setIndexNames((0, "SIP-MIB", "sipUriSupportedIndex"))
if mibBuilder.loadTexts: sipUriSupportedEntry.setDescription('A particular non-SIP URI supported by the SIP entity.')
sipUriSupportedIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 7, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: sipUriSupportedIndex.setDescription('This object uniquely identifies a conceptual row\n             in the table.')
sipUriSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 7, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipUriSupported.setDescription("This object indicates a particular non-SIP URI supported\n             by the SIP entity.  Only the scheme itself (as described\n             in RFC 2396) is indicated.  For example, if the mailto:\n             URLs are supported,then the table entry contains 'mailto'\n             without the colon.")
sipFtrSupportedTable = MibTable((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 8), )
if mibBuilder.loadTexts: sipFtrSupportedTable.setDescription("This table contains a list of the non-standard features\n             supported by the SIP entity, and which may be required by\n             a peer. Definition of such features is outside the scope\n             of SIP, which only provides mechanisms whereby support for\n             specific features may be signalled or requested.\n\n             For example, a user agent client may require that a server\n             support the 'com.example.billing' feature, which it would\n             indicate in a Require header.  Such a client would have\n             a row in its sipFtrSupportedTable containing the string\n             'com.example.billing'.  Similarly, a server which is\n             capable of handling requests for such features would list\n             the string in its sipFtrSupportedTable.\n\n             If a server does not support the required feature\n             (indicated in a Require header to a UAS, or in a Proxy-\n             Require to a proxy server), the server returns a 420 Bad\n             Extension listing the feature in an Unsupported header.\n\n             Normally the list of such features supported by an entity\n             is static (i.e. will not change over time).")
sipFtrSupportedEntry = MibTableRow((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 8, 1), ).setIndexNames((0, "SIP-MIB", "sipFtrSupportedIndex"))
if mibBuilder.loadTexts: sipFtrSupportedEntry.setDescription('A particular non-standard feature supported by the SIP\n             entity, and which may be required by a peer.')
sipFtrSupportedIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 8, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: sipFtrSupportedIndex.setDescription('This object uniquely identifies a conceptual row in the\n             table.')
sipFtrSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 8, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipFtrSupported.setDescription('This object indicates a particular non-standard feature\n             which is supported by the SIP entity.')
sipOrganization = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 9), SnmpAdminString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipOrganization.setDescription('This object contains the name of the organization issuing\n             the request or response.  It may also be inserted by a\n             proxy at a boundary of an organization.  If the object\n             exists, it is inserted into requests and responses.')
sipMaxTransactions = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipMaxTransactions.setDescription('This object indicates the maximum number of simultaneous\n             transactions that the SIP entity can manage.')
sipRequestDfltExpires = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 11), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipRequestDfltExpires.setDescription('This object specifies the default duration that a SIP\n             client will wait for a response to an INVITE request.\n\n             For proxy servers, if a received request contained an\n             Expires header, then the value in the header takes\n             precedence.  The server returns a 408 Request Timeout if\n             no response is received before\n             expiration of the request timer.\n\n             For user agent clients, this value is inserted into the\n             Expires header.')
sipHideOperation = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 12), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("none", 1), ("hop", 2), ("route", 3),)).clone('none')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipHideOperation.setDescription("This object specifies which type of Hide header the server\n             adds to requests.  These headers are normally added by a\n             User Agent, but may be added by a proxy.  The value of\n             this object does not affect processing of Hide headers in\n             received requests.\n\n             The value of this object only applies to requests that do\n             not contain a Hide:route header.\n\n             none(1)  : The server doesn't insert a Hide header.\n             hop(2)   : The server inserts a Hide:hop header.\n             route(3) : The server inserts a Hide:route header.")
sipUserLocationServerAddr = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 1, 13), SnmpAdminString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipUserLocationServerAddr.setDescription('This object will specify the address of the User Location\n             Server (ULS) being used to resolve the location of end\n             points.\n\n             This could be a Domain Name Server (DNS) or a SIP\n             proxy/redirect server in the case where this entity is a\n             user agent. This could be some sort of database server if\n             this entity is a proxy/redirect server.\n\n             The format of the address follows the IETF service\n             location protocol. The syntax is as follows:\n\n                mapping-type:type-specific-syntax\n\n             The mapping-type specifies a scheme for mapping the\n             matching dial  string to a target server. The type-\n             specific-syntax is exactly that, something that the\n             particular mapping scheme can understand.\n             For example,\n                Session target           Meaning\n                ipv4:171.68.13.55:1006   The session target is the IP\n                                         version 4 address of\n                                         171.68.13.55 and port 1006.\n                dns:pots.cisco.com       The session target is the IP\n                                         host with dns name\n                                         pots.cisco.com.\n\n             The valid Mapping type definitions for the peer are as\n             follows:\n                ipv4  - Syntax: ipv4:w.x.y.z:port or  ipv4:w.x.y.z\n                dns   - Syntax: dns:host.domain.')
sipSummaryInRequests = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipSummaryInRequests.setDescription('This object indicates the total number of SIP request\n             messages received by the SIP entity.')
sipSummaryOutRequests = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipSummaryOutRequests.setDescription('This object contains the total number of SIP request\n             messages sent out (originated and relayed) by the SIP\n             entity.  Where a particular message is sent more than\n             once, for example as a retransmission, or as a result of\n             forking, each transmission is counted separately.')
sipSummaryInResponses = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipSummaryInResponses.setDescription('This object contains the total number of SIP response\n             messages received by the SIP entity.')
sipSummaryOutResponses = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipSummaryOutResponses.setDescription('This object contains the total number of SIP response\n             messages sent (originated and relayed) by the SIP entity.')
sipSummaryTotalTransactions = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipSummaryTotalTransactions.setDescription('This object contains a count of the number of transactions\n             completed or in progress.\n\n             A SIP transaction occurs between a client and a server and\n             comprises all messages from the first request sent from\n             the client to the server up to a final (non-1xx) response\n             sent from the server to the client.\n\n             A transaction is identified by the CSeq sequence number\n             within a single call leg.  The ACK request has the same\n             CSeq number as the corresponding INVITE request, but\n             comprises a transaction of its own.\n\n             In the case of a forked request, all branches count as a\n             single transaction.')
sipStatsInviteIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInviteIns.setDescription('This object reflects the total number of INVITE requests\n             received by the SIP entity.')
sipStatsInviteOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInviteOuts.setDescription('This object reflects the total number of INVITE requests\n             sent by the SIP entity.')
sipStatsAckIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsAckIns.setDescription('This object reflects the total number of ACK requests\n             received by the SIP entity.')
sipStatsAckOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsAckOuts.setDescription('This object reflects the total number of ACK requests sent\n             by the SIP entity.')
sipStatsByeIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsByeIns.setDescription('This object reflects the total number of BYE requests\n             received by the SIP entity.')
sipStatsByeOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsByeOuts.setDescription('This object reflects the total number of BYE requests sent\n             by the SIP entity.')
sipStatsCancelIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsCancelIns.setDescription('This object reflects the total number of CANCEL requests\n             received by the SIP entity.')
sipStatsCancelOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsCancelOuts.setDescription('This object reflects the total number of CANCEL requests\n             sent by the SIP entity.')
sipStatsOptionsIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsOptionsIns.setDescription('This object reflects the total number of OPTIONS requests\n             received by the SIP entity.')
sipStatsOptionsOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsOptionsOuts.setDescription('This object reflects the total number of OPTIONS requests\n             sent by the SIP entity.')
sipStatsRegisterIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRegisterIns.setDescription('This object reflects the total number of REGISTER requests\n             received by the SIP entity.')
sipStatsRegisterOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRegisterOuts.setDescription('This object reflects the total number of REGISTER requests\n             sent by the SIP entity.')
sipStatsInfoIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInfoIns.setDescription('This object reflects the total number of INFO requests\n             received by the SIP entity.')
sipStatsInfoOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 2, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInfoOuts.setDescription('This object reflects the total number of INFO requests\n             sent by the SIP entity.')
sipStatsInfoTryingIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 3, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInfoTryingIns.setDescription('This object reflects the total number of Trying\n             (100) responses received by the SIP entity.\n             Trying responses indicate that some unspecified\n             action is being taken on behalf of this call, but\n             the user has not yet been located.  Inbound Trying\n             responses indicate that outbound INVITE requests\n             sent out by this system have been received and\n             are processed.')
sipStatsInfoTryingOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 3, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInfoTryingOuts.setDescription('This object reflects the total number of Trying\n             (100) responses sent by the SIP entity.\n             Trying responses indicate that some unspecified\n             action is being taken on behalf of this call, but\n             the user has not yet been located.  Outbound Trying\n             responses indicate that this system is successfully\n             receiving INVITE requests and processing them on\n             behalf of the system initiating the INVITE.')
sipStatsInfoRingingIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 3, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInfoRingingIns.setDescription('This object reflects the total number of Ringing\n             (180) responses received by the SIP entity.\n             A inbound Ringing response indicates that the UAS that is\n             processing an INVITE initiated by this system has\n             found a possible location where the desired end user\n             has registered recently and is trying to alert the user.')
sipStatsInfoRingingOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 3, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInfoRingingOuts.setDescription('This object reflects the total number of Ringing\n             (180) responses sent by the SIP entity.\n             A outbound Ringing response indicates that this\n             system has processed an INVITE for a particular\n             end user and found a possible location where that\n             user has registered recently.  The system is trying\n             to alert the end user and is conveying that status\n             to the system that originated the INVITE.')
sipStatsInfoForwardedIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 3, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInfoForwardedIns.setDescription('This object reflects the total number of Call Is Being\n             Forwarded (181) responses received by the SIP entity.\n             A proxy server might use a Forwarded status code to\n             indicate that the call is being forwarded to a different\n             set of destinations.  Inbound Forwarded responses indicate\n             to this system that forwarding actions are taking place\n             with regard to calls initiated by this system.')
sipStatsInfoForwardedOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 3, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInfoForwardedOuts.setDescription('This object reflects the total number of Call Is Being\n             Forwarded (181) responses sent by the SIP entity.\n             A proxy server might use a Forwarded status code to\n             indicate that the call is being forwarded to a different\n             set of destinations.  Outbound Forwarded responses\n             indicate this system is taking some forwarding action\n             for calls and conveying that status to the system that\n             initiated the calls.')
sipStatsInfoQueuedIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 3, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInfoQueuedIns.setDescription('This object reflects the total number of Queued\n             (182) responses received by the SIP entity.\n             Inbound Queued responses indicate that the users that\n             this system is attempting to call are temporarily\n             unavailable but the SIP agents operating on behalf\n             of those users wish to queue the calls rather than\n             reject them.  When the called parties become available,\n             this system can expect to receive the appropriate\n             final status response.  The Reason-Phrase from the\n             Queued response messages Status-Line can give further\n             details about the status of the call.  Multiple\n             Queued responses to update this system about the status\n             of the queued call might be received.')
sipStatsInfoQueuedOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 3, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInfoQueuedOuts.setDescription('This object reflects the total number of Queued\n             (182) responses sent by the SIP entity.\n             Outbound Queued responses indicate that this system\n             has determined that the called party is temporarily\n             unavailable but the call is not rejected.  Instead,\n             the call is queued until the called party becomes\n             available.  Queued responses messages are sent to\n             the system originating the call request to convey\n             the current status of a queued call.')
sipStatsInfoSessionProgIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 3, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInfoSessionProgIns.setDescription('This object reflects the total number of Session\n             Progress (183) responses received by the SIP entity.')
sipStatsInfoSessionProgOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 3, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsInfoSessionProgOuts.setDescription('This object reflects the total number of Session\n             Progress (183) responses sent by the SIP entity.')
sipStatsSuccessOkIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 4, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsSuccessOkIns.setDescription('This object reflects the total number of Ok\n             (200) responses received by the SIP entity.\n             The meaning of inbound Ok responses depends\n             on the method used in the associated request.\n\n             BYE      : The Ok response means the call has\n                        been terminated.\n\n             CANCEL   : The Ok response means the search for\n                        the end user has been cancelled.\n\n             INVITE   : The Ok response means the called party\n                        has agreed to participate in the call.\n\n             OPTIONS  : The Ok response means the called party\n                        has agreed to share its capabilities.\n\n             REGISTER : The Ok response means the registration\n                        has succeeded.\n\n             INFO     : The Ok response means the INFO request\n                        was received and processed correctly.')
sipStatsSuccessOkOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 4, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsSuccessOkOuts.setDescription('This object reflects the total number of Ok\n             (200) responses sent by the SIP entity.\n             The meaning of outbound Ok responses depends\n             on the method used in the associated request.\n\n             BYE      : The Ok response means the call has\n                        been terminated.\n\n             CANCEL   : The Ok response means the search for\n                        the end user has been cancelled.\n\n             INVITE   : The Ok response means the called party\n                        has agreed to participate in the call.\n\n             OPTIONS  : The Ok response means the called party\n                        has agreed to share its capabilities.\n\n             REGISTER : The Ok response means the registration\n                        has succeeded.\n\n             INFO     : The Ok response means the INFO request\n                        was received and processed correctly.')
sipStatsRedirMultipleChoiceIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 5, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRedirMultipleChoiceIns.setDescription('This object reflects the total number of Multiple\n             Choices (300) responses received by the SIP entity.\n             Multiple Choices responses indicate that the called\n             party can be reached at several different locations\n             and the server cannot or prefers not to proxy the\n             request.')
sipStatsRedirMultipleChoiceOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 5, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRedirMultipleChoiceOuts.setDescription('This object reflects the total number of Multiple\n             Choices (300) responses sent by the SIP entity.\n             Multiple Choices responses indicate that the called\n             party can be reached at several different locations\n             and the server cannot or prefers not to proxy the\n             request.')
sipStatsRedirMovedPermIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 5, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRedirMovedPermIns.setDescription('This object reflects the total number of Moved\n             Permanently (301) responses received by the SIP entity.\n             Moved Permanently responses indicate that the called party\n             can no longer be found at the address offered in the\n             request and the requesting UAC should retry at the new\n             address given by the Contact header field of the\n             response.')
sipStatsRedirMovedPermOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 5, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRedirMovedPermOuts.setDescription('This object reflects the total number of Moved\n             Permanently (301) responses sent by the SIP entity.\n             Moved Permanently responses indicate that the called party\n             can no longer be found at the address offered in the\n             request and the requesting UAC should retry at the new\n             address given by the Contact header field of the\n             response.')
sipStatsRedirMovedTempIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 5, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRedirMovedTempIns.setDescription('This object reflects the total number of Moved\n             Temporarily (302) responses received by the SIP entity.\n             Moved Temporarily responses indicate the UAC should\n             retry the request directed at the new address(es)\n             given by the Contact header field of the response.\n             The duration of this redirection can be indicated\n             through the Expires header.  If no explicit expiration\n             time is given, the new address(es) are only valid\n             for this call.')
sipStatsRedirMovedTempOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 5, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRedirMovedTempOuts.setDescription('This object reflects the total number of Moved\n             Temporarily (302) responses sent by the SIP entity.\n             Moved Temporarily responses indicate the UAC should\n             retry the request directed at the new address(es)\n             given by the Contact header field of the response.\n             The duration of this redirection can be indicated\n             through the Expires header.  If no explicit expiration\n             time is given, the new address(es) are only valid\n             for this call.')
sipStatsRedirSeeOtherIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 5, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRedirSeeOtherIns.setDescription('This object reflects the total number of See Other\n             (303) responses received by the SIP entity.')
sipStatsRedirSeeOtherOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 5, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRedirSeeOtherOuts.setDescription('This object reflects the total number of See Other\n             (303) responses sent by the SIP entity.')
sipStatsRedirUseProxyIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 5, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRedirUseProxyIns.setDescription('This object reflects the total number of Use Proxy\n             (305) responses received by the SIP entity.\n             Use Proxy responses indicate that requested resources\n             must be accessed through the proxy given by the\n             Contact header field of the response.  The recipient\n             of this response is expected to repeat this single\n             request via the proxy.')
sipStatsRedirUseProxyOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 5, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRedirUseProxyOuts.setDescription('This object reflects the total number of Use Proxy\n             (305) responses sent by the SIP entity.\n             See Other responses indicate that requested resources\n             must be accessed through the proxy given by the\n             Contact header field of the response.  The recipient\n             of this response is expected to repeat this single\n             request via the proxy.')
sipStatsRedirAltServiceIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 5, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRedirAltServiceIns.setDescription('This object reflects the total number of Alternative\n             Service (380) responses received by the SIP entity.\n             Alternative Service responses indicate that the call\n             was not successful, but alternative services are\n             possible.  Those alternative services are described\n             in the message body of the response.')
sipStatsRedirAltServiceOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 5, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRedirAltServiceOuts.setDescription('This object reflects the total number of Alternative\n             Service (380) responses sent by the SIP entity.\n             Alternative Service responses indicate that the call\n             was not successful, but alternative services are\n             possible.  Those alternative services are described\n             in the message body of the response.')
sipStatsClientBadRequestIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientBadRequestIns.setDescription('This object reflects the total number of Bad Request (400)\n             responses received by the SIP entity. Inbound Bad Request\n             responses indicate that requests issued by this system\n             could not be understood due to malformed syntax.')
sipStatsClientBadRequestOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientBadRequestOuts.setDescription('This object reflects the total number of Bad Request (400)\n             responses sent by the SIP entity.  Outbound Bad Request\n             responses indicate that requests received by this system\n             could not be understood due to malformed syntax.')
sipStatsClientUnauthorizedIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientUnauthorizedIns.setDescription('This object reflects the total number of Unauthorized\n             (401) responses received by the SIP entity. Inbound\n             Unauthorized responses indicate that requests issued by\n             this system require user authentication.')
sipStatsClientUnauthorizedOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientUnauthorizedOuts.setDescription('This object reflects the total number of Unathorized (401)\n             responses sent by the SIP entity.\n             Outbound Unauthorized responses indicate that requests\n             received by this system require user authentication.')
sipStatsClientPaymentReqdIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientPaymentReqdIns.setDescription('This object reflects the total number of Payment Required\n             (402) responses received by the SIP entity.')
sipStatsClientPaymentReqdOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientPaymentReqdOuts.setDescription('This object reflects the total number of Payment Required\n             (402) responses sent by the SIP entity.')
sipStatsClientForbiddenIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientForbiddenIns.setDescription('This object reflects the total number of Forbidden (403)\n             responses received by the SIP entity.  Inbound Forbidden\n             responses indicate that requests issued by this system are\n             understood by the server but the server refuses to fulfill\n             the request.  Authorization will not help and the requests\n             should not be repeated.')
sipStatsClientForbiddenOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientForbiddenOuts.setDescription('This object reflects the total number of Forbidden (403)\n             responses sent by the SIP entity. Outbound Forbidden\n             responses indicate that requests received by this system\n             are understood but this system is refusing to\n             fulfill the requests.')
sipStatsClientNotFoundIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientNotFoundIns.setDescription('This object reflects the total number of Not Found (404)\n             responses received by the SIP entity.\n             Inbound Not Found responses indicate that the called party\n             does not exist at the domain specified in the Request-URI\n             or the domain is not handled by the recipient of the\n             request.')
sipStatsClientNotFoundOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientNotFoundOuts.setDescription('This object reflects the total number of Not Found (404)\n             responses sent by the SIP entity.\n             Outbound Not Found responses indicate that this system\n             knows that the called party does not exist at the domain\n             specified in the Request-URI or the domain is not handled\n             by this system.')
sipStatsClientMethNotAllowedIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientMethNotAllowedIns.setDescription('This object reflects the total number of Method Not\n             Allowed (405) responses received by the SIP entity.\n             Inbound Method Not Allowed responses indicate that\n             requests issued by this system have specified a SIP method\n             in the Request-Line that is not allowed for the address\n             identified by the Request-URI.')
sipStatsClientMethNotAllowedOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientMethNotAllowedOuts.setDescription('This object reflects the total number of Method Not\n             Allowed (405) responses sent by the SIP entity.\n             Outbound Method Not Allowed responses indicate that\n             requests received by this system have SIP methods\n             specified in the Request-Line that are not allowed for the\n             address identified by the Request-URI.')
sipStatsClientNotAcceptableIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientNotAcceptableIns.setDescription('This object reflects the total number of Not Acceptable\n             (406) responses received by the SIP entity.\n             Inbound Not Acceptable responses indicate that the\n             resources identified by requests issued by this system\n             cannot generate responses with content characteristics\n             acceptable to this system according to the accept headers\n             sent in the requests.')
sipStatsClientNotAcceptableOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientNotAcceptableOuts.setDescription('This object reflects the total number of Not Acceptable\n             (406) responses sent by the SIP entity.\n             Outbound Not Acceptable responses indicate that the\n             resources identified by requests received by this system\n             cannot generate responses with content characteristics\n             acceptable to the system sending the requests.')
sipStatsClientProxyAuthReqdIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientProxyAuthReqdIns.setDescription('This object reflects the total number of Proxy\n             Authentication Required (407) responses received by the\n             SIP entity.\n             Inbound Proxy Authentication Required responses indicate\n             that this system must authenticate itself with the proxy\n             before gaining access to the requested resource.')
sipStatsClientProxyAuthReqdOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientProxyAuthReqdOuts.setDescription('This object reflects the total number of Proxy\n             Authenticaion Required (407) responses sent by the SIP\n             entity.\n             Outbound Proxy Authentication Required responses indicate\n             that the systems issuing requests being processed by this\n             system must authenticate themselves with this system\n             before gaining access to requested resources.')
sipStatsClientReqTimeoutIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientReqTimeoutIns.setDescription('This object reflects the total number of Request Timeout\n             (408) responses received by the SIP entity.\n             Inbound Request Timeout responses indicate that requests\n             issued by this system are not being processed by the\n             server within the time indicated in the Expires header of\n             the request.')
sipStatsClientReqTimeoutOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientReqTimeoutOuts.setDescription('This object reflects the total number of Request Timeout\n             (408) responses sent by the SIP entity.\n             Outbound Request Timeout responses indicate that this\n             system is not able to produce an appropriate response\n             within the time indicated in the Expires header of the\n             request.')
sipStatsClientConflictIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientConflictIns.setDescription('This object reflects the total number of Conflict (409)\n             responses received by the SIP entity.\n             Inbound Conflict responses indicate that requests issued\n             by this system could not be completed due to a conflict\n             with the current state of a requested resource.')
sipStatsClientConflictOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientConflictOuts.setDescription('This object reflects the total number of Conflict (409)\n             responses sent by the SIP entity.\n             Outbound Conflict responses indicate that requests\n             received by this system could not be completed due to a\n             conflict with the current state of a requested resource.')
sipStatsClientGoneIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientGoneIns.setDescription('This object reflects the total number of Gone (410)\n             responses received by the SIP entity.\n             Inbound Gone responses indicate that resources requested\n             by this system are no longer available at the recipient\n             server and no forwarding address is known.')
sipStatsClientGoneOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientGoneOuts.setDescription('This object reflects the total number of Gone (410)\n             responses sent by the SIP entity.\n             Outbound Gone responses indicate that the requested\n             resources are no longer available at this system and\n             no forwarding address is known.')
sipStatsClientLengthRequiredIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientLengthRequiredIns.setDescription('This object reflects the total number of Length Required\n             (411) responses received by the SIP entity.\n             Inbound Length Required responses indicate that requests\n             issued by this system are being refused by servers because\n             of no defined Content-Length header field.')
sipStatsClientLengthRequiredOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientLengthRequiredOuts.setDescription('This object reflects the total number of Length Required\n             (411) responses sent by the SIP entity.\n             Outbound Length Required responses indicate that requests\n             received by this system are being refused because of no\n             defined Content-Length header field.')
sipStatsClientReqEntTooLargeIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientReqEntTooLargeIns.setDescription('This object reflects the total number of Request Entity\n             Too Large 413) responses received by the SIP entity.\n             Inbound Request Entity Too Large responses indicate that\n             requests issued by this system are being refused because\n             the request is larger than the server is willing or able\n             to process.')
sipStatsClientReqEntTooLargeOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientReqEntTooLargeOuts.setDescription('This object reflects the total number of Request Entity\n             Too Large (413) responses sent by the SIP entity.\n             Outbound Request Entity Too Large responses indicate that\n             requests received by this system are larger than this\n             system is willing or able to process.')
sipStatsClientReqURITooLargeIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientReqURITooLargeIns.setDescription('This object reflects the total number of Request-URI Too\n             Large (414) responses received by the SIP entity.\n             Inbound Request-URI Too Large responses indicate that\n             requests issued by this system are being refused because\n             the Request-URI is longer than the server is willing or\n             able to interpret.')
sipStatsClientReqURITooLargeOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientReqURITooLargeOuts.setDescription('This object reflects the total number of Request-URI Too\n             Large (414) responses sent by the SIP entity.\n             Outbound Request-URI Too Large responses indicate that\n             Request-URIs received by this system are longer than this\n             system is willing or able to interpret.')
sipStatsClientNoSupMediaTypeIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientNoSupMediaTypeIns.setDescription('This object reflects the total number of Unsupported Media\n             Type (415) responses received by the SIP entity.\n             Inbound Unsupported Media Type responses indicate that\n             requests issued by this system are being refused because\n             the message body of the request is in a format not\n             supported by the requested resource for the requested\n             method.')
sipStatsClientNoSupMediaTypeOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientNoSupMediaTypeOuts.setDescription('This object reflects the total number of Unsupported Media\n             Type (415) responses sent by the SIP entity.\n             Outbound Unsupported Media Type responses indicate that\n             the body of requests received by this system are in a\n             format not supported by the requested resource for the\n             requested method.')
sipStatsClientBadExtensionIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 31), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientBadExtensionIns.setDescription('This object reflects the total number of Bad Extension\n             (420) responses received by the SIP entity.\n             Inbound Bad Extension responses indicate that the\n             recipient did not understand the protocol extension\n             specified in a Require header field.')
sipStatsClientBadExtensionOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientBadExtensionOuts.setDescription('This object reflects the total number of Bad Extension\n             (420) responses sent by the SIP entity.\n             Outbound Bad Extension responses indicate that this system\n             did not understand the protocol extension specified in a\n             Require header field of requests.')
sipStatsClientTempNotAvailIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 33), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientTempNotAvailIns.setDescription('This object reflects the total number of Temporarily Not\n             Available 480) responses received by the SIP entity.\n             Inbound Temporarily Not Available responses indicate that\n             the called party is currently unavailable.')
sipStatsClientTempNotAvailOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 34), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientTempNotAvailOuts.setDescription("This object reflects the total number of Temporarily Not\n             Available (480) responses sent by the SIP entity.\n             Outbound Temporarily Not Available responses indicate that\n             the called party's end system was contacted successfully\n             but the called party is currently unavailable.")
sipStatsClientCallLegNoExistIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 35), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientCallLegNoExistIns.setDescription('This object reflects the total number of Call\n             Leg/Transaction Does Not Exist (481) responses received by\n             the SIP entity.\n             Inbound Call Leg/Transaction Does Not Exist responses\n             indicate that either BYE or CANCEL requests issued by this\n             system were received by a server and no matching call leg\n             or transaction existed.')
sipStatsClientCallLegNoExistOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 36), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientCallLegNoExistOuts.setDescription('This object reflects the total number of Call\n             Leg/Transaction Does Not Exist (481) responses sent by the\n             SIP entity.\n             Outbound Call Leg/Transaction Does Not Exist responses\n             indicate that BYE or CANCEL requests have been received by\n             this system and no call leg or transaction matching that\n             request exists.')
sipStatsClientLoopDetectedIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 37), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientLoopDetectedIns.setDescription('This object reflects the total number of Loop Detected\n             (482) responses received by the SIP entity.\n             Inbound Loop Detected responses indicate that requests\n             issued by this system were received at servers and the\n             server found itself in the Via path more than once.')
sipStatsClientLoopDetectedOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 38), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientLoopDetectedOuts.setDescription('This object reflects the total number of Loop Detected\n             (482) responses sent by the SIP entity.\n             Outbound Loop Detected responses indicate that requests\n             received by this system contain a Via path with this\n             system appearing more than once.')
sipStatsClientTooManyHopsIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 39), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientTooManyHopsIns.setDescription('This object reflects the total number of Too Many Hops\n             (483) responses received by the SIP entity.\n             Inbound Too Many Hops responses indicate that requests\n             issued by this system contain more Via entries (hops) than\n             allowed by the Max-Forwards header field of the requests.')
sipStatsClientTooManyHopsOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 40), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientTooManyHopsOuts.setDescription('This object reflects the total number of Too Many Hops\n             (483) responses sent by the SIP entity.\n             Outbound Too Many Hops responses indicate that requests\n             received by this system contain more Via entries (hops)\n             than are allowed by the Max-Forwards header field of the\n             requests.')
sipStatsClientAddrIncompleteIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 41), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientAddrIncompleteIns.setDescription('This object reflects the total number of Address\n             Incomplete (484) responses received by the SIP entity.\n             Inbound Address Incomplete responses indicate that\n             requests issued by this system had To addresses or\n             Request-URIs that were incomplete.')
sipStatsClientAddrIncompleteOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 42), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientAddrIncompleteOuts.setDescription('This object reflects the total number of Address\n             Incomplete (484) responses sent by the SIP entity.\n             Outbound Address Incomplete responses indicate that\n             requests received by this system had To addresses or\n             Request-URIs that were incomplete.')
sipStatsClientAmbiguousIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 43), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientAmbiguousIns.setDescription('This object reflects the total number of Ambiguous (485)\n             responses received by the SIP entity.\n             Inbound Ambiguous responses indicate that requests issued\n             by this system provided ambiguous address information.')
sipStatsClientAmbiguousOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 44), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientAmbiguousOuts.setDescription('This object reflects the total number of Ambiguous (485)\n             responses sent by the SIP entity.\n             Outbound Ambiguous responses indicate that requests\n             received by this system contained ambiguous address\n             information.')
sipStatsClientBusyHereIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 45), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientBusyHereIns.setDescription('This object reflects the total number of Busy Here (486)\n             responses received by the SIP entity.\n             Inbound Busy Here responses indicate that the\n             called party is currently not willing or not able to\n             take additional calls.')
sipStatsClientBusyHereOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 6, 46), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsClientBusyHereOuts.setDescription("This object reflects the total number of Busy Here (486)\n             responses sent by the SIP entity.\n             Outbound Busy Here responses indicate that the\n             called party's end system was contacted successfully but\n             the called party is currently not willing or able to take\n             additional calls.")
sipStatsServerIntErrorIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 7, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsServerIntErrorIns.setDescription('This object reflects the total number of Internal Server\n             Error (500) responses received by the SIP entity.\n             Inbound Internal Server Error responses indicate that\n             servers to which this system is sending requests have\n             encountered unexpected conditions that prevent them from\n             fulfilling the requests.')
sipStatsServerIntErrorOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 7, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsServerIntErrorOuts.setDescription('This object reflects the total number of Internal Server\n             Error (500) responses sent by the SIP entity.\n             Outbound Internal Server Error responses indicate that\n             this system has encountered unexpected conditions that\n             prevent it from fulfilling received requests.')
sipStatsServerNotImplementedIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 7, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsServerNotImplementedIns.setDescription('This object reflects the total number of Not Implemented\n             (501) responses received by the SIP entity.\n             Inbound Not Implemented responses indicate that servers to\n             which this system is sending requests do not support the\n             functionality required to fulfill the requests.')
sipStatsServerNotImplementedOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 7, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsServerNotImplementedOuts.setDescription('This object reflects the total number of Not Implemented\n             (501) responses sent by the SIP entity.\n             Outbound Not Implemented responses indicate that this\n             system does not support the functionality required to\n             fulfill the requests.')
sipStatsServerBadGatewayIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 7, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsServerBadGatewayIns.setDescription('This object reflects the total number of Bad Gateway (502)\n             responses received by the SIP entity.')
sipStatsServerBadGatewayOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 7, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsServerBadGatewayOuts.setDescription('This object reflects the total number of Bad Gateway (502)\n             responses sent by the SIP entity.')
sipStatsServerServiceUnavailIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 7, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsServerServiceUnavailIns.setDescription("This object reflects the total number of Service\n             Unavailable (503) responses received by the SIP entity.\n             Inbound Service Unavailable responses indicate that the\n             server servicing this system's request is temporarily\n             unavailable to handle the request.")
sipStatsServerServiceUnavailOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 7, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsServerServiceUnavailOuts.setDescription('This object reflects the total number of Service\n             Unavailable (503) responses sent by the SIP entity.\n             Outbound Service Unavailable responses indicate that this\n             system is temporarily unable to handle received requests.')
sipStatsServerGatewayTimeoutIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 7, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsServerGatewayTimeoutIns.setDescription("This object reflects the total number of Gateway Time-out\n             (504) responses received by the SIP entity.\n             Inbound Gateway Time-out responses indicate that the\n             server attempting to complete this system's request did\n             not receive a timely response from yet another system it\n             was accessing to complete the request.")
sipStatsServerGatewayTimeoutOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 7, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsServerGatewayTimeoutOuts.setDescription('This object reflects the total number of Gateway Time-out\n             (504) responses sent by the SIP entity.\n             Outbound Gateway Time-out responses indicate that this\n             system did not receive a timely response from the system\n             it had accessed to assist in completing a received\n             request.')
sipStatsServerBadSipVersionIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 7, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsServerBadSipVersionIns.setDescription('This object reflects the total number of SIP Version Not\n             Supported (505) responses received by the SIP entity.\n             Inbound SIP Version Not Supported responses indicate that\n             the server does not support, or refuses to support, the\n             SIP protocol version that was used in the request\n             message.')
sipStatsServerBadSipVersionOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 7, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsServerBadSipVersionOuts.setDescription('This object reflects the total number of SIP Version Not\n             Supported (505) responses sent by the SIP entity.\n             Outbound SIP Version Not Supported responses indicate that\n             this system does not support, or refuses to support, the\n             SIP protocol version used in received requests.')
sipStatsGlobalBusyEverywhereIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 8, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsGlobalBusyEverywhereIns.setDescription("This object reflects the total number of Busy\n             Everywhere (600) responses received by the SIP entity.\n             Inbound Busy Everywhere responses indicate that the\n             called party's end system was contacted successfully\n             but the called party is busy and does not want to take\n             the call at this time.")
sipStatsGlobalBusyEverywhereOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 8, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsGlobalBusyEverywhereOuts.setDescription("This object reflects the total number of Busy\n             Everywhere (600) responses sent by the SIP entity.\n             Outbound Busy Everywhere responses indicate that\n             this system has successfully contacted a called party's\n             end system and the called party does not want to take\n             the call at this time.")
sipStatsGlobalDeclineIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 8, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsGlobalDeclineIns.setDescription("This object reflects the total number of Decline\n             (603) responses received by the SIP entity.\n             Decline responses indicate that the called party's end\n             system was contacted successfully but the called party\n             explicitly does not want to, or cannot, participate.")
sipStatsGlobalDeclineOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 8, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsGlobalDeclineOuts.setDescription("This object reflects the total number of Decline\n             (603) responses sent by the SIP entity.\n             Outbound Decline responses indicate that this system\n             has successfully contacted a called party's end system\n             and the called party explicitly does not want to, or\n             cannot, participate.")
sipStatsGlobalNotAnywhereIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 8, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsGlobalNotAnywhereIns.setDescription("This object reflects the total number of Does Not\n             Exist Anywhere (604) responses received by the SIP entity.\n             Inbound Does Not Exist Anywhere responses indicate that\n             the server handling this system's request has\n             authoritative information that the called party indicated\n             in the To request field does not exist anywhere.")
sipStatsGlobalNotAnywhereOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 8, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsGlobalNotAnywhereOuts.setDescription('This object reflects the total number of Does Not\n             Exist Anywhere (604) responses sent by the SIP entity.\n             Outbound Does Not Exist Anywhere responses indicate that\n             this system has authoritative information that the called\n             party in the To field of received requests does not exist\n             anywhere.')
sipStatsGlobalNotAcceptableIns = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 8, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsGlobalNotAcceptableIns.setDescription("This object reflects the total number of Not Acceptable\n             (606) responses received by the SIP entity.\n             Inbound Not Acceptable responses indicate that the called\n             party's end system was contacted successfully but some\n             aspect of the session description is not acceptable.")
sipStatsGlobalNotAcceptableOuts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 8, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsGlobalNotAcceptableOuts.setDescription('This object reflects the total number of Not Acceptable\n             (606) responses sent by the SIP entity.\n             Outbound Not Acceptable responses indicate that the called\n             party wishes to communicate, but cannot adequately support\n             the session described in the request.')
sipCurrentTransactions = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9, 1), Gauge32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCurrentTransactions.setDescription('This object contains the number of transactions awaiting\n             definitive (non-1xx) response.  In the case of a forked\n             request, all branches count as a single transaction.  The\n             value of this object will reflect the number of rows in\n             sipTransactionTable.')
sipTransactionTable = MibTable((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9, 2), )
if mibBuilder.loadTexts: sipTransactionTable.setDescription('This table contains information on all of the transactions\n             currently being processed (the count of such transactions\n             is maintained in the sipCurrentTransactions object).')
sipTransactionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9, 2, 1), ).setIndexNames((0, "SIP-MIB", "sipTransIndex"))
if mibBuilder.loadTexts: sipTransactionEntry.setDescription('Information on a particular current transaction.')
sipTransIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)))
if mibBuilder.loadTexts: sipTransIndex.setDescription('This object uniquely identifies a conceptual row in the\n             table.')
sipTransTo = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9, 2, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipTransTo.setDescription('This object contains the value of the To header in request\n             message.')
sipTransFrom = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9, 2, 1, 3), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipTransFrom.setDescription('This object contains the value of the From header in the\n             request message.')
sipTransCallId = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9, 2, 1, 4), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipTransCallId.setDescription('This object contains the value of the CallId value in the\n             request message.')
sipTransCSeq = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9, 2, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipTransCSeq.setDescription('This object contains the CSeq value for the current\n             transaction.')
sipTransState = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9, 2, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9,))).clone(namedValues=NamedValues(("null", 1), ("initial", 2), ("calling", 3), ("ringing", 4), ("completed", 5), ("callProceeding", 6), ("failure", 7), ("success", 8), ("confirmed", 9),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipTransState.setDescription('This object contains the current state of the SIP\n             transaction.\n\n             null(1)           : The SIP entity is not active.\n             initial(2)        : Prior to sending or receiving any\n                                 request.\n             calling(3)        : After sending the request and prior to\n                                 receiving any response.\n             ringing(4)        : After receiving one or more\n                                 informational (1xx) responses.\n             completed(5)      : After ACK has been sent following\n                                 reception of definitive response.\n             callProceeding(6) : Entered on reception of an INVITE.\n             failure(7)        : Entered when call fails(send status\n                                 code>=300).\n             success(8)        : Entered when user answers(send status\n                                 code=200).\n             confirmed(9)      : Entered on reception of an ACK in\n                                 failure or success states.')
sipTransOutstandingBranches = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipTransOutstandingBranches.setDescription('This object contains a count of the number of branches\n             awaiting a final response.  Only a forking proxy will have\n             a value greater than one.')
sipTransExpiry = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9, 2, 1, 8), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipTransExpiry.setDescription('This object contains an indication of when the transaction\n             will be considered to have timed out.  This value is based\n             on the value in the Expires header, or the value of the\n             sipRequestDfltExpires object if no Expires value was\n             specified in the original request.')
sipTransCallingPartyContentType = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9, 2, 1, 9), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipTransCallingPartyContentType.setDescription('This object contains the content type of the transaction,\n             including parameters, as indicated by the session\n             initiator. All optional white space is removed from\n             subfields in the media-type specification.  It may\n             indicate mime multipart, in which case the multiple\n             entries are separated by spaces.')
sipTransCalledPartyContentType = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 9, 2, 1, 10), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipTransCalledPartyContentType.setDescription('This object contains the content type of the transaction,\n             including parameters, as indicated by the session\n             respondant.  All optional white space is removed from\n             subfields in the media-type specification.  It may\n             indicate mime multipart, in which case the multiple\n             entries are separated by spaces.')
sipNumUnsupportedUris = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 1, 2, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipNumUnsupportedUris.setDescription('Number of RequestURIs received with unsupported scheme.\n             A server normally responds to such requests with a 400 Bad\n             Request status code.')
sipUACfg = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 2, 1))
sipUACfgTimer = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 2, 1, 1))
sipUACfgRetry = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 2, 1, 2))
sipUAStats = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 2, 2))
sipUAStatsRetry = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 2, 2, 1))
sipUACfgTimerTrying = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(100,1000))).setUnits('milliseconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipUACfgTimerTrying.setDescription('This object specifies the time a user agent will wait to\n             receive a provisional response to an INVITE before\n             resending the INVITE.')
sipUACfgTimerExpires = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(60000,300000))).setUnits('milliseconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipUACfgTimerExpires.setDescription('This object specifies the time a user agent will wait to\n             receive a final response to an INVITE before canceling the\n             transaction.')
sipUACfgTimerConnect = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(100,1000))).setUnits('milliseconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipUACfgTimerConnect.setDescription('This object specifies the time a user agent will wait to\n             receive an ACK confirmation indicating that a session is\n             established.')
sipUACfgTimerDisconnect = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(100,1000))).setUnits('milliseconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipUACfgTimerDisconnect.setDescription('This object specifies the time a user agent will wait to\n             receive a BYE confirmation indicating that a session is\n             disconnected.')
sipUACfgRetryInvite = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 1, 2, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,10))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipUACfgRetryInvite.setDescription('This object will specify the number of times a user agent\n             will retry sending an INVITE request.')
sipUACfgRetryBye = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 1, 2, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,10))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipUACfgRetryBye.setDescription('This object will specify the number of times a user agent\n             will retry sending a BYE request.')
sipUACfgRetryCancel = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 1, 2, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,10))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipUACfgRetryCancel.setDescription('This object will specify the number of times a user agent\n             will retry sending a CANCEL request.')
sipUACfgRetryRegister = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 1, 2, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,10))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipUACfgRetryRegister.setDescription('This object will specify the number of times a user agent\n             will retry sending a REGISTER request.')
sipUACfgRetryResponse = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 1, 2, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,10))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipUACfgRetryResponse.setDescription('This object will specify the number of times a user agent\n             will retry sending a Response and expecting an ACK.')
sipStatsRetryInvites = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRetryInvites.setDescription("This object reflects the total number of INVITE retries\n             that have been sent by the user agent.   If the number of\n             'first attempt' INVITES is of interest, subtract the value\n             of this object from sipStatsTrafficInviteOut.")
sipStatsRetryByes = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRetryByes.setDescription('This object reflects the total number of BYE retries that\n             have been sent by the user agent.')
sipStatsRetryCancels = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRetryCancels.setDescription('This object reflects the total number of CANCEL retries\n             that have been sent by the user agent.')
sipStatsRetryRegisters = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRetryRegisters.setDescription('This object reflects the total number of REGISTER retries\n             that have been sent by the user agent.')
sipStatsRetryResponses = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 2, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipStatsRetryResponses.setDescription('This object reflects the total number of Response (while\n             expecting an ACK) retries that have been sent by the user\n             agent.')
sipServerCfg = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 3, 1))
sipServerStats = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 3, 2))
sipServerHost = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 3, 1, 1), SnmpAdminString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipServerHost.setDescription('This is the host portion of a SIP URL that is assigned\n             to the SIP server.  It may contain a fully qualified\n             domain name, or an IP address (v4 only for now).')
sipInformationTryingInitial = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 3, 1, 2), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipInformationTryingInitial.setDescription('If this object is true, the server sends 100 Trying when a\n             request is processed.')
sipInformationTryingInterval = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 3, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,60000))).setUnits('milliseconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipInformationTryingInterval.setDescription('Server sends a 100 Trying at intervals of this duration\n             as counted from when the request was processed.  If the\n             value is zero, no such retransmission is performed.')
sipPgpVersion = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 3, 1, 4), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipPgpVersion.setDescription('This object indicates the version of PGP (Pretty Good\n             Privacy) supported by this server.  Common values are\n             2.6.2 and 5.0.')
sipServerDfltAction = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 3, 1, 5), SipServerActions()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipServerDfltAction.setDescription('This object specifies whether the default action of the\n             server is to be a proxy server or a redirect server.  A\n             User Agent may indicate a preference upon registration of\n             Contact information. The value of this object is used in\n             the absence of such an indication.')
sipServerRespectUAAction = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 3, 1, 6), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipServerRespectUAAction.setDescription('This object specifies whether the server should respect\n             the wishes of a User Agent when the UA specifies a server\n             action (proxy or redirect) for certain Contact\n             information.  If the value of this object is false, then\n             the value contained in the sipServerDfltAction is used.')
sipRequestUriHostMatching = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 3, 1, 7), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipRequestUriHostMatching.setDescription("This object specifies whether or not the host in\n             RequestURI must match server's host name.\n\n             If the value of this object is TRUE, then the server\n             requires a match, and if the RequestURI doesn't match the\n             server's host name, a 404 Not Found status code is\n             returned by the server.\n             If the value is FALSE, then no match is required.")
sipProxyCfg = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1))
sipProxyStats = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 4, 2))
sipRequestMaxExpires = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipRequestMaxExpires.setDescription('This object specifies the maximum duration that a SIP\n             proxy server will accept from a client in the Expires\n             header.\n             If a longer duration is contained in the request, the\n             server returns a 400 Bad Request response.')
sipProxyStateful = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 2), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipProxyStateful.setDescription('This object specifies whether or not the proxy server\n             operates in stateful mode.  When stateful, a proxy\n             remembers the incoming request which generated outgoing\n             requests, and the outgoing requests. A stateless proxy\n             forgets all information once an outgoing request is\n             generated.\n\n             If the value of this object is TRUE, the proxy is\n             stateful.  If FALSE, the proxy is stateless.')
sipProxySendsCancel = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 3), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipProxySendsCancel.setDescription('This object specifies whether or not a forking proxy sends\n             CANCEL on outstanding branch requests after receiving a\n             2xx or 6xx, or after the request times-out.\n             If the value of this object is TRUE, the server sends a\n             CANCELs on branches where no definitive response has been\n             received.  If FALSE, the proxy does not send CANCELs.')
sipProxyForwardAll1xx = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 4), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipProxyForwardAll1xx.setDescription('This object specifies whether or not the proxy forwards\n             all 1xx responses upstream towards the source of the\n             request.\n\n             If the value of this object is TRUE, all 1xx response are\n             sent.  If the value is FALSE, duplicate 1xx responses are\n             not sent upstream.')
sipProxyRecursion = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 5), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipProxyRecursion.setDescription('This object specifies whether or not the Proxy performs\n             recursive search on the Contacts provided in 3xx\n             redirects.\n\n             If the value of this object is TRUE, a recursive search is\n             performed.  If the value is FALSE, no search is performed,\n             the 3xx response is sent upstream towards the source of\n             the request.')
sipProxyProvideAlternatives = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 6), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipProxyProvideAlternatives.setDescription("The object specifies whether or not the Server provides\n             alternative Contacts in 3xx and 485 responses.\n\n             If the value of this object is TRUE, the server inserts a\n             list of alternative URLs into a Contact header where the\n             request Originator may possibly find the desired called\n             party.  If the value is FALSE, the server doesn't add\n             Contact information to 3xx and 485 responses.\n\n             Note that the policies of a server may limit the\n             particular alternatives that are returned when this object\n             is TRUE.")
sipProxyRecordRoute = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 7), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipProxyRecordRoute.setDescription("This object specifies whether or not the proxy adds itself\n             to the Record-Route header.  This header is used to list\n             the proxies that insist on being in the signalling path\n             for subsequent requests related to the call-leg.\n\n             If the value of this object is TRUE, the proxy adds itself\n             to the end of the Record-Route header, creating the header\n             if required.\n             If the value is FALSE, the proxy doesn't add itself to the\n             Record-Route header.")
sipProxyUseCompact = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 8), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipProxyUseCompact.setDescription('This object specifies whether or not the proxy should use\n             the compact encoding form in the requests it sends.\n\n             If the value of this object is TRUE, the proxy encodes all\n             outgoing messages using the compact encoding form.  If the\n             value is FALSE, the encoding form used on the\n             corresponding incoming message is used, and if no incoming\n             message existed, full encoding is used.')
sipProxyRetransmissionBuffer = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipProxyRetransmissionBuffer.setDescription('This object specifies the duration after reception of the\n             first definitive non-200 response that a stateful proxy\n             retains state in order to handle possible retransmissions\n             of the response.')
sipProxyAuthMethod = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 10), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("none", 1), ("basic", 2), ("digest", 3), ("pgp", 4),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipProxyAuthMethod.setDescription('This object specifies the authentication method that is\n             used to authenticate request originators.  If the value is\n             none(1), no authentication is performed.')
sipProxyAuthPgpAlgorithm = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 11), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("other", 1), ("md5", 2), ("sha1", 3),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipProxyAuthPgpAlgorithm.setDescription('This object specifies the PGP algorithm the proxy uses.')
sipProxyAuthRealm = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 12), SnmpAdminString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipProxyAuthRealm.setDescription('This object specifies the realm used in Proxy-Authenticate\n             headers.  Note that this may need to be stored per user.')
sipProxyNonceLifeTime = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setUnits('milliseconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipProxyNonceLifeTime.setDescription('This object specifies the life-time of a given nonce.  A\n             nonce is a server specified value whose contents are\n             opaque to the entity being authenticated and which is used\n             in calculating authentication data.  If this object has a\n             value of zero, then\n             nonces are not reused.')
sipPgpPrivateKey = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 14), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipPgpPrivateKey.setDescription("The value of this object is the server's private PGP key,\n             used for both PGP authentication of this server and for\n             PGP-based\n             encryption.")
sipRxProxyAuthTable = MibTable((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 15), )
if mibBuilder.loadTexts: sipRxProxyAuthTable.setDescription('This table contains authentication data for peers of the\n             server.')
sipRxProxyAuthEntry = MibTableRow((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 15, 1), ).setIndexNames((0, "SIP-MIB", "sipRxProxyAuthIndex"))
if mibBuilder.loadTexts: sipRxProxyAuthEntry.setDescription('This object contains authentication data for a single\n             peer.')
sipRxProxyAuthIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 15, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: sipRxProxyAuthIndex.setDescription('This object uniquely identifies a conceptual row in the\n             table.')
sipRxProxyAuthRealm = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 15, 1, 2), SnmpAdminString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sipRxProxyAuthRealm.setDescription('This object contains the realm that is specified by\n             another server when it is authenticating this server.')
sipRxProxyAuthPassword = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 15, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,4095))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sipRxProxyAuthPassword.setDescription('This object contains the password that this server uses\n             when it is being authenticated by another server using the\n             realm specified by the sipRxProxyAuthRealm object in this\n             table row.')
sipRxProxyAuthStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 15, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sipRxProxyAuthStatus.setDescription('The row status of the entry. This object is required\n             to create or delete rows remotely by a manager.')
sipHideRespect = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 1, 16), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipHideRespect.setDescription('This object specifies whether the server encrypts Via\n             headers as requested by received Hide headers.')
sipNumProxyRequireFailures = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 4, 2, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipNumProxyRequireFailures.setDescription('This object contains the number of occurrences of\n             unsupported options being specified in received Proxy-\n             Require headers.  Such occurrences result in a 420 Bad\n             Extension status code being\n             returned.')
sipRedirCfg = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 5, 1))
sipRedirStats = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 5, 2))
sipRegCfg = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1))
sipRegStats = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 1, 6, 2))
sipRegAllowThirdParty = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 1), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipRegAllowThirdParty.setDescription('This object specifies whether or not the Registrar should\n             allows third party registrations. In third-party\n             registration, the entity issuing the request (in the From\n             header) is different from the entity being registered (in\n             the To header) to whom the\n             provided Contact information applies.\n             If the value of this object is TRUE, the Registrar allows\n             third party registrations.  If the value is FALSE, third\n             party registrations are rejected: a 403 Forbidden status\n             code is returned to the requestor.')
sipRegContactDfltExpiryDuration = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 2), Unsigned32().clone(3600)).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipRegContactDfltExpiryDuration.setDescription('This object specifies the default expiration (time-to-\n             live) of Contact information that is provided by User\n             Agents when registering with this Registrar.  This value\n             is only used when no expiration has been specified by the\n             user in the REGISTER\n             request.\n\n             If the value is applied to a registration and is different\n             from the default (one hour), the server must return the\n             value to the registered User Agent.\n\n             The value contained in this object only applies if the\n             value of the sipContactDfltExpiryDate object is NULL.  If\n             the value of this object applies, and is zero, then no\n             default expiry is applied to registered contact\n             information.')
sipRegContactDfltExpiryDate = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 3), DateAndTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipRegContactDfltExpiryDate.setDescription('This object specifies the default expiration date (time-\n             to-live) of Contact information that is provided by User\n             Agents when registering with this Registrar.  This value\n             is only used when no expiration has been specified by the\n             user in the REGISTER request.\n\n             If this value is applied to a registration, the server\n             must return the value to the registered User Agent.\n\n             The value contained in this object only applies if the\n             value of the sipContactDfltExpiryDuration object is zero.\n             If the value of this object applies, and is NULL, then no\n             default expiry is applied to\n             registered contact information.')
sipRegMaxContactExpiryDate = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)).clone(4294967295)).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipRegMaxContactExpiryDate.setDescription('This object specifies the maximum expiry that may be\n             requested by a User Agent for a particular Contact.  User\n             Agents can specify expiry using either an Expiry header in\n             a REGISTER request, or using an Expires parameter in a\n             Contact header in a REGISTER request.  If the value\n             requested by the User Agent is greater than the value of\n             this object, then the contact information is given the\n             duration specified by this object, and that duration\n             is indicated to the User Agent in the response.')
sipRegRespHasContacts = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 5), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipRegRespHasContacts.setDescription('This object specifies whether or not the Registrar should\n             return all currently reachable locations for a\n             successfully registering party in the REGISTER response\n             message.\n\n             If the value of this object is TRUE, the Registrar returns\n             the locations in the REGISTER response.  If the value is\n             FALSE, no location information is provided.')
sipRegMaxUsers = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 6), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipRegMaxUsers.setDescription('This object specifies the maximum number of users that the\n             registrar supports.  The current number of users is\n             reflected by sipRegCurrentUsers.')
sipRegCurrentUsers = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 7), Gauge32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipRegCurrentUsers.setDescription('This object specifies the number of users currently\n             configured on the registrar.')
sipRegUserTable = MibTable((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 8), )
if mibBuilder.loadTexts: sipRegUserTable.setDescription('This table contains information on all users registered to\n             this Registrar.')
sipRegUserEntry = MibTableRow((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 8, 1), ).setIndexNames((0, "SIP-MIB", "sipUserIndex"))
if mibBuilder.loadTexts: sipRegUserEntry.setDescription('This entry contains information for a single user\n             registered to this Registrar.')
sipUserIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 8, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: sipUserIndex.setDescription('This object uniquely identifies a conceptual row in the\n             table.')
sipUserUri = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 8, 1, 2), SnmpAdminString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sipUserUri.setDescription("This object contains the user's address-of-record.  It is\n             the main form by which the registrar knows the user.  The\n             format is typically 'user@domain'.  It is contained in the\n             To header for all REGISTER requests.")
sipUserPassword = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 8, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sipUserPassword.setDescription('This object specifies the password that the user must\n             enter when being authenticated.')
sipUserAuthenticationFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 8, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipUserAuthenticationFailures.setDescription('This object contains a count of the number of times the\n             user has failed authentication.')
sipUserTableRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 8, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sipUserTableRowStatus.setDescription('The row status of the entry. This object is required\n             to create or delete rows remotely by a manager.')
sipContactTable = MibTable((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 9), )
if mibBuilder.loadTexts: sipContactTable.setDescription('This table contains information on every location where\n             every registered user wishes to be found (i.e. has\n   provided\n             Contact information).')
sipContactEntry = MibTableRow((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 9, 1), ).setIndexNames((0, "SIP-MIB", "sipUserIndex"), (0, "SIP-MIB", "sipContactIndex"))
if mibBuilder.loadTexts: sipContactEntry.setDescription('This entry contains information for a single Contact.\n             Multiple contacts may exist for a single user.')
sipContactIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 9, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: sipContactIndex.setDescription('Along with the sipUserIndex, this object uniquely\n             identifies a conceptual row in the table.')
sipContactDisplayName = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 9, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipContactDisplayName.setDescription("This object contains the display name for the Contact.\n             For example, 'Santa at Home', or 'Santa on his Sled',\n             corresponding to contact URLs of\n             sip:BigGuy@sip.northpole.ca or\n             sip:sclaus817@sip.mobile.com, respectively.")
sipContactURI = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 9, 1, 3), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipContactURI.setDescription('This object contains either a SIP URL or a URI where the\n             user can be contacted.  This URI is normally returned to a\n             client from a redirect server, or is used as the\n             RequestURI in a SIP request line for requests forwarded by\n             a proxy.')
sipContactLastUpdated = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 9, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipContactLastUpdated.setDescription('This object indicates the time when this contact\n             information was accepted.  If the contact information is\n             updated via a subsequent REGISTER of the same information,\n             this object is also updated.')
sipContactExpiry = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 9, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipContactExpiry.setDescription('This object contains the date and time when the contact\n             information will no longer be valid.  Such times may be\n             specified by the user at registration (Expires header or\n             expiry parameter in the Contact information), or a system\n             default can be applied.')
sipContactPreference = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 9, 1, 6), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipContactPreference.setDescription("This object specifies the preference for this contact\n             relative to all other active contacts for same user.  A\n             registering user may provide this preference as a 'qvalue'\n             parameter in the Contact header.\n\n             The format of this item is a decimal number between 0\n             and 1 (for example 0.9).  Higher values indicate locations\n             preferred by the user.")
sipContactAction = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 9, 1, 7), SipServerActions()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipContactAction.setDescription("This object indicates whether the user wanted the server\n             to act as a redirect server or as a proxy server.  It is\n             specified by the optional 'action' parameter in the\n             Contact header.")
sipContactRetryAfter = MibTableColumn((1, 3, 6, 1, 2, 1, 9998, 1, 6, 1, 9, 1, 8), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipContactRetryAfter.setDescription('This object indicates that the contact information is\n             currently inactive, and that it should only be activated\n             after the date and time specified by the object.  This\n             value is provided by a user when deleting contact\n             information using a REGISTER request containing a Retry-\n             After header.')
sipRegAcceptedRegistrations = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 6, 2, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipRegAcceptedRegistrations.setDescription('This object contains a count of the number of REGISTER\n             requests that have been accepted (status code 200) by the\n             Registrar.  This includes additions of new contact\n             information, refreshing contact information, as well as\n             requests for deletion of contact information.')
sipRegRejectedRegistrations = MibScalar((1, 3, 6, 1, 2, 1, 9998, 1, 6, 2, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipRegRejectedRegistrations.setDescription('This object contains a count of the number REGISTER\n             requests that have been rejected by the Registrar.')
sipMIBNotifPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 2))
sipMIBNotif = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 2, 0))
sipNotif = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 2, 0, 1))
sipUANotif = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 2, 0, 2))
sipProxyNotif = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 2, 0, 3))
sipRedirNotif = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 2, 0, 4))
sipRegNotif = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 2, 0, 5))
sipMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 3))
sipMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 3, 1))
sipMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 9998, 3, 2))
sipCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 9998, 3, 1, 1)).setObjects(*(("SIP-MIB", "sipCommonConfigGroup"), ("SIP-MIB", "sipCommonStatsGroup"), ("SIP-MIB", "sipUAConfigGroup"), ("SIP-MIB", "sipUAStatsGroup"), ("SIP-MIB", "sipServerConfigGroup"), ("SIP-MIB", "sipProxyConfigGroup"), ("SIP-MIB", "sipProxyStatsGroup"), ("SIP-MIB", "sipRegistrarConfigGroup"), ("SIP-MIB", "sipRegistrarStatsGroup"),))
if mibBuilder.loadTexts: sipCompliance.setDescription('The compliance statement for SIP entities.')
sipCommonConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 9998, 3, 2, 1)).setObjects(*(("SIP-MIB", "sipProtocolVersion"), ("SIP-MIB", "sipServiceOperStatus"), ("SIP-MIB", "sipServiceAdminStatus"), ("SIP-MIB", "sipServiceStartTime"), ("SIP-MIB", "sipServiceLastChange"), ("SIP-MIB", "sipTransport"), ("SIP-MIB", "sipPortStatus"), ("SIP-MIB", "sipUriSupported"), ("SIP-MIB", "sipFtrSupported"), ("SIP-MIB", "sipOrganization"), ("SIP-MIB", "sipMaxTransactions"), ("SIP-MIB", "sipRequestDfltExpires"), ("SIP-MIB", "sipHideOperation"), ("SIP-MIB", "sipUserLocationServerAddr"),))
if mibBuilder.loadTexts: sipCommonConfigGroup.setDescription('A collection of objects providing configuration common\n             to all SIP enities.')
sipCommonStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 9998, 3, 2, 2)).setObjects(*(("SIP-MIB", "sipSummaryInRequests"), ("SIP-MIB", "sipSummaryOutRequests"), ("SIP-MIB", "sipSummaryInResponses"), ("SIP-MIB", "sipSummaryOutResponses"), ("SIP-MIB", "sipSummaryTotalTransactions"), ("SIP-MIB", "sipStatsInviteIns"), ("SIP-MIB", "sipStatsInviteOuts"), ("SIP-MIB", "sipStatsAckIns"), ("SIP-MIB", "sipStatsAckOuts"), ("SIP-MIB", "sipStatsByeIns"), ("SIP-MIB", "sipStatsByeOuts"), ("SIP-MIB", "sipStatsCancelIns"), ("SIP-MIB", "sipStatsCancelOuts"), ("SIP-MIB", "sipStatsOptionsIns"), ("SIP-MIB", "sipStatsOptionsOuts"), ("SIP-MIB", "sipStatsRegisterIns"), ("SIP-MIB", "sipStatsRegisterOuts"), ("SIP-MIB", "sipStatsInfoIns"), ("SIP-MIB", "sipStatsInfoOuts"), ("SIP-MIB", "sipStatsInfoTryingIns"), ("SIP-MIB", "sipStatsInfoTryingOuts"), ("SIP-MIB", "sipStatsInfoRingingIns"), ("SIP-MIB", "sipStatsInfoRingingOuts"), ("SIP-MIB", "sipStatsInfoForwardedIns"), ("SIP-MIB", "sipStatsInfoForwardedOuts"), ("SIP-MIB", "sipStatsInfoQueuedIns"), ("SIP-MIB", "sipStatsInfoQueuedOuts"), ("SIP-MIB", "sipStatsInfoSessionProgIns"), ("SIP-MIB", "sipStatsInfoSessionProgOuts"), ("SIP-MIB", "sipStatsSuccessOkIns"), ("SIP-MIB", "sipStatsSuccessOkOuts"), ("SIP-MIB", "sipStatsRedirMultipleChoiceIns"), ("SIP-MIB", "sipStatsRedirMultipleChoiceOuts"), ("SIP-MIB", "sipStatsRedirMovedPermIns"), ("SIP-MIB", "sipStatsRedirMovedPermOuts"), ("SIP-MIB", "sipStatsRedirMovedTempIns"), ("SIP-MIB", "sipStatsRedirMovedTempOuts"), ("SIP-MIB", "sipStatsRedirSeeOtherIns"), ("SIP-MIB", "sipStatsRedirSeeOtherOuts"), ("SIP-MIB", "sipStatsRedirUseProxyIns"), ("SIP-MIB", "sipStatsRedirUseProxyOuts"), ("SIP-MIB", "sipStatsRedirAltServiceIns"), ("SIP-MIB", "sipStatsRedirAltServiceOuts"), ("SIP-MIB", "sipStatsClientBadRequestIns"), ("SIP-MIB", "sipStatsClientBadRequestOuts"), ("SIP-MIB", "sipStatsClientUnauthorizedIns"), ("SIP-MIB", "sipStatsClientUnauthorizedOuts"), ("SIP-MIB", "sipStatsClientPaymentReqdIns"), ("SIP-MIB", "sipStatsClientPaymentReqdOuts"), ("SIP-MIB", "sipStatsClientForbiddenIns"), ("SIP-MIB", "sipStatsClientForbiddenOuts"), ("SIP-MIB", "sipStatsClientNotFoundIns"), ("SIP-MIB", "sipStatsClientNotFoundOuts"), ("SIP-MIB", "sipStatsClientMethNotAllowedIns"), ("SIP-MIB", "sipStatsClientMethNotAllowedOuts"), ("SIP-MIB", "sipStatsClientNotAcceptableIns"), ("SIP-MIB", "sipStatsClientNotAcceptableOuts"), ("SIP-MIB", "sipStatsClientProxyAuthReqdIns"), ("SIP-MIB", "sipStatsClientProxyAuthReqdOuts"), ("SIP-MIB", "sipStatsClientReqTimeoutIns"), ("SIP-MIB", "sipStatsClientReqTimeoutOuts"), ("SIP-MIB", "sipStatsClientConflictIns"), ("SIP-MIB", "sipStatsClientConflictOuts"), ("SIP-MIB", "sipStatsClientGoneIns"), ("SIP-MIB", "sipStatsClientGoneOuts"), ("SIP-MIB", "sipStatsClientLengthRequiredIns"), ("SIP-MIB", "sipStatsClientLengthRequiredOuts"), ("SIP-MIB", "sipStatsClientReqEntTooLargeIns"), ("SIP-MIB", "sipStatsClientReqEntTooLargeOuts"), ("SIP-MIB", "sipStatsClientReqURITooLargeIns"), ("SIP-MIB", "sipStatsClientReqURITooLargeOuts"), ("SIP-MIB", "sipStatsClientNoSupMediaTypeIns"), ("SIP-MIB", "sipStatsClientNoSupMediaTypeOuts"), ("SIP-MIB", "sipStatsClientBadExtensionIns"), ("SIP-MIB", "sipStatsClientBadExtensionOuts"), ("SIP-MIB", "sipStatsClientTempNotAvailIns"), ("SIP-MIB", "sipStatsClientTempNotAvailOuts"), ("SIP-MIB", "sipStatsClientCallLegNoExistIns"), ("SIP-MIB", "sipStatsClientCallLegNoExistOuts"), ("SIP-MIB", "sipStatsClientLoopDetectedIns"), ("SIP-MIB", "sipStatsClientLoopDetectedOuts"), ("SIP-MIB", "sipStatsClientTooManyHopsIns"), ("SIP-MIB", "sipStatsClientTooManyHopsOuts"), ("SIP-MIB", "sipStatsClientAddrIncompleteIns"), ("SIP-MIB", "sipStatsClientAddrIncompleteOuts"), ("SIP-MIB", "sipStatsClientAmbiguousIns"), ("SIP-MIB", "sipStatsClientAmbiguousOuts"), ("SIP-MIB", "sipStatsClientBusyHereIns"), ("SIP-MIB", "sipStatsClientBusyHereOuts"), ("SIP-MIB", "sipStatsServerIntErrorIns"), ("SIP-MIB", "sipStatsServerIntErrorOuts"), ("SIP-MIB", "sipStatsServerNotImplementedIns"), ("SIP-MIB", "sipStatsServerNotImplementedOuts"), ("SIP-MIB", "sipStatsServerBadGatewayIns"), ("SIP-MIB", "sipStatsServerBadGatewayOuts"), ("SIP-MIB", "sipStatsServerServiceUnavailIns"), ("SIP-MIB", "sipStatsServerServiceUnavailOuts"), ("SIP-MIB", "sipStatsServerGatewayTimeoutIns"), ("SIP-MIB", "sipStatsServerGatewayTimeoutOuts"), ("SIP-MIB", "sipStatsServerBadSipVersionIns"), ("SIP-MIB", "sipStatsServerBadSipVersionOuts"), ("SIP-MIB", "sipStatsGlobalBusyEverywhereIns"), ("SIP-MIB", "sipStatsGlobalBusyEverywhereOuts"), ("SIP-MIB", "sipStatsGlobalDeclineIns"), ("SIP-MIB", "sipStatsGlobalDeclineOuts"), ("SIP-MIB", "sipStatsGlobalNotAnywhereIns"), ("SIP-MIB", "sipStatsGlobalNotAnywhereOuts"), ("SIP-MIB", "sipStatsGlobalNotAcceptableIns"), ("SIP-MIB", "sipStatsGlobalNotAcceptableOuts"), ("SIP-MIB", "sipCurrentTransactions"), ("SIP-MIB", "sipTransTo"), ("SIP-MIB", "sipTransFrom"), ("SIP-MIB", "sipTransCallId"), ("SIP-MIB", "sipTransCSeq"), ("SIP-MIB", "sipTransState"), ("SIP-MIB", "sipTransOutstandingBranches"), ("SIP-MIB", "sipTransExpiry"), ("SIP-MIB", "sipTransCallingPartyContentType"), ("SIP-MIB", "sipTransCalledPartyContentType"), ("SIP-MIB", "sipNumUnsupportedUris"),))
if mibBuilder.loadTexts: sipCommonStatsGroup.setDescription('A collection of objects providing statistics common\n             toall SIP entities.')
sipUAConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 9998, 3, 2, 4)).setObjects(*(("SIP-MIB", "sipUACfgTimerTrying"), ("SIP-MIB", "sipUACfgTimerExpires"), ("SIP-MIB", "sipUACfgTimerConnect"), ("SIP-MIB", "sipUACfgTimerDisconnect"), ("SIP-MIB", "sipUACfgRetryInvite"), ("SIP-MIB", "sipUACfgRetryBye"), ("SIP-MIB", "sipUACfgRetryCancel"), ("SIP-MIB", "sipUACfgRetryRegister"), ("SIP-MIB", "sipUACfgRetryResponse"),))
if mibBuilder.loadTexts: sipUAConfigGroup.setDescription('A collection of objects providing configuration for\n             SIP User Agents.')
sipUAStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 9998, 3, 2, 5)).setObjects(*(("SIP-MIB", "sipStatsRetryInvites"), ("SIP-MIB", "sipStatsRetryByes"), ("SIP-MIB", "sipStatsRetryCancels"), ("SIP-MIB", "sipStatsRetryRegisters"), ("SIP-MIB", "sipStatsRetryResponses"),))
if mibBuilder.loadTexts: sipUAStatsGroup.setDescription('A collection of objects providing statistics for\n             SIP User Agents.')
sipServerConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 9998, 3, 2, 7)).setObjects(*(("SIP-MIB", "sipServerHost"), ("SIP-MIB", "sipInformationTryingInitial"), ("SIP-MIB", "sipInformationTryingInterval"), ("SIP-MIB", "sipPgpVersion"), ("SIP-MIB", "sipServerDfltAction"), ("SIP-MIB", "sipServerRespectUAAction"), ("SIP-MIB", "sipRequestUriHostMatching"),))
if mibBuilder.loadTexts: sipServerConfigGroup.setDescription('A collection of objects providing configuration common\n             to SIP Proxy and Redirect servers.')
sipProxyConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 9998, 3, 2, 9)).setObjects(*(("SIP-MIB", "sipRequestMaxExpires"), ("SIP-MIB", "sipProxyStateful"), ("SIP-MIB", "sipProxySendsCancel"), ("SIP-MIB", "sipProxyForwardAll1xx"), ("SIP-MIB", "sipProxyRecursion"), ("SIP-MIB", "sipProxyProvideAlternatives"), ("SIP-MIB", "sipProxyRecordRoute"), ("SIP-MIB", "sipProxyUseCompact"), ("SIP-MIB", "sipProxyRetransmissionBuffer"), ("SIP-MIB", "sipProxyAuthMethod"), ("SIP-MIB", "sipProxyAuthPgpAlgorithm"), ("SIP-MIB", "sipProxyAuthRealm"), ("SIP-MIB", "sipProxyNonceLifeTime"), ("SIP-MIB", "sipPgpPrivateKey"), ("SIP-MIB", "sipRxProxyAuthRealm"), ("SIP-MIB", "sipRxProxyAuthPassword"), ("SIP-MIB", "sipRxProxyAuthStatus"), ("SIP-MIB", "sipHideRespect"),))
if mibBuilder.loadTexts: sipProxyConfigGroup.setDescription('A collection of objects providing configuration for\n             SIP Proxy servers.')
sipProxyStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 9998, 3, 2, 10)).setObjects(*(("SIP-MIB", "sipNumProxyRequireFailures"),))
if mibBuilder.loadTexts: sipProxyStatsGroup.setDescription('A collection of objects providing statistics for\n             SIP Proxy servers.')
sipRegistrarConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 9998, 3, 2, 15)).setObjects(*(("SIP-MIB", "sipRegAllowThirdParty"), ("SIP-MIB", "sipRegContactDfltExpiryDuration"), ("SIP-MIB", "sipRegContactDfltExpiryDate"), ("SIP-MIB", "sipRegMaxContactExpiryDate"), ("SIP-MIB", "sipRegRespHasContacts"), ("SIP-MIB", "sipRegMaxUsers"), ("SIP-MIB", "sipRegCurrentUsers"), ("SIP-MIB", "sipUserUri"), ("SIP-MIB", "sipUserPassword"), ("SIP-MIB", "sipUserAuthenticationFailures"), ("SIP-MIB", "sipUserTableRowStatus"), ("SIP-MIB", "sipContactDisplayName"), ("SIP-MIB", "sipContactURI"), ("SIP-MIB", "sipContactLastUpdated"), ("SIP-MIB", "sipContactExpiry"), ("SIP-MIB", "sipContactPreference"), ("SIP-MIB", "sipContactAction"), ("SIP-MIB", "sipContactRetryAfter"),))
if mibBuilder.loadTexts: sipRegistrarConfigGroup.setDescription('A collection of objects providing configuration for\n             SIP Registrars.')
sipRegistrarStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 9998, 3, 2, 16)).setObjects(*(("SIP-MIB", "sipRegAcceptedRegistrations"), ("SIP-MIB", "sipRegRejectedRegistrations"),))
if mibBuilder.loadTexts: sipRegistrarStatsGroup.setDescription('A collection of objects providing statistics for\n             SIP Registrars.')
mibBuilder.exportSymbols("SIP-MIB", sipReg=sipReg, sipUriSupportedTable=sipUriSupportedTable, sipStatsCancelIns=sipStatsCancelIns, sipTransExpiry=sipTransExpiry, sipStatsClientNotAcceptableOuts=sipStatsClientNotAcceptableOuts, sipStatsClientConflictOuts=sipStatsClientConflictOuts, sipStatsClientBadRequestOuts=sipStatsClientBadRequestOuts, sipStatsServerBadSipVersionIns=sipStatsServerBadSipVersionIns, sipStatsClientTempNotAvailIns=sipStatsClientTempNotAvailIns, sipContactEntry=sipContactEntry, sipRegAllowThirdParty=sipRegAllowThirdParty, sipCommonStatsSummary=sipCommonStatsSummary, sipRxProxyAuthTable=sipRxProxyAuthTable, sipStatsInfoRingingIns=sipStatsInfoRingingIns, sipStatsRedirMultipleChoiceIns=sipStatsRedirMultipleChoiceIns, sipUserPassword=sipUserPassword, sipRegContactDfltExpiryDate=sipRegContactDfltExpiryDate, sipPortStatus=sipPortStatus, sipStatsAckIns=sipStatsAckIns, sipUAStats=sipUAStats, sipInformationTryingInterval=sipInformationTryingInterval, sipStatsRedirSeeOtherOuts=sipStatsRedirSeeOtherOuts, sipCommonStatsRedirect=sipCommonStatsRedirect, sipInformationTryingInitial=sipInformationTryingInitial, sipStatsInfoTryingOuts=sipStatsInfoTryingOuts, sipStatsClientProxyAuthReqdOuts=sipStatsClientProxyAuthReqdOuts, sipStatsServerBadGatewayOuts=sipStatsServerBadGatewayOuts, sipProxyNonceLifeTime=sipProxyNonceLifeTime, sipRegUserTable=sipRegUserTable, sipProxyForwardAll1xx=sipProxyForwardAll1xx, sipStatsOptionsOuts=sipStatsOptionsOuts, sipSummaryTotalTransactions=sipSummaryTotalTransactions, sipStatsClientAmbiguousOuts=sipStatsClientAmbiguousOuts, sipStatsRetryInvites=sipStatsRetryInvites, sipStatsServerIntErrorOuts=sipStatsServerIntErrorOuts, sipTransFrom=sipTransFrom, sipRequestMaxExpires=sipRequestMaxExpires, sipServerConfigGroup=sipServerConfigGroup, sipStatsInfoRingingOuts=sipStatsInfoRingingOuts, sipPgpVersion=sipPgpVersion, sipRegAcceptedRegistrations=sipRegAcceptedRegistrations, sipSummaryOutRequests=sipSummaryOutRequests, sipStatsClientNotFoundOuts=sipStatsClientNotFoundOuts, sipProxyStatsGroup=sipProxyStatsGroup, sipStatsClientLoopDetectedIns=sipStatsClientLoopDetectedIns, sipProxyProvideAlternatives=sipProxyProvideAlternatives, sipStatsClientBusyHereIns=sipStatsClientBusyHereIns, sipStatsRetryByes=sipStatsRetryByes, sipProxyStateful=sipProxyStateful, sipTransTo=sipTransTo, sipTransCalledPartyContentType=sipTransCalledPartyContentType, sipStatsRedirMovedPermOuts=sipStatsRedirMovedPermOuts, sipStatsClientBadExtensionIns=sipStatsClientBadExtensionIns, sipOrganization=sipOrganization, sipCommonStatsGlobalFail=sipCommonStatsGlobalFail, sipUACfgRetryResponse=sipUACfgRetryResponse, sipMIB=sipMIB, sipCommonConfigGroup=sipCommonConfigGroup, sipRequestDfltExpires=sipRequestDfltExpires, sipCommonStatsErrClient=sipCommonStatsErrClient, sipStatsClientMethNotAllowedOuts=sipStatsClientMethNotAllowedOuts, sipTransCSeq=sipTransCSeq, sipStatsClientNotFoundIns=sipStatsClientNotFoundIns, sipStatsInviteOuts=sipStatsInviteOuts, sipCommonStatsSuccess=sipCommonStatsSuccess, sipStatsClientGoneIns=sipStatsClientGoneIns, sipStatsGlobalNotAcceptableIns=sipStatsGlobalNotAcceptableIns, sipTransState=sipTransState, sipRxProxyAuthRealm=sipRxProxyAuthRealm, sipStatsInfoSessionProgOuts=sipStatsInfoSessionProgOuts, sipRegStats=sipRegStats, sipUAConfigGroup=sipUAConfigGroup, sipContactTable=sipContactTable, sipCommonStatsErrServer=sipCommonStatsErrServer, sipContactRetryAfter=sipContactRetryAfter, sipStatsClientConflictIns=sipStatsClientConflictIns, sipStatsClientPaymentReqdOuts=sipStatsClientPaymentReqdOuts, sipRxProxyAuthIndex=sipRxProxyAuthIndex, sipStatsServerGatewayTimeoutOuts=sipStatsServerGatewayTimeoutOuts, sipMIBConformance=sipMIBConformance, sipStatsSuccessOkIns=sipStatsSuccessOkIns, sipStatsRetryRegisters=sipStatsRetryRegisters, sipStatsRedirMovedPermIns=sipStatsRedirMovedPermIns, sipFtrSupportedTable=sipFtrSupportedTable, sipStatsClientReqURITooLargeIns=sipStatsClientReqURITooLargeIns, sipUACfgRetry=sipUACfgRetry, sipRedir=sipRedir, sipStatsRedirMovedTempOuts=sipStatsRedirMovedTempOuts, sipTransCallId=sipTransCallId, sipCommonStatsGroup=sipCommonStatsGroup, sipProxyConfigGroup=sipProxyConfigGroup, sipStatsRedirSeeOtherIns=sipStatsRedirSeeOtherIns, sipServerHost=sipServerHost, sipUAStatsGroup=sipUAStatsGroup, sipContactURI=sipContactURI, sipHideRespect=sipHideRespect, sipCommon=sipCommon, sipTransCallingPartyContentType=sipTransCallingPartyContentType, sipStatsRedirAltServiceOuts=sipStatsRedirAltServiceOuts, sipStatsRetryCancels=sipStatsRetryCancels, sipStatsServerBadSipVersionOuts=sipStatsServerBadSipVersionOuts, sipStatsRegisterIns=sipStatsRegisterIns, sipUAStatsRetry=sipUAStatsRetry, sipStatsServerServiceUnavailIns=sipStatsServerServiceUnavailIns, sipStatsClientBusyHereOuts=sipStatsClientBusyHereOuts, sipServerStats=sipServerStats, sipStatsClientReqTimeoutOuts=sipStatsClientReqTimeoutOuts, sipProxyUseCompact=sipProxyUseCompact, sipMIBObjects=sipMIBObjects, sipStatsGlobalBusyEverywhereIns=sipStatsGlobalBusyEverywhereIns, sipStatsOptionsIns=sipStatsOptionsIns, sipUACfgTimerTrying=sipUACfgTimerTrying, sipProxyRetransmissionBuffer=sipProxyRetransmissionBuffer, sipStatsClientUnauthorizedIns=sipStatsClientUnauthorizedIns, sipStatsClientNoSupMediaTypeOuts=sipStatsClientNoSupMediaTypeOuts, sipStatsRedirMultipleChoiceOuts=sipStatsRedirMultipleChoiceOuts, sipStatsByeIns=sipStatsByeIns, sipStatsRedirUseProxyIns=sipStatsRedirUseProxyIns, sipProxyRecordRoute=sipProxyRecordRoute, sipRedirStats=sipRedirStats, sipStatsClientNoSupMediaTypeIns=sipStatsClientNoSupMediaTypeIns, sipTransIndex=sipTransIndex, sipUA=sipUA, sipStatsAckOuts=sipStatsAckOuts, sipStatsClientAddrIncompleteIns=sipStatsClientAddrIncompleteIns, sipProxyAuthMethod=sipProxyAuthMethod, sipPortTable=sipPortTable, sipTransOutstandingBranches=sipTransOutstandingBranches, sipCommonStatsInfo=sipCommonStatsInfo, sipSummaryOutResponses=sipSummaryOutResponses, sipStatsRedirMovedTempIns=sipStatsRedirMovedTempIns, sipCommonCfg=sipCommonCfg, sipStatsClientBadRequestIns=sipStatsClientBadRequestIns, sipStatsClientAmbiguousIns=sipStatsClientAmbiguousIns, sipUACfgTimerExpires=sipUACfgTimerExpires, sipProxy=sipProxy, sipServerDfltAction=sipServerDfltAction, sipServiceLastChange=sipServiceLastChange, sipRegCfg=sipRegCfg, sipStatsClientForbiddenIns=sipStatsClientForbiddenIns, sipUACfgRetryCancel=sipUACfgRetryCancel, sipNotif=sipNotif, sipUANotif=sipUANotif, sipServiceStartTime=sipServiceStartTime, sipStatsClientTooManyHopsIns=sipStatsClientTooManyHopsIns, sipUserAuthenticationFailures=sipUserAuthenticationFailures, sipStatsSuccessOkOuts=sipStatsSuccessOkOuts, sipStatsGlobalBusyEverywhereOuts=sipStatsGlobalBusyEverywhereOuts, sipRegRespHasContacts=sipRegRespHasContacts, sipMaxTransactions=sipMaxTransactions, sipRegistrarConfigGroup=sipRegistrarConfigGroup, sipStatsServerNotImplementedOuts=sipStatsServerNotImplementedOuts, sipStatsClientReqTimeoutIns=sipStatsClientReqTimeoutIns, sipRegistrarStatsGroup=sipRegistrarStatsGroup, sipUserTableRowStatus=sipUserTableRowStatus, sipRxProxyAuthStatus=sipRxProxyAuthStatus, sipStatsRegisterOuts=sipStatsRegisterOuts, sipRxProxyAuthEntry=sipRxProxyAuthEntry, sipStatsInfoSessionProgIns=sipStatsInfoSessionProgIns, sipStatsGlobalNotAnywhereOuts=sipStatsGlobalNotAnywhereOuts, sipStatsClientLengthRequiredIns=sipStatsClientLengthRequiredIns, sipServer=sipServer, sipStatsClientPaymentReqdIns=sipStatsClientPaymentReqdIns, sipStatsClientReqURITooLargeOuts=sipStatsClientReqURITooLargeOuts, sipMIBCompliances=sipMIBCompliances, sipStatsServerGatewayTimeoutIns=sipStatsServerGatewayTimeoutIns, sipStatsClientForbiddenOuts=sipStatsClientForbiddenOuts, sipStatsInviteIns=sipStatsInviteIns, sipStatsClientNotAcceptableIns=sipStatsClientNotAcceptableIns, sipTransactionTable=sipTransactionTable, sipRegRejectedRegistrations=sipRegRejectedRegistrations, sipContactLastUpdated=sipContactLastUpdated, sipMIBGroups=sipMIBGroups, sipStatsClientReqEntTooLargeOuts=sipStatsClientReqEntTooLargeOuts, sipContactExpiry=sipContactExpiry, sipTransactionEntry=sipTransactionEntry, sipFtrSupported=sipFtrSupported, sipStatsClientProxyAuthReqdIns=sipStatsClientProxyAuthReqdIns, sipStatsClientCallLegNoExistOuts=sipStatsClientCallLegNoExistOuts, sipUACfgRetryBye=sipUACfgRetryBye, sipProxySendsCancel=sipProxySendsCancel, sipMIBNotifPrefix=sipMIBNotifPrefix, sipUACfgTimerConnect=sipUACfgTimerConnect, sipStatsServerIntErrorIns=sipStatsServerIntErrorIns, sipProxyRecursion=sipProxyRecursion, sipStatsClientMethNotAllowedIns=sipStatsClientMethNotAllowedIns, sipStatsServerNotImplementedIns=sipStatsServerNotImplementedIns, sipRegMaxContactExpiryDate=sipRegMaxContactExpiryDate, sipSummaryInResponses=sipSummaryInResponses, sipStatsByeOuts=sipStatsByeOuts, sipStatsClientBadExtensionOuts=sipStatsClientBadExtensionOuts, sipStatsClientLengthRequiredOuts=sipStatsClientLengthRequiredOuts, sipUACfgTimer=sipUACfgTimer, sipStatsServerServiceUnavailOuts=sipStatsServerServiceUnavailOuts, sipServerRespectUAAction=sipServerRespectUAAction, sipContactPreference=sipContactPreference, sipProxyAuthPgpAlgorithm=sipProxyAuthPgpAlgorithm, sipNumProxyRequireFailures=sipNumProxyRequireFailures, sipStatsClientTooManyHopsOuts=sipStatsClientTooManyHopsOuts, sipStatsRedirAltServiceIns=sipStatsRedirAltServiceIns, sipStatsInfoQueuedIns=sipStatsInfoQueuedIns, sipUACfgTimerDisconnect=sipUACfgTimerDisconnect, sipStatsRetryResponses=sipStatsRetryResponses, sipUACfgRetryInvite=sipUACfgRetryInvite, sipContactAction=sipContactAction, sipFtrSupportedIndex=sipFtrSupportedIndex, sipServerCfg=sipServerCfg, sipProxyAuthRealm=sipProxyAuthRealm, sipStatsServerBadGatewayIns=sipStatsServerBadGatewayIns, sipProxyCfg=sipProxyCfg, sipPort=sipPort, sipStatsGlobalNotAcceptableOuts=sipStatsGlobalNotAcceptableOuts, sipStatsInfoForwardedOuts=sipStatsInfoForwardedOuts, sipCommonStatsMethod=sipCommonStatsMethod, sipSummaryInRequests=sipSummaryInRequests, sipStatsClientGoneOuts=sipStatsClientGoneOuts, sipNumUnsupportedUris=sipNumUnsupportedUris, sipStatsInfoForwardedIns=sipStatsInfoForwardedIns, sipStatsGlobalNotAnywhereIns=sipStatsGlobalNotAnywhereIns, sipRegNotif=sipRegNotif, sipStatsInfoTryingIns=sipStatsInfoTryingIns, PYSNMP_MODULE_ID=sipMIB, sipServiceAdminStatus=sipServiceAdminStatus, sipRxProxyAuthPassword=sipRxProxyAuthPassword, sipStatsInfoOuts=sipStatsInfoOuts, sipProtocolVersion=sipProtocolVersion, sipStatsClientUnauthorizedOuts=sipStatsClientUnauthorizedOuts, sipRequestUriHostMatching=sipRequestUriHostMatching, sipPgpPrivateKey=sipPgpPrivateKey, sipRegContactDfltExpiryDuration=sipRegContactDfltExpiryDuration, sipMIBNotif=sipMIBNotif, sipProxyNotif=sipProxyNotif, sipRedirNotif=sipRedirNotif, sipHideOperation=sipHideOperation, sipStatsInfoQueuedOuts=sipStatsInfoQueuedOuts, sipServiceOperStatus=sipServiceOperStatus, sipStatsRedirUseProxyOuts=sipStatsRedirUseProxyOuts, sipUserLocationServerAddr=sipUserLocationServerAddr, sipStatsClientReqEntTooLargeIns=sipStatsClientReqEntTooLargeIns, sipUriSupportedEntry=sipUriSupportedEntry, sipUACfg=sipUACfg, sipRegMaxUsers=sipRegMaxUsers, sipProxyStats=sipProxyStats, sipCommonStats=sipCommonStats, sipUriSupported=sipUriSupported, sipFtrSupportedEntry=sipFtrSupportedEntry, sipContactDisplayName=sipContactDisplayName, sipStatsGlobalDeclineOuts=sipStatsGlobalDeclineOuts, sipTransport=sipTransport, sipCurrentTransactions=sipCurrentTransactions, sipRedirCfg=sipRedirCfg, sipStatsCancelOuts=sipStatsCancelOuts, sipRegUserEntry=sipRegUserEntry, sipUserIndex=sipUserIndex)
mibBuilder.exportSymbols("SIP-MIB", sipContactIndex=sipContactIndex, sipStatsInfoIns=sipStatsInfoIns, sipPortEntry=sipPortEntry, sipRegCurrentUsers=sipRegCurrentUsers, sipStatsClientCallLegNoExistIns=sipStatsClientCallLegNoExistIns, sipUACfgRetryRegister=sipUACfgRetryRegister, sipCommonStatsTrans=sipCommonStatsTrans, sipStatsClientLoopDetectedOuts=sipStatsClientLoopDetectedOuts, sipUserUri=sipUserUri, sipCompliance=sipCompliance, sipStatsClientTempNotAvailOuts=sipStatsClientTempNotAvailOuts, SipServerActions=SipServerActions, sipUriSupportedIndex=sipUriSupportedIndex, sipStatsGlobalDeclineIns=sipStatsGlobalDeclineIns, sipStatsClientAddrIncompleteOuts=sipStatsClientAddrIncompleteOuts)
