# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AS2SecuritySettings(Model):
    """The AS2 agreement security settings.

    All required parameters must be populated in order to send to Azure.

    :param override_group_signing_certificate: Required. The value indicating
     whether to send or request a MDN.
    :type override_group_signing_certificate: bool
    :param signing_certificate_name: The name of the signing certificate.
    :type signing_certificate_name: str
    :param encryption_certificate_name: The name of the encryption
     certificate.
    :type encryption_certificate_name: str
    :param enable_nrr_for_inbound_encoded_messages: Required. The value
     indicating whether to enable NRR for inbound encoded messages.
    :type enable_nrr_for_inbound_encoded_messages: bool
    :param enable_nrr_for_inbound_decoded_messages: Required. The value
     indicating whether to enable NRR for inbound decoded messages.
    :type enable_nrr_for_inbound_decoded_messages: bool
    :param enable_nrr_for_outbound_mdn: Required. The value indicating whether
     to enable NRR for outbound MDN.
    :type enable_nrr_for_outbound_mdn: bool
    :param enable_nrr_for_outbound_encoded_messages: Required. The value
     indicating whether to enable NRR for outbound encoded messages.
    :type enable_nrr_for_outbound_encoded_messages: bool
    :param enable_nrr_for_outbound_decoded_messages: Required. The value
     indicating whether to enable NRR for outbound decoded messages.
    :type enable_nrr_for_outbound_decoded_messages: bool
    :param enable_nrr_for_inbound_mdn: Required. The value indicating whether
     to enable NRR for inbound MDN.
    :type enable_nrr_for_inbound_mdn: bool
    :param sha2_algorithm_format: The Sha2 algorithm format. Valid values are
     Sha2, ShaHashSize, ShaHyphenHashSize, Sha2UnderscoreHashSize.
    :type sha2_algorithm_format: str
    """

    _validation = {
        'override_group_signing_certificate': {'required': True},
        'enable_nrr_for_inbound_encoded_messages': {'required': True},
        'enable_nrr_for_inbound_decoded_messages': {'required': True},
        'enable_nrr_for_outbound_mdn': {'required': True},
        'enable_nrr_for_outbound_encoded_messages': {'required': True},
        'enable_nrr_for_outbound_decoded_messages': {'required': True},
        'enable_nrr_for_inbound_mdn': {'required': True},
    }

    _attribute_map = {
        'override_group_signing_certificate': {'key': 'overrideGroupSigningCertificate', 'type': 'bool'},
        'signing_certificate_name': {'key': 'signingCertificateName', 'type': 'str'},
        'encryption_certificate_name': {'key': 'encryptionCertificateName', 'type': 'str'},
        'enable_nrr_for_inbound_encoded_messages': {'key': 'enableNRRForInboundEncodedMessages', 'type': 'bool'},
        'enable_nrr_for_inbound_decoded_messages': {'key': 'enableNRRForInboundDecodedMessages', 'type': 'bool'},
        'enable_nrr_for_outbound_mdn': {'key': 'enableNRRForOutboundMDN', 'type': 'bool'},
        'enable_nrr_for_outbound_encoded_messages': {'key': 'enableNRRForOutboundEncodedMessages', 'type': 'bool'},
        'enable_nrr_for_outbound_decoded_messages': {'key': 'enableNRRForOutboundDecodedMessages', 'type': 'bool'},
        'enable_nrr_for_inbound_mdn': {'key': 'enableNRRForInboundMDN', 'type': 'bool'},
        'sha2_algorithm_format': {'key': 'sha2AlgorithmFormat', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AS2SecuritySettings, self).__init__(**kwargs)
        self.override_group_signing_certificate = kwargs.get('override_group_signing_certificate', None)
        self.signing_certificate_name = kwargs.get('signing_certificate_name', None)
        self.encryption_certificate_name = kwargs.get('encryption_certificate_name', None)
        self.enable_nrr_for_inbound_encoded_messages = kwargs.get('enable_nrr_for_inbound_encoded_messages', None)
        self.enable_nrr_for_inbound_decoded_messages = kwargs.get('enable_nrr_for_inbound_decoded_messages', None)
        self.enable_nrr_for_outbound_mdn = kwargs.get('enable_nrr_for_outbound_mdn', None)
        self.enable_nrr_for_outbound_encoded_messages = kwargs.get('enable_nrr_for_outbound_encoded_messages', None)
        self.enable_nrr_for_outbound_decoded_messages = kwargs.get('enable_nrr_for_outbound_decoded_messages', None)
        self.enable_nrr_for_inbound_mdn = kwargs.get('enable_nrr_for_inbound_mdn', None)
        self.sha2_algorithm_format = kwargs.get('sha2_algorithm_format', None)
