# Set SSH connection methods preference

Setting up a SSH connection to hosts can be tricky. Beaker supports three methods to SSH to hosts:

1. `:ip`
2. `:vmhostname` - DNS name
3. `:hostname`

Beaker tries to SSH to hosts using these methods in a particular preference (order). Default preference is mentioned above. We allow hypervisor authors and end users to provide an array of these methods that reflects their preference. Note that methods are identified by Ruby symbols, not strings.

## Why set a preference?

Depending upon your hypervisor, your host could have specific method that it uses to SSH better and faster than other methods. For example, hosts generated by vmpooler connects better with `vmhostname` as some change their ip adderess on restart. Therefore vmpooler hypervisor sets its connection preference to use vmhostname first.

## Setting SSH connection preference at hypervisor level

Hypervisor authors can set SSH connection preference. The only thing they have to do is override the `connection_preference` method set in [hypervisor.rb](https://github.com/puppetlabs/beaker/blob/master/lib/beaker/hypervisor.rb) file in their own hypervisor file.

For example, `beaker-vmpooler` overriding this in [vmpooler.rb](https://github.com/puppetlabs/beaker-vmpooler/blob/master/lib/beaker/hypervisor/vmpooler.rb) file.

## Setting SSH connection methods in hosts file

End users can override the connection preference that is default or set by their hypervisor. This can be done from your hosts file. All you need to do is provide a `ssh_preference` for each host. The value of this key should be an array of the methods specified above in an order you prefer. Beaker then will attempt to SSH to the hosts in that particular order.

Example of a host file:

```yaml
HOSTS:
  ubuntu1604-64-1:
    hypervisor: vmpooler
    platform: ubuntu-16.04-amd64
    template: ubuntu-1604-x86_64
    ssh_preference:
    - :vmhostname
    - :hostname
    - :ip
    roles:
    - agent
    - default
  ubuntu1604-64-2:
    hypervisor: vmpooler
    platform: ubuntu-16.04-amd64
    template: ubuntu-1604-x86_64
    ssh_preference: [:ip, :vmhostname]
    roles:
    - agent
CONFIG:
  nfs_server: none
  consoleport: 443
```
